/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.xui;

import com.memoire.vainstall.VADirectoryStep;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.xui.XuiAbstractPanel;
import com.memoire.vainstall.xui.XuiButton;
import com.memoire.vainstall.xui.XuiImagePanel;
import com.memoire.vainstall.xui.XuiLabel;
import com.memoire.vainstall.xui.XuiOptionPane;
import com.memoire.vainstall.xui.XuiPanel;
import com.memoire.vainstall.xui.XuiTitle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class XuiDirectoryPanel
extends XuiAbstractPanel
implements VADirectoryStep {
    JTextField tfDir_;
    JButton btBrowse_;

    public XuiDirectoryPanel() {
        this.setLayout(new BorderLayout());
        XuiPanel xuiPanel = new XuiPanel();
        xuiPanel.setLayout(new BorderLayout());
        xuiPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        xuiPanel.setForeground(new Color(128, 255, 255));
        XuiPanel xuiPanel2 = new XuiPanel();
        xuiPanel2.setLayout(new BorderLayout(0, 0));
        xuiPanel2.setBorder(new CompoundBorder(new LineBorder(Color.black, 2), new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new LineBorder(Color.black, 2))));
        XuiLabel xuiLabel = new XuiLabel(VAGlobals.i18n("UI_Directory"));
        xuiLabel.setBackground(new Color(160, 224, 224));
        xuiLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        xuiLabel.setOpaque(true);
        xuiPanel2.add((Component)xuiLabel, "Center");
        this.tfDir_ = new JTextField();
        this.tfDir_.setText(VAGlobals.DEST_PATH);
        this.tfDir_.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.tfDir_.setFont(new Font("Monospaced", 0, 14));
        xuiPanel2.add((Component)this.tfDir_, "South");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(2, 4, 2, 4));
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(new Color(160, 224, 224));
        jPanel.setOpaque(true);
        this.btBrowse_ = new XuiButton(VAGlobals.i18n("UI_Browse"));
        this.btBrowse_.setForeground(Color.black);
        this.btBrowse_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XuiDirectoryPanel.this.browse();
            }
        });
        jPanel.add((Component)this.btBrowse_, "East");
        xuiPanel2.add((Component)jPanel, "East");
        XuiTitle xuiTitle = new XuiTitle(VAGlobals.i18n("UI_Directory"), 0);
        xuiTitle.setFont(new Font("SansSerif", 0, 16));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setBorder(null);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)xuiTitle, "North");
        jPanel2.add((Component)xuiPanel2, "Center");
        xuiPanel.add((Component)jPanel2, "North");
        XuiImagePanel xuiImagePanel = XuiImagePanel.IMAGE_PANEL;
        this.add((Component)xuiImagePanel, "West");
        this.add((Component)xuiPanel, "Center");
    }

    public void setDirectory(File file) {
        if (file != null) {
            this.tfDir_.setText(file.getAbsolutePath());
        }
    }

    public File getDirectory() {
        String string = this.tfDir_.getText();
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!(file2 == null || file2.exists() && file2.canWrite())) {
            XuiOptionPane.showErrorDialog((Dialog)this.getTopLevelAncestor(), file2 + VAGlobals.i18n("UI_NoDirectoryAccess"), VAGlobals.i18n("UI_Error"));
            file = null;
        }
        return file;
    }

    public void roDirectory(File file) {
        XuiOptionPane.showErrorDialog((Dialog)this.getTopLevelAncestor(), VAGlobals.i18n("Setup_NoWritableDirectory") + file.getAbsolutePath() + "\n" + VAGlobals.i18n("Setup_NoWritableDirectoryInfos"), VAGlobals.i18n("UI_Error"));
    }

    public void rejectDirectory() {
        XuiOptionPane.showErrorDialog((Dialog)this.getTopLevelAncestor(), VAGlobals.i18n("UI_NotChooseDirectory"), VAGlobals.i18n("UI_Error"));
    }

    public boolean acceptDirectory() {
        int n = XuiOptionPane.showConfirmDialog((Dialog)this.getTopLevelAncestor(), VAGlobals.i18n("UI_InstallationDirectory") + "\n" + this.getDirectory() + "\n" + VAGlobals.i18n("UI_IsThatRight"), VAGlobals.i18n("UI_Confirm"));
        return n == 1;
    }

    private void browse() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, VAGlobals.i18n("UI_Select"));
        File file = null;
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (file.exists() && file.isDirectory() && file.canWrite()) {
                this.tfDir_.setText(file.getAbsolutePath());
            } else {
                XuiOptionPane.showErrorDialog((Dialog)this.getTopLevelAncestor(), file.getName() + VAGlobals.i18n("UI_NotValidDirectory"), VAGlobals.i18n("UI_Error"));
            }
        }
    }
}

