/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.xui;

import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VALanguageStep;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAWelcomeStep;
import com.memoire.vainstall.VAWizardInterface;
import com.memoire.vainstall.xui.XuiAbstractPanel;
import com.memoire.vainstall.xui.XuiBlueScreen;
import com.memoire.vainstall.xui.XuiButton;
import com.memoire.vainstall.xui.XuiOptionPane;
import com.memoire.vainstall.xui.XuiPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class XuiWizard
extends JDialog
implements VAWizardInterface,
ActionListener {
    private static XuiWizard UNIQUE_WIZARD = null;
    JButton btAbout_;
    JButton btNext_;
    JButton btBack_;
    JButton btCancel_;
    XuiAbstractPanel panel_;
    JPanel pnNav_;

    protected XuiWizard() {
        super(XuiBlueScreen.MAIN);
        this.init();
    }

    protected void init() {
        super.setTitle("VAInstall");
        super.setDefaultCloseOperation(1);
        this.setModal(true);
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.black);
        this.pnNav_ = new XuiPanel();
        this.pnNav_.setLayout(new FlowLayout(2, 4, 0));
        this.pnNav_.setBackground(Color.black);
        this.pnNav_.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.btAbout_ = new XuiButton(VAGlobals.i18n("XuiWizard_About"));
        this.btNext_ = new XuiButton(VAGlobals.i18n("UI_Next"));
        this.btBack_ = new XuiButton(VAGlobals.i18n("UI_Back"));
        this.btCancel_ = new XuiButton(VAGlobals.i18n("UI_Cancel"));
        this.pnNav_.add(this.btAbout_);
        this.pnNav_.add(this.btCancel_);
        this.pnNav_.add(this.btBack_);
        this.pnNav_.add(this.btNext_);
        this.btAbout_.addActionListener(this);
        this.btNext_.addActionListener(this);
        this.btBack_.addActionListener(this);
        this.btCancel_.addActionListener(this);
        this.panel_ = new XuiAbstractPanel();
        this.panel_.setPreferredSize(new Dimension(660, 360));
        container.add("Center", this.panel_);
        container.add("South", this.pnNav_);
        this.setSize(this.getPreferredSize());
        this.doLayout();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
    }

    public static VAWizardInterface createWizard() {
        if (UNIQUE_WIZARD == null) {
            UNIQUE_WIZARD = new XuiWizard();
        } else {
            UNIQUE_WIZARD.init();
        }
        return UNIQUE_WIZARD;
    }

    public void setStep(VAStep vAStep) {
        this.panel_ = (XuiAbstractPanel)vAStep;
        Container container = this.getContentPane();
        container.removeAll();
        this.panel_.setPreferredSize(new Dimension(660, 360));
        container.add("Center", this.panel_);
        if (vAStep instanceof VAWelcomeStep || vAStep instanceof VALanguageStep) {
            this.btAbout_.setText(VAGlobals.i18n("XuiWizard_About"));
            this.btNext_.setText(VAGlobals.i18n("UI_Next"));
            this.btBack_.setText(VAGlobals.i18n("UI_Back"));
            this.btCancel_.setText(VAGlobals.i18n("UI_Cancel"));
            this.doLayout();
            this.validate();
        }
        container.add("South", this.pnNav_);
        container.doLayout();
        this.invalidate();
        container.validate();
        Dimension dimension = this.getSize();
    }

    public XuiAbstractPanel getPanel() {
        return this.panel_;
    }

    public void setActionEnabled(int n) {
        this.btCancel_.setEnabled((n & 1) == 1);
        this.btBack_.setEnabled((n & 2) == 2);
        this.btNext_.setEnabled((n & 4) == 4 || (n & 8) == 8);
        if ((n & 8) == 8) {
            this.btNext_.setText(VAGlobals.i18n("UI_Finish"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btCancel_) {
            this.dispose(true);
        } else if (object == this.btBack_) {
            this.panel_.backAction();
        } else if (object == this.btNext_) {
            this.panel_.nextAction();
        } else if (object == this.btAbout_) {
            this.about();
        }
    }

    public void about() {
        XuiOptionPane.showMessageDialog(this, "\n^VAInstall 0.21\nAxel von Arnim <vonarnim@club-internet.fr>\nhttp://www.ifrance.com/vonarnim/vainstall\n" + VAGlobals.i18n("UI_License") + "GPL2" + "\n" + "(c) " + "2000-2002" + " " + "Axel von Arnim" + "\n" + "\n^Xtra Mode\n" + "(c) 2001-2002 Guillaume Desnoix", VAGlobals.i18n("XuiWizard_About"));
    }

    public void hide(boolean bl) {
        if (bl) {
            int n = XuiOptionPane.showConfirmDialog(this, VAGlobals.i18n("UI_AbortQuestion"), VAGlobals.i18n("UI_Cancel"));
            if (n == 1) {
                this.panel_.cancelAction();
            }
        } else {
            super.hide();
        }
    }

    public void dispose() {
        this.hide(true);
    }

    public void dispose(boolean bl) {
        this.hide(bl);
    }

    public void show() {
        super.show();
    }

    public void hide() {
        this.hide(true);
    }
}

