/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.Param;
import org.apache.struts2.util.AppendIteratorFilter;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="append", tldTagClass="org.apache.struts2.views.jsp.iterator.AppendIteratorTag", description="Append the values of a list of iterators to one iterator")
public class AppendIterator
extends Component
implements Param.UnnamedParametric {
    private static final Log _log = LogFactory.getLog(AppendIterator.class);
    private AppendIteratorFilter appendIteratorFilter = null;
    private List _parameters;

    public AppendIterator(ValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        this._parameters = new ArrayList();
        this.appendIteratorFilter = new AppendIteratorFilter();
        return super.start(writer);
    }

    public boolean end(Writer writer, String body) {
        for (Object iteratorEntryObj : this._parameters) {
            if (!MakeIterator.isIterable(iteratorEntryObj)) {
                _log.warn((Object)("param with value resolved as " + iteratorEntryObj + " cannot be make as iterator, it will be ignored and hence will not appear in the merged iterator"));
                continue;
            }
            this.appendIteratorFilter.setSource(MakeIterator.convert(iteratorEntryObj));
        }
        this.appendIteratorFilter.execute();
        if (this.getId() != null && this.getId().length() > 0) {
            this.getStack().getContext().put(this.getId(), this.appendIteratorFilter);
        }
        this.appendIteratorFilter = null;
        return super.end(writer, body);
    }

    public void addParameter(Object value) {
        this._parameters.add(value);
    }

    @StrutsTagAttribute(description="The id of which if supplied will have the resultant appended iterator stored under in the stack's context")
    public void setId(String id) {
        super.setId(id);
    }
}

