/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public abstract class NLSLocale {
    static final int JDK_1_1_4 = 1;
    static final int JDK_1_1_6 = 2;
    static final int JDK_1_1_7 = 3;
    static final int JDK_1_1_8 = 4;
    static final int JDK_1_2_1 = 5;
    public static final int NLSCHARSET = 0;
    public static final int JAVACHARSET = 1;
    public static final int IANACHARSET = 2;
    private static final int JDK_LATEST_VERSION = 5;
    private static final String CLASSNAME_PREFIX = "oracle.gss.util.NLSLocale";
    private static final String CLASSNAME_SUFFIX = "000";
    private static final int JDK_VERSION_MAX_LENGTH = 5;
    private int m_jdkVersion;
    private Hashtable m_NLSLang2JavaLang;
    private Hashtable m_NLSTerr2JavaTerr;
    private Hashtable m_NLSLocale2JavaLocale;
    private Hashtable m_NLSCharset2JavaCharset;
    private Hashtable m_JavaCharset2NLSCharset;
    private Hashtable m_JavaLocale2NLSLocale;
    private Hashtable m_JavaLocale2NLSLang;
    private Hashtable m_JavaLang2NLSLang;
    private Hashtable m_JavaTerr2NLSTerr;
    private Hashtable m_JavaCharset2IANACharset;
    private Hashtable m_IANACharset2JavaCharset;
    private Hashtable m_NLSCharset2IANACharset;
    private Hashtable m_IANACharset2NLSCharset;
    private Hashtable m_IANACharset;
    private Hashtable m_JavaCharset;
    private Hashtable m_NLSCharset;
    private static Hashtable m_jdk2NlsVersion = new Hashtable();
    private static Hashtable m_NLSLocaleInstances;

    static {
        m_jdk2NlsVersion.put("1.1", new Integer(1));
        m_jdk2NlsVersion.put("1.1.1", new Integer(1));
        m_jdk2NlsVersion.put("1.1.2", new Integer(1));
        m_jdk2NlsVersion.put("1.1.3", new Integer(1));
        m_jdk2NlsVersion.put("1.1.4", new Integer(1));
        m_jdk2NlsVersion.put("1.1.5", new Integer(1));
        m_jdk2NlsVersion.put("1.1.6", new Integer(2));
        m_jdk2NlsVersion.put("1.1.7B", new Integer(3));
        m_jdk2NlsVersion.put("1.1.7", new Integer(3));
        m_jdk2NlsVersion.put("1.1.8", new Integer(4));
        m_jdk2NlsVersion.put("1.2", new Integer(4));
        m_jdk2NlsVersion.put("1.2.1", new Integer(5));
        m_jdk2NlsVersion.put("1.2.1p", new Integer(5));
        m_jdk2NlsVersion.put("1.2.2", new Integer(5));
        m_jdk2NlsVersion.put("1.3.0", new Integer(5));
    }

    NLSLocale() {
    }

    abstract Hashtable createIANACharset2JavaCharset();

    abstract Hashtable createIANACharset2NLSCharset();

    abstract Hashtable createJavaCharset2IANACharset();

    abstract Hashtable createJavaCharset2NLSCharset();

    abstract Hashtable createJavaLang2NLSLang();

    abstract Hashtable createJavaLocale2NLSLang();

    abstract Hashtable createJavaLocale2NLSLocale();

    abstract Hashtable createJavaTerr2NLSTerr();

    abstract Hashtable createNLSCharset2IANACharset();

    abstract Hashtable createNLSCharset2JavaCharset();

    abstract Hashtable createNLSLang2JavaLang();

    abstract Hashtable createNLSLocale2JavaLocale();

    abstract Hashtable createNLSTerr2JavaTerr();

    public Enumeration enumIANACharsets() {
        if (this.m_IANACharset == null) {
            this.m_IANACharset = (Hashtable)this.getIANACS2JavaCSTable().clone();
            Enumeration enumeration = this.getIANACS2NLSCSTable().keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.m_IANACharset.put(k, "");
            }
        }
        return this.m_IANACharset.keys();
    }

    public Enumeration enumJavaCharsets() {
        if (this.m_JavaCharset == null) {
            this.m_JavaCharset = (Hashtable)this.getJavaCS2NLSCSTable().clone();
            Enumeration enumeration = this.getJavaCS2IANACSTable().keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.m_JavaCharset.put(k, "");
            }
        }
        return this.m_JavaCharset.keys();
    }

    public Enumeration enumJavaLocales() {
        return this.getJavaLoc2NLSLocTable().keys();
    }

    public Enumeration enumNLSCharsets() {
        if (this.m_NLSCharset == null) {
            this.m_NLSCharset = (Hashtable)this.getNLSCS2JavaCSTable().clone();
            Enumeration enumeration = this.getNLSCS2IANACSTable().keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                this.m_NLSCharset.put(k, "");
            }
        }
        return this.m_NLSCharset.keys();
    }

    public Enumeration enumNLSLocales() {
        return this.getNLSLoc2JavaLocTable().keys();
    }

    Hashtable getIANACS2JavaCSTable() {
        if (this.m_IANACharset2JavaCharset == null) {
            this.m_IANACharset2JavaCharset = this.createIANACharset2JavaCharset();
        }
        return this.m_IANACharset2JavaCharset;
    }

    Hashtable getIANACS2NLSCSTable() {
        if (this.m_IANACharset2NLSCharset == null) {
            this.m_IANACharset2NLSCharset = this.createIANACharset2NLSCharset();
        }
        return this.m_IANACharset2NLSCharset;
    }

    public String getIANACharset(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = (String)this.getNLSCS2IANACSTable().get(string);
                break;
            }
            case 1: {
                string2 = (String)this.getJavaCS2IANACSTable().get(string.toUpperCase(Locale.US));
                break;
            }
            default: {
                return string;
            }
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public static NLSLocale getInstance() {
        Integer n;
        String string = System.getProperty("java.version");
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        int n2 = (n = (Integer)m_jdk2NlsVersion.get(string)) != null ? n : 5;
        return NLSLocale.getInstance(n2);
    }

    public static NLSLocale getInstance(int n) {
        NLSLocale nLSLocale = null;
        Integer n2 = new Integer(n);
        if (n > 5) {
            return null;
        }
        if (m_NLSLocaleInstances == null) {
            m_NLSLocaleInstances = new Hashtable();
        } else {
            nLSLocale = (NLSLocale)m_NLSLocaleInstances.get(n2);
            if (nLSLocale != null) {
                return nLSLocale;
            }
        }
        String string = CLASSNAME_PREFIX;
        String string2 = Integer.toHexString(n);
        string = String.valueOf(string) + CLASSNAME_SUFFIX.substring(0, CLASSNAME_SUFFIX.length() - string2.length()) + string2;
        try {
            Class<?> clazz = Class.forName(string);
            nLSLocale = (NLSLocale)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (nLSLocale != null) {
            m_NLSLocaleInstances.put(n2, nLSLocale);
        }
        return nLSLocale;
    }

    Hashtable getJavaCS2IANACSTable() {
        if (this.m_JavaCharset2IANACharset == null) {
            this.m_JavaCharset2IANACharset = this.createJavaCharset2IANACharset();
        }
        return this.m_JavaCharset2IANACharset;
    }

    Hashtable getJavaCS2NLSCSTable() {
        if (this.m_JavaCharset2NLSCharset == null) {
            this.m_JavaCharset2NLSCharset = this.createJavaCharset2NLSCharset();
        }
        return this.m_JavaCharset2NLSCharset;
    }

    public String getJavaCharset(int n, String string) {
        String string2;
        if (string == null) {
            return null;
        }
        switch (n) {
            case 0: {
                string2 = (String)this.getNLSCS2JavaCSTable().get(string.toUpperCase(Locale.US));
                break;
            }
            case 2: {
                string2 = (String)this.getIANACS2JavaCSTable().get(string.toUpperCase(Locale.US));
                break;
            }
            default: {
                return string;
            }
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public String getJavaCharset(String string) {
        String string2 = (String)this.getNLSCS2JavaCSTable().get(string.toUpperCase(Locale.US));
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    Hashtable getJavaLang2NLSLangTable() {
        if (this.m_JavaLang2NLSLang == null) {
            this.m_JavaLang2NLSLang = this.createJavaLang2NLSLang();
        }
        return this.m_JavaLang2NLSLang;
    }

    public String getJavaLanguage(String string) {
        return (String)this.getNLSLang2JavaLangTable().get(string.toUpperCase(Locale.US));
    }

    Hashtable getJavaLoc2NLSLangTable() {
        if (this.m_JavaLocale2NLSLang == null) {
            this.m_JavaLocale2NLSLang = this.createJavaLocale2NLSLang();
        }
        return this.m_JavaLocale2NLSLang;
    }

    Hashtable getJavaLoc2NLSLocTable() {
        if (this.m_JavaLocale2NLSLocale == null) {
            this.m_JavaLocale2NLSLocale = this.createJavaLocale2NLSLocale();
        }
        return this.m_JavaLocale2NLSLocale;
    }

    public Locale getJavaLocale(String string) {
        String string2 = string.toUpperCase(Locale.US);
        Locale locale = (Locale)this.getNLSLoc2JavaLocTable().get(string2);
        if (locale == null) {
            String string3;
            String string4;
            int n = string2.indexOf("_");
            if (n > -1) {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                string4 = string2;
                string3 = "";
            }
            locale = this.getJavaLocale(string4, string3);
        }
        return locale;
    }

    public Locale getJavaLocale(String string, String string2) {
        Locale locale = null;
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        String string5 = string3.compareTo("") == 0 ? "" : this.getJavaLanguage(string3);
        if (string5 != null) {
            if (string4.compareTo("") == 0) {
                locale = new Locale(string5, "");
            } else {
                String string6 = this.getJavaTerritory(string4);
                if (string6 != null) {
                    locale = new Locale(string5, string6);
                }
            }
        }
        return locale;
    }

    Hashtable getJavaTerr2NLSTerrTable() {
        if (this.m_JavaTerr2NLSTerr == null) {
            this.m_JavaTerr2NLSTerr = this.createJavaTerr2NLSTerr();
        }
        return this.m_JavaTerr2NLSTerr;
    }

    public String getJavaTerritory(String string) {
        return (String)this.getNLSTerr2JavaTerrTable().get(string.toUpperCase(Locale.US));
    }

    Hashtable getNLSCS2IANACSTable() {
        if (this.m_NLSCharset2IANACharset == null) {
            this.m_NLSCharset2IANACharset = this.createNLSCharset2IANACharset();
        }
        return this.m_NLSCharset2IANACharset;
    }

    Hashtable getNLSCS2JavaCSTable() {
        if (this.m_NLSCharset2JavaCharset == null) {
            this.m_NLSCharset2JavaCharset = this.createNLSCharset2JavaCharset();
        }
        return this.m_NLSCharset2JavaCharset;
    }

    public String getNLSCharset(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = (String)this.getJavaCS2NLSCSTable().get(string);
                if (string2 != null && !string2.equals("")) break;
                string2 = (String)this.getIANACS2NLSCSTable().get(string);
                break;
            }
            case 2: {
                string2 = (String)this.getIANACS2NLSCSTable().get(string);
                break;
            }
            default: {
                return string;
            }
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public String getNLSCharset(String string) {
        String string2 = (String)this.getJavaCS2NLSCSTable().get(string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    Hashtable getNLSLang2JavaLangTable() {
        if (this.m_NLSLang2JavaLang == null) {
            this.m_NLSLang2JavaLang = this.createNLSLang2JavaLang();
        }
        return this.m_NLSLang2JavaLang;
    }

    public String getNLSLanguage(String string) {
        return (String)this.getJavaLang2NLSLangTable().get(string);
    }

    public String getNLSLanguage(Locale locale) {
        String string = null;
        string = (String)this.getJavaLoc2NLSLangTable().get(locale);
        if (string == null) {
            string = this.getNLSLanguage(locale.getLanguage());
        }
        return string;
    }

    Hashtable getNLSLoc2JavaLocTable() {
        if (this.m_NLSLocale2JavaLocale == null) {
            this.m_NLSLocale2JavaLocale = this.createNLSLocale2JavaLocale();
        }
        return this.m_NLSLocale2JavaLocale;
    }

    public String getNLSLocale() {
        return this.getNLSLocale(Locale.getDefault());
    }

    public String getNLSLocale(Locale locale) {
        String string = (String)this.getJavaLoc2NLSLocTable().get(locale);
        if (string == null) {
            String string2 = this.getNLSLanguage(locale);
            String string3 = locale.getCountry();
            if (string3.compareTo("") == 0) {
                return string2;
            }
            String string4 = this.getNLSTerritory(string3);
            if (string2 != null && string4 != null) {
                string = String.valueOf(string2) + "_" + string4;
            }
        }
        return string;
    }

    Hashtable getNLSTerr2JavaTerrTable() {
        if (this.m_NLSTerr2JavaTerr == null) {
            this.m_NLSTerr2JavaTerr = this.createNLSTerr2JavaTerr();
        }
        return this.m_NLSTerr2JavaTerr;
    }

    public String getNLSTerritory(String string) {
        return (String)this.getJavaTerr2NLSTerrTable().get(string);
    }

    public String getNLSTerritory(Locale locale) {
        int n;
        String string;
        String string2 = locale.getCountry();
        if (string2.compareTo("") == 0 && (string = this.getNLSLocale(locale)) != null && (n = string.indexOf(95)) != -1) {
            return string.substring(n + 1);
        }
        return this.getNLSTerritory(locale.getCountry());
    }
}

