/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.sql.Datum;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibServer;
import oracle.sql.LnxLibThin;

public class NUMBER
extends Datum {
    static byte[] MAX_LONG = NUMBER.toBytes(Long.MAX_VALUE);
    static byte[] MIN_LONG = NUMBER.toBytes(Long.MIN_VALUE);
    private static final int CHARACTER_ZERO = 48;
    private static final BigDecimal BIGDEC_NEGZERO = new BigDecimal("-0");
    private static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDEC_ONE = BigDecimal.valueOf(1L);
    private static final BigInteger BIGINT_ZERO = BigInteger.valueOf(0L);
    private static final BigInteger BIGINT_HUND = BigInteger.valueOf(100L);
    private static final byte DIGEND = 21;
    private static final byte ODIGEND = 9;
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final double BIGRATIO = 0.1505149978319906;
    private static final int BIGLENMAX = 22;
    static final byte LNXM_NUM = 22;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final double ORANUM_FBASE = 100.0;
    static final int LNXBASE = 100;
    static final byte IEEE_DBL_DIG = 15;
    private static final byte IEEE_FLT_DIG = 6;
    static final int LNXEXPMX = 127;
    static final int LNXEXPMN = 0;
    static final int LNXMXOUT = 40;
    static final int LNXMXFMT = 64;
    private static final byte BYTE_MAX_VALUE = 127;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final byte[] PI = new byte[]{-63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21};
    private static final byte[] E = new byte[]{-63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77};
    private static final byte[] LN10 = new byte[]{-63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61};
    private static LnxLib _slnxlib;

    public NUMBER() {
        super(NUMBER._makeZero());
    }

    public NUMBER(byte by) {
        super(NUMBER.toBytes(by));
    }

    public NUMBER(double d) throws SQLException {
        super(NUMBER.toBytes(d));
    }

    public NUMBER(float f) {
        super(NUMBER.toBytes(f));
    }

    public NUMBER(int n) {
        super(NUMBER.toBytes(n));
    }

    public NUMBER(long l) {
        super(NUMBER.toBytes(l));
    }

    public NUMBER(Object object) throws SQLException {
        if (object instanceof Integer) {
            this.setShareBytes(NUMBER.toBytes((Integer)object));
        } else if (object instanceof Long) {
            this.setShareBytes(NUMBER.toBytes((Long)object));
        } else if (object instanceof Float) {
            this.setShareBytes(NUMBER.toBytes(((Float)object).floatValue()));
        } else if (object instanceof Double) {
            this.setShareBytes(NUMBER.toBytes((Double)object));
        } else if (object instanceof BigInteger) {
            this.setShareBytes(NUMBER.toBytes((BigInteger)object));
        } else if (object instanceof BigDecimal) {
            this.setShareBytes(NUMBER.toBytes((BigDecimal)object));
        } else if (object instanceof Boolean) {
            this.setShareBytes(NUMBER.toBytes((Boolean)object));
        } else if (object instanceof String) {
            this.setShareBytes(this.stringToBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public NUMBER(String string, int n) throws SQLException {
        super(NUMBER.toBytes(string, n));
    }

    public NUMBER(BigDecimal bigDecimal) throws SQLException {
        super(NUMBER.toBytes(bigDecimal));
    }

    public NUMBER(BigInteger bigInteger) throws SQLException {
        super(NUMBER.toBytes(bigInteger));
    }

    public NUMBER(short s) {
        super(NUMBER.toBytes(s));
    }

    public NUMBER(boolean bl) {
        super(NUMBER.toBytes(bl));
    }

    public NUMBER(byte[] byArray) {
        super(byArray);
    }

    private static void _byteTo2Chars(byte by, char[] cArray, int n) {
        if (by < 0) {
            cArray[n] = 48;
            cArray[n + 1] = 48;
        } else if (by < 10) {
            cArray[n] = 48;
            cArray[n + 1] = (char)(48 + by);
        } else if (by < 100) {
            cArray[n] = (char)(48 + by / 10);
            cArray[n + 1] = (char)(48 + by % 10);
        } else {
            cArray[n] = 48;
            cArray[n + 1] = 48;
        }
    }

    private static int _byteToChars(byte by, char[] cArray, int n) {
        if (by < 0) {
            return 0;
        }
        if (by < 10) {
            cArray[n] = (char)(48 + by);
            return 1;
        }
        if (by < 100) {
            cArray[n] = (char)(48 + by / 10);
            cArray[n + 1] = (char)(48 + by % 10);
            return 2;
        }
        cArray[n] = 49;
        cArray[n + 1] = (char)(48 + by / 10 - 10);
        cArray[n + 2] = (char)(48 + by % 10);
        return 3;
    }

    static byte[] _fromLnxFmt(byte[] byArray) {
        byte[] byArray2;
        int n = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            byArray2 = new byte[n];
            byArray2[0] = (byte)((byArray[0] & 0xFFFFFF7F) - 65);
            int n2 = 1;
            while (n2 < n) {
                byArray2[n2] = (byte)(byArray[n2] - 1);
                ++n2;
            }
        } else {
            byArray2 = n - 1 == 20 && byArray[n - 1] != 102 ? new byte[n] : new byte[n - 1];
            byArray2[0] = (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
            int n3 = 1;
            while (n3 < byArray2.length) {
                byArray2[n3] = (byte)(101 - byArray[n3]);
                ++n3;
            }
        }
        return byArray2;
    }

    private static LnxLib _getLnxLib() {
        block3: {
            if (_slnxlib != null) break block3;
            try {
                if (System.getProperty("oracle.jserver.version") != null) {
                    _slnxlib = new LnxLibServer();
                    break block3;
                }
                _slnxlib = new LnxLibThin();
            }
            catch (SecurityException securityException) {
                _slnxlib = new LnxLibThin();
            }
        }
        return _slnxlib;
    }

    static boolean _isInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101 || byArray[0] == 0 && byArray.length == 1;
    }

    private static boolean _isInt(byte[] byArray) {
        byte by;
        if (NUMBER._isZero(byArray)) {
            return true;
        }
        if (NUMBER._isInf(byArray)) {
            return false;
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        byte by2 = (byte)(byArray2.length - 1);
        return by2 <= (by = byArray2[0]) + 1;
    }

    static boolean _isNegInf(byte[] byArray) {
        return byArray[0] == 0 && byArray.length == 1;
    }

    static boolean _isPosInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101;
    }

    static boolean _isPositive(byte[] byArray) {
        return (byArray[0] & 0xFFFFFF80) != 0;
    }

    static boolean _isZero(byte[] byArray) {
        return byArray[0] == -128 && byArray.length == 1;
    }

    static byte[] _makeNegInf() {
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    static byte[] _makePosInf() {
        byte[] byArray = new byte[]{-1, 101};
        return byArray;
    }

    static byte[] _makeZero() {
        byte[] byArray = new byte[]{-128};
        return byArray;
    }

    private static void _printBytes(byte[] byArray) {
        int n = byArray.length;
        System.out.print(String.valueOf(n) + ": ");
        int n2 = 0;
        while (n2 < n) {
            System.out.print(String.valueOf(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    static byte[] _toLnxFmt(byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n = byArray.length;
        if (bl) {
            byArray2 = new byte[n];
            byArray2[0] = (byte)(byArray[0] + 128 + 64 + 1);
            int n2 = 1;
            while (n2 < n) {
                byArray2[n2] = (byte)(byArray[n2] + 1);
                ++n2;
            }
        } else {
            byArray2 = n - 1 < 20 ? new byte[n + 1] : new byte[n];
            byArray2[0] = (byte)(~(byArray[0] + 128 + 64 + 1));
            int n3 = 1;
            while (n3 < n) {
                byArray2[n3] = (byte)(101 - byArray[n3]);
                ++n3;
            }
            if (n3 <= 20) {
                byArray2[n3] = 102;
            }
        }
        return byArray2;
    }

    public NUMBER abs() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxabs(this.shareBytes()));
    }

    public NUMBER acos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxacos(this.shareBytes()));
    }

    public NUMBER add(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxadd(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER asin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxasin(this.shareBytes()));
    }

    public NUMBER atan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan(this.shareBytes()));
    }

    public NUMBER atan2(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan2(this.shareBytes(), nUMBER.shareBytes()));
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        return NUMBER.toBigDecimal(this.shareBytes());
    }

    public BigInteger bigIntegerValue() throws SQLException {
        return NUMBER.toBigInteger(this.shareBytes());
    }

    public boolean booleanValue() {
        return NUMBER.toBoolean(this.shareBytes());
    }

    public byte byteValue() throws SQLException {
        return NUMBER.toByte(this.shareBytes());
    }

    public NUMBER ceil() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxceil(this.shareBytes()));
    }

    public int compareTo(NUMBER nUMBER) {
        return Datum.compareBytes(this.shareBytes(), nUMBER.shareBytes());
    }

    public NUMBER cos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcos(this.shareBytes()));
    }

    public NUMBER cosh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcsh(this.shareBytes()));
    }

    public NUMBER decrement() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdec(this.shareBytes()));
    }

    public NUMBER div(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdiv(this.shareBytes(), nUMBER.shareBytes()));
    }

    public double doubleValue() {
        return NUMBER.toDouble(this.shareBytes());
    }

    public static NUMBER e() {
        return new NUMBER(E);
    }

    public NUMBER exp() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxexp(this.shareBytes()));
    }

    public float floatValue() {
        return NUMBER.toFloat(this.shareBytes());
    }

    public NUMBER floatingPointRound(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfpr(this.shareBytes(), n));
    }

    public NUMBER floor() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxflo(this.shareBytes()));
    }

    public static NUMBER formattedTextToNumber(String string, String string2, String string3) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfcn(string, string2, string3));
    }

    public NUMBER increment() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxinc(this.shareBytes()));
    }

    public int intValue() throws SQLException {
        return NUMBER.toInt(this.shareBytes());
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.Integer") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.lang.Float") == 0 || string.compareTo("java.lang.Double") == 0 || string.compareTo("java.math.BigInteger") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Boolean") == 0;
    }

    public boolean isInf() {
        return NUMBER._isInf(this.shareBytes());
    }

    public boolean isInt() {
        return NUMBER._isInt(this.shareBytes());
    }

    public boolean isNegInf() {
        return NUMBER._isNegInf(this.shareBytes());
    }

    public boolean isPosInf() {
        return NUMBER._isPosInf(this.shareBytes());
    }

    public static boolean isValid(byte[] byArray) {
        int n = byArray.length;
        if (NUMBER._isPositive(byArray)) {
            if (n == 1) {
                return NUMBER._isZero(byArray);
            }
            if (byArray[0] == -1 && byArray[1] == 101) {
                return n == 2;
            }
            if (n > 21) {
                return false;
            }
            if (byArray[1] < 2 || byArray[n - 1] < 2) {
                return false;
            }
            int n2 = 1;
            while (n2 < n) {
                byte by = byArray[n2];
                if (by < 1 || by > 100) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (n < 3) {
            return NUMBER._isNegInf(byArray);
        }
        if (n > 21) {
            return false;
        }
        if (byArray[n - 1] != 102) {
            if (n <= 20) {
                return false;
            }
        } else {
            n = (byte)(n - 1);
        }
        if (byArray[1] > 100 || byArray[n - 1] > 100) {
            return false;
        }
        int n3 = 1;
        while (n3 < n) {
            byte by = byArray[n3];
            if (by < 2 || by > 101) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isZero() {
        return NUMBER._isZero(this.shareBytes());
    }

    public NUMBER ln() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxln(this.shareBytes()));
    }

    public static NUMBER ln10() {
        return new NUMBER(LN10);
    }

    public NUMBER log(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxlog(this.shareBytes(), nUMBER.shareBytes()));
    }

    public long longValue() throws SQLException {
        return NUMBER.toLong(this.shareBytes());
    }

    public Object makeJdbcArray(int n) {
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        return bigDecimalArray;
    }

    public NUMBER mod(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmod(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER mul(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmul(this.shareBytes(), nUMBER.shareBytes()));
    }

    public static NUMBER negInf() {
        return new NUMBER(NUMBER._makeNegInf());
    }

    public NUMBER negate() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxneg(this.shareBytes()));
    }

    public static NUMBER pi() {
        return new NUMBER(PI);
    }

    public static NUMBER posInf() {
        return new NUMBER(NUMBER._makePosInf());
    }

    public NUMBER pow(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxpow(this.shareBytes(), n));
    }

    public NUMBER pow(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxbex(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER round(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxrou(this.shareBytes(), n));
    }

    public NUMBER scale(int n, int n2, boolean[] blArray) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsca(this.shareBytes(), n, n2, blArray));
    }

    public NUMBER shift(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxshift(this.shareBytes(), n));
    }

    public short shortValue() throws SQLException {
        return NUMBER.toShort(this.shareBytes());
    }

    public int sign() {
        if (NUMBER._isZero(this.shareBytes())) {
            return 0;
        }
        return NUMBER._isPositive(this.shareBytes()) ? 1 : -1;
    }

    public NUMBER sin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsin(this.shareBytes()));
    }

    public NUMBER sinh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsnh(this.shareBytes()));
    }

    public NUMBER sqroot() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsqr(this.shareBytes()));
    }

    private byte[] stringToBytes(String string) throws SQLException {
        int n = 0;
        if ((string = string.trim()).indexOf(46) >= 0) {
            n = string.length() - 1 - string.indexOf(46);
        }
        return NUMBER.toBytes(string, n);
    }

    public String stringValue() {
        return NUMBER.toString(this.shareBytes());
    }

    public NUMBER sub(NUMBER nUMBER) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsub(this.shareBytes(), nUMBER.shareBytes()));
    }

    public NUMBER tan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtan(this.shareBytes()));
    }

    public NUMBER tanh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtnh(this.shareBytes()));
    }

    public static NUMBER textToPrecisionNumber(String string, boolean bl, int n, boolean bl2, int n2, String string2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcpn(string, bl, n, bl2, n2, string2));
    }

    public static BigDecimal toBigDecimal(byte[] byArray) throws SQLException {
        int n;
        long[] lArray = new long[10];
        int n2 = 9;
        int n3 = 1;
        int n4 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGDEC_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n5 = n = byArray2.length - 1;
        if ((n & 1) == 1) {
            lArray[n2] = byArray2[n3];
            n3 = (byte)(n3 + 1);
            --n5;
        } else {
            lArray[n2] = byArray2[n3] * 100 + byArray2[n3 + 1];
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n6 = n2;
        while (n5 != 0) {
            long l = byArray2[n3] * 100 + byArray2[n3 + 1];
            n2 = 9;
            while (n2 >= n6) {
                lArray[n2] = (l += lArray[n2] * 10000L) & 0xFFFFL;
                l >>= 16;
                n2 = (byte)(n2 - 1);
            }
            n6 = (byte)(n6 - 1);
            lArray[n6] = l;
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n7 = lArray[n6] >> 8 != 0L ? 2 * (9 - n6) + 2 : 2 * (9 - n6) + 1;
        byte[] byArray3 = new byte[n7];
        if ((n7 & 1) == 1) {
            byArray3[n4] = (byte)lArray[n6];
            ++n4;
        } else {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[++n4] = (byte)(lArray[n6] & 0xFFL);
            ++n4;
        }
        n6 = (byte)(n6 + 1);
        while (n6 <= 9) {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[n4 + 1] = (byte)(lArray[n6] & 0xFFL);
            n4 += 2;
            n6 = (byte)(n6 + 1);
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        int n8 = byArray2[0] - n + 1;
        bigDecimal = bigDecimal.movePointRight(n8 * 2);
        if (n8 < 0 && byArray2[n] % 10 == 0) {
            bigDecimal = bigDecimal.setScale(-(n8 * 2 + 1));
        }
        return bigDecimal;
    }

    public static BigInteger toBigInteger(byte[] byArray) throws SQLException {
        int n;
        long[] lArray = new long[10];
        int n2 = 9;
        int n3 = 1;
        int n4 = 0;
        if (NUMBER._isZero(byArray)) {
            return BIGINT_ZERO;
        }
        if (NUMBER._isInf(byArray)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean bl = NUMBER._isPositive(byArray);
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        if (byArray2[0] < 0) {
            return BIGINT_ZERO;
        }
        int n5 = n = Math.min(byArray2[0] + 1, byArray2.length - 1);
        if ((n & 1) == 1) {
            lArray[n2] = byArray2[n3];
            n3 = (byte)(n3 + 1);
            --n5;
        } else {
            lArray[n2] = byArray2[n3] * 100 + byArray2[n3 + 1];
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n6 = n2;
        while (n5 != 0) {
            long l = byArray2[n3] * 100 + byArray2[n3 + 1];
            n2 = 9;
            while (n2 >= n6) {
                lArray[n2] = (l += lArray[n2] * 10000L) & 0xFFFFL;
                l >>= 16;
                n2 = (byte)(n2 - 1);
            }
            n6 = (byte)(n6 - 1);
            lArray[n6] = l;
            n3 = (byte)(n3 + 2);
            n5 -= 2;
        }
        int n7 = lArray[n6] >> 8 != 0L ? 2 * (9 - n6) + 2 : 2 * (9 - n6) + 1;
        byte[] byArray3 = new byte[n7];
        if ((n7 & 1) == 1) {
            byArray3[n4] = (byte)lArray[n6];
            ++n4;
        } else {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[++n4] = (byte)(lArray[n6] & 0xFFL);
            ++n4;
        }
        n6 = (byte)(n6 + 1);
        while (n6 <= 9) {
            byArray3[n4] = (byte)(lArray[n6] >> 8);
            byArray3[n4 + 1] = (byte)(lArray[n6] & 0xFFL);
            n4 += 2;
            n6 = (byte)(n6 + 1);
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        int n8 = byArray2[0] - (n - 1);
        return bigInteger.multiply(BIGINT_HUND.pow(n8));
    }

    public static boolean toBoolean(byte[] byArray) {
        return !NUMBER._isZero(byArray);
    }

    public static byte toByte(byte[] byArray) throws SQLException {
        long l = 0L;
        l = NUMBER.toLong(byArray);
        if (l > 127L || l < -128L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (byte)l;
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(byte by) {
        return NUMBER.toBytes((long)by);
    }

    public static byte[] toBytes(double d) throws SQLException {
        if (d == 0.0 || d == -0.0) {
            return NUMBER._makeZero();
        }
        if (d == Double.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        return NUMBER._getLnxLib().lnxren(d);
    }

    public static byte[] toBytes(float f) {
        if (f == 0.0f || f == -0.0f) {
            return NUMBER._makeZero();
        }
        if (f == Float.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        return NUMBER._getLnxLib().lnxren(f);
    }

    public static byte[] toBytes(int n) {
        return NUMBER.toBytes((long)n);
    }

    public static byte[] toBytes(long l) {
        return NUMBER._getLnxLib().lnxmin(l);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] toBytes(String var0, int var1_1) throws SQLException {
        block33: {
            block34: {
                var2_2 = 0;
                var3_3 = 0;
                var5_4 = new byte[22];
                var7_5 = 0;
                var9_6 = true;
                var10_7 = false;
                var11_8 = false;
                var12_9 = 0;
                var14_10 = 0;
                var15_11 = 0;
                var16_12 = 40;
                var17_13 = 0;
                var18_14 = 0;
                var19_15 = 0;
                var0 = var0.trim();
                var20_16 = var0.length();
                if (var0.charAt(0) == '-') {
                    --var20_16;
                    var9_6 = false;
                    var19_15 = 1;
                }
                var2_2 = var20_16;
                var21_17 = new char[var20_16];
                var0.getChars(var19_15, var20_16 + var19_15, var21_17, 0);
                while (var3_3 < var2_2 && var21_17[var3_3] == '0') {
                    ++var3_3;
                }
                if (var3_3 == var2_2) {
                    return NUMBER._makeZero();
                }
                if (var20_16 < 2 || var21_17[var3_3] != '.') ** GOTO lbl64
                while (var2_2 > 0 && var21_17[var2_2 - 1] == '0') {
                    --var2_2;
                }
                if (++var3_3 == var2_2) {
                    return NUMBER._makeZero();
                }
                --var12_9;
                while (var3_3 < var2_2 - 1 && var21_17[var3_3] == '0' && var21_17[var3_3 + 1] == '0') {
                    --var12_9;
                    var15_11 += 2;
                    var3_3 += 2;
                }
                if (var12_9 <= -65) {
                    throw new SQLException(CoreException.getMessage((byte)2));
                }
                if (var2_2 - var3_3 > var16_12) {
                    var6_18 = 2 + var16_12;
                    if (var15_11 > 0) {
                        var6_18 += var15_11;
                    }
                    if (var6_18 <= var2_2) {
                        var2_2 = var6_18;
                    }
                    var17_13 = var2_2;
                    var10_7 = true;
                }
                var7_5 = var2_2 - var3_3 >> 1;
                if ((var2_2 - var3_3) % 2 != 0) {
                    var5_4[var7_5] = (byte)(Integer.parseInt(new String(var21_17, var2_2 - 1, 1)) * 10);
                    ++var14_10;
                    --var2_2;
                }
                while (var2_2 > var3_3) {
                    var5_4[--var7_5] = (byte)Integer.parseInt(new String(var21_17, var2_2 - 2, 2));
                    var2_2 -= 2;
                    ++var14_10;
                }
                break block33;
lbl-1000:
                // 1 sources

                {
                    --var2_2;
                    --var1_1;
lbl64:
                    // 2 sources

                    ** while (var1_1 > 0 && var2_2 > 0 && var21_17[var2_2 - 1] == '0')
                }
lbl65:
                // 1 sources

                if (var1_1 != 0 || var2_2 <= 1) break block34;
                if (var21_17[var2_2 - 1] == '.') {
                    --var2_2;
                }
                if (var3_3 != var2_2) ** GOTO lbl72
                return NUMBER._makeZero();
lbl-1000:
                // 1 sources

                {
                    var2_2 -= 2;
                    ++var12_9;
lbl72:
                    // 2 sources

                    ** while (var2_2 > 1 && var21_17[var2_2 - 2] == '0' && var21_17[var2_2 - 1] == '0')
                }
            }
            if (var12_9 > 62) {
                throw new SQLException(CoreException.getMessage((byte)3));
            }
            var4_19 = 0;
            while (var4_19 < var20_16) {
                if (var21_17[var4_19] == '.') {
                    var11_8 = true;
                    break;
                }
                ++var4_19;
            }
            if (var2_2 - var3_3 - (var11_8 != false ? 1 : 0) > var16_12) {
                var6_18 = var16_12 + (var11_8 != false ? 1 : 0);
                var22_20 = var2_2 - var6_18;
                var2_2 = var6_18;
                if ((var1_1 -= var22_20) < 0) {
                    var1_1 = 0;
                }
                var10_7 = true;
                var17_13 = var2_2;
            }
            v0 = var13_22 = var1_1 == 0 ? var2_2 - var3_3 : var2_2 - var1_1 - 1;
            if (var13_22 % 2 != 0) {
                var18_14 = Integer.parseInt(new String(var21_17, var3_3, 1));
                ++var3_3;
                --var13_22;
                if (var2_2 - 1 == var16_12) {
                    --var1_1;
                    var10_7 = true;
                    var17_13 = --var2_2;
                }
            } else {
                var18_14 = Integer.parseInt(new String(var21_17, var3_3, 2));
                var3_3 += 2;
                var13_22 -= 2;
            }
            var5_4[var7_5] = (byte)var18_14;
            ++var7_5;
            ++var14_10;
            while (var13_22 > 0) {
                var5_4[var7_5] = (byte)Integer.parseInt(new String(var21_17, var3_3, 2));
                ++var7_5;
                var3_3 += 2;
                ++var12_9;
                var13_22 -= 2;
                ++var14_10;
            }
            if (var3_3 < var2_2) {
                if (var1_1 % 2 != 0) {
                    var5_4[var7_5 += var1_1 / 2] = (byte)(Integer.parseInt(new String(var21_17, var2_2 - 1, 1)) * 10);
                    --var2_2;
                    --var1_1;
                } else {
                    var5_4[var7_5 += var1_1 / 2 - 1] = (byte)Integer.parseInt(new String(var21_17, var2_2 - 2, 2));
                    var2_2 -= 2;
                    var1_1 -= 2;
                }
                ++var14_10;
                --var7_5;
            }
            while (var1_1 > 0) {
                var5_4[var7_5] = (byte)Integer.parseInt(new String(var21_17, var2_2 - 2, 2));
                --var7_5;
                var2_2 -= 2;
                var1_1 -= 2;
                ++var14_10;
            }
        }
        if (var10_7) {
            var22_20 = var14_10;
            var18_14 = Integer.parseInt(new String(var21_17, var17_13, 1));
            if (var18_14 >= 5) {
                v1 = --var22_20;
                var5_4[v1] = (byte)(var5_4[v1] + 1);
                while (var5_4[var22_20] == 100) {
                    if (var22_20 == 0) {
                        ++var12_9;
                        var5_4[var22_20] = 1;
                        break;
                    }
                    var5_4[var22_20] = 0;
                    v2 = --var22_20;
                    var5_4[v2] = (byte)(var5_4[v2] + 1);
                }
                var4_19 = var14_10 - 1;
                while (var4_19 >= 0) {
                    if (var5_4[var4_19] != 0) break;
                    --var14_10;
                    --var4_19;
                }
            }
        }
        var22_21 = new byte[var14_10 + 1];
        var22_21[0] = (byte)var12_9;
        System.arraycopy(var5_4, 0, var22_21, 1, var14_10);
        return NUMBER._toLnxFmt(var22_21, var9_6);
    }

    public static byte[] toBytes(BigDecimal bigDecimal) throws SQLException {
        int n;
        long l;
        BigDecimal bigDecimal2;
        byte[] byArray = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n2 = 21;
        int n3 = 0;
        int n4 = 21;
        int n5 = 0;
        int n6 = 0;
        BigDecimal bigDecimal3 = bigDecimal.abs();
        int n7 = 0;
        if (bigDecimal.signum() == 0) {
            return NUMBER._makeZero();
        }
        boolean bl = bigDecimal.signum() != -1;
        int n8 = bigDecimal.scale();
        int n9 = bigDecimal3.compareTo(BIGDEC_ONE);
        int n10 = 0;
        if (n9 == -1) {
            while ((bigDecimal2 = bigDecimal3.movePointRight(++n10)).compareTo(BIGDEC_ONE) < 0) {
            }
            n7 = -n10;
        } else {
            while ((bigDecimal2 = bigDecimal3.movePointLeft(++n10)).compareTo(BIGDEC_ONE) >= 0) {
            }
            n7 = n10;
        }
        byte[] byArray2 = bigDecimal3.movePointRight(n8).toBigInteger().toByteArray();
        if (byArray2.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int n11 = 0;
        while (n11 < byArray2.length) {
            lArray[n11] = byArray2[n11] < 0 ? (long)(byArray2[n11] + 256) : (long)byArray2[n11];
            ++n11;
        }
        int n12 = byArray2.length;
        switch (n12 % 3) {
            case 2: {
                lArray2[n2] = (lArray[n3] << 8) + lArray[n3 + 1];
                n3 = (byte)(n3 + 2);
                n12 -= 2;
                break;
            }
            case 1: {
                lArray2[n2] = lArray[n3];
                n3 = (byte)(n3 + 1);
                --n12;
                break;
            }
            default: {
                l = (lArray[n3] << 16) + (lArray[n3 + 1] << 8) + lArray[n3 + 2];
                lArray2[n2] = l % 1000000L;
                lArray2[n2 - 1] = l / 1000000L;
                n4 = (byte)(n4 - (lArray2[n2 - 1] != 0L ? 1 : 0));
                n3 = (byte)(n3 + 3);
                n12 -= 3;
                break;
            }
        }
        while (n12 != 0) {
            l = (lArray[n3] << 4) + (lArray[n3 + 1] >> 4);
            n2 = 21;
            while (n2 >= n4) {
                lArray2[n2] = (l += lArray2[n2] << 12) % 1000000L;
                l /= 1000000L;
                n2 = (byte)(n2 - 1);
            }
            if (l != 0L) {
                n4 = (byte)(n4 - 1);
                lArray2[n4] = l;
            }
            l = ((lArray[n3 + 1] & 0xFL) << 8) + lArray[n3 + 2];
            n2 = 21;
            while (n2 >= n4) {
                lArray2[n2] = (l += lArray2[n2] << 12) % 1000000L;
                l /= 1000000L;
                n2 = (byte)(n2 - 1);
            }
            if (l != 0L) {
                n4 = (byte)(n4 - 1);
                lArray2[n4] = l;
            }
            n3 = (byte)(n3 + 3);
            n12 -= 3;
        }
        byArray[n5] = (byte)(lArray2[n4] / 10000L);
        if (byArray[n5] != 0) {
            n = 3 * (21 - n4) + 3;
            byArray[n5 + 1] = (byte)(lArray2[n4] % 10000L / 100L);
            byArray[n5 + 2] = (byte)(lArray2[n4] % 100L);
            n5 += 3;
        } else {
            byArray[n5] = (byte)(lArray2[n4] % 10000L / 100L);
            if (byArray[n5] != 0) {
                n = 3 * (21 - n4) + 2;
                byArray[n5 + 1] = (byte)(lArray2[n4] % 100L);
                n5 += 2;
            } else {
                byArray[n5] = (byte)lArray2[n4];
                n = 3 * (21 - n4) + 1;
                ++n5;
            }
        }
        n2 = (byte)(n4 + 1);
        while (n2 <= 21) {
            byArray[n5] = (byte)(lArray2[n2] / 10000L);
            byArray[n5 + 1] = (byte)(lArray2[n2] % 10000L / 100L);
            byArray[n5 + 2] = (byte)(lArray2[n2] % 100L);
            n5 += 3;
            n2 = (byte)(n2 + 1);
        }
        n11 = n5 - 1;
        while (n11 >= 0) {
            if (byArray[n11] != 0) break;
            --n;
            --n11;
        }
        if (n8 > 0 && (n8 & 1) != 0) {
            int n13 = n;
            byte[] byArray3 = new byte[n13 + 1];
            if (byArray[0] <= 9) {
                n11 = 0;
                while (n11 < n13 - 1) {
                    byArray3[n11] = (byte)(byArray[n11] % 10 * 10 + byArray[n11 + 1] / 10);
                    ++n11;
                }
                byArray3[n11] = (byte)(byArray[n11] % 10 * 10);
                if (byArray3[n13 - 1] == 0) {
                    --n;
                }
            } else {
                byArray3[n13] = (byte)(byArray[n13 - 1] % 10 * 10);
                n11 = n13 - 1;
                while (n11 > 0) {
                    byArray3[n11] = (byte)(byArray[n11] / 10 + byArray[n11 - 1] % 10 * 10);
                    --n11;
                }
                byArray3[n11] = (byte)(byArray[n11] / 10);
                if (byArray3[n13] > 0) {
                    ++n;
                }
            }
            System.arraycopy(byArray3, 0, byArray, 0, n);
        }
        if (n > 20) {
            n11 = 20;
            n = 20;
            if (byArray[n11] >= 50) {
                int n14 = --n11;
                byArray[n14] = (byte)(byArray[n14] + 1);
                while (byArray[n11] == 100) {
                    if (n11 == 0) {
                        ++n7;
                        byArray[n11] = 1;
                        break;
                    }
                    byArray[n11] = 0;
                    int n15 = --n11;
                    byArray[n15] = (byte)(byArray[n15] + 1);
                }
                n11 = n - 1;
                while (n11 >= 0) {
                    if (byArray[n11] != 0) break;
                    --n;
                    --n11;
                }
            }
        }
        n6 = n7 <= 0 ? (byArray[0] < 10 ? -(2 - n7) / 2 + 1 : -(2 - n7) / 2) : (n7 - 1) / 2;
        if (n6 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (n6 <= -65) {
            throw new SQLException(CoreException.getMessage((byte)2));
        }
        byte[] byArray4 = new byte[n + 1];
        byArray4[0] = (byte)n6;
        System.arraycopy(byArray, 0, byArray4, 1, n);
        return NUMBER._toLnxFmt(byArray4, bl);
    }

    public static byte[] toBytes(BigInteger bigInteger) throws SQLException {
        int n;
        long l;
        int n2;
        byte[] byArray;
        Object object;
        byte[] byArray2 = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n3 = 21;
        int n4 = 0;
        int n5 = 21;
        boolean bl = false;
        int n6 = 0;
        boolean bl2 = true;
        if (bigInteger.signum() == 0) {
            return NUMBER._makeZero();
        }
        if (bigInteger.signum() == -1) {
            object = bigInteger.abs();
            bl2 = false;
            byArray = ((BigInteger)object).toByteArray();
            n2 = (int)Math.floor((double)((BigInteger)object).bitLength() * 0.1505149978319906);
        } else {
            byArray = bigInteger.toByteArray();
            n2 = (int)Math.floor((double)bigInteger.bitLength() * 0.1505149978319906);
        }
        if (byArray.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int n7 = 0;
        while (n7 < byArray.length) {
            lArray[n7] = byArray[n7] < 0 ? (long)(byArray[n7] + 256) : (long)byArray[n7];
            ++n7;
        }
        int n8 = byArray.length;
        switch (n8 % 3) {
            case 2: {
                lArray2[n3] = (lArray[n4] << 8) + lArray[n4 + 1];
                n4 = (byte)(n4 + 2);
                n8 -= 2;
                break;
            }
            case 1: {
                lArray2[n3] = lArray[n4];
                n4 = (byte)(n4 + 1);
                --n8;
                break;
            }
            default: {
                l = (lArray[n4] << 16) + (lArray[n4 + 1] << 8) + lArray[n4 + 2];
                lArray2[n3] = l % 1000000L;
                lArray2[n3 - 1] = l / 1000000L;
                n5 = (byte)(n5 - (lArray2[n3 - 1] != 0L ? 1 : 0));
                n4 = (byte)(n4 + 3);
                n8 -= 3;
                break;
            }
        }
        while (n8 != 0) {
            l = (lArray[n4] << 4) + (lArray[n4 + 1] >> 4);
            n3 = 21;
            while (n3 >= n5) {
                lArray2[n3] = (l += lArray2[n3] << 12) % 1000000L;
                l /= 1000000L;
                n3 = (byte)(n3 - 1);
            }
            if (l != 0L) {
                n5 = (byte)(n5 - 1);
                lArray2[n5] = l;
            }
            l = ((lArray[n4 + 1] & 0xFL) << 8) + lArray[n4 + 2];
            n3 = 21;
            while (n3 >= n5) {
                lArray2[n3] = (l += lArray2[n3] << 12) % 1000000L;
                l /= 1000000L;
                n3 = (byte)(n3 - 1);
            }
            if (l != 0L) {
                n5 = (byte)(n5 - 1);
                lArray2[n5] = l;
            }
            n4 = (byte)(n4 + 3);
            n8 -= 3;
        }
        byArray2[n6] = (byte)(lArray2[n5] / 10000L);
        if (byArray2[n6] != 0) {
            n = 3 * (21 - n5) + 3;
            byArray2[n6 + 1] = (byte)(lArray2[n5] % 10000L / 100L);
            byArray2[n6 + 2] = (byte)(lArray2[n5] % 100L);
            n6 += 3;
        } else {
            byArray2[n6] = (byte)(lArray2[n5] % 10000L / 100L);
            if (byArray2[n6] != 0) {
                n = 3 * (21 - n5) + 2;
                byArray2[n6 + 1] = (byte)(lArray2[n5] % 100L);
                n6 += 2;
            } else {
                byArray2[n6] = (byte)lArray2[n5];
                n = 3 * (21 - n5) + 1;
                ++n6;
            }
        }
        n3 = (byte)(n5 + 1);
        while (n3 <= 21) {
            byArray2[n6] = (byte)(lArray2[n3] / 10000L);
            byArray2[n6 + 1] = (byte)(lArray2[n3] % 10000L / 100L);
            byArray2[n6 + 2] = (byte)(lArray2[n3] % 100L);
            n6 += 3;
            n3 = (byte)(n3 + 1);
        }
        n7 = n6 - 1;
        while (n7 >= 0) {
            if (byArray2[n7] != 0) break;
            --n;
            --n7;
        }
        if (n > 19) {
            n7 = 20;
            n = 19;
            if (byArray2[n7] >= 50) {
                int n9 = --n7;
                byArray2[n9] = (byte)(byArray2[n9] + 1);
                while (byArray2[n7] == 100) {
                    if (n7 == 0) {
                        ++n2;
                        byArray2[n7] = 1;
                        break;
                    }
                    byArray2[n7] = 0;
                    int n10 = --n7;
                    byArray2[n10] = (byte)(byArray2[n10] + 1);
                }
                n7 = n - 1;
                while (n7 >= 0) {
                    if (byArray2[n7] != 0) break;
                    --n;
                    --n7;
                }
            }
        }
        if (n2 > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        object = new byte[n + 1];
        object[0] = (byte)n2;
        System.arraycopy(byArray2, 0, object, 1, n);
        return NUMBER._toLnxFmt((byte[])object, bl2);
    }

    public static byte[] toBytes(short s) {
        return NUMBER.toBytes((long)s);
    }

    public static byte[] toBytes(boolean bl) {
        if (bl) {
            return NUMBER.toBytes(1L);
        }
        return NUMBER.toBytes(0L);
    }

    public static double toDouble(byte[] byArray) {
        if (NUMBER._isZero(byArray)) {
            return 0.0;
        }
        if (NUMBER._isPosInf(byArray)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NUMBER._isNegInf(byArray)) {
            return Double.NEGATIVE_INFINITY;
        }
        return NUMBER._getLnxLib().lnxnur(byArray);
    }

    public static float toFloat(byte[] byArray) {
        return (float)NUMBER.toDouble(byArray);
    }

    public String toFormattedText(String string, String string2) throws SQLException {
        return NUMBER._getLnxLib().lnxnfn(this.shareBytes(), string, string2);
    }

    public static int toInt(byte[] byArray) throws SQLException {
        long l = 0L;
        l = NUMBER.toLong(byArray);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (int)l;
    }

    public Object toJdbc() throws SQLException {
        try {
            return this.bigDecimalValue();
        }
        catch (SQLException sQLException) {
            return new SQLException(sQLException.getMessage());
        }
    }

    public static long toLong(byte[] byArray) throws SQLException {
        if (NUMBER._isZero(byArray)) {
            return 0L;
        }
        if (NUMBER._isInf(byArray) || Datum.compareBytes(byArray, MAX_LONG) > 0 || Datum.compareBytes(byArray, MIN_LONG) < 0) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return NUMBER._getLnxLib().lnxsni(byArray);
    }

    public static short toShort(byte[] byArray) throws SQLException {
        long l = 0L;
        l = NUMBER.toLong(byArray);
        if (l > 32767L || l < -32768L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (short)l;
    }

    public static String toString(byte[] byArray) {
        int n = 0;
        if (NUMBER._isZero(byArray)) {
            return new String("0");
        }
        if (NUMBER._isPosInf(byArray)) {
            return new Double(Double.POSITIVE_INFINITY).toString();
        }
        if (NUMBER._isNegInf(byArray)) {
            return new Double(Double.NEGATIVE_INFINITY).toString();
        }
        byte[] byArray2 = NUMBER._fromLnxFmt(byArray);
        int n2 = byArray2[0];
        int n3 = byArray2.length - 1;
        int n4 = n2 - (n3 - 1);
        char[] cArray = new char[512];
        if (!NUMBER._isPositive(byArray)) {
            cArray[n++] = 45;
        }
        if (n4 >= 0) {
            n += NUMBER._byteToChars(byArray2[1], cArray, n);
            int n5 = 2;
            while (n5 <= n3) {
                NUMBER._byteTo2Chars(byArray2[n5], cArray, n);
                n += 2;
                ++n5;
                --n2;
            }
            if (n2 > 0) {
                while (n2 > 0) {
                    cArray[n++] = 48;
                    cArray[n++] = 48;
                    --n2;
                }
            }
        } else {
            int n6 = n3 + n4;
            if (n6 > 0) {
                n += NUMBER._byteToChars(byArray2[1], cArray, n);
                if (n6 == 1) {
                    cArray[n++] = 46;
                }
                int n7 = 2;
                while (n7 < n3) {
                    NUMBER._byteTo2Chars(byArray2[n7], cArray, n);
                    n += 2;
                    if (n6 == n7) {
                        cArray[n++] = 46;
                    }
                    ++n7;
                }
                if (byArray2[n7] % 10 == 0) {
                    n += NUMBER._byteToChars((byte)(byArray2[n7] / 10), cArray, n);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n7], cArray, n);
                    n += 2;
                }
            } else {
                cArray[n++] = 48;
                cArray[n++] = 46;
                while (n6 < 0) {
                    cArray[n++] = 48;
                    cArray[n++] = 48;
                    ++n6;
                }
                int n8 = 1;
                while (n8 < n3) {
                    NUMBER._byteTo2Chars(byArray2[n8], cArray, n);
                    n += 2;
                    ++n8;
                }
                if (byArray2[n8] % 10 == 0) {
                    n += NUMBER._byteToChars((byte)(byArray2[n8] / 10), cArray, n);
                } else {
                    NUMBER._byteTo2Chars(byArray2[n8], cArray, n);
                    n += 2;
                }
            }
        }
        return new String(cArray, 0, n);
    }

    public String toText(String string) throws SQLException {
        return NUMBER._getLnxLib().lnxnuc(this.shareBytes(), string);
    }

    public NUMBER truncate(int n) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtru(this.shareBytes(), n));
    }

    public static NUMBER zero() {
        return new NUMBER(NUMBER._makeZero());
    }
}

