/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.anatproc;

import com.pixelmed.anatproc.Concept;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.utils.StringUtilities;

public class CodedConcept
extends Concept {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/anatproc/CodedConcept.java,v 1.3 2010/04/08 22:38:41 dclunie Exp $";
    protected String codingSchemeDesignator;
    protected String legacyCodingSchemeDesignator;
    protected String codingSchemeVersion;
    protected String codeValue;
    protected String codeMeaning;
    protected String codeStringEquivalent;
    protected String[] synonynms;

    public CodedConcept(String string, String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray) {
        super(string);
        this.codingSchemeDesignator = string2;
        this.legacyCodingSchemeDesignator = string3;
        this.codingSchemeVersion = string4;
        this.codeValue = string5;
        this.codeMeaning = string6;
        this.codeStringEquivalent = string7;
        this.synonynms = stringArray;
    }

    protected CodedConcept() {
    }

    public String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public String getLegacyCodingSchemeDesignator() {
        return this.legacyCodingSchemeDesignator;
    }

    public String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public String getCodeValue() {
        return this.codeValue;
    }

    public String getCodeMeaning() {
        return this.codeMeaning;
    }

    public String getCodeStringEquivalent() {
        return this.codeStringEquivalent;
    }

    public String[] getSynonyms() {
        return this.synonynms;
    }

    public CodedSequenceItem getCodedSequenceItem() throws DicomException {
        CodedSequenceItem codedSequenceItem = this.codingSchemeVersion != null && this.codingSchemeVersion.length() > 0 ? new CodedSequenceItem(this.codeValue, this.codingSchemeDesignator, this.codingSchemeVersion, this.codeMeaning) : new CodedSequenceItem(this.codeValue, this.codingSchemeDesignator, this.codeMeaning);
        return codedSequenceItem;
    }

    public String getCodeAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.codeValue);
        stringBuffer.append(",");
        if (this.legacyCodingSchemeDesignator == null) {
            stringBuffer.append(this.codingSchemeDesignator);
        } else {
            stringBuffer.append(this.legacyCodingSchemeDesignator);
            stringBuffer.append(" {");
            stringBuffer.append(this.codingSchemeDesignator);
            stringBuffer.append("}");
        }
        if (this.codingSchemeVersion != null) {
            stringBuffer.append(" [");
            stringBuffer.append(this.codingSchemeVersion);
            stringBuffer.append("]");
        }
        stringBuffer.append(",\"");
        stringBuffer.append(this.codeMeaning);
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\tcode: ");
        stringBuffer.append(this.getCodeAsString());
        stringBuffer.append("\n");
        stringBuffer.append("\tcodeStringEquivalent: ");
        stringBuffer.append(this.codeStringEquivalent);
        stringBuffer.append("\n");
        stringBuffer.append("\tsynonynms: ");
        stringBuffer.append(StringUtilities.toString(this.synonynms));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String toStringBrief() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CUI: ");
        stringBuffer.append(this.conceptUniqueIdentifier);
        stringBuffer.append(" ");
        stringBuffer.append(this.getCodeAsString());
        return stringBuffer.toString();
    }
}

