/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.anatproc;

import com.pixelmed.anatproc.DisplayableConcept;
import com.pixelmed.anatproc.SchemeAndValuePair;
import com.pixelmed.dicom.CodedSequenceItem;
import java.util.HashMap;

public class DictionaryOfConcepts {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/anatproc/DictionaryOfConcepts.java,v 1.5 2010/08/15 17:50:55 dclunie Exp $";
    protected DisplayableConcept[] conceptEntries;
    protected HashMap schemeAndValuePairsToConceptEntries;
    protected HashMap meaningsAndSynonymsToConceptEntries;
    protected HashMap codeStringEquivalentToConceptEntries;
    protected String[] badWords;
    protected String descriptionOfConcept;

    protected void doCommonConstructorStuff(DisplayableConcept[] displayableConceptArray, String[] stringArray, String string) {
        this.conceptEntries = displayableConceptArray;
        this.badWords = stringArray;
        this.descriptionOfConcept = string;
        this.schemeAndValuePairsToConceptEntries = new HashMap();
        this.meaningsAndSynonymsToConceptEntries = new HashMap();
        this.codeStringEquivalentToConceptEntries = new HashMap();
        for (DisplayableConcept displayableConcept : displayableConceptArray) {
            String[] stringArray2 = displayableConcept.getCodeValue();
            String string2 = displayableConcept.getCodingSchemeDesignator();
            SchemeAndValuePair schemeAndValuePair = new SchemeAndValuePair((String)stringArray2, string2);
            this.schemeAndValuePairsToConceptEntries.put(schemeAndValuePair, displayableConcept);
            String string3 = displayableConcept.getLegacyCodingSchemeDesignator();
            if (string3 != null) {
                schemeAndValuePair = new SchemeAndValuePair((String)stringArray2, string3);
                this.schemeAndValuePairsToConceptEntries.put(schemeAndValuePair, displayableConcept);
            }
            stringArray2 = displayableConcept.getCodeMeaning();
            String string4 = stringArray2.toLowerCase();
            this.meaningsAndSynonymsToConceptEntries.put(string4, displayableConcept);
            stringArray2 = displayableConcept.getCodeStringEquivalent();
            if (stringArray2 != null) {
                this.codeStringEquivalentToConceptEntries.put(stringArray2, displayableConcept);
                String string5 = stringArray2.toLowerCase();
                this.meaningsAndSynonymsToConceptEntries.put(string5, displayableConcept);
            }
            if ((stringArray2 = displayableConcept.getSynonyms()) == null) continue;
            for (String string6 : stringArray2) {
                String string7 = string6.toLowerCase();
                this.meaningsAndSynonymsToConceptEntries.put(string7, displayableConcept);
            }
        }
    }

    public DictionaryOfConcepts(DisplayableConcept[] displayableConceptArray) {
        this.doCommonConstructorStuff(displayableConceptArray, null, null);
    }

    public DictionaryOfConcepts(DisplayableConcept[] displayableConceptArray, String[] stringArray, String string) {
        this.doCommonConstructorStuff(displayableConceptArray, stringArray, string);
    }

    public String getDescriptionOfConcept() {
        return this.descriptionOfConcept == null ? "" : this.descriptionOfConcept;
    }

    public DisplayableConcept find(SchemeAndValuePair schemeAndValuePair) {
        return (DisplayableConcept)this.schemeAndValuePairsToConceptEntries.get(schemeAndValuePair);
    }

    public DisplayableConcept find(CodedSequenceItem codedSequenceItem) {
        return this.find(new SchemeAndValuePair(codedSequenceItem));
    }

    public DisplayableConcept find(String string) {
        return (DisplayableConcept)this.meaningsAndSynonymsToConceptEntries.get(string.toLowerCase());
    }

    public DisplayableConcept findCodeStringExact(String string) {
        return (DisplayableConcept)this.codeStringEquivalentToConceptEntries.get(string);
    }

    protected String removeAnyBadWords(String string) {
        if (this.badWords != null) {
            for (String string2 : this.badWords) {
                string = string.replaceAll(string2.toLowerCase(), " ");
            }
            string = string.replaceAll("[ ][ ]*", " ").trim().replaceAll("^[ ]$", "");
        }
        return string;
    }

    protected static String removeAccentsFromLowerCaseString(String string) {
        string = string.replaceAll("[\u00e0\u00e1\u00e3\u00e4\u00e5\u0101\u0105\u0103\u00e2]", "a");
        string = string.replaceAll("[\u00e6]", "ae");
        string = string.replaceAll("[\u00e7\u0107\u0109\u010b]", "c");
        string = string.replaceAll("[\u010f\u0111]", "d");
        string = string.replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0119\u011b\u0115\u0117]", "e");
        string = string.replaceAll("[\u0192]", "f");
        string = string.replaceAll("[\u011d\u011f\u0121\u0123]", "g");
        string = string.replaceAll("[\u0125\u0127]", "h");
        string = string.replaceAll("[\u00ec\u00ed\u00ee\u00ef\u012b\u0129\u012d\u012f\u0131]", "i");
        string = string.replaceAll("[\u0133]", "ij");
        string = string.replaceAll("[\u0135]", "j");
        string = string.replaceAll("[\u0138]", "k");
        string = string.replaceAll("[\u0142\u013e\u013a\u013c\u0140]", "l");
        string = string.replaceAll("[\u00f1\u0144\u0148\u0146\u0149\u014b]", "n");
        string = string.replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u0151\u014f]", "o");
        string = string.replaceAll("[\u0153]", "oe");
        string = string.replaceAll("[\u0155\u0159\u0157]", "r");
        string = string.replaceAll("[\u015b\u0161\u015f\u015d\u0219]", "s");
        string = string.replaceAll("[\u0165\u0163\u0167\u021b]", "t");
        string = string.replaceAll("[\u00f9\u00fa\u00fb\u00fc\u016b\u016f\u0171\u016d\u0169\u0173]", "u");
        string = string.replaceAll("[\u0175]", "w");
        string = string.replaceAll("[\u00fd\u00ff\u0177]", "y");
        string = string.replaceAll("[\u017e\u017c\u017a]", "z");
        string = string.replaceAll("[\u00df]", "ss");
        return string;
    }

    protected DisplayableConcept findLongestIndividualEntryContainedWithin(String string) {
        DisplayableConcept displayableConcept = null;
        String string2 = string.toLowerCase();
        string2 = DictionaryOfConcepts.removeAccentsFromLowerCaseString(string2);
        string2 = string2.replaceAll("[^\\p{L}\\d]", " ").replaceAll("[ ][ ]*", " ").trim().replaceAll("^[ ]$", "");
        if ((string2 = this.removeAnyBadWords(string2)).length() > 0) {
            int n = 0;
            for (DisplayableConcept displayableConcept2 : this.conceptEntries) {
                String[] stringArray;
                int n2;
                String string3 = displayableConcept2.getCodeMeaning().toLowerCase();
                if (string2.contains(string3) && (n2 = string3.length()) > n) {
                    displayableConcept = displayableConcept2;
                    n = n2;
                }
                if ((stringArray = displayableConcept2.getSynonyms()) == null) continue;
                for (String string4 : stringArray) {
                    int n3;
                    string4 = string4.toLowerCase();
                    if (!string2.contains(string4 = DictionaryOfConcepts.removeAccentsFromLowerCaseString(string4)) || (n3 = string4.length()) <= n) continue;
                    displayableConcept = displayableConcept2;
                    n = n3;
                }
            }
        }
        return displayableConcept;
    }

    protected DisplayableConcept findInEntriesFirstThenTryLongestIndividualEntryContainedWithin(String string) {
        DisplayableConcept displayableConcept = this.find(string);
        if (displayableConcept == null) {
            displayableConcept = this.findLongestIndividualEntryContainedWithin(string);
        }
        return displayableConcept;
    }

    protected DisplayableConcept findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning(CodedSequenceItem codedSequenceItem) {
        String string;
        DisplayableConcept displayableConcept = this.find(codedSequenceItem);
        if (displayableConcept == null && (string = codedSequenceItem.getCodeMeaning()) != null) {
            displayableConcept = this.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin(string);
        }
        return displayableConcept;
    }
}

