/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SOPClassDescriptions;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.display.DicomBrowser;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.dose.CTDose;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.GenerateRadiationDoseStructuredReport;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.doseocr.RenderedDoseReport;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.ftp.FTPApplicationProperties;
import com.pixelmed.ftp.FTPClientApplicationConfigurationDialog;
import com.pixelmed.ftp.FTPFileSender;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPRemoteHostInformation;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.NetworkApplicationConfigurationDialog;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.network.TransferSyntaxSelectionPolicy;
import com.pixelmed.network.UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeBrowser;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.validate.DicomSRValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoseUtility
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/DoseUtility.java,v 1.30 2010/11/27 23:38:48 dclunie Exp $";
    protected static String propertiesFileName = ".com.pixelmed.apps.DoseUtility.properties";
    protected static String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    protected static String propertyName_DicomCurrentlySelectedQueryTargetAE = "Dicom.CurrentlySelectedQueryTargetAE";
    protected static String propertyName_CurrentlySelectedDoseRegistry = "DoseUtility.CurrentlySelectedDoseRegistry";
    protected static String localDatabaseName = "Local";
    protected static int textFieldLengthForQueryPatientName = 16;
    protected static int textFieldLengthForQueryPatientID = 10;
    protected static int textFieldLengthForQueryStudyDate = 8;
    protected static String queryIntroductionLabelText = "Query -";
    protected static String queryPatientNameLabelText = "Patient's Name:";
    protected static String queryPatientIDLabelText = "Patient's ID:";
    protected static String queryStudyDateLabelText = "Study Date:";
    protected static String configureButtonLabel = "Configure";
    protected static String logButtonLabel = "Log";
    protected static String queryButtonLabel = "Query";
    protected static String retrieveButtonLabel = "Retrieve";
    protected static String importButtonLabel = "Import";
    protected static String viewButtonLabel = "View";
    protected static String validateButtonLabel = "Validate";
    protected static String reportButtonLabel = "Report";
    protected static String makeSRButtonLabel = "Make RDSR";
    protected static String sendButtonLabel = "->Dicom";
    protected static String registryButtonLabel = "->Registry";
    protected static String purgeButtonLabel = "Purge";
    protected static String configureButtonToolTipText = "Configure the application, including DICOM network properties";
    protected static String logButtonToolTipText = "Show the log of activities";
    protected static String queryButtonToolTipText = "Query a remote DICOM network host";
    protected static String retrieveButtonToolTipText = "Retrieve query selection from remote DICOM network host";
    protected static String importButtonToolTipText = "Import from media into originals database";
    protected static String viewButtonToolTipText = "View image or structured report contents";
    protected static String validateButtonToolTipText = "Validate structured report contents";
    protected static String reportButtonToolTipText = "Generate report of dose information";
    protected static String makeSRButtonToolTipText = "Generate Radiation Dose Structured Report from extracted dose information";
    protected static String sendButtonToolTipText = "Send Radiation Dose Structured Reports to remote DICOM host";
    protected static String registryButtonToolTipText = "Send Radiation Dose Structured Reports to Dose Registry";
    protected static String purgeButtonToolTipText = "Remove selected entry from local database and delete any local copy of files";
    protected static String queryPatientNameToolTipText = "The text to use for the Patient's Name when querying";
    protected static String queryPatientIDToolTipText = "The text to use for the Patient's ID when querying";
    protected static String queryStudyDateToolTipText = "The text to use for the Study Date when querying";
    protected static String retrieveOnlyDoseSeriesRecordLabelText = "Retrieve only dose series";
    protected static String processOnlyDoseSeriesRecordLabelText = "Process only dose series";
    protected static String showOnlyDoseSummaryLabelText = "Show only dose summary";
    protected static String showDetailedLogLabelText = "Show detailed log";
    protected static String reportTabularLayoutLabelText = "Show tabular layout in report";
    protected static String caseSensitiveCodeMeaningValidationLabelText = "Case sensitive validation of code meanings";
    protected static String deidentifyWhenSendingToRegistryLabelText = "Deidentify when sending to registry";
    protected static String reportTitleMessage = "DoseUtility Report";
    protected static String loggerTitleMessage = "DoseUtility Log";
    protected static int viewerFrameWidthWanted = 512;
    protected static int viewerFrameHeightWanted = 512;
    protected static int validatorFrameWidthWanted = 512;
    protected static int validatorFrameHeightWanted = 384;
    protected static int reportDialogWidthWanted = 1200;
    protected static int reportDialogHeightWanted = 384;
    protected static int loggertDialogWidthWanted = 512;
    protected static int loggerDialogHeightWanted = 384;
    protected DatabaseInformationModel srcDatabase;
    protected JFrame mainFrame;
    protected JPanel srcDatabasePanel;
    protected JPanel remoteQueryRetrievePanel;
    protected JCheckBox retrieveOnlyDoseSeriesRecordCheckBox;
    protected JCheckBox processOnlyDoseSeriesRecordCheckBox;
    protected JCheckBox showOnlyDoseSummaryCheckBox;
    protected JCheckBox showDetailedLogCheckBox;
    protected JCheckBox reportTabularLayoutCheckBox;
    protected JCheckBox caseSensitiveCodeMeaningValidationCheckBox;
    protected JCheckBox deidentifyWhenSendingToRegistryCheckBox;
    protected JTextField queryFilterPatientNameTextField;
    protected JTextField queryFilterPatientIDTextField;
    protected JTextField queryFilterStudyDateTextField;
    protected JProgressBar progressBar;
    protected MessageLogger logger;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformation networkApplicationInformation;
    protected FTPApplicationProperties ftpApplicationProperties;
    protected FTPRemoteHostInformation ftpRemoteHostInformation;
    protected QueryInformationModel currentRemoteQueryInformationModel;
    protected QueryTreeBrowser currentRemoteQueryTreeBrowser;
    protected String ourCalledAETitle;
    protected static DicomSRValidator validator;
    protected static boolean haveScannedForCodecs;
    protected static boolean haveCheckedForJPEGLosslessCodec;
    protected static boolean haveFoundJPEGLosslessCodec;
    protected static boolean haveCheckedForJPEG2000Part1Codec;
    protected static boolean haveFoundJPEG2000Part1Codec;
    protected File savedImagesFolder;
    protected StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher;
    protected DatabaseTreeRecord currentDatabaseTreeRecordSelection;
    Thread activeThread;

    protected boolean haveJPEGLosslessCodec() {
        if (!haveCheckedForJPEGLosslessCodec) {
            if (!haveScannedForCodecs) {
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEGLosslessCodec = false;
            String string = "jpeg-lossless";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    haveFoundJPEGLosslessCodec = true;
                    try {
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            catch (Exception exception) {
                haveFoundJPEGLosslessCodec = false;
            }
            haveCheckedForJPEGLosslessCodec = true;
        }
        return haveFoundJPEGLosslessCodec;
    }

    protected boolean haveJPEG2000Part1Codec() {
        if (!haveCheckedForJPEG2000Part1Codec) {
            if (!haveScannedForCodecs) {
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEG2000Part1Codec = false;
            String string = "JPEG2000";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    haveFoundJPEG2000Part1Codec = true;
                    try {
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            catch (Exception exception) {
                haveFoundJPEG2000Part1Codec = false;
            }
            haveCheckedForJPEG2000Part1Codec = true;
        }
        return haveFoundJPEG2000Part1Codec;
    }

    protected void setCurrentRemoteQueryInformationModel(String string) {
        this.currentRemoteQueryInformationModel = null;
        String string2 = "";
        if (string != null && string.length() > 0 && this.networkApplicationProperties != null && this.networkApplicationInformation != null) {
            try {
                String string3 = this.networkApplicationProperties.getCallingAETitle();
                String string4 = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string4);
                if (presentationAddress == null) {
                    throw new Exception("For remote query AE <" + string + ">, presentationAddress cannot be determined");
                }
                String string5 = presentationAddress.getHostname();
                int n = presentationAddress.getPort();
                String string6 = this.networkApplicationInformation.getApplicationEntityMap().getQueryModel(string4);
                int n2 = this.networkApplicationProperties.getQueryDebugLevel();
                if (!NetworkApplicationProperties.isStudyRootQueryModel(string6) && string6 != null) {
                    throw new Exception("For remote query AE <" + string + ">, query model " + string6 + " not supported");
                }
                this.currentRemoteQueryInformationModel = new StudyRootQueryInformationModel(string5, n, string4, string3, n2);
                string2 = ":" + string;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.networkApplicationInformation != null && (set = this.networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(null, string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    protected static void importFileIntoDatabase(DatabaseInformationModel databaseInformationModel, String string, String string2) throws FileNotFoundException, IOException, DicomException {
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing: " + string));
        FileInputStream fileInputStream = new FileInputStream(string);
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream, TagFromName.PixelData);
        dicomInputStream.close();
        fileInputStream.close();
        databaseInformationModel.insertObject(attributeList, string, string2);
    }

    protected void activateStorageSCP() throws DicomException, IOException {
        if (this.networkApplicationProperties != null) {
            int n = this.networkApplicationProperties.getListeningPort();
            this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Starting up DICOM association listener on port " + n + " AET " + this.ourCalledAETitle));
            System.err.println("Starting up DICOM association listener on port " + n + " AET " + this.ourCalledAETitle);
            int n2 = this.networkApplicationProperties.getStorageSCPDebugLevel();
            int n3 = this.networkApplicationProperties.getQueryDebugLevel();
            this.storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.savedImagesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDINSINGLEFOLDER, new OurReceivedObjectHandler(), this.srcDatabase == null ? null : this.srcDatabase.getQueryResponseGeneratorFactory(n3), this.srcDatabase == null ? null : this.srcDatabase.getRetrieveResponseGeneratorFactory(n3), this.networkApplicationInformation, new OurPresentationContextSelectionPolicy(), false, n2);
            new Thread(this.storageSOPClassSCPDispatcher).start();
        }
    }

    protected void activateTemporaryDatabases() throws DicomException {
        this.srcDatabase = new PatientStudySeriesConcatenationInstanceModel("mem:src", null, localDatabaseName);
    }

    protected Vector getCurrentSourceFilePathSelections() {
        Vector vector = new Vector();
        if (this.currentDatabaseTreeRecordSelection != null) {
            DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(this.currentDatabaseTreeRecordSelection, vector);
        }
        return vector;
    }

    public static void recurseThroughChildrenGatheringFileNamesOfDoseFiles(DatabaseTreeRecord databaseTreeRecord, Vector vector, boolean bl) {
        Object object;
        Object object2;
        InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            object2 = databaseTreeRecord.getLocalPrimaryKeyValue();
            if (informationEntity != null && object2 != null) {
                object = null;
                try {
                    String string;
                    String string2;
                    object = databaseTreeRecord.getDatabaseInformationModel().findAllAttributeValuesForSelectedRecord(informationEntity, (String)object2);
                    if (informationEntity.equals(InformationEntity.SERIES)) {
                        String string3;
                        string2 = (String)object.get("MODALITY");
                        if (!(OCR.isPossiblyDoseScreenSeries(string2, string = (String)object.get("SERIESNUMBER"), string3 = (String)object.get("SERIESDESCRIPTION")) || ExposureDoseSequence.isPossiblyPhilipsDoseScreenSeries(string2, string, string3) || string2.equals("SR"))) {
                            bl3 = false;
                        }
                    } else if (!(!informationEntity.equals(InformationEntity.INSTANCE) || OCR.isPossiblyDoseScreenInstance(string2 = (String)object.get("SOPCLASSUID"), string = (String)object.get("IMAGETYPE")) || ExposureDoseSequence.isPossiblyPhilipsDoseScreenInstance(string2, string) || string2.equals("1.2.840.10008.5.1.4.1.1.88.67") || string2.equals("1.2.840.10008.5.1.4.1.1.88.22") || string2.equals("1.2.840.10008.5.1.4.1.1.88.33"))) {
                        bl3 = false;
                        bl2 = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        if (bl2 && informationEntity == InformationEntity.INSTANCE && (object2 = databaseTreeRecord.getLocalFileNameValue()) != null) {
            vector.add(object2);
        }
        if (bl3 && (object2 = databaseTreeRecord.children()) != null) {
            while (object2.hasMoreElements()) {
                object = (DatabaseTreeRecord)object2.nextElement();
                if (object == null) continue;
                DoseUtility.recurseThroughChildrenGatheringFileNamesOfDoseFiles((DatabaseTreeRecord)object, vector, bl);
            }
        }
    }

    public static void recurseThroughChildrenGatheringFileNamesOfSRFiles(DatabaseTreeRecord databaseTreeRecord, Vector vector) {
        Object object;
        Object object2;
        InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
        if (informationEntity != null && informationEntity.equals(InformationEntity.INSTANCE) && (object2 = databaseTreeRecord.getLocalPrimaryKeyValue()) != null) {
            object = null;
            try {
                String string;
                String string2;
                object = databaseTreeRecord.getDatabaseInformationModel().findAllAttributeValuesForSelectedRecord(informationEntity, (String)object2);
                if (object != null && SOPClass.isStructuredReport(string2 = (String)object.get("SOPCLASSUID")) && (string = databaseTreeRecord.getLocalFileNameValue()) != null) {
                    vector.add(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if ((object2 = databaseTreeRecord.children()) != null) {
            while (object2.hasMoreElements()) {
                object = (DatabaseTreeRecord)object2.nextElement();
                if (object == null) continue;
                DoseUtility.recurseThroughChildrenGatheringFileNamesOfSRFiles((DatabaseTreeRecord)object, vector);
            }
        }
    }

    protected Vector extractRadiationDoseSRFiles(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.get(i);
                try {
                    CodedSequenceItem codedSequenceItem;
                    DicomInputStream dicomInputStream = new DicomInputStream(new FileInputStream(string));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream);
                    dicomInputStream.close();
                    String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                    if (string2.equals("1.2.840.10008.5.1.4.1.1.88.67")) {
                        vector2.add(string);
                        continue;
                    }
                    if (!attributeList.isSRDocument() || (codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ConceptNameCodeSequence)) == null) continue;
                    String string3 = codedSequenceItem.getCodingSchemeDesignator();
                    String string4 = codedSequenceItem.getCodeValue();
                    if (string3 == null || !string3.equals("DCM") || string4 == null || !string4.equals("113701")) continue;
                    vector2.add(string);
                    continue;
                }
                catch (Exception exception) {
                    if (this.showDetailedLogCheckBox.isSelected()) {
                        this.logger.sendLn(exception.toString());
                    }
                    exception.printStackTrace(System.err);
                }
            }
        }
        return vector2;
    }

    protected static void updateProgressBase(JProgressBar jProgressBar, int n, int n2) {
        if (jProgressBar != null) {
            jProgressBar.setValue(n);
            jProgressBar.setMaximum(n2);
            jProgressBar.setStringPainted(true);
            jProgressBar.repaint();
        }
    }

    protected void generateDoseReportInformation(DatabaseTreeRecord databaseTreeRecord, JEditorPane jEditorPane, StringBuffer stringBuffer, boolean bl, MessageLogger messageLogger, JProgressBar jProgressBar, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            DoseUtility.updateProgressBase(jProgressBar, n, n2);
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || informationEntity.equals(InformationEntity.PATIENT)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    n2 += databaseTreeRecord.getChildCount();
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.generateDoseReportInformation(databaseTreeRecord2, jEditorPane, stringBuffer, bl, messageLogger, jProgressBar, n, n2);
                        ++n;
                    }
                }
            } else {
                Vector vector = new Vector();
                DoseUtility.recurseThroughChildrenGatheringFileNamesOfDoseFiles(databaseTreeRecord, vector, this.processOnlyDoseSeriesRecordCheckBox.isSelected());
                int n3 = vector.size();
                DoseUtility.updateProgressBase(jProgressBar, n, n2 += n3);
                stringBuffer.append(RenderedDoseReport.generateDoseReportInformationFromFiles(vector, this.showOnlyDoseSummaryCheckBox.isSelected(), bl ? "text/html" : "text/plain"));
                DoseUtility.updateProgressBase(jProgressBar, n += n3, n2);
            }
        }
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord databaseTreeRecord, MessageLogger messageLogger, JProgressBar jProgressBar, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            DoseUtility.updateProgressBase(jProgressBar, n, n2);
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || !informationEntity.equals(InformationEntity.INSTANCE)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    n2 += databaseTreeRecord.getChildCount();
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.purgeFilesAndDatabaseInformation(databaseTreeRecord2, messageLogger, jProgressBar, n, n2);
                        ++n;
                    }
                }
                if (informationEntity != null) {
                    if (this.showDetailedLogCheckBox.isSelected()) {
                        messageLogger.sendLn("Purging " + databaseTreeRecord);
                    }
                    databaseTreeRecord.removeFromParent();
                }
            } else {
                String string = databaseTreeRecord.getLocalFileNameValue();
                String string2 = databaseTreeRecord.getLocalFileReferenceTypeValue();
                if (string2 != null && string2.equals("C")) {
                    try {
                        if (this.showDetailedLogCheckBox.isSelected()) {
                            messageLogger.sendLn("Deleting file " + string);
                        }
                        if (!new File(string).delete()) {
                            messageLogger.sendLn("Failed to delete local copy of file " + string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        messageLogger.sendLn("Failed to delete local copy of file " + string);
                    }
                }
                if (this.showDetailedLogCheckBox.isSelected()) {
                    messageLogger.sendLn("Purging " + databaseTreeRecord);
                }
                databaseTreeRecord.removeFromParent();
            }
        }
    }

    protected static String getSRDescriptionForLog(AttributeList attributeList) {
        return "Patient " + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID) + " Study " + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate) + " Accession " + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber);
    }

    protected static String getOriginDescriptionForLog(CTDose cTDose, DatabaseInformationModel databaseInformationModel) throws DicomException {
        Map map;
        ArrayList arrayList;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = cTDose.getSourceSOPInstanceUID();
        if (string5 != null && (arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string5)) != null && arrayList.size() >= 1 && (map = (Map)arrayList.get(0)) != null) {
            Map map2;
            String string6;
            string4 = (String)map.get("INSTANCENUMBER");
            String string7 = databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.INSTANCE);
            if (string7 != null && (string6 = (String)map.get(string7.toUpperCase())) != null && (map2 = databaseInformationModel.findAllAttributeValuesForSelectedRecord(InformationEntity.SERIES, string6)) != null) {
                string = (String)map2.get("MODALITY");
                string2 = (String)map2.get("SERIESNUMBER");
                string3 = (String)map2.get("SERIESDESCRIPTION");
            }
        }
        return "Series " + string + " " + string2 + " " + string3 + " Instance " + string4;
    }

    protected void generateDoseSR(DatabaseInformationModel databaseInformationModel, DatabaseTreeRecord databaseTreeRecord, MessageLogger messageLogger, JProgressBar jProgressBar, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            DoseUtility.updateProgressBase(jProgressBar, n, n2);
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || informationEntity.equals(InformationEntity.PATIENT)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    n2 += databaseTreeRecord.getChildCount();
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.generateDoseSR(databaseInformationModel, databaseTreeRecord2, messageLogger, jProgressBar, n, n2);
                        ++n;
                    }
                }
            } else {
                Vector vector = new Vector();
                DoseUtility.recurseThroughChildrenGatheringFileNamesOfDoseFiles(databaseTreeRecord, vector, this.processOnlyDoseSeriesRecordCheckBox.isSelected());
                int n3 = vector.size();
                DoseUtility.updateProgressBase(jProgressBar, n, n2 += n3);
                CTDose cTDose = GenerateRadiationDoseStructuredReport.generateDoseReportInformationFromFiles(vector);
                if (cTDose != null) {
                    File file = File.createTempFile("rdsr", ".sr");
                    file.deleteOnExit();
                    String string = file.getCanonicalPath();
                    String string2 = this.networkApplicationProperties == null ? "OURAETITLE" : this.networkApplicationProperties.getCallingAETitle();
                    cTDose.write(string, string2);
                    AttributeList attributeList = cTDose.getAttributeList();
                    databaseInformationModel.insertObject(attributeList, string, "C");
                    String string3 = DoseUtility.getOriginDescriptionForLog(cTDose, databaseInformationModel);
                    String string4 = DoseUtility.getSRDescriptionForLog(attributeList);
                    String string5 = "Generated SR for " + string4 + " from " + string3;
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string5));
                    messageLogger.sendLn(string5);
                } else {
                    String string = "No dose information or SR generated for " + databaseTreeRecord.toString();
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string));
                    messageLogger.sendLn(string);
                }
                DoseUtility.updateProgressBase(jProgressBar, n += n3, n2);
            }
        }
    }

    protected Vector<String> deidentifyFiles(Vector<String> vector) throws DicomException, IOException {
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(vector.size());
            this.progressBar.setStringPainted(true);
            this.progressBar.repaint();
            for (int i = 0; i < vector.size(); ++i) {
                String string = vector.get(i);
                if (string != null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Deidentifying " + string));
                    File file = new File(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(file);
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream);
                    dicomInputStream.close();
                    attributeList.removeGroupLengthAttributes();
                    attributeList.correctDecompressedImagePixelModule();
                    attributeList.insertLossyImageCompressionHistoryIfDecompressed();
                    attributeList.removeMetaInformationHeaderAttributes();
                    attributeList.removeUnsafePrivateAttributes();
                    ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
                    ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, true);
                    ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", null, null, null, this.ourCalledAETitle, "DoseUtility", null, this.getBuildDate(), "De-identified", DateTimeAttribute.getFormattedString(new Date()));
                    FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", this.ourCalledAETitle);
                    attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                    File file2 = File.createTempFile("clean", ".dcm");
                    file2.deleteOnExit();
                    attributeList.write(file2);
                    this.logger.sendLn("Deidentifying " + string + " into " + file2.getCanonicalPath());
                    vector2.add(file2.getCanonicalPath());
                }
                this.progressBar.setValue(i + 1);
                this.progressBar.setStringPainted(true);
                this.progressBar.repaint();
            }
        }
        return vector2;
    }

    private String showInputDialogToSelectFTPTargetByLocalName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.ftpRemoteHostInformation != null && (set = this.ftpRemoteHostInformation.getListOfLocalNames()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(null, string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    protected static String getQueryRetrieveAEFromIdentifier(AttributeList attributeList, QueryInformationModel queryInformationModel) {
        Attribute attribute;
        String string = null;
        if (attributeList != null && (attribute = attributeList.get(TagFromName.RetrieveAETitle)) != null) {
            string = attribute.getSingleStringValueOrNull();
        }
        if (string == null && queryInformationModel != null) {
            string = queryInformationModel.getCalledAETitle();
        }
        return string;
    }

    protected static String getQueryRetrieveLevel(AttributeList attributeList, Attribute attribute) {
        Object object;
        String string = null;
        if (attributeList != null && (object = attributeList.get(TagFromName.QueryRetrieveLevel)) != null) {
            string = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (string == null && attribute != null && (object = attribute.getTag()) != null) {
            if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                string = "PATIENT";
            } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                string = "STUDY";
            } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                string = "SERIES";
            } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                string = "IMAGE";
            }
        }
        return string;
    }

    protected void performRetrieve(AttributeList attributeList, String string, String string2) {
        try {
            AttributeList attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
                AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(attributeTag);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList2.put(attributeTag, codeStringAttribute);
                this.currentRemoteQueryInformationModel.performHierarchicalMoveFrom(attributeList2, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected ArrayList<QueryTreeRecord> findDoseSeriesRecordsInQueryTree(QueryTreeRecord queryTreeRecord, ArrayList<QueryTreeRecord> arrayList) {
        boolean bl = true;
        if (queryTreeRecord != null) {
            Object object;
            AttributeList attributeList = queryTreeRecord.getAllAttributesReturnedInIdentifier();
            InformationEntity informationEntity = queryTreeRecord.getInformationEntity();
            if (informationEntity != null && attributeList != null) {
                if (informationEntity.equals(InformationEntity.SERIES)) {
                    if (OCR.isPossiblyDoseScreenSeries(attributeList) || ExposureDoseSequence.isPossiblyPhilipsDoseScreenSeries(attributeList) || Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality).equals("SR")) {
                        arrayList.add(queryTreeRecord);
                        bl = false;
                    }
                } else if (informationEntity.equals(InformationEntity.INSTANCE)) {
                    object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                    if (OCR.isPossiblyDoseScreenInstance(attributeList) || ExposureDoseSequence.isPossiblyPhilipsDoseScreenInstance(attributeList) || ((String)object).equals("1.2.840.10008.5.1.4.1.1.88.67") || ((String)object).equals("1.2.840.10008.5.1.4.1.1.88.22") || ((String)object).equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                        arrayList.add(queryTreeRecord);
                        bl = false;
                    }
                }
            }
            if (bl && (object = queryTreeRecord.children()) != null) {
                while (object.hasMoreElements()) {
                    queryTreeRecord = (QueryTreeRecord)object.nextElement();
                    if (queryTreeRecord == null) continue;
                    this.findDoseSeriesRecordsInQueryTree(queryTreeRecord, arrayList);
                }
            }
        }
        return arrayList;
    }

    protected ArrayList<QueryTreeRecord> findCTSeriesAndRelatedRecordsInQueryTree(QueryTreeRecord queryTreeRecord, ArrayList<QueryTreeRecord> arrayList) {
        boolean bl = true;
        if (queryTreeRecord != null) {
            Object object;
            InformationEntity informationEntity = queryTreeRecord.getInformationEntity();
            if (informationEntity != null) {
                if (informationEntity.equals(InformationEntity.SERIES)) {
                    String string;
                    object = queryTreeRecord.getAllAttributesReturnedInIdentifier();
                    if (object != null && ((string = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.Modality)).equals("CT") || string.equals("SR"))) {
                        arrayList.add(queryTreeRecord);
                    }
                    bl = false;
                } else if (informationEntity.equals(InformationEntity.INSTANCE)) {
                    arrayList.add(queryTreeRecord);
                    bl = false;
                }
            }
            if (bl && (object = queryTreeRecord.children()) != null) {
                while (object.hasMoreElements()) {
                    queryTreeRecord = (QueryTreeRecord)object.nextElement();
                    if (queryTreeRecord == null) continue;
                    this.findCTSeriesAndRelatedRecordsInQueryTree(queryTreeRecord, arrayList);
                }
            }
        }
        return arrayList;
    }

    @Override
    protected void createGUI() {
        this.setBackground(Color.lightGray);
        this.setInternationalizedFontsForGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (DoseUtility.this.networkApplicationInformation != null && DoseUtility.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DoseUtility.this.networkApplicationInformation).removeAllSources();
                }
                DoseUtility.this.dispose();
                System.exit(0);
            }
        });
    }

    public DoseUtility(String string) throws DicomException, IOException {
        super(string, propertiesFileName);
        this.activateTemporaryDatabases();
        this.savedImagesFolder = new File(System.getProperty("java.io.tmpdir"));
        try {
            this.networkApplicationProperties = new NetworkApplicationProperties(this.getProperties());
        }
        catch (Exception exception) {
            this.networkApplicationProperties = null;
        }
        Object object = new NetworkApplicationInformationFederated();
        ((NetworkApplicationInformationFederated)object).startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.networkApplicationInformation = object;
        this.activateStorageSCP();
        try {
            this.ftpApplicationProperties = new FTPApplicationProperties(this.getProperties());
        }
        catch (Exception exception) {
            this.ftpApplicationProperties = null;
        }
        if (this.ftpApplicationProperties != null) {
            this.ftpRemoteHostInformation = this.ftpApplicationProperties.getFTPRemoteHostInformation();
        }
        this.logger = new DialogMessageLogger(loggerTitleMessage, loggertDialogWidthWanted, loggerDialogHeightWanted, false, false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (DoseUtility.this.networkApplicationInformation != null && DoseUtility.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DoseUtility.this.networkApplicationInformation).removeAllSources();
                }
            }
        });
        this.mainFrame = this;
        this.srcDatabasePanel = new JPanel();
        this.remoteQueryRetrievePanel = new JPanel();
        this.srcDatabasePanel.setLayout(new GridLayout(1, 1));
        this.remoteQueryRetrievePanel.setLayout(new GridLayout(1, 1));
        object = new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
        Border border = BorderFactory.createEtchedBorder();
        JSplitPane jSplitPane = new JSplitPane(1, this.remoteQueryRetrievePanel, this.srcDatabasePanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setBorder(border);
        JButton jButton = new JButton(configureButtonLabel);
        jButton.setToolTipText(configureButtonToolTipText);
        jPanel.add(jButton);
        jButton.addActionListener(new ConfigureActionListener());
        JButton jButton2 = new JButton(logButtonLabel);
        jButton2.setToolTipText(logButtonToolTipText);
        jPanel.add(jButton2);
        jButton2.addActionListener(new LogActionListener());
        JButton jButton3 = new JButton(queryButtonLabel);
        jButton3.setToolTipText(queryButtonToolTipText);
        jPanel.add(jButton3);
        jButton3.addActionListener(new QueryActionListener());
        JButton jButton4 = new JButton(retrieveButtonLabel);
        jButton4.setToolTipText(retrieveButtonToolTipText);
        jPanel.add(jButton4);
        jButton4.addActionListener(new RetrieveActionListener());
        JButton jButton5 = new JButton(importButtonLabel);
        jButton5.setToolTipText(importButtonToolTipText);
        jPanel.add(jButton5);
        jButton5.addActionListener(new ImportActionListener());
        JButton jButton6 = new JButton(viewButtonLabel);
        jButton6.setToolTipText(viewButtonToolTipText);
        jPanel.add(jButton6);
        jButton6.addActionListener(new ViewActionListener());
        JButton jButton7 = new JButton(validateButtonLabel);
        jButton7.setToolTipText(validateButtonToolTipText);
        jPanel.add(jButton7);
        jButton7.addActionListener(new ValidateActionListener());
        JButton jButton8 = new JButton(reportButtonLabel);
        jButton8.setToolTipText(reportButtonToolTipText);
        jPanel.add(jButton8);
        jButton8.addActionListener(new ReportActionListener());
        JButton jButton9 = new JButton(makeSRButtonLabel);
        jButton9.setToolTipText(makeSRButtonToolTipText);
        jPanel.add(jButton9);
        jButton9.addActionListener(new MakeSRActionListener());
        JButton jButton10 = new JButton(sendButtonLabel);
        jButton10.setToolTipText(sendButtonToolTipText);
        jPanel.add(jButton10);
        jButton10.addActionListener(new SendActionListener());
        JButton jButton11 = new JButton(registryButtonLabel);
        jButton11.setToolTipText(registryButtonToolTipText);
        jPanel.add(jButton11);
        jButton11.addActionListener(new RegistryActionListener());
        JButton jButton12 = new JButton(purgeButtonLabel);
        jButton12.setToolTipText(purgeButtonToolTipText);
        jPanel.add(jButton12);
        jButton12.addActionListener(new PurgeActionListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(border);
        JLabel jLabel = new JLabel(queryIntroductionLabelText);
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel(queryPatientNameLabelText);
        jLabel2.setToolTipText(queryPatientNameToolTipText);
        jPanel2.add(jLabel2);
        this.queryFilterPatientNameTextField = new JTextField("", textFieldLengthForQueryPatientName);
        jPanel2.add(this.queryFilterPatientNameTextField);
        JLabel jLabel3 = new JLabel(queryPatientIDLabelText);
        jLabel3.setToolTipText(queryPatientIDToolTipText);
        jPanel2.add(jLabel3);
        this.queryFilterPatientIDTextField = new JTextField("", textFieldLengthForQueryPatientID);
        jPanel2.add(this.queryFilterPatientIDTextField);
        JLabel jLabel4 = new JLabel(queryStudyDateLabelText);
        jLabel4.setToolTipText(queryStudyDateToolTipText);
        jPanel2.add(jLabel4);
        this.queryFilterStudyDateTextField = new JTextField("", textFieldLengthForQueryStudyDate);
        jPanel2.add(this.queryFilterStudyDateTextField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 0));
        jPanel3.setBorder(border);
        this.retrieveOnlyDoseSeriesRecordCheckBox = new JCheckBox(retrieveOnlyDoseSeriesRecordLabelText);
        this.retrieveOnlyDoseSeriesRecordCheckBox.setSelected(true);
        jPanel3.add(this.retrieveOnlyDoseSeriesRecordCheckBox);
        this.processOnlyDoseSeriesRecordCheckBox = new JCheckBox(processOnlyDoseSeriesRecordLabelText);
        this.processOnlyDoseSeriesRecordCheckBox.setSelected(true);
        jPanel3.add(this.processOnlyDoseSeriesRecordCheckBox);
        this.showOnlyDoseSummaryCheckBox = new JCheckBox(showOnlyDoseSummaryLabelText);
        this.showOnlyDoseSummaryCheckBox.setSelected(true);
        jPanel3.add(this.showOnlyDoseSummaryCheckBox);
        this.showDetailedLogCheckBox = new JCheckBox(showDetailedLogLabelText);
        this.showDetailedLogCheckBox.setSelected(false);
        jPanel3.add(this.showDetailedLogCheckBox);
        this.reportTabularLayoutCheckBox = new JCheckBox(reportTabularLayoutLabelText);
        this.reportTabularLayoutCheckBox.setSelected(true);
        jPanel3.add(this.reportTabularLayoutCheckBox);
        this.caseSensitiveCodeMeaningValidationCheckBox = new JCheckBox(caseSensitiveCodeMeaningValidationLabelText);
        this.caseSensitiveCodeMeaningValidationCheckBox.setSelected(true);
        jPanel3.add(this.caseSensitiveCodeMeaningValidationCheckBox);
        this.deidentifyWhenSendingToRegistryCheckBox = new JCheckBox(deidentifyWhenSendingToRegistryLabelText);
        this.deidentifyWhenSendingToRegistryCheckBox.setSelected(true);
        jPanel3.add(this.deidentifyWhenSendingToRegistryCheckBox);
        JPanel jPanel4 = new JPanel();
        Serializable serializable = new GridBagLayout();
        jPanel4.setLayout((LayoutManager)((Object)serializable));
        Serializable serializable2 = this.getStatusBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        ((GridBagLayout)serializable).setConstraints((Component)serializable2, gridBagConstraints);
        jPanel4.add((Component)serializable2);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(false);
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).weightx = 0.5;
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(this.progressBar, (GridBagConstraints)serializable2);
        jPanel4.add(this.progressBar);
        serializable = new JPanel();
        serializable2 = new GridBagLayout();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ((GridBagLayout)serializable2).setConstraints(jSplitPane, gridBagConstraints);
        ((Container)serializable).add(jSplitPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel, gridBagConstraints);
        ((Container)serializable).add(jPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel2, gridBagConstraints);
        ((Container)serializable).add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel3, gridBagConstraints);
        ((Container)serializable).add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel4, gridBagConstraints);
        ((Container)serializable).add(jPanel4);
        serializable2 = this.getContentPane();
        ((Container)serializable2).add((Component)serializable);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase().startsWith("windows")) {
                System.err.println("DoseUtility.main(): detected Windows - using Windows LAF");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            new DoseUtility("Dose Utility");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static {
        haveScannedForCodecs = false;
        haveCheckedForJPEGLosslessCodec = false;
        haveFoundJPEGLosslessCodec = false;
        haveCheckedForJPEG2000Part1Codec = false;
        haveFoundJPEG2000Part1Codec = false;
    }

    protected class ConfigureActionListener
    implements ActionListener {
        protected ConfigureActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DoseUtility.this.storageSOPClassSCPDispatcher.shutdown();
                new NetworkApplicationConfigurationDialog(DoseUtility.this.mainFrame, DoseUtility.this.networkApplicationInformation, DoseUtility.this.networkApplicationProperties);
                new FTPClientApplicationConfigurationDialog(DoseUtility.this.mainFrame, DoseUtility.this.ftpRemoteHostInformation, DoseUtility.this.ftpApplicationProperties);
                DoseUtility.this.networkApplicationProperties.getProperties(DoseUtility.this.getProperties());
                DoseUtility.this.ftpApplicationProperties.getProperties(DoseUtility.this.getProperties());
                DoseUtility.this.storeProperties("Edited and saved from user interface");
                DoseUtility.this.activateStorageSCP();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class LogActionListener
    implements ActionListener {
        protected LogActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
            }
        }
    }

    protected class RetrieveActionListener
    implements ActionListener {
        protected RetrieveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            ArrayList<QueryTreeRecord> arrayList = new ArrayList<QueryTreeRecord>();
            if (DoseUtility.this.currentRemoteQueryTreeBrowser != null) {
                for (QueryTreeRecord object : DoseUtility.this.currentRemoteQueryTreeBrowser.getSelectionPaths()) {
                    if (DoseUtility.this.retrieveOnlyDoseSeriesRecordCheckBox.isSelected()) {
                        arrayList.addAll(DoseUtility.this.findDoseSeriesRecordsInQueryTree(object, new ArrayList<QueryTreeRecord>()));
                        continue;
                    }
                    arrayList.addAll(DoseUtility.this.findCTSeriesAndRelatedRecordsInQueryTree(object, new ArrayList<QueryTreeRecord>()));
                }
            }
            if (arrayList != null) {
                for (QueryTreeRecord queryTreeRecord : arrayList) {
                    AttributeList attributeList = queryTreeRecord.getUniqueKeys();
                    Attribute attribute = queryTreeRecord.getUniqueKey();
                    AttributeList attributeList2 = queryTreeRecord.getAllAttributesReturnedInIdentifier();
                    String string = DoseUtility.getQueryRetrieveAEFromIdentifier(attributeList2, DoseUtility.this.currentRemoteQueryInformationModel);
                    String string2 = DoseUtility.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string);
                    String string3 = DoseUtility.getQueryRetrieveLevel(attributeList2, attribute);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + string3 + " " + attribute.getSingleStringValueOrEmptyString() + " from " + string2));
                    if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                        DoseUtility.this.logger.sendLn("Request retrieval of " + string3 + " " + attribute.getSingleStringValueOrEmptyString() + " from " + string2 + " (" + string + ")");
                    }
                    DoseUtility.this.performRetrieve(attributeList, string3, string);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
            }
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class QueryActionListener
    implements ActionListener {
        protected QueryActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = DoseUtility.this.getProperties();
            String string = properties.getProperty(propertyName_DicomCurrentlySelectedQueryTargetAE);
            string = DoseUtility.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select remote system", "Query ...", string);
            DoseUtility.this.remoteQueryRetrievePanel.removeAll();
            if (string != null) {
                DoseUtility.this.setCurrentRemoteQueryInformationModel(string);
                if (DoseUtility.this.currentRemoteQueryInformationModel == null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cannot query " + string));
                } else {
                    try {
                        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
                        AttributeList attributeList = new AttributeList();
                        AttributeTag attributeTag = TagFromName.PatientName;
                        StringAttribute stringAttribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
                        String string2 = DoseUtility.this.queryFilterPatientNameTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        string2 = DoseUtility.this.queryFilterPatientIDTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientBirthDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientSex;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ModalitiesInStudy;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        string2 = DoseUtility.this.queryFilterStudyDateTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientAge;
                        stringAttribute = new AgeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.Modality;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.InstanceNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ImageType;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.NumberOfFrames;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPClassUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SpecificCharacterSet;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        ((Attribute)stringAttribute).addValue("ISO_IR 100");
                        DoseUtility.this.activeThread = new Thread(new QueryWorker(attributeList));
                        DoseUtility.this.activeThread.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string + " failed"));
                    }
                }
            }
            DoseUtility.this.remoteQueryRetrievePanel.validate();
        }
    }

    protected class QueryWorker
    implements Runnable {
        AttributeList filter;

        QueryWorker(AttributeList attributeList) {
            this.filter = attributeList;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            String string = DoseUtility.this.currentRemoteQueryInformationModel.getCalledAETitle();
            String string2 = DoseUtility.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Performing query on " + string2));
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Query to " + string2 + " (" + string + ") starting");
            }
            try {
                QueryTreeModel queryTreeModel = DoseUtility.this.currentRemoteQueryInformationModel.performHierarchicalQuery(this.filter);
                DoseUtility.this.currentRemoteQueryTreeBrowser = new OurQueryTreeBrowser(DoseUtility.this.currentRemoteQueryInformationModel, queryTreeModel, DoseUtility.this.remoteQueryRetrievePanel);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying " + string2));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string2 + " failed " + exception));
                if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                    DoseUtility.this.logger.sendLn("Query to " + string2 + " (" + string + ") failed due to" + exception);
                }
                exception.printStackTrace(System.err);
            }
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Query to " + string2 + " (" + string + ") complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying  " + string2));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class OurQueryTreeBrowser
    extends QueryTreeBrowser {
        OurQueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, Container container) throws DicomException {
            super(queryInformationModel, queryTreeModel, container);
        }

        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
            return new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                }
            };
        }
    }

    protected class ImportActionListener
    implements ActionListener {
        protected ImportActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                    ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
                }
                new Thread(new ImportWorker("/", DoseUtility.this.srcDatabase, DoseUtility.this.srcDatabasePanel)).start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class ImportWorker
    implements Runnable {
        MediaImporter importer;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;

        ImportWorker(String string, DatabaseInformationModel databaseInformationModel, JPanel jPanel) {
            this.importer = new OurMediaImporter(string, DoseUtility.this.logger, DoseUtility.this.progressBar);
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Import starting");
            }
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            try {
                this.importer.choosePathAndImportDicomFiles();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.srcDatabasePanel.validate();
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done importing"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        protected boolean canUseBzip;

        public OurMediaImporter(String string, MessageLogger messageLogger, JProgressBar jProgressBar) {
            super(string, messageLogger, jProgressBar);
            this.canUseBzip = PresentationContextListFactory.haveBzip2Support();
        }

        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DoseUtility.importFileIntoDatabase(DoseUtility.this.srcDatabase, string, "R");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }

        protected boolean isOKToImport(String string, String string2) {
            return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null && (string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2") || string2.equals("1.2.840.10008.1.2.1.99") || string2.equals("1.2.840.10008.1.2.1.99") && this.canUseBzip || string2.equals("1.2.840.10008.1.2.4.50") || DoseUtility.this.haveJPEGLosslessCodec() && (string2.equals("1.2.840.10008.1.2.4.57") || string2.equals("1.2.840.10008.1.2.4.70")) || DoseUtility.this.haveJPEG2000Part1Codec() && (string2.equals("1.2.840.10008.1.2.4.91") || string2.equals("1.2.840.10008.1.2.4.90")));
        }
    }

    protected class RegistryActionListener
    implements ActionListener {
        protected RegistryActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FTPRemoteHost fTPRemoteHost;
                Properties properties = DoseUtility.this.getProperties();
                String string = properties.getProperty(propertyName_CurrentlySelectedDoseRegistry);
                string = DoseUtility.this.showInputDialogToSelectFTPTargetByLocalName("Select remote registry", "Registry ...", string);
                if (string != null && (fTPRemoteHost = DoseUtility.this.ftpRemoteHostInformation.getRemoteHost(string)) != null) {
                    int n = DoseUtility.this.ftpApplicationProperties == null ? 0 : DoseUtility.this.ftpApplicationProperties.getClientDebugLevel();
                    DoseUtility.this.activeThread = new Thread(new RegistryWorker(DoseUtility.this.currentDatabaseTreeRecordSelection, DoseUtility.this.srcDatabase, DoseUtility.this.srcDatabasePanel, fTPRemoteHost, n));
                    DoseUtility.this.activeThread.start();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Send to registry failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class RegistryWorker
    implements Runnable {
        DatabaseTreeRecord databaseSelection;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;
        FTPRemoteHost remoteHost;
        int debugLevel;

        RegistryWorker(DatabaseTreeRecord databaseTreeRecord, DatabaseInformationModel databaseInformationModel, JPanel jPanel, FTPRemoteHost fTPRemoteHost, int n) {
            this.databaseSelection = databaseTreeRecord;
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
            this.remoteHost = fTPRemoteHost;
            this.debugLevel = n;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
            }
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Sending to Registry started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Sending to Registry started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            if (this.databaseSelection != null) {
                Vector vector = new Vector();
                DoseUtility.recurseThroughChildrenGatheringFileNamesOfSRFiles(this.databaseSelection, vector);
                Vector<String> vector2 = DoseUtility.this.extractRadiationDoseSRFiles(vector);
                try {
                    if (DoseUtility.this.deidentifyWhenSendingToRegistryCheckBox.isSelected()) {
                        vector2 = DoseUtility.this.deidentifyFiles(vector2);
                    }
                    String[] stringArray = vector2.toArray(new String[vector2.size()]);
                    new FTPFileSender(this.remoteHost, stringArray, true, this.debugLevel, DoseUtility.this.showDetailedLogCheckBox.isSelected() ? DoseUtility.this.logger : null, DoseUtility.this.progressBar);
                }
                catch (Exception exception) {
                    if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                        DoseUtility.this.logger.sendLn(exception.toString());
                    }
                    exception.printStackTrace(System.err);
                }
            }
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Sending to Registry complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending to Registry"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class SendActionListener
    implements ActionListener {
        protected SendActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Properties properties = DoseUtility.this.getProperties();
                String string = properties.getProperty(propertyName_DicomCurrentlySelectedStorageTargetAE);
                string = DoseUtility.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select destination", "Send ...", string);
                if (string != null) {
                    String string2 = DoseUtility.this.networkApplicationProperties.getCallingAETitle();
                    String string3 = DoseUtility.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                    PresentationAddress presentationAddress = DoseUtility.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string3);
                    String string4 = presentationAddress.getHostname();
                    int n = presentationAddress.getPort();
                    DoseUtility.this.activeThread = new Thread(new SendWorker(DoseUtility.this.currentDatabaseTreeRecordSelection, DoseUtility.this.srcDatabase, DoseUtility.this.srcDatabasePanel, string4, n, string3, string2));
                    DoseUtility.this.activeThread.start();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Send to remote DICOM network host failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class SendWorker
    implements Runnable {
        DatabaseTreeRecord databaseSelection;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;
        String hostname;
        int port;
        String calledAETitle;
        String callingAETitle;

        SendWorker(DatabaseTreeRecord databaseTreeRecord, DatabaseInformationModel databaseInformationModel, JPanel jPanel, String string, int n, String string2, String string3) {
            this.databaseSelection = databaseTreeRecord;
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
            this.hostname = string;
            this.port = n;
            this.calledAETitle = string2;
            this.callingAETitle = string3;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
            }
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Sending to remote DICOM network host started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Sending to remote DICOM network host started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            if (this.databaseSelection != null) {
                Vector vector = new Vector();
                DoseUtility.recurseThroughChildrenGatheringFileNamesOfSRFiles(this.databaseSelection, vector);
                Vector vector2 = DoseUtility.this.extractRadiationDoseSRFiles(vector);
                SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles(vector2);
                int n = setOfDicomFiles.size();
                DoseUtility.this.progressBar.setMaximum(n);
                DoseUtility.this.progressBar.setStringPainted(true);
                DoseUtility.this.progressBar.repaint();
                try {
                    new StorageSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandler(n, DoseUtility.this.showDetailedLogCheckBox.isSelected() ? DoseUtility.this.logger : null, DoseUtility.this.progressBar), 0);
                }
                catch (Exception exception) {
                    if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                        DoseUtility.this.logger.sendLn(exception.toString());
                    }
                    exception.printStackTrace(System.err);
                }
            }
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Sending to remote DICOM network host complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending to remote DICOM network host"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class OurMultipleInstanceTransferStatusHandler
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int nFiles;
        MessageLogger logger;
        JProgressBar progressBar;

        OurMultipleInstanceTransferStatusHandler(int n, MessageLogger messageLogger, JProgressBar jProgressBar) {
            this.nFiles = n;
            this.logger = messageLogger;
            this.progressBar = jProgressBar;
        }

        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Remaining " + n + ", completed " + n2 + ", failed " + n3 + ", warning " + n4));
            DoseUtility.updateProgressBase(this.progressBar, this.nFiles - n, this.nFiles);
            if (this.logger != null) {
                this.logger.sendLn((bl ? "Sent " : "Failed to send ") + string2);
            }
        }
    }

    protected class ValidateActionListener
    implements ActionListener {
        protected ValidateActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DoseUtility.this.activeThread = new Thread(new ValidateWorker(DoseUtility.this.getCurrentSourceFilePathSelections()));
                DoseUtility.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Validation failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class ValidateWorker
    implements Runnable {
        Vector sourceFilePathSelections;

        ValidateWorker(Vector vector) {
            this.sourceFilePathSelections = vector;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
            }
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Validation started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Validation started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            if (this.sourceFilePathSelections != null) {
                for (String string : this.sourceFilePathSelections) {
                    try {
                        DicomInputStream dicomInputStream = new DicomInputStream(new FileInputStream(string));
                        AttributeList attributeList = new AttributeList();
                        attributeList.read(dicomInputStream);
                        dicomInputStream.close();
                        if (attributeList.isSRDocument()) {
                            if (validator == null) {
                                validator = new DicomSRValidator();
                            }
                            if (validator == null) {
                                throw new DicomException(" not instantiate a validator");
                            }
                            validator.setOptionMatchCaseOfCodeMeaning(DoseUtility.this.caseSensitiveCodeMeaningValidationCheckBox.isSelected());
                            String string2 = validator.validate(attributeList);
                            JTextArea jTextArea = new JTextArea(string2);
                            JScrollPane jScrollPane = new JScrollPane(jTextArea);
                            JDialog jDialog = new JDialog();
                            jDialog.setSize(validatorFrameWidthWanted, validatorFrameHeightWanted);
                            jDialog.setTitle("Validation of " + attributeList.buildInstanceTitleFromAttributeList());
                            jDialog.getContentPane().add(jScrollPane);
                            jDialog.setVisible(true);
                            continue;
                        }
                        throw new DicomException("Validation of " + SOPClassDescriptions.getDescriptionFromUID(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID)) + " SOP Class not supported");
                    }
                    catch (Exception exception) {
                        if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                            DoseUtility.this.logger.sendLn(exception.toString());
                        }
                        exception.printStackTrace(System.err);
                    }
                }
            }
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("Validation complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done validation"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class ViewActionListener
    implements ActionListener {
        protected ViewActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DoseUtility.this.activeThread = new Thread(new ViewWorker(DoseUtility.this.getCurrentSourceFilePathSelections()));
                DoseUtility.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("View failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class ViewWorker
    implements Runnable {
        Vector sourceFilePathSelections;

        ViewWorker(Vector vector) {
            this.sourceFilePathSelections = vector;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
            }
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("View started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("View started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            if (this.sourceFilePathSelections != null) {
                DicomBrowser.loadAndDisplayImagesFromSOPInstances(this.sourceFilePathSelections, null, null, viewerFrameWidthWanted, viewerFrameHeightWanted);
            }
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                DoseUtility.this.logger.sendLn("View complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done view"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class MakeSRActionListener
    implements ActionListener {
        protected MakeSRActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DoseUtility.this.activeThread = new Thread(new MakeSRWorker(DoseUtility.this.currentDatabaseTreeRecordSelection, DoseUtility.this.srcDatabase, DoseUtility.this.srcDatabasePanel));
                DoseUtility.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Generating SR failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class MakeSRWorker
    implements Runnable {
        DatabaseTreeRecord databaseSelection;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;

        MakeSRWorker(DatabaseTreeRecord databaseTreeRecord, DatabaseInformationModel databaseInformationModel, JPanel jPanel) {
            this.databaseSelection = databaseTreeRecord;
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DoseUtility.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DoseUtility.this.logger).setVisible(true);
            }
            DoseUtility.this.logger.sendLn("Generating SR started");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Generating SR started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            try {
                DoseUtility.this.generateDoseSR(this.srcDatabase, this.databaseSelection, DoseUtility.this.logger, DoseUtility.this.progressBar, 0, 1);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Generating SR failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.srcDatabasePanel.validate();
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            DoseUtility.this.logger.sendLn("Generating SR complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done generating SR"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class PurgeActionListener
    implements ActionListener {
        protected PurgeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DoseUtility.this.activeThread = new Thread(new PurgeWorker(DoseUtility.this.currentDatabaseTreeRecordSelection));
                DoseUtility.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class PurgeWorker
    implements Runnable {
        DatabaseTreeRecord databaseSelection;

        PurgeWorker(DatabaseTreeRecord databaseTreeRecord) {
            this.databaseSelection = databaseTreeRecord;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            DoseUtility.this.logger.sendLn("Purging started");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            try {
                DoseUtility.this.purgeFilesAndDatabaseInformation(this.databaseSelection, DoseUtility.this.logger, DoseUtility.this.progressBar, 0, 1);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                exception.printStackTrace(System.err);
            }
            DoseUtility.this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(DoseUtility.this.srcDatabase, DoseUtility.this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            DoseUtility.this.srcDatabasePanel.validate();
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            DoseUtility.this.logger.sendLn("Purging complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done purging"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class ReportActionListener
    implements ActionListener {
        protected ReportActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DoseUtility.this.activeThread = new Thread(new ReportWorker(DoseUtility.this.currentDatabaseTreeRecordSelection));
                DoseUtility.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Reporting failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class ReportWorker
    implements Runnable {
        DatabaseTreeRecord databaseSelection;

        ReportWorker(DatabaseTreeRecord databaseTreeRecord) {
            this.databaseSelection = databaseTreeRecord;
        }

        public void run() {
            Cursor cursor = DoseUtility.this.getCursor();
            DoseUtility.this.setCursor(Cursor.getPredefinedCursor(3));
            DoseUtility.this.logger.sendLn("Reporting started");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Reporting started"));
            DoseUtility.this.progressBar.setStringPainted(true);
            DoseUtility.this.progressBar.repaint();
            try {
                String string;
                String string2;
                boolean bl = DoseUtility.this.reportTabularLayoutCheckBox.isSelected();
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setContentType(bl ? "text/html" : "text/plain");
                jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                Border border = BorderFactory.createEtchedBorder();
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setBorder(border);
                JDialog jDialog = new JDialog();
                jDialog.setPreferredSize(new Dimension(reportDialogWidthWanted, reportDialogHeightWanted));
                jDialog.setTitle(reportTitleMessage);
                jDialog.getContentPane().add(jScrollPane);
                jDialog.pack();
                if (bl) {
                    string2 = "<html><body><table border=1>";
                    if (DoseUtility.this.showOnlyDoseSummaryCheckBox.isSelected()) {
                        string2 = string2 + CTDose.getHTMLTableHeaderRow();
                    }
                    string = "</table></body></html>";
                } else {
                    string2 = "";
                    string = "";
                }
                StringBuffer stringBuffer = new StringBuffer();
                DoseUtility.this.generateDoseReportInformation(this.databaseSelection, jEditorPane, stringBuffer, bl, DoseUtility.this.logger, DoseUtility.this.progressBar, 0, 1);
                String string3 = string2 + stringBuffer.toString() + string;
                jEditorPane.setText(string3);
                jDialog.setVisible(true);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Reporting failed: " + exception));
                exception.printStackTrace(System.err);
            }
            DoseUtility.this.progressBar.setValue(DoseUtility.this.progressBar.getMaximum());
            DoseUtility.this.progressBar.setStringPainted(false);
            DoseUtility.this.progressBar.repaint();
            DoseUtility.this.logger.sendLn("Reporting complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done reporting"));
            DoseUtility.this.setCursor(cursor);
        }
    }

    protected class OurSourceDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurSourceDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
            super(databaseInformationModel, container);
        }

        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedFiles() {
            return new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DatabaseTreeRecord) {
                        DoseUtility.this.currentDatabaseTreeRecordSelection = (DatabaseTreeRecord)object;
                    }
                }
            };
        }

        protected void doSomethingMoreWithWhateverWasSelected() {
        }
    }

    class OurTransferSyntaxSelectionPolicy
    extends TransferSyntaxSelectionPolicy {
        OurTransferSyntaxSelectionPolicy() {
        }

        public LinkedList applyTransferSyntaxSelectionPolicy(LinkedList linkedList, int n, int n2) {
            boolean bl = PresentationContextListFactory.haveBzip2Support();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                PresentationContext presentationContext = (PresentationContext)listIterator.next();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                List list = presentationContext.getTransferSyntaxUIDs();
                ListIterator listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    String string = (String)listIterator2.next();
                    if (string == null) continue;
                    if (string.equals("1.2.840.10008.1.2")) {
                        bl3 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.1")) {
                        bl2 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.2")) {
                        bl4 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.1.99")) {
                        bl5 = true;
                        continue;
                    }
                    if (string.equals("1.3.6.1.4.1.5962.300.1")) {
                        bl6 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.50")) {
                        bl7 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.57")) {
                        bl8 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.70")) {
                        bl9 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.91")) {
                        bl10 = true;
                        continue;
                    }
                    if (!string.equals("1.2.840.10008.1.2.4.90")) continue;
                    bl11 = true;
                }
                presentationContext.newTransferSyntaxUIDs();
                if (bl6 && bl) {
                    presentationContext.addTransferSyntaxUID("1.3.6.1.4.1.5962.300.1");
                    continue;
                }
                if (bl5) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1.99");
                    continue;
                }
                if (bl2) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1");
                    continue;
                }
                if (bl4) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.2");
                    continue;
                }
                if (bl3) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2");
                    continue;
                }
                if (bl7) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.50");
                    continue;
                }
                if (bl8 && DoseUtility.this.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.57");
                    continue;
                }
                if (bl9 && DoseUtility.this.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.70");
                    continue;
                }
                if (bl10 && DoseUtility.this.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.91");
                    continue;
                }
                if (bl11 && DoseUtility.this.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.90");
                    continue;
                }
                presentationContext.setResultReason((byte)4);
            }
            return linkedList;
        }
    }

    class OurPresentationContextSelectionPolicy
    extends UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy {
        OurPresentationContextSelectionPolicy() {
            this.transferSyntaxSelectionPolicy = new OurTransferSyntaxSelectionPolicy();
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                String string4 = DoseUtility.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string3);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Received " + string + " from " + string3 + " in " + string2));
                if (DoseUtility.this.showDetailedLogCheckBox.isSelected()) {
                    DoseUtility.this.logger.sendLn("Received " + string + " from " + string4 + " (" + string3 + ")");
                }
                try {
                    DoseUtility.importFileIntoDatabase(DoseUtility.this.srcDatabase, string, "C");
                    DoseUtility.this.srcDatabasePanel.removeAll();
                    new OurSourceDatabaseTreeBrowser(DoseUtility.this.srcDatabase, DoseUtility.this.srcDatabasePanel);
                    DoseUtility.this.srcDatabasePanel.validate();
                    new File(string).deleteOnExit();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

