/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.display.ImageEditUtilities;
import com.pixelmed.display.SourceImage;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class RotateFlipSetOfImages {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/RotateFlipSetOfImages.java,v 1.2 2009/04/21 09:10:08 dclunie Exp $";
    protected String ourAETitle = "OURAETITLE";
    protected String dstFolderName;
    protected int rotation;
    protected boolean horizontal_flip;
    protected boolean update_orientation;

    public static void setDerived(AttributeList attributeList, int n, boolean bl, boolean bl2) throws DicomException {
        Object object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DerivationDescription);
        if (((String)object).length() > 0) {
            object = (String)object + "\\";
        }
        object = (String)object + "Rotated " + Integer.toString(n) + " degrees" + (bl ? ", flipped horizontally" : "") + ", " + (bl2 ? "upated orientation" : "orientation untouched");
        attributeList.remove(TagFromName.DerivationDescription);
        Object object2 = new ShortTextAttribute(TagFromName.DerivationDescription);
        ((Attribute)object2).addValue((String)object);
        attributeList.put((Attribute)object2);
        object = attributeList.get(TagFromName.ImageType);
        if (object != null && ((Attribute)object).getVM() > 0 && (object2 = ((Attribute)object).getStringValues()) != null && ((String[])object2).length > 0) {
            object2[0] = "DERIVED";
            ((Attribute)object).removeValues();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                ((Attribute)object).addValue((String)object2[i]);
            }
        }
        object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
        object2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
        if (object != null && ((String)object).length() > 0 && object2 != null && ((String)object2).length() > 0) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SourceImageSequence);
            if (sequenceAttribute == null) {
                sequenceAttribute = new SequenceAttribute(TagFromName.SourceImageSequence);
            }
            AttributeList attributeList2 = new AttributeList();
            UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue((String)object);
            attributeList2.put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
            ((Attribute)uniqueIdentifierAttribute).addValue((String)object2);
            attributeList2.put(uniqueIdentifierAttribute);
            sequenceAttribute.addItem(attributeList2);
            attributeList.remove(TagFromName.SourceImageSequence);
            attributeList.put(sequenceAttribute);
        }
        attributeList.remove(TagFromName.SOPInstanceUID);
        object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(new UIDGenerator().getAnotherNewUID());
        attributeList.put((Attribute)object);
    }

    public static void correctPatientOrientation(AttributeList attributeList, int n, boolean bl) throws DicomException {
        Attribute attribute = attributeList.get(TagFromName.PatientOrientation);
        if (attribute != null && attribute.getVM() > 0) {
            attribute.removeValues();
        }
    }

    public static double[] swapRowAndColumnVectors(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        dArray[0] = dArray[3];
        dArray[1] = dArray[4];
        dArray[2] = dArray[5];
        dArray[3] = d;
        dArray[4] = d2;
        dArray[5] = d3;
        return dArray;
    }

    public static double[] invertDirectionOfRowVector(double[] dArray) {
        dArray[0] = -dArray[0];
        dArray[1] = -dArray[1];
        dArray[2] = -dArray[2];
        return dArray;
    }

    public static double[] invertDirectionOfColumnVector(double[] dArray) {
        dArray[3] = -dArray[3];
        dArray[4] = -dArray[4];
        dArray[5] = -dArray[5];
        return dArray;
    }

    public static void correctImageOrientationPatient(AttributeList attributeList, int n, boolean bl) throws DicomException {
        Attribute attribute = attributeList.get(TagFromName.ImageOrientationPatient);
        if (attribute != null && attribute.getVM() > 0) {
            double[] dArray = attribute.getDoubleValues();
            if (dArray != null && dArray.length == 6) {
                if (n == 90) {
                    RotateFlipSetOfImages.swapRowAndColumnVectors(dArray);
                    RotateFlipSetOfImages.invertDirectionOfRowVector(dArray);
                } else if (n == 180) {
                    RotateFlipSetOfImages.invertDirectionOfRowVector(dArray);
                    RotateFlipSetOfImages.invertDirectionOfColumnVector(dArray);
                } else if (n == 270) {
                    RotateFlipSetOfImages.swapRowAndColumnVectors(dArray);
                    RotateFlipSetOfImages.invertDirectionOfColumnVector(dArray);
                }
                if (bl) {
                    RotateFlipSetOfImages.invertDirectionOfRowVector(dArray);
                }
                attribute.removeValues();
                for (int i = 0; i < dArray.length; ++i) {
                    attribute.addValue(dArray[i]);
                }
            } else {
                throw new DicomException("Invalid ImageOrientationPatient - cannot correct for rotation/flip");
            }
        }
    }

    public RotateFlipSetOfImages(int n, boolean bl, boolean bl2, String string, String string2, MessageLogger messageLogger) throws IOException, DicomException {
        this.dstFolderName = string2;
        if (n % 90 != 0) {
            throw new DicomException("Rotation of " + n + " not supported");
        }
        while (n >= 360) {
            n -= 360;
        }
        while (n < 0) {
            n += 360;
        }
        this.rotation = n;
        this.horizontal_flip = bl;
        this.update_orientation = bl2;
        OurMediaImporter ourMediaImporter = new OurMediaImporter(messageLogger);
        ourMediaImporter.importDicomFiles(string);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 5) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                new RotateFlipSetOfImages(Integer.parseInt(stringArray[0]), stringArray[1].toUpperCase().contains("Y"), stringArray[2].toUpperCase().contains("Y"), stringArray[3], stringArray[4], printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.RotateFlipSetOfImages rotation horizontal_flip update_orientation srcdir|DICOMDIR dstdir");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                if (SOPClass.isImageStorage(string2)) {
                    SourceImage sourceImage = new SourceImage(attributeList);
                    ImageEditUtilities.rotateAndFlip(sourceImage, attributeList, RotateFlipSetOfImages.this.rotation, RotateFlipSetOfImages.this.horizontal_flip);
                    if (RotateFlipSetOfImages.this.update_orientation) {
                        RotateFlipSetOfImages.correctPatientOrientation(attributeList, RotateFlipSetOfImages.this.rotation, RotateFlipSetOfImages.this.horizontal_flip);
                        RotateFlipSetOfImages.correctImageOrientationPatient(attributeList, RotateFlipSetOfImages.this.rotation, RotateFlipSetOfImages.this.horizontal_flip);
                    }
                    RotateFlipSetOfImages.setDerived(attributeList, RotateFlipSetOfImages.this.rotation, RotateFlipSetOfImages.this.horizontal_flip, RotateFlipSetOfImages.this.update_orientation);
                    ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.RotateFlipSetOfImages.main()", null, "Vers. 20090421", "Rotated and/or Flipped", DateTimeAttribute.getFormattedString(new Date()));
                    attributeList.correctDecompressedImagePixelModule();
                    attributeList.removeGroupLengthAttributes();
                    attributeList.removeMetaInformationHeaderAttributes();
                    attributeList.remove(TagFromName.DataSetTrailingPadding);
                    FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", RotateFlipSetOfImages.this.ourAETitle);
                    String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                    File file = new File(RotateFlipSetOfImages.this.dstFolderName, string3 + ".dcm");
                    attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
                } else {
                    this.logLn("Error: File " + string + " is an unsupported SOP Class " + string2);
                }
            }
            catch (Exception exception) {
                this.logLn("Error: File " + string + " exception " + exception);
            }
        }
    }
}

