/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.ApplicationEntityConfigurationDialog;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.JFileChooser;

public class WatchFolderAndSend {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/WatchFolderAndSend.java,v 1.4 2009/12/16 22:10:37 dclunie Exp $";
    protected static int sleepTimeBetweenCheckingForFolderContent = 10000;
    protected static int intervalAfterLastModificationWithinWhichDoNotSendFileYet = 1000;
    protected static String propertiesFileName = ".com.pixelmed.apps.WatchFolderAndSend.properties";
    protected static String localnameForRemoteAE = "remote";
    protected static String propertiesFilePath = FileUtilities.makePathToFileInUsersHomeDirectory(propertiesFileName);

    protected static ApplicationEntity getPropertiesEditInDialogAndSave(int n) {
        Closeable closeable;
        Object object;
        ApplicationEntity applicationEntity = null;
        Properties properties = new Properties();
        try {
            object = new File(propertiesFilePath);
            if (((File)object).exists()) {
                closeable = new FileInputStream((File)object);
                properties.load((InputStream)closeable);
                ((FileInputStream)closeable).close();
                if (n > 0) {
                    System.err.println("WatchFolderAndSend().getPropertiesEditInDialogAndSave(): got existing properties " + properties);
                }
                NetworkApplicationInformation networkApplicationInformation = new NetworkApplicationInformation(properties);
                String string = networkApplicationInformation.getApplicationEntityTitleFromLocalName(localnameForRemoteAE);
                ApplicationEntityMap applicationEntityMap = networkApplicationInformation.getApplicationEntityMap();
                if (string != null && applicationEntityMap != null) {
                    applicationEntity = new ApplicationEntity(string);
                    PresentationAddress presentationAddress = applicationEntityMap.getPresentationAddress(string);
                    if (presentationAddress != null) {
                        applicationEntity.setPresentationAddress(presentationAddress);
                    }
                    if (n > 0) {
                        System.err.println("WatchFolderAndSend().getPropertiesEditInDialogAndSave(): extracted AE " + applicationEntity);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        applicationEntity = applicationEntity == null ? new ApplicationEntityConfigurationDialog(null, localnameForRemoteAE) : new ApplicationEntityConfigurationDialog(null, localnameForRemoteAE, applicationEntity);
        try {
            object = new NetworkApplicationInformation();
            ((NetworkApplicationInformation)object).add(localnameForRemoteAE, applicationEntity);
            properties = ((NetworkApplicationInformation)object).getProperties(properties);
            if (n > 0) {
                System.err.println("WatchFolderAndSend().getPropertiesEditInDialogAndSave(): saving revised properties " + properties);
            }
            closeable = new FileOutputStream(propertiesFilePath);
            properties.store((OutputStream)closeable, "Reconfigured from dialog");
            ((FileOutputStream)closeable).close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return applicationEntity;
    }

    public WatchFolderAndSend(String string, String string2, int n, String string3, String string4, int n2, int n3, MessageLogger messageLogger) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        if (string != null) {
            File file = new File(string);
            while (file.exists() && file.isDirectory()) {
                if (n3 > 0) {
                    System.err.println("WatchFolderAndSend(): watched folder exists");
                }
                SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
                File[] fileArray = file.listFiles();
                if (fileArray != null && fileArray.length > 0) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file2 = fileArray[i];
                        if (!file2.exists() || !file2.isFile()) continue;
                        String string5 = file2.getName();
                        long l = file2.lastModified();
                        long l2 = System.currentTimeMillis();
                        if (n3 > 0) {
                            System.err.println("WatchFolderAndSend(): lastModified = " + l);
                        }
                        if (n3 > 0) {
                            System.err.println("WatchFolderAndSend(): currentTime  = " + l2);
                        }
                        if (l2 - l > (long)intervalAfterLastModificationWithinWhichDoNotSendFileYet) {
                            if (DicomFileUtilities.isDicomOrAcrNemaFile(file2)) {
                                if (n2 > 0 && messageLogger != null) {
                                    messageLogger.sendLn("Queueing " + string5);
                                }
                                setOfDicomFiles.add(file2);
                                continue;
                            }
                            if (n2 <= 0 || messageLogger == null) continue;
                            messageLogger.sendLn("Skipping non-DICOM file " + string5);
                            continue;
                        }
                        if (n2 <= 0 || messageLogger == null) continue;
                        messageLogger.sendLn("Skipping file still being modified " + string5);
                    }
                    if (setOfDicomFiles != null & setOfDicomFiles.size() > 0 && new StorageSOPClassSCU(string2, n, string3, string4, setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandlerWithFileName(n2, n3, messageLogger), null, 0, n3).encounteredTrappedExceptions() && n2 > 0 && messageLogger != null) {
                        messageLogger.sendLn("Sending queued files problem - connection or association failure ?");
                    }
                }
                if (n3 > 0) {
                    System.err.println("WatchFolderAndSend(): sleeping for " + sleepTimeBetweenCheckingForFolderContent + " mS");
                }
                Thread.currentThread();
                Thread.sleep(sleepTimeBetweenCheckingForFolderContent);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0 || stringArray.length >= 4 && stringArray.length <= 7) {
                Serializable serializable;
                String string = null;
                String string2 = null;
                int n = 0;
                String string3 = null;
                String string4 = "US";
                int n2 = 0;
                int n3 = 0;
                MessageLogger messageLogger = null;
                if (stringArray.length == 0) {
                    serializable = new JFileChooser();
                    serializable.setDialogTitle("Select Watched Folder ...");
                    serializable.setFileSelectionMode(1);
                    if (serializable.showOpenDialog(null) == 0) {
                        string = serializable.getSelectedFile().getAbsolutePath();
                    } else {
                        System.exit(0);
                    }
                    ApplicationEntity applicationEntity = WatchFolderAndSend.getPropertiesEditInDialogAndSave(n3);
                    string2 = applicationEntity.getPresentationAddress().getHostname();
                    n = applicationEntity.getPresentationAddress().getPort();
                    string3 = applicationEntity.getDicomAETitle();
                    n2 = 1;
                    messageLogger = new DialogMessageLogger("WatchFolderAndSend Log", 512, 384, true, true);
                } else {
                    string = stringArray[0];
                    string2 = stringArray[1];
                    n = Integer.parseInt(stringArray[2]);
                    string3 = stringArray[3];
                    if (stringArray.length > 4) {
                        string4 = stringArray[4];
                    }
                    if (stringArray.length > 5) {
                        n2 = Integer.parseInt(stringArray[5]);
                    }
                    if (stringArray.length > 6) {
                        n3 = Integer.parseInt(stringArray[6]);
                    }
                    messageLogger = new PrintStreamMessageLogger(System.err);
                }
                serializable = new File(string);
                new WatchFolderAndSend(string, string2, n, string3, string4, n2, n3, messageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.WatchFolderAndSend [watchedfolder remoteHost remotePort remoteAET [ourAET [verbositylevel [debuglevel]]]]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    protected class OurMultipleInstanceTransferStatusHandlerWithFileName
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int verbosityLevel;
        int debugLevel;
        MessageLogger logger;

        OurMultipleInstanceTransferStatusHandlerWithFileName(int n, int n2, MessageLogger messageLogger) {
            this.verbosityLevel = n;
            this.debugLevel = n2;
            this.logger = messageLogger;
        }

        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            File file = new File(string2);
            String string3 = file.getName();
            if (this.verbosityLevel > 0 && this.logger != null) {
                this.logger.sendLn("Send of " + string3 + " " + (bl ? "succeeded" : "failed"));
            }
            if (bl) {
                if (file.exists() && file.isFile()) {
                    if (this.debugLevel > 0) {
                        System.err.println("WatchFolderAndSend(): removing " + string3);
                    }
                    if (file.delete()) {
                        if (this.verbosityLevel > 0 && this.logger != null) {
                            this.logger.sendLn("Removed " + string3);
                        }
                    } else if (this.verbosityLevel > 0 && this.logger != null) {
                        this.logger.sendLn("Failed to remove " + string3);
                    }
                }
            } else if (this.verbosityLevel > 0 && this.logger != null) {
                this.logger.sendLn("Leaving " + string3);
            }
        }
    }
}

