/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.EncapsulatedInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.TransferSyntaxFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class AttributeList
extends TreeMap {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeList.java,v 1.104 2010/11/06 16:06:17 dclunie Exp $";
    private static boolean haveScannedForCodecs;
    protected static DicomDictionary dictionary;
    protected boolean pixelDataWasDecompressed = false;
    protected boolean pixelDataWasLossy = false;
    protected String lossyMethod = null;
    protected double compressionRatio = 0.0;

    protected static void createDictionaryifNecessary() {
        if (dictionary == null) {
            dictionary = new DicomDictionary();
        }
    }

    private void dumpListOfAllAvailableReaders(PrintStream printStream) {
        String[] stringArray = ImageIO.getReaderFormatNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            printStream.println(stringArray[i] + ":");
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(stringArray[i]);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                printStream.println("\t" + imageReaderSpi.getDescription(Locale.US) + " " + imageReaderSpi.getVendorName() + " " + imageReaderSpi.getVersion());
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeList) {
            AttributeList attributeList = (AttributeList)object;
            if (this.size() == attributeList.size()) {
                for (Attribute attribute : this.values()) {
                    String string;
                    Attribute attribute2 = attributeList.get(attribute.getTag());
                    String string2 = attribute.getDelimitedStringValuesOrDefault("").trim();
                    if (string2.equals(string = attribute2.getDelimitedStringValuesOrDefault("").trim())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (Attribute attribute : this.values()) {
            n += attribute.toString().hashCode();
        }
        return n;
    }

    private AttributeTag readAttributeTag(DicomInputStream dicomInputStream) throws IOException {
        int n = dicomInputStream.readUnsigned16();
        int n2 = dicomInputStream.readUnsigned16();
        return new AttributeTag(n, n2);
    }

    private long readNewSequenceAttribute(Attribute attribute, DicomInputStream dicomInputStream, long l, long l2, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        block6: {
            boolean bl = l2 == 0xFFFFFFFFL;
            long l3 = bl ? 0xFFFFFFFFL : l + l2 - 1L;
            try {
                while (bl || l < l3) {
                    long l4 = l;
                    AttributeTag attributeTag = this.readAttributeTag(dicomInputStream);
                    l += 4L;
                    long l5 = dicomInputStream.readUnsigned32();
                    l += 4L;
                    if (attributeTag.equals(TagFromName.SequenceDelimitationItem)) break;
                    if (attributeTag.equals(TagFromName.Item)) {
                        AttributeList attributeList = new AttributeList();
                        l = attributeList.read(dicomInputStream, l, l5, false, specificCharacterSet);
                        ((SequenceAttribute)attribute).addItem(attributeList, l4);
                        continue;
                    }
                    throw new DicomException("Bad tag " + attributeTag + "(not Item or Sequence Delimiter) in Sequence at byte offset " + l);
                }
            }
            catch (EOFException eOFException) {
                if (!bl) {
                    throw new EOFException();
                }
            }
            catch (IOException iOException) {
                if (bl) break block6;
                throw new IOException();
            }
        }
        return l;
    }

    private long read(DicomInputStream dicomInputStream, long l, long l2, boolean bl, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        return this.read(dicomInputStream, l, l2, bl, specificCharacterSet, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long read(DicomInputStream dicomInputStream, long l, long l2, boolean bl, SpecificCharacterSet specificCharacterSet, AttributeTag attributeTag) throws IOException, DicomException {
        if (dicomInputStream.areReadingDataSet()) {
            if (dicomInputStream.getTransferSyntaxToReadDataSet().isDeflated()) {
                dicomInputStream = new DicomInputStream(new InflaterInputStream(dicomInputStream, new Inflater(true)), "1.2.840.10008.1.2.1", false);
                l = 0L;
            } else if (dicomInputStream.getTransferSyntaxToReadDataSet().isBzip2ed()) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.excalibur.bzip2.CBZip2InputStream");
                    Class[] classArray = new Class[]{InputStream.class};
                    Object[] objectArray = new Object[]{dicomInputStream};
                    InputStream inputStream = (InputStream)clazz.getConstructor(classArray).newInstance(objectArray);
                    dicomInputStream = new DicomInputStream(inputStream, "1.2.840.10008.1.2.1", false);
                    l = 0L;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new DicomException("Not a correctly encoded bzip2 bitstream - " + invocationTargetException);
                }
                catch (Exception exception) {
                    throw new DicomException("Could not instantiate bzip2 codec - " + exception);
                }
            }
        }
        AttributeList.createDictionaryifNecessary();
        boolean bl2 = l2 == 0xFFFFFFFFL;
        long l3 = bl2 ? 0xFFFFFFFFL : l + l2 - 1L;
        byte[] byArray = new byte[2];
        boolean bl3 = dicomInputStream.getTransferSyntaxInUse().isExplicitVR();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        AttributeTag attributeTag2 = null;
        try {
            while (true) {
                Object object;
                long l4;
                void var20_27;
                if (!bl2) {
                    if (l >= l3) return l;
                }
                attributeTag2 = this.readAttributeTag(dicomInputStream);
                l += 4L;
                if (attributeTag != null && attributeTag2.equals(attributeTag)) {
                    return l;
                }
                if (attributeTag2.equals(TagFromName.ItemDelimitationItem)) {
                    dicomInputStream.readUnsigned32();
                    return l += 4L;
                }
                if (attributeTag2.equals(TagFromName.Item)) {
                    long l5 = dicomInputStream.readUnsigned32();
                    System.err.println("Ignoring bad Item at " + (l += 4L) + " " + attributeTag2 + " VL=<0x" + Long.toHexString(l5) + ">");
                    continue;
                }
                if (bl3) {
                    byte[] byArray2 = byArray;
                    dicomInputStream.readInsistently(byArray2, 0, 2);
                    l += 2L;
                } else {
                    byte[] byArray3 = dictionary.getValueRepresentationFromTag(attributeTag2);
                    if (byArray3 == null) {
                        byte[] byArray4 = byArray;
                        byArray4[0] = 85;
                        byArray4[1] = 78;
                    }
                }
                if (bl3) {
                    if (ValueRepresentation.isShortValueLengthVR((byte[])var20_27)) {
                        l4 = dicomInputStream.readUnsigned16();
                        l += 2L;
                    } else {
                        dicomInputStream.readUnsigned16();
                        l4 = dicomInputStream.readUnsigned32();
                        l += 6L;
                    }
                } else {
                    l4 = dicomInputStream.readUnsigned32();
                    l += 4L;
                }
                if (bl3 && ValueRepresentation.isUnknownVR((byte[])var20_27) && (object = dictionary.getValueRepresentationFromTag(attributeTag2)) != null && ((byte[])object).length >= 2 && !ValueRepresentation.isSequenceVR((byte[])object)) {
                    var20_27[0] = object[0];
                    var20_27[1] = object[1];
                }
                if (attributeTag2.isPrivateCreator()) {
                    var20_27[0] = 76;
                    var20_27[1] = 79;
                }
                object = null;
                if (ValueRepresentation.isSequenceVR((byte[])var20_27) || ValueRepresentation.isUnknownVR((byte[])var20_27) && l4 == 0xFFFFFFFFL) {
                    object = new SequenceAttribute(attributeTag2);
                    l = this.readNewSequenceAttribute((Attribute)object, dicomInputStream, l, l4, specificCharacterSet);
                } else if (l4 != 0xFFFFFFFFL) {
                    try {
                        object = AttributeFactory.newAttribute(attributeTag2, (byte[])var20_27, l4, dicomInputStream, specificCharacterSet, bl3, n5, l);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        object = null;
                    }
                    l += l4;
                } else if (l4 == 0xFFFFFFFFL && attributeTag2.equals(TagFromName.PixelData)) {
                    int n6 = n * n2 * n4;
                    String string = dicomInputStream.getTransferSyntaxInUse().getUID();
                    boolean bl4 = false;
                    EncapsulatedInputStream encapsulatedInputStream = new EncapsulatedInputStream(dicomInputStream);
                    if (string.equals("1.3.6.1.4.1.5962.300.2")) {
                        if (n5 == 1) {
                            byte[] byArray5 = new byte[n6 * n3];
                            for (int i = 0; i < n3; ++i) {
                                encapsulatedInputStream.read(byArray5, i * n6, n6);
                            }
                            object = new OtherByteAttribute(attributeTag2);
                            ((Attribute)object).setValues(byArray5);
                            bl4 = true;
                        } else {
                            if (n5 != 2) throw new DicomException("Encapsulated data of more than 2 bytes per sample not supported (got " + n5 + ")");
                            short[] sArray = new short[n6 * n3];
                            for (int i = 0; i < n3; ++i) {
                                encapsulatedInputStream.readUnsigned16(sArray, i * n6, n6);
                            }
                            object = new OtherWordAttribute(attributeTag2);
                            ((Attribute)object).setValues(sArray);
                            bl4 = true;
                        }
                    } else {
                        Object object2;
                        Object object3;
                        void var28_49;
                        if (!haveScannedForCodecs) {
                            ImageIO.scanForPlugins();
                            haveScannedForCodecs = true;
                        }
                        this.pixelDataWasDecompressed = true;
                        this.pixelDataWasLossy = false;
                        this.lossyMethod = null;
                        this.compressionRatio = 0.0;
                        Object var28_41 = null;
                        if (string.equals("1.2.840.10008.1.2.4.50") || string.equals("1.2.840.10008.1.2.4.51")) {
                            String string2 = "JPEG";
                            this.pixelDataWasLossy = true;
                            this.lossyMethod = "ISO_10918_1";
                        } else if (string.equals("1.2.840.10008.1.2.4.91")) {
                            String string3 = "JPEG2000";
                            this.pixelDataWasLossy = true;
                            this.lossyMethod = "ISO_15444_1";
                        } else if (string.equals("1.2.840.10008.1.2.4.90")) {
                            String string4 = "JPEG2000";
                        } else if (string.equals("1.2.840.10008.1.2.4.57") || string.equals("1.2.840.10008.1.2.4.70")) {
                            String string5 = "jpeg-lossless";
                        } else if (string.equals("1.2.840.10008.1.2.4.80")) {
                            String string6 = "jpeg-ls";
                        } else if (string.equals("1.2.840.10008.1.2.4.81")) {
                            String string7 = "jpeg-ls";
                            this.pixelDataWasLossy = true;
                            this.lossyMethod = "ISO_14495_1";
                        } else {
                            String string8 = "JPEG";
                            System.err.println("Unrecognized Transfer Syntax " + string + " for encapsulated PixelData - guessing " + string8);
                        }
                        if (var28_49 == null) throw new DicomException("Unrecognized Transfer Syntax " + string + " for encapsulated PixelData");
                        ImageReader imageReader = null;
                        ImageReaderSpi imageReaderSpi = null;
                        try {
                            imageReader = ImageIO.getImageReadersByFormatName((String)var28_49).next();
                            imageReaderSpi = imageReader.getOriginatingProvider();
                            object3 = imageReaderSpi.getDescription(Locale.US);
                            object2 = imageReaderSpi.getVendorName();
                            String string9 = imageReaderSpi.getVersion();
                            if (string.equals("1.2.840.10008.1.2.4.51") && ((String)object3).equals("Standard JPEG Image Reader") && ((String)object2).equals("Sun Microsystems, Inc.")) {
                                throw new DicomException("Reader " + (String)object3 + " " + (String)object2 + " " + string9 + " does not support extended lossy JPEG Transfer Syntax " + string);
                            }
                            System.err.println("Using reader from " + (String)object3 + " " + (String)object2 + " " + string9);
                            OurIIOReadProgressListener ourIIOReadProgressListener = new OurIIOReadProgressListener();
                            imageReader.addIIOReadProgressListener(ourIIOReadProgressListener);
                        }
                        catch (Exception exception) {
                            this.dumpListOfAllAvailableReaders(System.err);
                            throw new DicomException("No reader for " + (String)var28_49 + " available for Transfer Syntax " + string + "\nCaused by: " + exception);
                        }
                        if (imageReader != null) {
                            object3 = null;
                            object2 = null;
                            int n7 = n2 * n * n4;
                            int n8 = n7 * n3;
                            for (int i = 0; i < n3; ++i) {
                                BufferedImage bufferedImage = null;
                                ImageInputStream imageInputStream = ImageIO.createImageInputStream(encapsulatedInputStream);
                                imageReader.setInput(imageInputStream, true, true);
                                bufferedImage = imageReader.read(0);
                                if (bufferedImage == null) {
                                    throw new DicomException("Reader " + imageReaderSpi.getDescription(Locale.US) + " " + imageReaderSpi.getVendorName() + " " + imageReaderSpi.getVersion() + " returned null image for Transfer Syntax " + string);
                                }
                                Raster raster = bufferedImage.getData();
                                int n9 = raster.getNumDataElements();
                                if (n9 == n4) {
                                    int n10 = raster.getTransferType();
                                    if (n10 == 0) {
                                        byte[] byArray6 = (byte[])raster.getDataElements(0, 0, n2, n, null);
                                        if (object3 == null) {
                                            object3 = n3 == 1 ? (Object)byArray6 : (Object)new byte[n8];
                                        }
                                        if (byArray6 != null) {
                                            System.arraycopy(byArray6, 0, object3, n7 * i, n7);
                                        }
                                    } else if (n10 == 2 || n10 == 1) {
                                        short[] sArray = (short[])raster.getDataElements(0, 0, n2, n, null);
                                        if (object2 == null) {
                                            object2 = n3 == 1 ? (Object)sArray : (Object)new short[n8];
                                        }
                                        if (sArray != null) {
                                            System.arraycopy(sArray, 0, object2, n7 * i, n7);
                                        }
                                    }
                                }
                                encapsulatedInputStream.nextFrame();
                            }
                            encapsulatedInputStream.readSequenceDelimiter();
                            if (object3 != null) {
                                object = new OtherByteAttribute(attributeTag2);
                                ((Attribute)object).setValues((byte[])object3);
                                this.pixelDataWasDecompressed = true;
                            } else if (object2 != null) {
                                object = new OtherWordAttribute(attributeTag2);
                                ((Attribute)object).setValues((short[])object2);
                                this.pixelDataWasDecompressed = true;
                            }
                            bl4 = true;
                            try {
                                imageReader.dispose();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace(System.err);
                            }
                        }
                    }
                    if (!bl4) {
                        while (encapsulatedInputStream.skip(1024L) > 0L) {
                        }
                    }
                    long l6 = encapsulatedInputStream.getBytesRead();
                    l += l6;
                    if (this.pixelDataWasDecompressed) {
                        this.compressionRatio = (long)n2 * (long)n * (long)n4 * (long)n5 * (long)n3 * 1000L / l6;
                        this.compressionRatio /= 1000.0;
                    }
                }
                if (object == null) continue;
                if (this.get(attributeTag2) != null) {
                    System.err.println("Illegal duplicate tag in dataset - " + attributeTag2 + " - replacing previous occurence");
                }
                this.put(attributeTag2, (Attribute)object);
                if (attributeTag2.equals(TagFromName.FileMetaInformationGroupLength)) {
                    if (!dicomInputStream.areReadingMetaHeader()) continue;
                    long l7 = ((Attribute)object).getSingleIntegerValueOrDefault(0);
                    l = this.read(dicomInputStream, l, l7, false, null, attributeTag);
                    dicomInputStream.setReadingDataSet();
                    if (!bl) return this.read(dicomInputStream, l, 0xFFFFFFFFL, false, null, attributeTag);
                    return l;
                }
                if (attributeTag2.equals(TagFromName.TransferSyntaxUID)) {
                    if (!dicomInputStream.areReadingMetaHeader()) continue;
                    dicomInputStream.setTransferSyntaxToReadDataSet(new TransferSyntax(((Attribute)object).getSingleStringValueOrDefault("1.2.840.10008.1.2.1")));
                    continue;
                }
                if (attributeTag2.equals(TagFromName.SpecificCharacterSet)) {
                    specificCharacterSet = new SpecificCharacterSet(((Attribute)object).getStringValues(), ((Attribute)object).getByteValues());
                    continue;
                }
                if (attributeTag2.equals(TagFromName.Columns)) {
                    n2 = ((Attribute)object).getSingleIntegerValueOrDefault(0);
                    continue;
                }
                if (attributeTag2.equals(TagFromName.Rows)) {
                    n = ((Attribute)object).getSingleIntegerValueOrDefault(0);
                    continue;
                }
                if (attributeTag2.equals(TagFromName.NumberOfFrames)) {
                    n3 = ((Attribute)object).getSingleIntegerValueOrDefault(1);
                    continue;
                }
                if (attributeTag2.equals(TagFromName.SamplesPerPixel)) {
                    n4 = ((Attribute)object).getSingleIntegerValueOrDefault(1);
                    continue;
                }
                if (!attributeTag2.equals(TagFromName.BitsAllocated)) continue;
                n5 = (((Attribute)object).getSingleIntegerValueOrDefault(16) - 1) / 8 + 1;
            }
        }
        catch (EOFException eOFException) {
            if (bl2) return l;
            throw new EOFException();
        }
        catch (IOException iOException) {
            if (bl2) return l;
            throw new IOException();
        }
    }

    public void readOnlyMetaInformationHeader(DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, true, null);
    }

    public void read(DicomInputStream dicomInputStream, AttributeTag attributeTag) throws IOException, DicomException {
        this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, false, null, attributeTag);
    }

    public void read(DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.read(dicomInputStream, dicomInputStream.getByteOffsetOfStartOfData(), 0xFFFFFFFFL, false, null);
    }

    public void read(String string, String string2, boolean bl, boolean bl2) throws IOException, DicomException {
        this.read(string, string2, bl, bl2, null);
    }

    public void read(String string, String string2, boolean bl, boolean bl2, AttributeTag attributeTag) throws IOException, DicomException {
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = new FileInputStream(string);
            if (bl2) {
                inputStream = new BufferedInputStream(inputStream);
            }
            filterInputStream = new DicomInputStream(inputStream, string2, bl);
            this.read((DicomInputStream)filterInputStream, attributeTag);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void read(String string) throws IOException, DicomException {
        this.read(string, null, true, true);
    }

    public void read(String string, AttributeTag attributeTag) throws IOException, DicomException {
        this.read(string, null, true, true, attributeTag);
    }

    public void read(File file) throws IOException, DicomException {
        this.read(file.getCanonicalPath());
    }

    public void read(File file, AttributeTag attributeTag) throws IOException, DicomException {
        this.read(file.getCanonicalPath(), attributeTag);
    }

    protected void writeFragment(DicomOutputStream dicomOutputStream) throws IOException, DicomException {
        for (Attribute attribute : this.values()) {
            attribute.write(dicomOutputStream);
        }
    }

    public void write(DicomOutputStream dicomOutputStream, boolean bl) throws IOException, DicomException {
        DeflaterOutputStream deflaterOutputStream = null;
        OutputStream outputStream = null;
        for (Attribute attribute : this.values()) {
            boolean bl2;
            boolean bl3 = bl2 = attribute.getTag().getGroup() > 2;
            if (bl2) {
                if (dicomOutputStream.getTransferSyntaxToWriteDataSet().isDeflated()) {
                    deflaterOutputStream = new DeflaterOutputStream((OutputStream)dicomOutputStream, new Deflater(9, true));
                    dicomOutputStream = new DicomOutputStream(deflaterOutputStream, null, "1.2.840.10008.1.2.1");
                } else if (dicomOutputStream.getTransferSyntaxToWriteDataSet().isBzip2ed()) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.excalibur.bzip2.CBZip2OutputStream");
                        Class[] classArray = new Class[]{OutputStream.class};
                        Object[] objectArray = new Object[]{dicomOutputStream};
                        outputStream = (OutputStream)clazz.getConstructor(classArray).newInstance(objectArray);
                        dicomOutputStream = new DicomOutputStream(outputStream, null, "1.2.840.10008.1.2.1");
                    }
                    catch (Exception exception) {
                        throw new DicomException("Could not instantiate bzip2 codec - " + exception);
                    }
                }
                dicomOutputStream.setWritingDataSet();
            }
            if (!bl2 && !bl) continue;
            attribute.write(dicomOutputStream);
        }
        if (deflaterOutputStream != null) {
            deflaterOutputStream.finish();
        }
        if (outputStream != null) {
            outputStream.close();
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws IOException, DicomException {
        this.write(dicomOutputStream, true);
    }

    public void write(OutputStream outputStream, String string, boolean bl, boolean bl2) throws IOException, DicomException {
        this.write(outputStream, string, bl, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, String string, boolean bl, boolean bl2, boolean bl3) throws IOException, DicomException {
        if (bl2) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        try {
            DicomOutputStream dicomOutputStream = new DicomOutputStream(outputStream, bl ? "1.2.840.10008.1.2.1" : null, string);
            this.write(dicomOutputStream, bl);
            dicomOutputStream.close();
        }
        finally {
            if (bl3) {
                outputStream.close();
            }
        }
    }

    public void write(String string, String string2, boolean bl, boolean bl2) throws IOException, DicomException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.write(fileOutputStream, string2, bl, bl2);
    }

    public void write(String string) throws IOException, DicomException {
        this.write(string, "1.2.840.10008.1.2.1", true, true);
    }

    public void write(File file, String string, boolean bl, boolean bl2) throws IOException, DicomException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.write(fileOutputStream, string, bl, bl2);
    }

    public void write(File file) throws IOException, DicomException {
        this.write(file, "1.2.840.10008.1.2.1", true, true);
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        return super.put(object, object2);
    }

    public Attribute put(AttributeTag attributeTag, Attribute attribute) {
        if (attribute == null || attributeTag == null) {
            throw new NullPointerException();
        }
        return super.put(attributeTag, attribute);
    }

    public Attribute put(Attribute attribute) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        return this.put(attribute.getTag(), attribute);
    }

    public Attribute get(AttributeTag attributeTag) {
        return (Attribute)super.get(attributeTag);
    }

    public boolean isImage() {
        return this.get(TagFromName.PixelData) != null;
    }

    public boolean isSRDocument() {
        return this.get(TagFromName.ContentSequence) != null;
    }

    public static DicomDictionary getDictionary() {
        AttributeList.createDictionaryifNecessary();
        return dictionary;
    }

    public Attribute remove(AttributeTag attributeTag) {
        return (Attribute)super.remove(attributeTag);
    }

    public void replaceWithZeroLengthIfPresent(AttributeTag attributeTag) throws DicomException {
        Attribute attribute = this.get(attributeTag);
        if (attribute != null) {
            Attribute attribute2 = AttributeFactory.newAttribute(attributeTag, AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag));
            this.put(attributeTag, attribute2);
        }
    }

    public void replaceWithDummyValueIfPresent(AttributeTag attributeTag, String string) throws DicomException {
        Attribute attribute = this.get(attributeTag);
        if (attribute != null) {
            Attribute attribute2 = AttributeFactory.newAttribute(attributeTag, AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag));
            attribute2.addValue(string);
            this.put(attributeTag, attribute2);
        }
    }

    public void removePrivateAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (attribute.getTag().isPrivate()) {
                iterator.remove();
                continue;
            }
            if (!(attribute instanceof SequenceAttribute)) continue;
            Iterator iterator2 = ((SequenceAttribute)attribute).iterator();
            while (iterator2.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = (SequenceItem)iterator2.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.removePrivateAttributes();
            }
        }
    }

    public void removeUnsafePrivateAttributes() {
        AttributeTag attributeTag;
        Attribute attribute;
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            attribute = (Attribute)iterator.next();
            attributeTag = attribute.getTag();
            if (attributeTag.isPrivate()) {
                if (ClinicalTrialsAttributes.isSafePrivateAttribute(attributeTag, this)) {
                    object = this.getPrivateCreatorTag(attributeTag);
                    hashSet.add(object);
                    continue;
                }
                iterator.remove();
                continue;
            }
            if (!(attribute instanceof SequenceAttribute)) continue;
            object = ((SequenceAttribute)attribute).iterator();
            while (object.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = (SequenceItem)object.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.removeUnsafePrivateAttributes();
            }
        }
        iterator = this.values().iterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            attributeTag = attribute.getTag();
            if (!attributeTag.isPrivateCreator() || hashSet.contains(attributeTag)) continue;
            iterator.remove();
        }
    }

    public AttributeTag getPrivateCreatorTag(AttributeTag attributeTag) {
        int n = attributeTag.getGroup();
        int n2 = attributeTag.getElement();
        int n3 = (n2 & 0xFF00) >> 8;
        return new AttributeTag(n, n3);
    }

    public String getPrivateCreatorString(AttributeTag attributeTag) {
        AttributeTag attributeTag2 = this.getPrivateCreatorTag(attributeTag);
        String string = Attribute.getSingleStringValueOrEmptyString(this, attributeTag2);
        return string;
    }

    public void removeMetaInformationHeaderAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (attribute.getTag().getGroup() != 2) continue;
            iterator.remove();
        }
    }

    public void removeGroupLengthAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Attribute attribute = (Attribute)iterator.next();
            if (attribute instanceof SequenceAttribute) {
                object = ((SequenceAttribute)attribute).iterator();
                while (object.hasNext()) {
                    AttributeList attributeList;
                    SequenceItem sequenceItem = (SequenceItem)object.next();
                    if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                    attributeList.removeGroupLengthAttributes();
                }
                continue;
            }
            object = attribute.getTag();
            if (((AttributeTag)object).getElement() != 0 || ((AttributeTag)object).getGroup() == 2) continue;
            iterator.remove();
        }
        this.remove(TagFromName.LengthToEnd);
    }

    public void removeOverlayAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getTag().isOverlayGroup()) continue;
            iterator.remove();
        }
    }

    public void removeCurveAttributes() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getTag().isCurveGroup()) continue;
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        AttributeList.createDictionaryifNecessary();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Attribute)iterator.next()).toString(dictionary));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Attribute)iterator.next()).toString(dicomDictionary));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void setFileUsedByOnDiskAttributes(File file) {
        for (Attribute attribute : this.values()) {
            if (attribute instanceof OtherByteAttributeOnDisk) {
                ((OtherByteAttributeOnDisk)attribute).setFile(file);
                continue;
            }
            if (!(attribute instanceof OtherWordAttributeOnDisk)) continue;
            ((OtherWordAttributeOnDisk)attribute).setFile(file);
        }
    }

    public Attribute putNewAttribute(AttributeTag attributeTag, SpecificCharacterSet specificCharacterSet) throws DicomException {
        Attribute attribute = null;
        byte[] byArray = AttributeList.getDictionary().getValueRepresentationFromTag(attributeTag);
        if (byArray == null) {
            throw new DicomException("No such data element as " + attributeTag + " in dictionary");
        }
        attribute = AttributeFactory.newAttribute(attributeTag, byArray, specificCharacterSet);
        if (attribute == null) {
            throw new DicomException("Could not create attribute for tag " + attributeTag);
        }
        super.put(attributeTag, attribute);
        return attribute;
    }

    public Attribute putNewAttribute(AttributeTag attributeTag) throws DicomException {
        return this.putNewAttribute(attributeTag, null);
    }

    public void setSpecificCharacterSet(SpecificCharacterSet specificCharacterSet) {
        if (specificCharacterSet != null) {
            for (Attribute attribute : this.values()) {
                if (attribute == null) continue;
                if (attribute instanceof SequenceAttribute) {
                    Iterator iterator = ((SequenceAttribute)attribute).iterator();
                    while (iterator.hasNext()) {
                        AttributeList attributeList;
                        SequenceItem sequenceItem = (SequenceItem)iterator.next();
                        if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                        attributeList.setSpecificCharacterSet(specificCharacterSet);
                    }
                    continue;
                }
                if (!(attribute instanceof StringAttributeAffectedBySpecificCharacterSet)) continue;
                ((StringAttributeAffectedBySpecificCharacterSet)attribute).setSpecificCharacterSet(specificCharacterSet);
            }
        }
    }

    public SpecificCharacterSet getSuitableSpecificCharacterSetForAllStringValues() {
        return new SpecificCharacterSet(this);
    }

    public void insertSuitableSpecificCharacterSetForAllStringValues() throws DicomException {
        SpecificCharacterSet specificCharacterSet = this.getSuitableSpecificCharacterSetForAllStringValues();
        if (specificCharacterSet != null) {
            String string = specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute();
            if (string != null && string.length() > 0) {
                this.putNewAttribute(TagFromName.SpecificCharacterSet).addValue(string);
            } else {
                this.remove(TagFromName.SpecificCharacterSet);
            }
            this.setSpecificCharacterSet(specificCharacterSet);
        }
    }

    public void insertLossyImageCompressionHistoryIfDecompressed() throws DicomException {
        if (this.pixelDataWasDecompressed && this.pixelDataWasLossy) {
            Attribute attribute = new CodeStringAttribute(TagFromName.LossyImageCompression);
            attribute.addValue("01");
            this.put(attribute);
            if (this.lossyMethod != null && this.lossyMethod.length() > 0) {
                Object object;
                attribute = this.get(TagFromName.LossyImageCompressionMethod);
                if (attribute == null) {
                    attribute = new CodeStringAttribute(TagFromName.LossyImageCompressionMethod);
                    this.put(attribute);
                }
                int n = 0;
                if (attribute.getVM() == 0) {
                    attribute.addValue(this.lossyMethod);
                    n = 0;
                } else {
                    object = attribute.getStringValues();
                    if (((String[])object).length > 0 && object[((String[])object).length - 1] != null && !((String)object[((Object)object).length - 1]).equals(this.lossyMethod)) {
                        n = ((Object)object).length;
                        attribute.addValue(this.lossyMethod);
                    }
                }
                object = this.get(TagFromName.LossyImageCompressionRatio);
                if (object == null) {
                    object = new DecimalStringAttribute(TagFromName.LossyImageCompressionRatio);
                    this.put((Attribute)object);
                }
                if (((Attribute)object).getVM() <= n) {
                    while (--n > 0) {
                        ((Attribute)object).addValue("");
                    }
                    if (this.compressionRatio > 0.0) {
                        ((Attribute)object).addValue(this.compressionRatio);
                    } else {
                        ((Attribute)object).addValue("");
                    }
                }
            }
        }
    }

    public void correctDecompressedImagePixelModule() throws DicomException {
        if (this.pixelDataWasDecompressed && Attribute.getSingleIntegerValueOrDefault(this, TagFromName.SamplesPerPixel, 0) > 1) {
            Attribute attribute;
            String string = Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PhotometricInterpretation);
            if (string.equals("YBR_FULL_422") || string.equals("YBR_FULL") || string.equals("YBR_PARTIAL_422") || string.equals("YBR_PARTIAL_420") || string.equals("YBR_RCT") || string.equals("YBR_ICT")) {
                attribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                attribute.addValue("RGB");
                this.put(attribute);
            }
            attribute = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            attribute.addValue(0);
            this.put(attribute);
        }
        for (Attribute attribute : this.values()) {
            if (attribute == null || !(attribute instanceof SequenceAttribute)) continue;
            Iterator iterator = ((SequenceAttribute)attribute).iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList;
                SequenceItem sequenceItem = (SequenceItem)iterator.next();
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null) continue;
                attributeList.correctDecompressedImagePixelModule();
            }
        }
    }

    public String buildInstanceTitleFromAttributeList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PatientName));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.PatientID));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.StudyID));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.StudyDate));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.StudyDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.SeriesNumber));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.Modality));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.SeriesDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(this, TagFromName.InstanceNumber));
        stringBuffer.append(":");
        return stringBuffer.toString();
    }

    public static String buildInstanceTitleFromAttributeList(AttributeList attributeList) {
        return attributeList == null ? "" : attributeList.buildInstanceTitleFromAttributeList();
    }

    static void test(String[] stringArray) {
        Object object;
        try {
            object = new AttributeTag(32, 13);
            try {
                Class<CodeStringAttribute> clazz = CodeStringAttribute.class;
                Class[] classArray = new Class[]{AttributeTag.class};
                Object[] objectArray = new Object[]{object};
                Attribute attribute = (Attribute)clazz.getConstructor(classArray).newInstance(objectArray);
                System.err.println("made an " + attribute);
            }
            catch (Exception exception) {
                throw new DicomException("Could not instantiate an attribute for " + object + ": " + exception);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, looking for metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, true, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
            if (stringArray.length > 1) {
                System.err.println("also writing it unchanged to " + stringArray[1]);
                ((AttributeList)object).write(stringArray[1], "1.2.840.10008.1.2.1", true, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, looking for metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, true, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, looking for metaheader, EVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2.1", true, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, looking for metaheader, EVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2.1", true, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, no metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, false, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, no metaheader, no uid specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], null, false, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it buffered, no metaheader, IVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2", false, true);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("do it unbuffered, no metaheader, IVRLE specified");
        try {
            object = new AttributeList();
            System.err.println("test reading list");
            ((AttributeList)object).read(stringArray[0], "1.2.840.10008.1.2", false, false);
            System.err.println("test iteration through list");
            System.err.print(((AttributeList)object).toString());
            System.err.println("test fetching specific tags");
            System.err.println(((AttributeList)object).get(new AttributeTag(32, 13)));
            System.err.println(((AttributeList)object).get(new AttributeTag(16, 16)));
            System.err.println(((AttributeList)object).get(new AttributeTag(112, 16)));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 3 && stringArray[2].equals("TEST")) {
            AttributeList.test(stringArray);
        } else if (stringArray.length > 0) {
            String string = null;
            String string2 = null;
            String string3 = "1.2.840.10008.1.2.1";
            String string4 = null;
            boolean bl = true;
            if (stringArray.length == 1) {
                string2 = stringArray[0];
            } else if (stringArray.length == 2) {
                string2 = stringArray[0];
                string4 = stringArray[1];
            } else if (stringArray.length == 3) {
                string2 = stringArray[0];
                string3 = TransferSyntaxFromName.getUID(stringArray[1]);
                string4 = stringArray[2];
            } else if (stringArray.length == 4) {
                string = TransferSyntaxFromName.getUID(stringArray[0]);
                string2 = stringArray[1];
                string3 = TransferSyntaxFromName.getUID(stringArray[2]);
                string4 = stringArray[3];
            } else if (stringArray.length == 5) {
                string = TransferSyntaxFromName.getUID(stringArray[0]);
                string2 = stringArray[1];
                string3 = TransferSyntaxFromName.getUID(stringArray[2]);
                string4 = stringArray[3];
                bl = !stringArray[4].toUpperCase().contains("NO");
            }
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string2, string, string == null || string.length() == 0, true);
                if (string4 == null) {
                    System.err.print("Dumping ...");
                    System.err.print(attributeList.toString());
                } else {
                    attributeList.removeGroupLengthAttributes();
                    attributeList.removeMetaInformationHeaderAttributes();
                    attributeList.remove(TagFromName.DataSetTrailingPadding);
                    attributeList.correctDecompressedImagePixelModule();
                    FileMetaInformation.addFileMetaInformation(attributeList, string3, "OURAETITLE");
                    attributeList.write(string4, string3, bl, true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private class OurIIOReadProgressListener
    implements IIOReadProgressListener {
        private OurIIOReadProgressListener() {
        }

        public void imageComplete(ImageReader imageReader) {
        }

        public void imageProgress(ImageReader imageReader, float f) {
        }

        public void imageStarted(ImageReader imageReader, int n) {
        }

        public void readAborted(ImageReader imageReader) {
        }

        public void sequenceComplete(ImageReader imageReader) {
        }

        public void sequenceStarted(ImageReader imageReader, int n) {
        }

        public void thumbnailComplete(ImageReader imageReader) {
        }

        public void thumbnailProgress(ImageReader imageReader, float f) {
        }

        public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
        }
    }
}

