/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.SignedLongAttribute;
import com.pixelmed.dicom.SignedShortAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import java.io.PrintStream;
import java.text.NumberFormat;

class AttributeTest {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTest.java,v 1.2 2009/12/16 21:56:36 dclunie Exp $";

    AttributeTest() {
    }

    boolean testArrayOfShortComparison(String string, String string2, short[] sArray, short[] sArray2, int n, PrintStream printStream) {
        boolean bl = true;
        int n2 = sArray2.length;
        if (n2 != n) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned array of length " + n2 + " expected " + n);
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (sArray[i] == sArray2[i]) continue;
                printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as \"" + sArray2[i] + "\", but expected \"" + sArray[i] + "\"");
                bl = false;
            }
        }
        return bl;
    }

    boolean testArrayOfIntComparison(String string, String string2, int[] nArray, int[] nArray2, int n, PrintStream printStream) {
        boolean bl = true;
        int n2 = nArray2.length;
        if (n2 != n) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned array of length " + n2 + " expected " + n);
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as \"" + nArray2[i] + "\", but expected \"" + nArray[i] + "\"");
                bl = false;
            }
        }
        return bl;
    }

    boolean testArrayOfLongComparison(String string, String string2, long[] lArray, long[] lArray2, int n, PrintStream printStream) {
        boolean bl = true;
        int n2 = lArray2.length;
        if (n2 != n) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned array of length " + n2 + " expected " + n);
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == lArray2[i]) continue;
                printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as \"" + lArray2[i] + "\", but expected \"" + lArray[i] + "\"");
                bl = false;
            }
        }
        return bl;
    }

    boolean testArrayOfFloatComparison(String string, String string2, float[] fArray, float[] fArray2, int n, PrintStream printStream) {
        boolean bl = true;
        int n2 = fArray2.length;
        if (n2 != n) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned array of length " + n2 + " expected " + n);
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (fArray[i] == fArray2[i]) continue;
                printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as \"" + fArray2[i] + "\", but expected \"" + fArray[i] + "\"");
                bl = false;
            }
        }
        return bl;
    }

    boolean testArrayOfDoubleComparison(String string, String string2, double[] dArray, double[] dArray2, int n, PrintStream printStream) {
        boolean bl = true;
        int n2 = dArray2.length;
        if (n2 != n) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned array of length " + n2 + " expected " + n);
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (dArray[i] == dArray2[i]) continue;
                printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as \"" + dArray2[i] + "\", but expected \"" + dArray[i] + "\"");
                bl = false;
            }
        }
        return bl;
    }

    boolean testArrayOfStringComparison(String string, String string2, String[] stringArray, String[] stringArray2, int n, PrintStream printStream) {
        boolean bl = true;
        int n2 = stringArray2.length;
        if (n2 != n) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned array of length " + n2 + " expected " + n);
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray2[i];
                if (string3 == null) {
                    if (stringArray[i] == null) continue;
                    printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as null, but expected \"" + stringArray[i] + "\"");
                    bl = false;
                    continue;
                }
                if (stringArray[i].equals(string3)) continue;
                printStream.println(string + ": " + "Failed - " + string2 + " returned value [" + i + "] as \"" + string3 + "\", but expected \"" + stringArray[i] + "\"");
                bl = false;
            }
        }
        return bl;
    }

    boolean testSingleStringComparison(String string, String string2, String string3, String string4, PrintStream printStream) {
        boolean bl = true;
        if (string4 == null) {
            if (string3 != null) {
                printStream.println(string + ": " + "Failed - " + string2 + " returned value  as null, but expected \"" + string3 + "\"");
                bl = false;
            }
        } else if (!string3.equals(string4)) {
            printStream.println(string + ": " + "Failed - " + string2 + " returned value as \"" + string4 + "\", but expected \"" + string3 + "\"");
            bl = false;
        }
        return bl;
    }

    boolean testAttributeWithValues(String string, Attribute attribute, String[] stringArray, String string2, PrintStream printStream, boolean bl, boolean bl2) {
        return this.testAttributeWithValues(string, attribute, stringArray, string2, printStream, bl, bl2, null, null, null, null, null);
    }

    boolean testAttributeWithValues(String string, Attribute attribute, String[] stringArray, String string2, PrintStream printStream, boolean bl, boolean bl2, short[] sArray, int[] nArray, long[] lArray, float[] fArray, double[] dArray) {
        boolean bl3;
        Object object;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2; n += 1) {
            try {
                attribute.addValue(stringArray[n]);
                continue;
            }
            catch (Exception exception) {
                printStream.println(string + ": " + "Failed - addValue() threw Exception " + exception);
                return false;
            }
        }
        n = attribute.getVM();
        if (n != n2) {
            printStream.println(string + ": " + "Failed - getVM() returned " + n + " expected " + n2);
            return false;
        }
        n = 1;
        if (bl) {
            boolean bl4;
            if (sArray != null) {
                object = "getShortValues()";
                try {
                    bl4 = this.testArrayOfShortComparison(string, (String)object, sArray, attribute.getShortValues(), n2, printStream);
                    n = n != 0 && bl4 ? 1 : 0;
                }
                catch (Exception exception) {
                    printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
                    n = 0;
                }
            }
            if (nArray != null) {
                object = "getIntegerValues()";
                try {
                    bl4 = this.testArrayOfIntComparison(string, (String)object, nArray, attribute.getIntegerValues(), n2, printStream);
                    n = n != 0 && bl4 ? 1 : 0;
                }
                catch (Exception exception) {
                    printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
                    n = 0;
                }
            }
            if (lArray != null) {
                object = "getLongValues()";
                try {
                    boolean bl5 = this.testArrayOfLongComparison(string, (String)object, lArray, attribute.getLongValues(), n2, printStream);
                    n = n != 0 && bl5 ? 1 : 0;
                }
                catch (Exception exception) {
                    printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
                    n = 0;
                }
            }
            if (fArray != null) {
                object = "getFloatValues()";
                try {
                    boolean bl6 = this.testArrayOfFloatComparison(string, (String)object, fArray, attribute.getFloatValues(), n2, printStream);
                    n = n != 0 && bl6 ? 1 : 0;
                }
                catch (Exception exception) {
                    printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
                    n = 0;
                }
            }
            if (dArray != null) {
                object = "getDoubleValues()";
                try {
                    boolean bl7 = this.testArrayOfDoubleComparison(string, (String)object, dArray, attribute.getDoubleValues(), n2, printStream);
                    n = n != 0 && bl7 ? 1 : 0;
                }
                catch (Exception exception) {
                    printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
                    n = 0;
                }
            }
        }
        if (bl2) {
            object = "getOriginalStringValues()";
            try {
                boolean bl8 = this.testArrayOfStringComparison(string, (String)object, stringArray, attribute.getOriginalStringValues(), n2, printStream);
                n = n != 0 && bl8 ? 1 : 0;
            }
            catch (Exception exception) {
                printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
                n = 0;
            }
        }
        object = "getStringValues((NumberFormat)null)";
        try {
            boolean bl9 = this.testArrayOfStringComparison(string, (String)object, stringArray, attribute.getStringValues(null), n2, printStream);
            n = n != 0 && bl9 ? 1 : 0;
        }
        catch (Exception exception) {
            printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
            n = 0;
        }
        object = "getSingleStringValueOrDefault(String dflt)";
        String string3 = "DEFAULT";
        boolean bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], attribute.getSingleStringValueOrDefault(string3), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "getSingleStringValueOrDefault(String dflt,(NumberFormat)null)";
        string3 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], attribute.getSingleStringValueOrDefault(string3, null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "getDelimitedStringValuesOrDefault(String dflt)";
        string3 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, string2, attribute.getDelimitedStringValuesOrDefault(string3), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "getDelimitedStringValuesOrDefault(String dflt,(NumberFormat)null)";
        string3 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, string2, attribute.getDelimitedStringValuesOrDefault(string3, null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getStringValues(Attribute)";
        try {
            boolean bl11 = this.testArrayOfStringComparison(string, (String)object, stringArray, Attribute.getStringValues(attribute), n2, printStream);
            n = n != 0 && bl11 ? 1 : 0;
        }
        catch (Exception exception) {
            printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
            n = 0;
        }
        object = "static getStringValues(Attribute,(NumberFormat)null)";
        try {
            boolean bl12 = this.testArrayOfStringComparison(string, (String)object, stringArray, Attribute.getStringValues(attribute, (NumberFormat)null), n2, printStream);
            n = n != 0 && bl12 ? 1 : 0;
        }
        catch (Exception exception) {
            printStream.println(string + ": " + "Failed - " + (String)object + " threw Exception " + exception);
            n = 0;
        }
        object = "static getSingleStringValueOrDefault(Attribute,String dflt)";
        Object object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], Attribute.getSingleStringValueOrDefault(attribute, (String)object2), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getSingleStringValueOrDefault(Attribute,String dflt,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], Attribute.getSingleStringValueOrDefault(attribute, (String)object2, (NumberFormat)null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getSingleStringValueOrEmptyString(Attribute)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], Attribute.getSingleStringValueOrEmptyString(attribute), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getSingleStringValueOrEmptyString(Attribute,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], Attribute.getSingleStringValueOrEmptyString(attribute, (NumberFormat)null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getSingleStringValueOrNull(Attribute)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], Attribute.getSingleStringValueOrNull(attribute), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getSingleStringValueOrNull(Attribute,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, stringArray[0], Attribute.getSingleStringValueOrNull(attribute, (NumberFormat)null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getDelimitedStringValuesOrDefault(Attribute,String dflt)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, string2, Attribute.getDelimitedStringValuesOrDefault(attribute, (String)object2), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getDelimitedStringValuesOrDefault(Attribute,String dflt,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl10 = this.testSingleStringComparison(string, (String)object, string2, Attribute.getDelimitedStringValuesOrDefault(attribute, (String)object2, (NumberFormat)null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getDelimitedStringValuesOrEmptyString(Attribute)";
        object2 = "";
        bl10 = this.testSingleStringComparison(string, (String)object, string2, Attribute.getDelimitedStringValuesOrEmptyString(attribute), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getDelimitedStringValuesOrEmptyString(Attribute,(NumberFormat)null)";
        object2 = "";
        bl10 = this.testSingleStringComparison(string, (String)object, string2, Attribute.getDelimitedStringValuesOrEmptyString(attribute, (NumberFormat)null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getDelimitedStringValuesOrNull(Attribute)";
        object2 = null;
        bl10 = this.testSingleStringComparison(string, (String)object, string2, Attribute.getDelimitedStringValuesOrNull(attribute), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = "static getDelimitedStringValuesOrNull(Attribute,(NumberFormat)null)";
        object2 = null;
        bl10 = this.testSingleStringComparison(string, (String)object, string2, Attribute.getDelimitedStringValuesOrNull(attribute, (NumberFormat)null), printStream);
        n = n != 0 && bl10 ? 1 : 0;
        object = new AttributeList();
        ((AttributeList)object).put(attribute);
        object2 = attribute.getTag();
        String string4 = "static getStringValues(AttributeList,AttributeTag)";
        try {
            bl3 = this.testArrayOfStringComparison(string, string4, stringArray, Attribute.getStringValues((AttributeList)object, (AttributeTag)object2), n2, printStream);
            n = n != 0 && bl3 ? 1 : 0;
        }
        catch (Exception exception) {
            printStream.println(string + ": " + "Failed - " + string4 + " threw Exception " + exception);
            n = 0;
        }
        string4 = "static getStringValues(AttributeList,AttributeTag,(NumberFormat)null)";
        try {
            bl3 = this.testArrayOfStringComparison(string, string4, stringArray, Attribute.getStringValues((AttributeList)object, (AttributeTag)object2, null), n2, printStream);
            n = n != 0 && bl3 ? 1 : 0;
        }
        catch (Exception exception) {
            printStream.println(string + ": " + "Failed - " + string4 + " threw Exception " + exception);
            n = 0;
        }
        string4 = "static getSingleStringValueOrDefault(AttributeList,AttributeTag,String dflt)";
        String string5 = "DEFAULT";
        boolean bl13 = this.testSingleStringComparison(string, string4, stringArray[0], Attribute.getSingleStringValueOrDefault((AttributeList)object, (AttributeTag)object2, string5), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getSingleStringValueOrDefault(AttributeList,AttributeTag,String dflt,(NumberFormat)null)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, stringArray[0], Attribute.getSingleStringValueOrDefault((AttributeList)object, (AttributeTag)object2, string5, null), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getSingleStringValueOrEmptyString(AttributeList,AttributeTag)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, stringArray[0], Attribute.getSingleStringValueOrEmptyString((AttributeList)object, (AttributeTag)object2), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getSingleStringValueOrEmptyString(AttributeList,AttributeTag,(NumberFormat)null)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, stringArray[0], Attribute.getSingleStringValueOrEmptyString((AttributeList)object, (AttributeTag)object2, null), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getSingleStringValueOrNull(AttributeList,AttributeTag)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, stringArray[0], Attribute.getSingleStringValueOrNull((AttributeList)object, (AttributeTag)object2), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getSingleStringValueOrNull(AttributeList,AttributeTag,(NumberFormat)null)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, stringArray[0], Attribute.getSingleStringValueOrNull((AttributeList)object, (AttributeTag)object2, null), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getDelimitedStringValuesOrDefault(AttributeList,AttributeTag,String dflt)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, string2, Attribute.getDelimitedStringValuesOrDefault((AttributeList)object, (AttributeTag)object2, string5), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getDelimitedStringValuesOrDefault(AttributeList,AttributeTag,String dflt,(NumberFormat)null)";
        string5 = "DEFAULT";
        bl13 = this.testSingleStringComparison(string, string4, string2, Attribute.getDelimitedStringValuesOrDefault((AttributeList)object, (AttributeTag)object2, string5, null), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getDelimitedStringValuesOrEmptyString(AttributeList,AttributeTag)";
        string5 = "";
        bl13 = this.testSingleStringComparison(string, string4, string2, Attribute.getDelimitedStringValuesOrEmptyString((AttributeList)object, (AttributeTag)object2), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getDelimitedStringValuesOrEmptyString(AttributeList,AttributeTag,(NumberFormat)null)";
        string5 = "";
        bl13 = this.testSingleStringComparison(string, string4, string2, Attribute.getDelimitedStringValuesOrEmptyString((AttributeList)object, (AttributeTag)object2, null), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getDelimitedStringValuesOrNull(AttributeList,AttributeTag)";
        string5 = null;
        bl13 = this.testSingleStringComparison(string, string4, string2, Attribute.getDelimitedStringValuesOrNull((AttributeList)object, (AttributeTag)object2), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        string4 = "static getDelimitedStringValuesOrNull(AttributeList,AttributeTag,(NumberFormat)null)";
        string5 = null;
        bl13 = this.testSingleStringComparison(string, string4, string2, Attribute.getDelimitedStringValuesOrNull((AttributeList)object, (AttributeTag)object2, null), printStream);
        n = n != 0 && bl13 ? 1 : 0;
        return n != 0;
    }

    boolean testAttributeWithoutValues(String string, Attribute attribute, PrintStream printStream, boolean bl, boolean bl2) {
        boolean bl3 = true;
        Object object = "getSingleStringValueOrDefault(String dflt)";
        Object object2 = "DEFAULT";
        boolean bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, attribute.getSingleStringValueOrDefault((String)object2), printStream);
        bl3 = bl3 && bl4;
        object = "getSingleStringValueOrDefault(String dflt,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, attribute.getSingleStringValueOrDefault((String)object2, null), printStream);
        bl3 = bl3 && bl4;
        object = "static getSingleStringValueOrDefault(Attribute,String dflt)";
        object2 = "DEFAULT";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getSingleStringValueOrDefault(attribute, (String)object2), printStream);
        bl3 = bl3 && bl4;
        object = "static getSingleStringValueOrDefault(Attribute,String dflt,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getSingleStringValueOrDefault(attribute, (String)object2, (NumberFormat)null), printStream);
        bl3 = bl3 && bl4;
        object = "static getSingleStringValueOrEmptyString(Attribute)";
        object2 = "";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getSingleStringValueOrEmptyString(attribute), printStream);
        bl3 = bl3 && bl4;
        object = "static getSingleStringValueOrEmptyString(Attribute,(NumberFormat)null)";
        object2 = "";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getSingleStringValueOrEmptyString(attribute, (NumberFormat)null), printStream);
        bl3 = bl3 && bl4;
        object = "static getSingleStringValueOrNull(Attribute)";
        object2 = null;
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getSingleStringValueOrNull(attribute), printStream);
        bl3 = bl3 && bl4;
        object = "static getSingleStringValueOrNull(Attribute,(NumberFormat)null)";
        object2 = null;
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getSingleStringValueOrNull(attribute, (NumberFormat)null), printStream);
        bl3 = bl3 && bl4;
        object = "static getDelimitedStringValuesOrDefault(Attribute,String dflt)";
        object2 = "DEFAULT";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getDelimitedStringValuesOrDefault(attribute, (String)object2), printStream);
        bl3 = bl3 && bl4;
        object = "static getDelimitedStringValuesOrDefault(Attribute,String dflt,(NumberFormat)null)";
        object2 = "DEFAULT";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getDelimitedStringValuesOrDefault(attribute, (String)object2, (NumberFormat)null), printStream);
        bl3 = bl3 && bl4;
        object = "static getDelimitedStringValuesOrEmptyString(Attribute)";
        object2 = "";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getDelimitedStringValuesOrEmptyString(attribute), printStream);
        bl3 = bl3 && bl4;
        object = "static getDelimitedStringValuesOrEmptyString(Attribute,(NumberFormat)null)";
        object2 = "";
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getDelimitedStringValuesOrEmptyString(attribute, (NumberFormat)null), printStream);
        bl3 = bl3 && bl4;
        object = "static getDelimitedStringValuesOrNull(Attribute)";
        object2 = null;
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getDelimitedStringValuesOrNull(attribute), printStream);
        bl3 = bl3 && bl4;
        object = "static getDelimitedStringValuesOrNull(Attribute,(NumberFormat)null)";
        object2 = null;
        bl4 = this.testSingleStringComparison(string, (String)object, (String)object2, Attribute.getDelimitedStringValuesOrNull(attribute, (NumberFormat)null), printStream);
        bl3 = bl3 && bl4;
        object = new AttributeList();
        ((AttributeList)object).put(attribute);
        object2 = attribute.getTag();
        String string2 = "static getSingleStringValueOrDefault(AttributeList,AttributeTag,String dflt)";
        String string3 = "DEFAULT";
        boolean bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getSingleStringValueOrDefault((AttributeList)object, (AttributeTag)object2, string3), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getSingleStringValueOrDefault(AttributeList,AttributeTag,String dflt,(NumberFormat)null)";
        string3 = "DEFAULT";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getSingleStringValueOrDefault((AttributeList)object, (AttributeTag)object2, string3, null), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getSingleStringValueOrEmptyString(AttributeList,AttributeTag)";
        string3 = "";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getSingleStringValueOrEmptyString((AttributeList)object, (AttributeTag)object2), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getSingleStringValueOrEmptyString(AttributeList,AttributeTag,(NumberFormat)null)";
        string3 = "";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getSingleStringValueOrEmptyString((AttributeList)object, (AttributeTag)object2, null), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getSingleStringValueOrNull(AttributeList,AttributeTag)";
        string3 = null;
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getSingleStringValueOrNull((AttributeList)object, (AttributeTag)object2), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getSingleStringValueOrNull(AttributeList,AttributeTag,(NumberFormat)null)";
        string3 = null;
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getSingleStringValueOrNull((AttributeList)object, (AttributeTag)object2, null), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getDelimitedStringValuesOrDefault(AttributeList,AttributeTag,String dflt)";
        string3 = "DEFAULT";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getDelimitedStringValuesOrDefault((AttributeList)object, (AttributeTag)object2, string3), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getDelimitedStringValuesOrDefault(AttributeList,AttributeTag,String dflt,(NumberFormat)null)";
        string3 = "DEFAULT";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getDelimitedStringValuesOrDefault((AttributeList)object, (AttributeTag)object2, string3, null), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getDelimitedStringValuesOrEmptyString(AttributeList,AttributeTag)";
        string3 = "";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getDelimitedStringValuesOrEmptyString((AttributeList)object, (AttributeTag)object2), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getDelimitedStringValuesOrEmptyString(AttributeList,AttributeTag,(NumberFormat)null)";
        string3 = "";
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getDelimitedStringValuesOrEmptyString((AttributeList)object, (AttributeTag)object2, null), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getDelimitedStringValuesOrNull(AttributeList,AttributeTag)";
        string3 = null;
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getDelimitedStringValuesOrNull((AttributeList)object, (AttributeTag)object2), printStream);
        bl3 = bl3 && bl5;
        string2 = "static getDelimitedStringValuesOrNull(AttributeList,AttributeTag,(NumberFormat)null)";
        string3 = null;
        bl5 = this.testSingleStringComparison(string, string2, string3, Attribute.getDelimitedStringValuesOrNull((AttributeList)object, (AttributeTag)object2, null), printStream);
        bl3 = bl3 && bl5;
        return bl3;
    }

    boolean test(PrintStream printStream) {
        boolean bl = true;
        String[] stringArray = new String[]{"BLA1", "BLA2"};
        String string = "BLA1\\BLA2";
        boolean bl2 = this.testAttributeWithValues("CodeString", new CodeStringAttribute(TagFromName.ImageType), stringArray, string, printStream, false, true);
        bl = bl && bl2;
        boolean bl3 = this.testAttributeWithoutValues("CodeString", new CodeStringAttribute(TagFromName.ImageType), printStream, false, true);
        bl = bl && bl3;
        String[] stringArray2 = new String[]{"1", "2", "0", "-2147483648", "2147483647"};
        string = "1\\2\\0\\-2147483648\\2147483647";
        short[] sArray = new short[]{1, 2, 0, 0, 0};
        int[] nArray = new int[]{1, 2, 0, Integer.MIN_VALUE, Integer.MAX_VALUE};
        long[] lArray = new long[]{1L, 2L, 0L, Integer.MIN_VALUE, Integer.MAX_VALUE};
        float[] fArray = new float[]{1.0f, 2.0f, 0.0f, -2.1474836E9f, 2.1474836E9f};
        double[] dArray = new double[]{1.0, 2.0, 0.0, -2.147483648E9, 2.147483647E9};
        boolean bl4 = this.testAttributeWithValues("IntegerString", new IntegerStringAttribute(TagFromName.SeriesNumber), stringArray2, string, printStream, true, true, sArray, nArray, lArray, fArray, dArray);
        bl = bl && bl4;
        boolean bl5 = this.testAttributeWithoutValues("IntegerString", new IntegerStringAttribute(TagFromName.SeriesNumber), printStream, true, true);
        bl = bl && bl5;
        String[] stringArray3 = new String[]{"1", "2", "0", "65535"};
        string = "1\\2\\0\\65535";
        sArray = new short[]{1, 2, 0, -1};
        nArray = new int[]{1, 2, 0, 65535};
        lArray = new long[]{1L, 2L, 0L, 65535L};
        fArray = new float[]{1.0f, 2.0f, 0.0f, 65535.0f};
        dArray = new double[]{1.0, 2.0, 0.0, 65535.0};
        bl4 = this.testAttributeWithValues("UnsignedShort", new UnsignedShortAttribute(TagFromName.BitsStored), stringArray3, string, printStream, true, false, sArray, nArray, lArray, fArray, dArray);
        bl = bl && bl4;
        boolean bl6 = this.testAttributeWithoutValues("UnsignedShort", new UnsignedShortAttribute(TagFromName.BitsStored), printStream, true, false);
        bl = bl && bl6;
        String[] stringArray4 = new String[]{"1", "2", "0", "-32768", "32767"};
        string = "1\\2\\0\\-32768\\32767";
        sArray = new short[]{1, 2, 0, Short.MIN_VALUE, Short.MAX_VALUE};
        nArray = new int[]{1, 2, 0, Short.MIN_VALUE, Short.MAX_VALUE};
        lArray = new long[]{1L, 2L, 0L, -32768L, 32767L};
        fArray = new float[]{1.0f, 2.0f, 0.0f, -32768.0f, 32767.0f};
        dArray = new double[]{1.0, 2.0, 0.0, -32768.0, 32767.0};
        bl4 = this.testAttributeWithValues("SignedShort", new SignedShortAttribute(TagFromName.BitsStored), stringArray4, string, printStream, true, false, sArray, nArray, lArray, fArray, dArray);
        bl = bl && bl4;
        boolean bl7 = this.testAttributeWithoutValues("SignedShort", new SignedShortAttribute(TagFromName.BitsStored), printStream, true, false);
        bl = bl && bl7;
        String[] stringArray5 = new String[]{"1", "2", "0", "4294967295"};
        string = "1\\2\\0\\4294967295";
        sArray = new short[]{1, 2, 0, -1};
        nArray = new int[]{1, 2, 0, -1};
        lArray = new long[]{1L, 2L, 0L, 0xFFFFFFFFL};
        fArray = new float[]{1.0f, 2.0f, 0.0f, 4.2949673E9f};
        dArray = new double[]{1.0, 2.0, 0.0, 4.294967295E9};
        bl4 = this.testAttributeWithValues("UnsignedLong", new UnsignedLongAttribute(TagFromName.BitsStored), stringArray5, string, printStream, true, false, sArray, nArray, lArray, fArray, dArray);
        bl = bl && bl4;
        boolean bl8 = this.testAttributeWithoutValues("UnsignedLong", new UnsignedLongAttribute(TagFromName.BitsStored), printStream, true, false);
        bl = bl && bl8;
        String[] stringArray6 = new String[]{"1", "2", "0", "-2147483648", "2147483647"};
        string = "1\\2\\0\\-2147483648\\2147483647";
        sArray = new short[]{1, 2, 0, 0, -1};
        nArray = new int[]{1, 2, 0, Integer.MIN_VALUE, Integer.MAX_VALUE};
        lArray = new long[]{1L, 2L, 0L, Integer.MIN_VALUE, Integer.MAX_VALUE};
        fArray = new float[]{1.0f, 2.0f, 0.0f, -2.1474836E9f, 2.1474836E9f};
        dArray = new double[]{1.0, 2.0, 0.0, -2.147483648E9, 2.147483647E9};
        bl4 = this.testAttributeWithValues("SignedLong", new SignedLongAttribute(TagFromName.BitsStored), stringArray6, string, printStream, true, false, sArray, nArray, lArray, fArray, dArray);
        bl = bl && bl4;
        boolean bl9 = this.testAttributeWithoutValues("SignedLong", new SignedLongAttribute(TagFromName.BitsStored), printStream, true, false);
        bl = bl && bl9;
        String[] stringArray7 = new String[]{"1.5", "2.5"};
        string = "1.5\\2.5";
        boolean bl10 = this.testAttributeWithValues("DecimalString", new DecimalStringAttribute(TagFromName.SliceThickness), stringArray7, string, printStream, true, true);
        bl = bl && bl10;
        boolean bl11 = this.testAttributeWithoutValues("DecimalString", new DecimalStringAttribute(TagFromName.SliceThickness), printStream, true, true);
        bl = bl && bl11;
        String[] stringArray8 = new String[]{"1.5", "2.5"};
        string = "1.5\\2.5";
        bl10 = this.testAttributeWithValues("FloatSingle", new FloatSingleAttribute(TagFromName.BeamAngle), stringArray8, string, printStream, true, false);
        bl = bl && bl10;
        boolean bl12 = this.testAttributeWithoutValues("FloatSingle", new FloatSingleAttribute(TagFromName.BeamAngle), printStream, true, false);
        bl = bl && bl12;
        printStream.println("Overall: " + (bl ? "Passed" : "Failed"));
        return bl;
    }

    public static void main(String[] stringArray) {
        new AttributeTest().test(System.err);
    }
}

