/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class ContentItem
implements TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ContentItem.java,v 1.21 2011/02/11 17:01:34 dclunie Exp $";
    protected String valueType;
    protected String relationshipType;
    protected CodedSequenceItem conceptName;
    protected String referencedContentItemIdentifier;
    ContentItem parent;
    List children;
    AttributeList list;

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    public int getIndex(TreeNode treeNode) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            if (!this.children.get(i).equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Enumeration children() {
        return this.children == null ? null : new Vector(this.children).elements();
    }

    private void extractCommonAttributes() {
        this.valueType = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ValueType);
        this.relationshipType = Attribute.getSingleStringValueOrNull(this.list, TagFromName.RelationshipType);
        this.conceptName = CodedSequenceItem.getSingleCodedSequenceItemOrNull(this.list, TagFromName.ConceptNameCodeSequence);
        this.referencedContentItemIdentifier = Attribute.getDelimitedStringValuesOrEmptyString(this.list, TagFromName.ReferencedContentItemIdentifier).replace('\\', '.');
    }

    protected ContentItem(ContentItem contentItem, AttributeList attributeList) {
        this.parent = contentItem;
        if (contentItem != null) {
            contentItem.addChild(this);
        }
        this.list = attributeList;
        this.extractCommonAttributes();
    }

    protected ContentItem(ContentItem contentItem, String string, String string2, CodedSequenceItem codedSequenceItem) throws DicomException {
        this.parent = contentItem;
        if (contentItem != null) {
            contentItem.addChild(this);
        }
        this.list = new AttributeList();
        this.valueType = string;
        Attribute attribute = new CodeStringAttribute(TagFromName.ValueType);
        attribute.addValue(string);
        this.list.put(attribute);
        this.relationshipType = string2;
        if (string2 != null && string2.length() > 0) {
            attribute = new CodeStringAttribute(TagFromName.RelationshipType);
            attribute.addValue(string2);
            this.list.put(attribute);
        }
        this.conceptName = codedSequenceItem;
        if (codedSequenceItem != null) {
            attribute = new SequenceAttribute(TagFromName.ConceptNameCodeSequence);
            ((SequenceAttribute)attribute).addItem(codedSequenceItem.getAttributeList());
            this.list.put(attribute);
        }
        this.referencedContentItemIdentifier = null;
    }

    public void addChild(ContentItem contentItem) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(contentItem);
    }

    public void addSibling(ContentItem contentItem) throws DicomException {
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(contentItem);
    }

    public ContentItem getParentAsContentItem() {
        return this.parent;
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getReferencedSOPClassUID() {
        return null;
    }

    public String getReferencedSOPInstanceUID() {
        return null;
    }

    public String getGraphicType() {
        return null;
    }

    public float[] getGraphicData() {
        return null;
    }

    public String getConceptNameAndValue() {
        return this.getConceptNameCodeMeaning() + " " + this.getConceptValue();
    }

    public abstract String getConceptValue();

    public CodedSequenceItem getConceptName() {
        return this.conceptName;
    }

    public String getConceptNameCodeMeaning() {
        return this.conceptName == null ? "" : this.conceptName.getCodeMeaning();
    }

    public String getConceptNameCodeValue() {
        return this.conceptName == null ? "" : this.conceptName.getCodeValue();
    }

    public String getConceptNameCodingSchemeDesignator() {
        return this.conceptName == null ? "" : this.conceptName.getCodingSchemeDesignator();
    }

    public String getReferencedContentItemIdentifier() {
        return this.referencedContentItemIdentifier == null ? "" : this.referencedContentItemIdentifier;
    }

    public int[] getReferencedContentItemIdentifierArray() {
        String[] stringArray;
        int[] nArray = null;
        if (this.referencedContentItemIdentifier != null && this.referencedContentItemIdentifier.length() > 0 && (stringArray = this.referencedContentItemIdentifier.split("[.]")) != null && stringArray.length > 0) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        return nArray;
    }

    public String toString() {
        return (this.referencedContentItemIdentifier == null || this.referencedContentItemIdentifier.length() == 0 ? "" : "R-") + (this.relationshipType == null ? "" : this.relationshipType) + ": " + (this.valueType == null || this.valueType.length() == 0 ? "" : this.valueType + ": ") + (this.conceptName == null ? "" : this.conceptName.getCodeMeaning()) + (this.referencedContentItemIdentifier == null || this.referencedContentItemIdentifier.length() == 0 ? "" : this.referencedContentItemIdentifier);
    }

    public ContentItem getNamedChild(String string, String string2) {
        ContentItem contentItem = null;
        if (string != null && string2 != null) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                ContentItem contentItem2 = (ContentItem)this.getChildAt(i);
                if (contentItem2 == null) continue;
                String string3 = contentItem2.getConceptNameCodingSchemeDesignator();
                String string4 = contentItem2.getConceptNameCodeValue();
                if (string3 == null || !string3.equals(string) || string4 == null || !string4.equals(string2)) continue;
                contentItem = contentItem2;
                break;
            }
        }
        return contentItem;
    }

    public ContentItem getNamedChild(CodedSequenceItem codedSequenceItem) {
        String string = codedSequenceItem.getCodingSchemeDesignator();
        String string2 = codedSequenceItem.getCodeValue();
        ContentItem contentItem = null;
        if (string != null && string2 != null) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                ContentItem contentItem2 = (ContentItem)this.getChildAt(i);
                if (contentItem2 == null) continue;
                String string3 = contentItem2.getConceptNameCodingSchemeDesignator();
                String string4 = contentItem2.getConceptNameCodeValue();
                if (string3 == null || !string3.equals(string) || string4 == null || !string4.equals(string2)) continue;
                contentItem = contentItem2;
                break;
            }
        }
        return contentItem;
    }

    public String getSingleStringValueOrNullOfNamedChild(String string, String string2) {
        String string3 = null;
        ContentItem contentItem = this.getNamedChild(string, string2);
        if (contentItem != null) {
            if (contentItem instanceof ContentItemFactory.StringContentItem) {
                string3 = ((ContentItemFactory.StringContentItem)contentItem).getConceptValue();
            } else if (contentItem instanceof ContentItemFactory.CodeContentItem) {
                string3 = ((ContentItemFactory.CodeContentItem)contentItem).getConceptValue();
            } else if (contentItem instanceof ContentItemFactory.NumericContentItem) {
                string3 = ((ContentItemFactory.NumericContentItem)contentItem).getNumericValue();
            }
        }
        return string3;
    }

    public static String getSingleStringValueOrNullOfNamedChild(ContentItem contentItem, String string, String string2) {
        String string3 = null;
        if (contentItem != null) {
            string3 = contentItem.getSingleStringValueOrNullOfNamedChild(string, string2);
        }
        return string3;
    }

    public boolean contentItemNameMatchesCodeValueAndCodingSchemeDesignator(String string, String string2) {
        boolean bl = false;
        if (this.conceptName != null) {
            String string3 = this.conceptName.getCodingSchemeDesignator();
            String string4 = this.conceptName.getCodeValue();
            if (string3 != null && string3.trim().equals(string2.trim()) && string4 != null && string4.trim().equals(string.trim())) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean contentItemNameMatchesCodeValueAndCodingSchemeDesignator(ContentItem contentItem, String string, String string2) {
        boolean bl = false;
        if (contentItem != null) {
            bl = contentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(string, string2);
        }
        return bl;
    }
}

