/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClassDescriptions;
import com.pixelmed.dicom.TagFromName;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class DescriptionFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DescriptionFactory.java,v 1.10 2010/12/01 13:27:53 dclunie Exp $";
    private static final double obliquityThresholdCosineValue = 0.8;

    public static final String getMajorAxisFromPatientRelativeDirectionCosine(double d, double d2, double d3) {
        String string = null;
        String string2 = d < 0.0 ? "R" : "L";
        String string3 = d2 < 0.0 ? "A" : "P";
        String string4 = d3 < 0.0 ? "F" : "H";
        double d4 = Math.abs(d);
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        if (d4 > 0.8 && d4 > d5 && d4 > d6) {
            string = string2;
        } else if (d5 > 0.8 && d5 > d4 && d5 > d6) {
            string = string3;
        } else if (d6 > 0.8 && d6 > d4 && d6 > d5) {
            string = string4;
        }
        return string;
    }

    public static final String makeImageOrientationLabelFromImageOrientationPatient(double d, double d2, double d3, double d4, double d5, double d6) {
        String string = null;
        String string2 = DescriptionFactory.getMajorAxisFromPatientRelativeDirectionCosine(d, d2, d3);
        String string3 = DescriptionFactory.getMajorAxisFromPatientRelativeDirectionCosine(d4, d5, d6);
        if (string2 != null && string3 != null) {
            if ((string2.equals("R") || string2.equals("L")) && (string3.equals("A") || string3.equals("P"))) {
                string = "AXIAL";
            } else if ((string3.equals("R") || string3.equals("L")) && (string2.equals("A") || string2.equals("P"))) {
                string = "AXIAL";
            } else if ((string2.equals("R") || string2.equals("L")) && (string3.equals("H") || string3.equals("F"))) {
                string = "CORONAL";
            } else if ((string3.equals("R") || string3.equals("L")) && (string2.equals("H") || string2.equals("F"))) {
                string = "CORONAL";
            } else if ((string2.equals("A") || string2.equals("P")) && (string3.equals("H") || string3.equals("F"))) {
                string = "SAGITTAL";
            } else if ((string3.equals("A") || string3.equals("P")) && (string2.equals("H") || string2.equals("F"))) {
                string = "SAGITTAL";
            }
        } else {
            string = "OBLIQUE";
        }
        return string;
    }

    public static final String makePatientOrientationFromPatientRelativeDirectionCosine(double d, double d2, double d3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = d < 0.0 ? "R" : "L";
        String string2 = d2 < 0.0 ? "A" : "P";
        String string3 = d3 < 0.0 ? "F" : "H";
        double d4 = Math.abs(d);
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        for (int i = 0; i < 3; ++i) {
            if (d4 > 1.0E-4 && d4 > d5 && d4 > d6) {
                stringBuffer.append(string);
                d4 = 0.0;
                continue;
            }
            if (d5 > 1.0E-4 && d5 > d4 && d5 > d6) {
                stringBuffer.append(string2);
                d5 = 0.0;
                continue;
            }
            if (!(d6 > 1.0E-4) || !(d6 > d4) || !(d6 > d5)) break;
            stringBuffer.append(string3);
            d6 = 0.0;
        }
        return stringBuffer.toString();
    }

    public static final String makePatientOrientationFromImageOrientationPatient(double d, double d2, double d3, double d4, double d5, double d6) {
        return DescriptionFactory.makePatientOrientationFromPatientRelativeDirectionCosine(d, d2, d3) + "\\" + DescriptionFactory.makePatientOrientationFromPatientRelativeDirectionCosine(d4, d5, d6);
    }

    public static final String makeImageDescription(AttributeList attributeList) {
        String string;
        String string2;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.InConcatenationNumber);
        if (string3 == null) {
            string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber);
        }
        stringBuffer.append(string3);
        Object object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.NumberOfFrames);
        if (object != null && !((String)object).equals("1")) {
            stringBuffer.append(" [");
            stringBuffer.append((String)object);
            stringBuffer.append(" frames]");
        }
        stringBuffer.append(" {");
        object = "";
        Object object2 = null;
        String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
        if (string4 == null) {
            string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPClassUIDInFile);
        }
        if (string4 != null) {
            object2 = SOPClassDescriptions.getAbbreviationFromUID(string4);
            stringBuffer.append((String)object);
            object = ",";
            stringBuffer.append((String)object2);
        }
        string4 = null;
        Attribute attribute = attributeList.get(TagFromName.ImageType);
        if (attribute != null) {
            stringArray = null;
            try {
                stringArray = attribute.getStringValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
            if (stringArray != null && stringArray.length > 0) {
                if (stringArray[0].equals("DERIVED")) {
                    stringBuffer.append((String)object);
                    object = ",";
                    stringBuffer.append(stringArray[0]);
                }
                if (stringArray.length > 2) {
                    string4 = stringArray[2];
                    if (!stringArray[2].equals("OTHER") && !stringArray[2].equals("MIXED")) {
                        stringBuffer.append((String)object);
                        object = ",";
                        stringBuffer.append(stringArray[2]);
                    }
                    if (!(stringArray.length <= 3 || stringArray[3].equals("NONE") || stringArray[3].equals("UNKNOWN") || stringArray[3].equals("MIXED"))) {
                        stringBuffer.append((String)object);
                        object = ",";
                        stringBuffer.append(stringArray[3]);
                    }
                }
            }
        }
        if ((stringArray = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AcquisitionContrast)) != null && !stringArray.equals("UNKNOWN") && string4 != null && !string4.equals(stringArray)) {
            stringBuffer.append((String)object);
            object = ",";
            if (stringArray.equals("MIXED")) {
                stringBuffer.append("MIXED CONTRAST");
            } else {
                stringBuffer.append((String)stringArray);
            }
        }
        if ((string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.VolumeBasedCalculationTechnique)) != null && !string2.equals("NONE") && !string2.equals("MIXED")) {
            stringBuffer.append((String)object);
            object = ",";
            stringBuffer.append(string2);
        }
        if ((string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation)) == null || string.equals("MONOCHROME1") || string.equals("MONOCHROME2")) {
            String string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PixelPresentation);
            if (string5 != null && !string5.equals("MONOCHROME")) {
                stringBuffer.append((String)object);
                object = ",";
                if (string5.equals("MIXED")) {
                    stringBuffer.append("COLOR & MONOCHROME");
                } else {
                    stringBuffer.append(string5);
                }
            }
        } else {
            stringBuffer.append((String)object);
            object = ",";
            stringBuffer.append(string);
        }
        stringBuffer.append("}");
        object = attributeList.get(TagFromName.ImageOrientationPatient);
        if (object != null) {
            object2 = null;
            try {
                object2 = ((Attribute)object).getDoubleValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
            if (object2 != null && ((Object)object2).length == 6) {
                stringBuffer.append(" <");
                stringBuffer.append(DescriptionFactory.makeImageOrientationLabelFromImageOrientationPatient((double)object2[0], (double)object2[1], (double)object2[2], (double)object2[3], (double)object2[4], (double)object2[5]));
                stringBuffer.append(" ");
                stringBuffer.append(DescriptionFactory.makePatientOrientationFromImageOrientationPatient((double)object2[0], (double)object2[1], (double)object2[2], (double)object2[3], (double)object2[4], (double)object2[5]));
                stringBuffer.append(">");
            }
        }
        if ((object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ImageComments)) != null) {
            stringBuffer.append(" - ");
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public static final String makeImageDescription(Map map) {
        String string;
        String string2;
        String string3;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = (String)map.get("INCONCATENATIONNUMBER");
        if (string4 == null) {
            string4 = (String)map.get("INSTANCENUMBER");
        }
        if (string4 == null) {
            string4 = "";
        }
        stringBuffer.append(string4);
        String string5 = (String)map.get("NUMBEROFFRAMES");
        if (string5 != null && !string5.equals("1")) {
            stringBuffer.append(" [");
            stringBuffer.append(string5);
            stringBuffer.append(" frames]");
        }
        stringBuffer.append(" {");
        string5 = "";
        Object object2 = null;
        String string6 = (String)map.get("SOPCLASSUID");
        if (string6 != null) {
            object2 = SOPClassDescriptions.getAbbreviationFromUID(string6);
            stringBuffer.append(string5);
            string5 = ",";
            stringBuffer.append((String)object2);
        }
        string6 = null;
        String string7 = (String)map.get("IMAGETYPE");
        if (string7 != null && ((StringTokenizer)(object = new StringTokenizer(string7, "\\"))).hasMoreTokens()) {
            string3 = ((StringTokenizer)object).nextToken();
            if (string3.equals("DERIVED")) {
                stringBuffer.append(string5);
                string5 = ",";
                stringBuffer.append(string3);
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string6 = ((StringTokenizer)object).nextToken();
                    if (!string6.equals("OTHER") && !string6.equals("MIXED")) {
                        stringBuffer.append(string5);
                        string5 = ",";
                        stringBuffer.append(string6);
                    }
                    if (((StringTokenizer)object).hasMoreTokens() && !(string = ((StringTokenizer)object).nextToken()).equals("NONE") && !string.equals("UNKNOWN") && !string.equals("MIXED")) {
                        stringBuffer.append(string5);
                        string5 = ",";
                        stringBuffer.append(string);
                    }
                }
            }
        }
        if ((object = (String)map.get("ACQUISITIONCONTRAST")) != null && !((String)object).equals("UNKNOWN") && string6 != null && !string6.equals(object)) {
            stringBuffer.append(string5);
            string5 = ",";
            if (((String)object).equals("MIXED")) {
                stringBuffer.append("MIXED CONTRAST");
            } else {
                stringBuffer.append((String)object);
            }
        }
        if ((string3 = (String)map.get("VOLUMEBASEDCALCULATIONTECHNIQUE")) != null && !string3.equals("NONE") && !string3.equals("MIXED")) {
            stringBuffer.append(string5);
            string5 = ",";
            stringBuffer.append(string3);
        }
        if ((string2 = (String)map.get("PHOTOMETRICINTERPRETATION")) == null || string2.equals("MONOCHROME1") || string2.equals("MONOCHROME2")) {
            string = (String)map.get("PIXELPRESENTATION");
            if (string != null && !string.equals("MONOCHROME")) {
                stringBuffer.append(string5);
                string5 = ",";
                if (string.equals("MIXED")) {
                    stringBuffer.append("COLOR & MONOCHROME");
                } else {
                    stringBuffer.append(string);
                }
            }
        } else {
            stringBuffer.append(string5);
            string5 = ",";
            stringBuffer.append(string2);
        }
        stringBuffer.append("}");
        string5 = (String)map.get("IMAGEORIENTATIONPATIENT");
        if (string5 != null) {
            try {
                object2 = new StringTokenizer(string5, "\\");
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    double d = Double.parseDouble(((StringTokenizer)object2).nextToken());
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        double d2 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                        if (((StringTokenizer)object2).hasMoreTokens()) {
                            double d3 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                            if (((StringTokenizer)object2).hasMoreTokens()) {
                                double d4 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                                if (((StringTokenizer)object2).hasMoreTokens()) {
                                    double d5 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                                    if (((StringTokenizer)object2).hasMoreTokens()) {
                                        double d6 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                                        stringBuffer.append(" <");
                                        stringBuffer.append(DescriptionFactory.makeImageOrientationLabelFromImageOrientationPatient(d, d2, d3, d4, d5, d6));
                                        stringBuffer.append(" ");
                                        stringBuffer.append(DescriptionFactory.makePatientOrientationFromImageOrientationPatient(d, d2, d3, d4, d5, d6));
                                        stringBuffer.append(">");
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string5 = (String)map.get("IMAGECOMMENTS")) != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }

    public static final String makeSeriesDescription(AttributeList attributeList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber));
        stringBuffer.append(" ");
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Modality);
        if (string != null) {
            stringBuffer.append("{");
            stringBuffer.append(string);
            stringBuffer.append("} ");
        }
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription));
        return stringBuffer.toString();
    }

    public static final String makeSeriesDescription(Map map) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = (String)map.get("SERIESNUMBER");
        if (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append(" ");
        }
        if ((string2 = (String)map.get("MODALITY")) != null) {
            stringBuffer.append("{");
            stringBuffer.append(string2);
            stringBuffer.append("} ");
        }
        if ((string = (String)map.get("SERIESDESCRIPTION")) != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String makePatientDescription(Map map) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)map.get("PATIENTNAME");
        if (string2 != null) {
            if (string2.contains("^")) {
                string2 = string2.replaceFirst("\\^+$", "");
            }
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        if ((string = (String)map.get("PATIENTID")) != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

