/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.TagFromName;
import java.io.IOException;
import java.io.InputStream;

public class EncapsulatedInputStream
extends InputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/EncapsulatedInputStream.java,v 1.12 2008/08/18 15:10:07 dclunie Exp $";
    private BinaryInputStream i;
    private boolean bigEndian;
    private byte[] buffer;
    private boolean firstTime;
    private byte[] fragment;
    private int fragmentSize;
    private int fragmentOffset;
    private int fragmentRemaining;
    private boolean sequenceDelimiterEncountered;
    private boolean endOfFrameEncountered;
    private boolean currentFragmentContainsEndOfFrame;
    private long bytesRead;

    protected long getBytesRead() {
        return this.bytesRead;
    }

    private AttributeTag readAttributeTag() throws IOException {
        int n = this.i.readUnsigned16();
        int n2 = this.i.readUnsigned16();
        this.bytesRead += 4L;
        return new AttributeTag(n, n2);
    }

    private long readItemTag() throws IOException {
        AttributeTag attributeTag = this.readAttributeTag();
        long l = this.i.readUnsigned32();
        this.bytesRead += 4L;
        if (attributeTag.equals(TagFromName.SequenceDelimitationItem)) {
            l = 0L;
            this.sequenceDelimiterEncountered = true;
        } else if (!attributeTag.equals(TagFromName.Item)) {
            throw new IOException("Unexpected DICOM tag " + attributeTag + " (vl=" + l + ") in encapsulated data whilst expecting Item or SequenceDelimitationItem");
        }
        return l;
    }

    public void readSequenceDelimiter() throws IOException {
        if (!this.sequenceDelimiterEncountered) {
            this.readItemTag();
        }
        if (!this.sequenceDelimiterEncountered) {
            throw new IOException("Expected DICOM Sequence Delimitation Item tag in encapsulated data");
        }
    }

    public EncapsulatedInputStream(BinaryInputStream binaryInputStream) {
        this.i = binaryInputStream;
        this.bigEndian = binaryInputStream.isBigEndian();
        this.buffer = new byte[8];
        this.fragment = null;
        this.firstTime = true;
        this.sequenceDelimiterEncountered = false;
        this.endOfFrameEncountered = false;
    }

    public void nextFrame() {
        if (this.fragment != null && this.fragmentOffset != 0) {
            this.fragment = null;
        }
        this.endOfFrameEncountered = false;
    }

    public final void readUnsigned16(short[] sArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2 * 2;
        byte[] byArray = new byte[n4];
        this.read(byArray, 0, n4);
        this.bytesRead += (long)n4;
        int n5 = 0;
        if (this.bigEndian) {
            for (n3 = 0; n3 < n2; ++n3) {
                sArray[n + n3] = (short)((byArray[n5++] << 8) + (byArray[n5++] & 0xFF));
            }
        } else {
            while (n3 < n2) {
                sArray[n + n3] = (short)((byArray[n5++] & 0xFF) + (byArray[n5++] << 8));
                ++n3;
            }
        }
    }

    public final int read() throws IOException {
        int n = this.read(this.buffer, 0, 1);
        return n == -1 ? -1 : this.buffer[0] & 0xFF;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.endOfFrameEncountered) {
            return -1;
        }
        int n3 = 0;
        int n4 = n2;
        while (n4 > 0 && !this.sequenceDelimiterEncountered && !this.endOfFrameEncountered) {
            int n5;
            if (this.fragment == null) {
                long l;
                if (this.firstTime) {
                    l = this.readItemTag();
                    if (this.sequenceDelimiterEncountered) {
                        throw new IOException("Expected offset table item tag; got sequence delimiter");
                    }
                    this.i.skipInsistently(l);
                    this.bytesRead += l;
                    this.firstTime = false;
                }
                if ((l = this.readItemTag()) != 0L) {
                    this.currentFragmentContainsEndOfFrame = false;
                    this.fragmentRemaining = this.fragmentSize = (int)l;
                    this.fragment = new byte[this.fragmentSize];
                    this.i.readInsistently(this.fragment, 0, this.fragmentSize);
                    this.bytesRead += (long)this.fragmentSize;
                    this.fragmentOffset = 0;
                    int n6 = this.fragmentRemaining - 1;
                    while (--n6 > 0) {
                        int n7 = this.fragment[n6] & 0xFF;
                        int n8 = this.fragment[n6 + 1] & 0xFF;
                        if (n7 != 255 || n8 != 217) continue;
                        this.currentFragmentContainsEndOfFrame = true;
                        break;
                    }
                    if (n6 > 0) {
                        this.fragmentRemaining = n6 + 2;
                    }
                }
            }
            int n9 = n5 = n4 < this.fragmentRemaining ? n4 : this.fragmentRemaining;
            if (n5 > 0) {
                System.arraycopy(this.fragment, this.fragmentOffset, byArray, n, n5);
                n += n5;
                this.fragmentOffset += n5;
                this.fragmentRemaining -= n5;
                n4 -= n5;
                n3 += n5;
            }
            if (this.fragmentRemaining > 0) continue;
            this.fragment = null;
            if (!this.currentFragmentContainsEndOfFrame) continue;
            this.endOfFrameEncountered = true;
        }
        return n3 == 0 ? -1 : n3;
    }
}

