/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class MoveDicomFilesIntoHierarchy {
    protected static String hierarchicalFolderName = "Sorted";
    protected static String duplicatesFolderNamePrefix = "Duplicates";

    protected static void processFilesRecursively(File file, String string) throws SecurityException, IOException, DicomException, NoSuchAlgorithmException {
        if (file != null && file.exists()) {
            File[] fileArray;
            if (file.isFile() && (string == null || string.length() == 0 || file.getName().endsWith(string))) {
                MoveDicomFilesIntoHierarchy.doSomethingWithEachFile(file);
            } else if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    MoveDicomFilesIntoHierarchy.processFilesRecursively(fileArray[i], string);
                }
            }
        }
    }

    protected static boolean doSomethingWithEachFile(File file) throws IOException, DicomException, NoSuchAlgorithmException {
        boolean bl = false;
        if (DicomFileUtilities.isDicomOrAcrNemaFile(file)) {
            Object object;
            Object object2;
            AttributeList attributeList = new AttributeList();
            attributeList.read(file, TagFromName.PixelData);
            String string = "";
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID).replaceAll("[^0-9.]", "").trim();
            if (string2.length() == 0) {
                System.err.println("\"" + file + "\": no SOP Instance UID - doing nothing");
            } else {
                String string3;
                String string4;
                object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
                if (((String)object2).length() == 0) {
                    object2 = "NOID";
                }
                if ((string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName).replaceAll("[^A-Za-z0-9 ^=,.]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ").replaceAll("^[.]", "_")).length() == 0) {
                    string4 = "NONAME";
                }
                if ((string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate).replaceAll("[^0-9]", "").trim()).length() == 0) {
                    string3 = "19000101";
                }
                while (string3.length() < 8) {
                    string3 = string3 + "0";
                }
                String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime).replaceFirst("[.].*$", "").replaceAll("[^0-9]", "");
                while (string5.length() < 6) {
                    string5 = string5 + "0";
                }
                object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
                String string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
                String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).replaceAll("[^0-9]", "");
                while (string7.length() < 3) {
                    string7 = "0" + string7;
                }
                String string8 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ");
                String string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality).replaceAll("[^A-Za-z0-9 ]", "_").replaceAll("^[ _]*", "").replaceAll("[ _]*$", "").replaceAll("[ ][ ]*", " ").replaceAll("[_][_]*", "_").replaceAll("[_][ ]*", " ").toUpperCase();
                String string10 = "";
                string10 = ((String)object).length() == 0 ? (string6.length() == 0 ? string3 + " " + string5 : string3 + " " + string5 + " [ - " + string6 + "]") : (string6.length() == 0 ? string3 + " " + string5 + " [" + (String)object + "]" : string3 + " " + string5 + " [" + (String)object + " - " + string6 + "]");
                String string11 = "";
                string11 = string9.length() == 0 ? (string8.length() == 0 ? "Series " + string7 + " []" : "Series " + string7 + " [ - " + string8 + "]") : (string8.length() == 0 ? "Series " + string7 + " [" + string9 + "]" : "Series " + string7 + " [" + string9 + " - " + string8 + "]");
                string = string4 + " [" + (String)object2 + "]" + "/" + string10 + "/" + string11 + "/" + string2 + ".dcm";
            }
            if (string.length() > 0) {
                object2 = new File(hierarchicalFolderName, string);
                if (file.getCanonicalPath().equals(((File)object2).getCanonicalPath())) {
                    System.err.println("\"" + file + "\": source and destination same - doing nothing");
                } else {
                    int n = 0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while (!bl2) {
                        object = ((File)object2).getParentFile();
                        if (object != null && !((File)object).exists() && !((File)object).mkdirs()) {
                            System.err.println("\"" + file + "\": parent directory creation failed for \"" + object2 + "\"");
                        }
                        if (((File)object2).exists()) {
                            if (FileUtilities.md5(file.getCanonicalPath()).equals(FileUtilities.md5(((File)object2).getCanonicalPath()))) {
                                System.err.println("\"" + file + "\": destination exists and is identical - not overwriting - removing original \"" + object2 + "\"");
                                if (!file.delete()) {
                                    System.err.println("\"" + file + "\": deletion of duplicate original unsuccessful");
                                }
                                bl3 = true;
                                bl2 = true;
                                continue;
                            }
                            System.err.println("\"" + file + "\": destination exists and is different - not overwriting - move duplicate elsewhere \"" + object2 + "\"");
                            boolean bl4 = false;
                            object2 = new File(duplicatesFolderNamePrefix + "_" + Integer.toString(++n), string);
                            continue;
                        }
                        bl2 = true;
                    }
                    if (!bl3) {
                        if (file.renameTo((File)object2)) {
                            bl = true;
                            System.err.println("\"" + file + "\" moved to \"" + object2 + "\"");
                        } else {
                            System.err.println("\"" + file + "\": move attempt failed to \"" + object2 + "\"");
                        }
                    }
                }
            }
        } else {
            System.err.println("\"" + file + "\": not a DICOM file - doing nothing");
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                MoveDicomFilesIntoHierarchy.processFilesRecursively(new File(stringArray[i]), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

