/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.TagFromName;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public class Overlay {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/Overlay.java,v 1.6 2009/07/10 01:32:13 dclunie Exp $";
    private int numberOfFrames;
    private SingleOverlay[] arrayOfOverlays = new SingleOverlay[16];
    private SingleOverlay[][] arrayOfOverlaysPerFrame = null;
    private int[] numberOfOverlaysPerFrame = null;

    private void constructArrayOfOverlaysPerFrame() {
        if (this.arrayOfOverlaysPerFrame == null) {
            this.arrayOfOverlaysPerFrame = new SingleOverlay[this.numberOfFrames][];
            this.numberOfOverlaysPerFrame = new int[this.numberOfFrames];
            for (int i = 0; i < this.numberOfFrames; ++i) {
                this.arrayOfOverlaysPerFrame[i] = new SingleOverlay[16];
                for (int j = 0; j < 16; ++j) {
                    SingleOverlay singleOverlay = this.arrayOfOverlays[j];
                    if (singleOverlay == null || !singleOverlay.appliesToFrame(i)) continue;
                    this.arrayOfOverlaysPerFrame[i][j] = singleOverlay;
                    int n = i;
                    this.numberOfOverlaysPerFrame[n] = this.numberOfOverlaysPerFrame[n] + 1;
                }
            }
        }
    }

    public Overlay(AttributeList attributeList) {
        this.numberOfFrames = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        for (int n = 0; n < 32; n = (int)((short)(n + 2))) {
            int n2 = n / 2;
            this.arrayOfOverlays[n2] = null;
            short s = (short)(24576 + n);
            Attribute attribute = attributeList.get(new AttributeTag(s, TagFromName.OverlayData.getElement()));
            Attribute attribute2 = attributeList.get(new AttributeTag(s, TagFromName.OverlayRows.getElement()));
            Attribute attribute3 = attributeList.get(new AttributeTag(s, TagFromName.OverlayColumns.getElement()));
            Attribute attribute4 = attributeList.get(new AttributeTag(s, TagFromName.OverlayBitPosition.getElement()));
            if (attribute == null && attribute2 == null && attribute3 == null && attribute4 == null) continue;
            try {
                this.arrayOfOverlays[n2] = new SingleOverlay(attributeList, s);
                continue;
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
    }

    public int getNumberOfOverlays(int n) {
        this.constructArrayOfOverlaysPerFrame();
        return this.numberOfOverlaysPerFrame[n];
    }

    public BufferedImage getOverlayAsBinaryBufferedImage(int n, int n2) {
        this.constructArrayOfOverlaysPerFrame();
        SingleOverlay singleOverlay = this.arrayOfOverlaysPerFrame[n][n2];
        return singleOverlay == null ? null : singleOverlay.getOverlayAsBinaryBufferedImage(n);
    }

    public int getRowOrigin(int n, int n2) {
        this.constructArrayOfOverlaysPerFrame();
        SingleOverlay singleOverlay = this.arrayOfOverlaysPerFrame[n][n2];
        return singleOverlay == null ? 0 : singleOverlay.getRowOrigin(n);
    }

    public int getColumnOrigin(int n, int n2) {
        this.constructArrayOfOverlaysPerFrame();
        SingleOverlay singleOverlay = this.arrayOfOverlaysPerFrame[n][n2];
        return singleOverlay == null ? 0 : singleOverlay.getColumnOrigin(n);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.arrayOfOverlays.length; ++i) {
            if (this.arrayOfOverlays[i] == null) continue;
            stringBuffer.append(this.arrayOfOverlays[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            String string = stringArray[0];
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string);
                Overlay overlay = new Overlay(attributeList);
                System.err.print(overlay);
                System.err.println("getNumberOfOverlays(frame 0) = " + overlay.getNumberOfOverlays(0));
                System.err.println("getOverlayAsBinaryBufferedImage(frame 0,overlay 0) = " + overlay.getOverlayAsBinaryBufferedImage(0, 0));
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private class SingleOverlay {
        short group;
        short[] data;
        int rows;
        int columns;
        int frames;
        int rowOrigin;
        int columnOrigin;
        int frameOrigin;
        int bitPosition;
        String type;
        String subtype;
        String label;
        String description;
        int area;
        double mean;
        double standardDeviation;
        BufferedImage[] imagesForEachFrame = null;

        void doCommonConstructorStuff(short s, short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, String string2, String string3, String string4, int n8, double d, double d2) {
            this.group = s;
            this.data = sArray;
            this.rows = n;
            this.columns = n2;
            this.frames = n3;
            this.rowOrigin = n4;
            this.columnOrigin = n5;
            this.frameOrigin = n6;
            this.bitPosition = n7;
            this.type = string;
            this.subtype = string2;
            this.label = string3;
            this.description = string4;
            this.area = n8;
            this.mean = d;
            this.standardDeviation = d2;
        }

        SingleOverlay(short s, short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, String string2, String string3, String string4, int n8, double d, double d2) {
            this.doCommonConstructorStuff(s, sArray, n, n2, n3, n4, n5, n6, n7, string, string2, string3, string4, n8, d, d2);
        }

        SingleOverlay(AttributeList attributeList, short s) throws DicomException {
            assert (s % 2 == 0 && s >= 24576 && s <= 24606);
            Attribute attribute = attributeList.get(new AttributeTag(s, TagFromName.OverlayData.getElement()));
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, -1);
            int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayRows.getElement()), n);
            int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, -1);
            int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayColumns.getElement()), n3);
            int n5 = 1;
            int n6 = 1;
            int[] nArray = Attribute.getIntegerValues(attributeList, new AttributeTag(s, TagFromName.OverlayOrigin.getElement()));
            if (nArray != null) {
                if (nArray.length >= 2) {
                    n5 = nArray[0];
                    n6 = nArray[1];
                } else if (nArray.length == 1) {
                    n5 = nArray[0];
                    n6 = nArray[0];
                }
            }
            int n7 = attribute != null ? 0 : Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayBitPosition.getElement()), attribute == null ? -1 : 0);
            int n8 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, -1);
            int n9 = attribute != null ? 1 : Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayBitsAllocated.getElement()), n7 == 0 ? 1 : n8);
            String string = Attribute.getSingleStringValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayType.getElement()), "G").trim();
            String string2 = Attribute.getSingleStringValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlaySubtype.getElement()), "").trim();
            String string3 = Attribute.getSingleStringValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayLabel.getElement()), "").trim();
            String string4 = Attribute.getSingleStringValueOrDefault(attributeList, new AttributeTag(s, TagFromName.OverlayDescription.getElement()), "").trim();
            int n10 = Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.NumberOfFramesInOverlay.getElement()), Overlay.this.numberOfFrames);
            int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.ImageFrameOrigin.getElement()), 1);
            int n12 = Attribute.getSingleIntegerValueOrDefault(attributeList, new AttributeTag(s, TagFromName.ROIArea.getElement()), 0);
            double d = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(s, TagFromName.ROIMean.getElement()), 0.0);
            double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(s, TagFromName.ROIStandardDeviation.getElement()), 0.0);
            short[] sArray = null;
            if (n2 > 0 && n4 > 0) {
                int n13 = (n2 * n4 * n10 - 1) / 16 + 1;
                if (attribute != null) {
                    if (attribute instanceof OtherByteAttribute) {
                        byte[] byArray = attribute.getByteValues();
                        sArray = new short[n13];
                        int n14 = 0;
                        for (int i = 0; i < n13; ++i) {
                            if (n14 < byArray.length) {
                                sArray[i] = (short)(byArray[n14] & 0xFF);
                            }
                            if (++n14 < byArray.length) {
                                sArray[i] = (short)(sArray[i] | (short)byArray[n14] << 8 & 0xFF00);
                            }
                            ++n14;
                        }
                    } else if (attribute instanceof OtherWordAttribute) {
                        sArray = attribute.getShortValues();
                    } else {
                        throw new DicomException("OverlayData attribute present in group 0x" + Integer.toHexString(s) + " but unsupported or bad VR");
                    }
                    if (sArray == null) {
                        throw new DicomException("OverlayData attribute present in group 0x" + Integer.toHexString(s) + " but no values");
                    }
                    if (sArray.length < n13) {
                        throw new DicomException("OverlayData in group 0x" + Integer.toHexString(s) + " is too short (got " + sArray.length + " dec words, expected " + n13 + " dec words");
                    }
                } else if (n7 != -1 && n9 > 0 && n9 == n8) {
                    sArray = new short[n13];
                    int n15 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
                    if (n15 != 1) {
                        throw new DicomException("SamplesPerPixel must be 1, not" + n15 + ", to use overlay in PixelData in group 0x" + Integer.toHexString(s));
                    }
                    if (n2 != n || n4 != n3) {
                        throw new DicomException("OverlayRow and OverlayColumns must equal image Rows and Columns respectively, to use overlay in PixelData in group 0x" + Integer.toHexString(s));
                    }
                    Attribute attribute2 = attributeList.get(TagFromName.PixelData);
                    if (attribute2 == null) {
                        throw new DicomException("No PixelData from which to extract overlay in group 0x" + Integer.toHexString(s));
                    }
                    if (attribute2 instanceof OtherWordAttributeOnDisk) {
                        System.err.println("Overlay.SingleOverlay(): Extraction of overlay from PixelData left on disk not supported yet");
                    } else {
                        int n16 = n7;
                        int n17 = 1;
                        while (n16-- > 0) {
                            n17 <<= 1;
                        }
                        short[] sArray2 = attribute2.getShortValues();
                        int n18 = (n11 - 1) * n * n3;
                        int n19 = 0;
                        int n20 = 0;
                        int n21 = 0;
                        for (int i = 0; i < n10; ++i) {
                            for (int j = 0; j < n; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    if (++n20 >= 16) {
                                        sArray[n19++] = (short)n21;
                                        n21 = 0;
                                        n20 = 0;
                                    } else {
                                        n21 >>= 1;
                                    }
                                    int n22 = (sArray2[n18++] & n17) > 0 ? 32768 : 0;
                                    n21 |= n22;
                                }
                            }
                        }
                    }
                }
            } else {
                throw new DicomException("Cannot construct overlay from inconsistent or missing overlay attributes in group 0x" + Integer.toHexString(s));
            }
            this.doCommonConstructorStuff(s, sArray, n2, n4, n10, n5 - 1, n6 - 1, n11 - 1, n7, string, string2, string3, string4, n12, d, d2);
        }

        boolean appliesToFrame(int n) {
            return n >= this.frameOrigin && n < this.frameOrigin + this.frames;
        }

        public BufferedImage getOverlayAsBinaryBufferedImage(int n) {
            boolean bl = false;
            BufferedImage bufferedImage = null;
            if (this.appliesToFrame(n)) {
                if (this.imagesForEachFrame == null) {
                    this.imagesForEachFrame = new BufferedImage[this.frames];
                    if (this.data != null) {
                        byte[] byArray = new byte[]{0, -1};
                        byte[] byArray2 = new byte[]{0, -1};
                        byte[] byArray3 = new byte[]{0, -1};
                        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3, 0);
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        for (int i = 0; i < this.frames; ++i) {
                            this.imagesForEachFrame[i] = new BufferedImage(this.columns, this.rows, 12, indexColorModel);
                            Raster raster = this.imagesForEachFrame[i].getData();
                            SampleModel sampleModel = raster.getSampleModel();
                            DataBuffer dataBuffer = raster.getDataBuffer();
                            for (int j = 0; j < this.rows; ++j) {
                                for (int k = 0; k < this.columns; ++k) {
                                    int n5;
                                    if (n3 <= 0) {
                                        n4 = this.data[n2++];
                                        n3 = 16;
                                    }
                                    if ((n5 = n4 & 1) > 0) {
                                        sampleModel.setSample(k, j, 0, 1, dataBuffer);
                                        bl = true;
                                    }
                                    n4 >>= 1;
                                    --n3;
                                }
                            }
                            this.imagesForEachFrame[i].setData(raster);
                        }
                    }
                }
                int n6 = n - this.frameOrigin;
                bufferedImage = this.imagesForEachFrame[n6];
            }
            return bufferedImage;
        }

        public int getRowOrigin(int n) {
            return this.rowOrigin;
        }

        public int getColumnOrigin(int n) {
            return this.columnOrigin;
        }

        public final String toString() {
            return "Overlay group 0x" + Integer.toHexString(this.group) + ": rows=" + this.rows + ",columns=" + this.columns + ",frames=" + this.frames + "; rowOrigin=" + this.rowOrigin + ",columnOrigin=" + this.columnOrigin + ",frameOrigin=" + this.frameOrigin + "; bitPosition=" + this.bitPosition + "; type=" + this.type + ",subtype=" + this.subtype + ",label=" + this.label + ",description=\"" + this.description + "\"" + "; area=" + this.area + ",mean=" + this.mean + ",standardDeviation=" + this.standardDeviation;
        }
    }
}

