/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.FloatFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class SUVTransform {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SUVTransform.java,v 1.2 2009/11/06 15:29:50 dclunie Exp $";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private SingleSUVTransform useTransform;
    private final int precisionToDisplayDouble = 4;
    private final int maximumIntegerDigits = 8;
    private final int maximumMaximumFractionDigits = 6;

    private static long getTimeInMilliSecondsSinceEpoch(String string) {
        long l;
        try {
            l = dateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            l = 0L;
        }
        return l;
    }

    private static long getTimeInMilliSecondsSinceEpoch(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) {
        return SUVTransform.getTimeInMilliSecondsSinceEpoch(Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag) + Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag2));
    }

    public SUVTransform(AttributeList attributeList) {
        this.useTransform = new SingleSUVTransform(attributeList);
    }

    public String toString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        SingleSUVTransform singleSUVTransform = this.useTransform;
        if (singleSUVTransform.isValidSUVbw()) {
            stringBuffer.append("SUVbw = ");
            double d = singleSUVTransform.getSUVbwValue(n2);
            stringBuffer.append(FloatFormatter.toString(d));
            stringBuffer.append(" ");
            stringBuffer.append(singleSUVTransform.getSUVbwUnits());
        }
        return stringBuffer.toString();
    }

    private class SingleSUVTransform {
        double rescaleIntercept;
        boolean haveSUVbw;
        double scaleFactorSUVbw;
        String unitsSUVbw;

        SingleSUVTransform(AttributeList attributeList) {
            String string;
            String string2;
            if (attributeList != null && (string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID)).equals("1.2.840.10008.5.1.4.1.1.128") && (string = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.CorrectedImage)).contains("ATTN") && string.contains("DECY")) {
                String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Units);
                double d = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 1.0);
                this.rescaleIntercept = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                if (string3.equals("BQML")) {
                    String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.DecayCorrection);
                    double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.PatientWeight, 0.0);
                    Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadionuclideTotalDose);
                    Attribute attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadionuclideHalfLife);
                    Attribute attribute3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.RadiopharmaceuticalInformationSequence, TagFromName.RadiopharmaceuticalStartTime);
                    String string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesDate);
                    long l = SUVTransform.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.SeriesDate, TagFromName.SeriesTime);
                    long l2 = SUVTransform.getTimeInMilliSecondsSinceEpoch(attributeList, TagFromName.AcquisitionDate, TagFromName.AcquisitionTime);
                    long l3 = l;
                    String string6 = string5;
                    if (l > l2) {
                        String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, new AttributeTag(9, 16)).trim();
                        String string8 = Attribute.getSingleStringValueOrNull(attributeList, new AttributeTag(9, 4109));
                        if (string7.equals("GEMS_PETD_01") && string8 != null) {
                            l3 = SUVTransform.getTimeInMilliSecondsSinceEpoch(string8);
                            string6 = string8.substring(0, 8);
                        } else {
                            l3 = 0L;
                            string6 = null;
                        }
                    }
                    if (string4.equals("START") && attribute != null && attribute2 != null && attribute3 != null && string6 != null && l3 != 0L && d2 != 0.0) {
                        long l4 = SUVTransform.getTimeInMilliSecondsSinceEpoch(string6 + attribute3.getSingleStringValueOrEmptyString());
                        double d3 = (double)(l3 - l4) / 1000.0;
                        double d4 = attribute2.getSingleDoubleValueOrDefault(0.0);
                        double d5 = attribute.getSingleDoubleValueOrDefault(0.0);
                        double d6 = d5 * Math.pow(2.0, -d3 / d4);
                        this.scaleFactorSUVbw = d2 * 1000.0 / d6;
                        this.scaleFactorSUVbw *= d;
                        this.haveSUVbw = true;
                        this.unitsSUVbw = "g/ml";
                    }
                } else if (string3.equals("CNTS")) {
                    String string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, new AttributeTag(28755, 16)).trim();
                    double d7 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(28755, 4096), 0.0);
                    if (string9.equals("Philips PET Private Group") && d7 != 0.0) {
                        this.scaleFactorSUVbw = d7 * d;
                        this.haveSUVbw = true;
                        this.unitsSUVbw = "g/ml";
                    }
                } else if (string3.equals("GML")) {
                    this.scaleFactorSUVbw = d;
                    this.haveSUVbw = true;
                    this.unitsSUVbw = "g/ml";
                }
            }
        }

        boolean isValidSUVbw() {
            return this.haveSUVbw;
        }

        double getSUVbwValue(int n) {
            return ((double)n + this.rescaleIntercept) * this.scaleFactorSUVbw;
        }

        String getSUVbwUnits() {
            return this.unitsSUVbw;
        }
    }
}

