/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public class SignedLongAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SignedLongAttribute.java,v 1.17 2009/12/16 21:56:37 dclunie Exp $";
    short[] cachedShortCopy;
    int[] values;
    long[] cachedLongCopy;
    float[] cachedFloatCopy;
    double[] cachedDoubleCopy;
    static int bytesPerValue = 4;

    private void flushCachedCopies() {
        this.cachedShortCopy = null;
        this.cachedLongCopy = null;
        this.cachedFloatCopy = null;
        this.cachedDoubleCopy = null;
    }

    public SignedLongAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.flushCachedCopies();
        this.values = null;
    }

    public SignedLongAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public SignedLongAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.flushCachedCopies();
        if (l % (long)bytesPerValue != 0L) {
            dicomInputStream.skipInsistently(l);
            throw new DicomException("incorrect value length (" + l + " dec) for VR " + this.getVRAsString() + " - skipping value length bytes to get to next data element");
        }
        int n = (int)(l / (long)bytesPerValue);
        this.values = null;
        for (int i = 0; i < n; ++i) {
            this.addValue(dicomInputStream.readSigned32());
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        int[] nArray = this.getIntegerValues();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                dicomOutputStream.writeSigned32(nArray[i]);
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" [");
        try {
            long[] lArray = this.getLongValues();
            if (lArray != null) {
                for (int i = 0; i < lArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("0x");
                    stringBuffer.append(Long.toHexString(lArray[i]));
                }
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        int[] nArray = this.getIntegerValues();
        if (nArray != null) {
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = numberFormat == null ? Long.toString(nArray[i]) : numberFormat.format(nArray[i]);
            }
        }
        return stringArray;
    }

    public short[] getShortValues() throws DicomException {
        if (this.cachedShortCopy == null) {
            this.cachedShortCopy = ArrayCopyUtilities.copySignedIntToShortArray(this.values);
        }
        return this.cachedShortCopy;
    }

    public int[] getIntegerValues() throws DicomException {
        return this.values;
    }

    public long[] getLongValues() throws DicomException {
        if (this.cachedLongCopy == null) {
            this.cachedLongCopy = ArrayCopyUtilities.copySignedIntToLongArray(this.values);
        }
        return this.cachedLongCopy;
    }

    public float[] getFloatValues() throws DicomException {
        if (this.cachedFloatCopy == null) {
            this.cachedFloatCopy = ArrayCopyUtilities.copySignedIntToFloatArray(this.values);
        }
        return this.cachedFloatCopy;
    }

    public double[] getDoubleValues() throws DicomException {
        if (this.cachedDoubleCopy == null) {
            this.cachedDoubleCopy = ArrayCopyUtilities.copySignedIntToDoubleArray(this.values);
        }
        return this.cachedDoubleCopy;
    }

    public void addValue(short s) throws DicomException {
        this.addValue((int)s);
    }

    public void addValue(int n) throws DicomException {
        this.flushCachedCopies();
        this.values = ArrayCopyUtilities.expandArray(this.values);
        this.values[this.valueMultiplicity++] = n;
        this.valueLength += 4L;
    }

    public void addValue(long l) throws DicomException {
        this.addValue((int)l);
    }

    public void addValue(float f) throws DicomException {
        this.addValue((int)f);
    }

    public void addValue(double d) throws DicomException {
        this.addValue((int)d);
    }

    public void addValue(String string) throws DicomException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException(numberFormatException.toString());
        }
        this.addValue(n);
    }

    public void removeValues() {
        this.flushCachedCopies();
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.SL;
    }
}

