/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;

public abstract class TextAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TextAttribute.java,v 1.16 2005/07/04 16:33:53 dclunie Exp $";
    protected SpecificCharacterSet specificCharacterSet;
    String[] values;

    protected String translateByteArrayToString(byte[] byArray, int n, int n2) {
        return this.specificCharacterSet == null ? new String(byArray, 0, n2) : this.specificCharacterSet.translateByteArrayToString(byArray, 0, n2);
    }

    protected byte[] translateStringToByteArray(String string) throws UnsupportedEncodingException {
        return this.specificCharacterSet == null ? string.getBytes() : this.specificCharacterSet.translateStringToByteArray(string);
    }

    protected TextAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.doCommonConstructorStuff(null);
    }

    protected TextAttribute(AttributeTag attributeTag, SpecificCharacterSet specificCharacterSet) {
        super(attributeTag);
        this.doCommonConstructorStuff(specificCharacterSet);
    }

    protected TextAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, specificCharacterSet);
    }

    protected TextAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, specificCharacterSet);
    }

    private void doCommonConstructorStuff(SpecificCharacterSet specificCharacterSet) {
        this.values = null;
        this.specificCharacterSet = specificCharacterSet;
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        this.doCommonConstructorStuff(specificCharacterSet);
        if (l > 0L) {
            byte[] byArray = new byte[(int)l];
            try {
                dicomInputStream.readInsistently(byArray, 0, (int)l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
            String string = this.translateByteArrayToString(byArray, 0, (int)l);
            l = string.length();
            this.addValue(string);
        }
    }

    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    private byte getPadByte() {
        return 32;
    }

    private byte[] getPaddedByteValues() throws DicomException {
        String[] stringArray = this.getStringValues();
        byte[] byArray = null;
        try {
            if (stringArray != null) {
                byArray = this.translateStringToByteArray(stringArray[0]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomException("Unsupported encoding:" + unsupportedEncodingException);
        }
        if (byArray != null) {
            int n = byArray.length;
            if (n % 2 != 0) {
                byte[] byArray2 = new byte[n + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray2[n] = this.getPadByte();
                byArray = byArray2;
            }
            if (this.getPaddedVL() != (long)byArray.length) {
                throw new DicomException("Internal error - byte array length not equal to expected padded VL");
            }
        }
        return byArray;
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        byte[] byArray = this.getPaddedByteValues();
        if (byArray != null && byArray.length > 0) {
            dicomOutputStream.write(byArray);
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" <");
        try {
            String[] stringArray = this.getStringValues();
            if (stringArray != null) {
                stringBuffer.append(stringArray[0]);
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        return this.values;
    }

    public void addValue(String string) throws DicomException {
        if (this.values != null || this.valueMultiplicity > 0) {
            throw new DicomException("No more than one value allowed for text attributes");
        }
        this.values = new String[1];
        this.values[0] = string;
        this.valueLength = string.length();
        ++this.valueMultiplicity;
    }

    public void removeValues() throws DicomException {
        this.valueLength = 0L;
        this.valueMultiplicity = 0;
        this.values = null;
    }
}

