/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class UnknownAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UnknownAttribute.java,v 1.16 2010/11/06 16:03:15 dclunie Exp $";
    protected byte[] originalLittleEndianByteValues;

    public UnknownAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public UnknownAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public UnknownAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.valueLength = l;
        this.valueMultiplicity = 1;
        try {
            this.originalLittleEndianByteValues = new byte[(int)l];
            dicomInputStream.readInsistently(this.originalLittleEndianByteValues, 0, (int)l);
        }
        catch (IOException iOException) {
            throw new DicomException("Failed to read value (length " + l + " dec) in UN attribute " + this.getTag());
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        dicomOutputStream.write(this.originalLittleEndianByteValues);
    }

    public String toString(DicomDictionary dicomDictionary) {
        return super.toString(dicomDictionary) + " " + this.getVR() + " ";
    }

    public void removeValues() {
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.UN;
    }

    public byte[] getByteValues() {
        return this.originalLittleEndianByteValues;
    }
}

