/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseMediaImporter;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeListFunctionalGroupsTableModelAllFrames;
import com.pixelmed.dicom.AttributeListFunctionalGroupsTableModelOneFrame;
import com.pixelmed.dicom.AttributeListTableBrowser;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTreeBrowser;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryBrowser;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.LongTextAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.PixelSpacing;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SpectroscopyVolumeLocalization;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.StructuredReportTreeBrowser;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.XMLRepresentationOfDicomObjectFactory;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.ImageLocalizerManager;
import com.pixelmed.display.OrientationAnnotations;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SingleImagePanelWithLineDrawing;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.SourceImageGraphicDisplaySelectorPanel;
import com.pixelmed.display.SourceImageSortOrderPanel;
import com.pixelmed.display.SourceImageVOILUTSelectorPanel;
import com.pixelmed.display.SourceSpectra;
import com.pixelmed.display.SourceSpectrumSortOrderPanel;
import com.pixelmed.display.SpectraPanel;
import com.pixelmed.display.SpectroscopyLocalizerManager;
import com.pixelmed.display.event.BrowserPaneChangeEvent;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.SourceImageSelectionChangeEvent;
import com.pixelmed.display.event.SourceSpectrumSelectionChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.display.event.WellKnownContext;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.query.FilterPanel;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeBrowser;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.FloatFormatter;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.validate.DicomInstanceValidator;
import com.pixelmed.validate.DicomSRValidator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DicomImageViewer
extends ApplicationFrame
implements KeyListener,
MouseListener {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomImageViewer.java,v 1.220 2010/11/27 13:54:13 dclunie Exp $";
    static final char screenSnapShotKeyChar = 'K';
    static final String propertiesFileName = ".com.pixelmed.display.DicomImageViewer.properties";
    private static final String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    private static final String propertyName_DicomCurrentlySelectedQueryTargetAE = "Dicom.CurrentlySelectedQueryTargetAE";
    static final String propertyName_FullScreen = "Display.FullScreen";
    private DatabaseApplicationProperties databaseApplicationProperties = null;
    private NetworkApplicationProperties networkApplicationProperties = null;
    private NetworkApplicationInformation networkApplicationInformation = null;
    protected StoredFilePathStrategy storedFilePathStrategy = StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS;
    protected File savedImagesFolder;
    protected String lastDirectoryPath;
    protected JPanel multiPanel;
    protected JList displayListOfPossibleReferenceImagesForImages;
    protected JList displayListOfPossibleBackgroundImagesForSpectra;
    protected JList displayListOfPossibleReferenceImagesForSpectra;
    protected JScrollPane databaseTreeScrollPane;
    protected JScrollPane dicomdirTreeScrollPane;
    protected JScrollPane scrollPaneOfCurrentAttributes;
    protected JScrollPane attributeFrameTableScrollPane;
    protected JScrollPane attributeTreeScrollPane;
    protected JScrollPane queryTreeScrollPane;
    protected JScrollPane structuredReportTreeScrollPane;
    private DatabaseInformationModel databaseInformationModel;
    private static final int widthWantedForBrowser = 400;
    private static final int heightWantedForAttributeTable = 76;
    private static final double browserAndMultiPaneAndCurrentAttributesResizeWeight = 0.9;
    private static final Dimension defaultMultiPanelDimension = new Dimension(512, 512);
    private int applicationWidth;
    private int applicationHeight;
    private int imagesPerRow;
    private int imagesPerCol;
    private ImageLocalizerManager imageLocalizerManager;
    private SpectroscopyLocalizerManager spectroscopyLocalizerManager;
    private AttributeListFunctionalGroupsTableModelOneFrame modelOfCurrentAttributesForCurrentFrameBrowser;
    private AttributeListTableBrowser tableOfCurrentAttributesForCurrentFrameBrowser;
    private AttributeListFunctionalGroupsTableModelAllFrames modelOfCurrentAttributesForAllFramesBrowser;
    private AttributeListTableBrowser tableOfCurrentAttributesForAllFramesBrowser;
    private DicomDirectory currentDicomDirectory;
    private OurFrameSelectionChangeListener mainPanelFrameSelectionChangeListener;
    private OurFrameSortOrderChangeListener mainPanelFrameSortOrderChangeListener;
    private int currentSourceIndex;
    private int[] currentSourceSortOrder;
    private JTabbedPane browserPane;
    private JPanel displayControlsPanel;
    private JPanel dicomdirControlsPanel;
    private JPanel databaseControlsPanel;
    private JPanel queryControlsPanel;
    private JPanel spectroscopyControlsPanel;
    private JPanel structuredReportTreeControlsPanel;
    private SourceImageVOILUTSelectorPanel sourceImageVOILUTSelectorPanel;
    private SourceImageGraphicDisplaySelectorPanel sourceImageGraphicDisplaySelectorPanel;
    private OurBrowserPaneChangeListener ourBrowserPaneChangeListener;
    private QueryInformationModel currentRemoteQueryInformationModel;
    private AttributeList currentRemoteQueryFilter;
    private QueryTreeRecord currentRemoteQuerySelectionQueryTreeRecord;
    private AttributeList currentRemoteQuerySelectionUniqueKeys;
    private Attribute currentRemoteQuerySelectionUniqueKey;
    private String currentRemoteQuerySelectionRetrieveAE;
    private String currentRemoteQuerySelectionLevel;
    private Vector currentFilePathSelections;
    private DatabaseTreeRecord currentDatabaseTreeRecordSelection;
    private String currentlyDisplayedInstanceFilePath;
    private AttributeList currentAttributeListForDatabaseImport;
    private TreeMap backgroundImageListMappedToFilenames = null;
    private TreeMap referenceImageListMappedToFilenames = null;
    private JPanel referenceImagePanelForImages = null;
    private JPanel referenceImagePanelForSpectra = null;
    private ButtonGroup attributeTreeSortOrderButtons = new ButtonGroup();

    public void quit() {
        this.dispose();
        System.exit(0);
    }

    protected void createGUI() {
        this.setBackground(Color.lightGray);
        this.setInternationalizedFontsForGUI();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DicomImageViewer.this.quit();
            }
        });
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == 'K') {
            Rectangle rectangle = this.getBounds();
            File file = this.takeSnapShot(rectangle);
            System.err.println("Snapshot to file " + file);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void createTableOfCurrentAttributesForCurrentFrameBrowser() {
        HashSet<AttributeTag> hashSet = new HashSet<AttributeTag>();
        hashSet.add(TagFromName.FileMetaInformationGroupLength);
        hashSet.add(TagFromName.ImplementationVersionName);
        hashSet.add(TagFromName.SourceApplicationEntityTitle);
        this.modelOfCurrentAttributesForCurrentFrameBrowser = new AttributeListFunctionalGroupsTableModelOneFrame(null, null, hashSet);
        this.tableOfCurrentAttributesForCurrentFrameBrowser = new AttributeListTableBrowser(this.modelOfCurrentAttributesForCurrentFrameBrowser);
        this.tableOfCurrentAttributesForCurrentFrameBrowser.setAutoResizeMode(0);
    }

    private AttributeListTableBrowser getTableOfCurrentAttributesForCurrentFrameBrowser() {
        return this.tableOfCurrentAttributesForCurrentFrameBrowser;
    }

    private AttributeListFunctionalGroupsTableModelOneFrame getModelOfCurrentAttributesForCurrentFrameBrowser() {
        return this.modelOfCurrentAttributesForCurrentFrameBrowser;
    }

    private void createTableOfCurrentAttributesForAllFramesBrowser() {
        HashSet hashSet = null;
        this.modelOfCurrentAttributesForAllFramesBrowser = new AttributeListFunctionalGroupsTableModelAllFrames(null, null, hashSet);
        this.tableOfCurrentAttributesForAllFramesBrowser = new AttributeListTableBrowser(this.modelOfCurrentAttributesForAllFramesBrowser);
        this.tableOfCurrentAttributesForAllFramesBrowser.setAutoResizeMode(0);
    }

    private AttributeListTableBrowser getTableOfCurrentAttributesForAllFramesBrowser() {
        return this.tableOfCurrentAttributesForAllFramesBrowser;
    }

    private AttributeListFunctionalGroupsTableModelAllFrames getModelOfCurrentAttributesForAllFramesBrowser() {
        return this.modelOfCurrentAttributesForAllFramesBrowser;
    }

    private GeometryOfVolume getNewGeometryOfVolume(AttributeList attributeList) {
        GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = null;
        try {
            geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
        }
        catch (Throwable throwable) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(throwable.toString()));
            throwable.printStackTrace(System.err);
        }
        return geometryOfVolumeFromAttributeList;
    }

    private SpectroscopyVolumeLocalization getNewSpectroscopyVolumeLocalization(AttributeList attributeList) {
        SpectroscopyVolumeLocalization spectroscopyVolumeLocalization = null;
        try {
            spectroscopyVolumeLocalization = new SpectroscopyVolumeLocalization(attributeList);
        }
        catch (DicomException dicomException) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(dicomException.toString()));
            dicomException.printStackTrace(System.err);
        }
        return spectroscopyVolumeLocalization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBackgroundImageForSpectra(String string) {
        AttributeList attributeList = new AttributeList();
        SourceImage sourceImage = null;
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading background image ..."));
            File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
            DicomInputStream dicomInputStream = new DicomInputStream(file);
            attributeList.read(dicomInputStream);
            dicomInputStream.close();
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            if (SOPClass.isImageStorage(string2)) {
                sourceImage = new SourceImage(attributeList);
            }
        }
        catch (Exception exception) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(exception.toString()));
            exception.printStackTrace(System.err);
        }
        finally {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
        }
        if (sourceImage != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceImageSelectionChangeEvent(WellKnownContext.SPECTROSCOPYBACKGROUNDIMAGE, sourceImage, null, 0, attributeList, this.getNewGeometryOfVolume(attributeList)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReferenceImagePanel(String string, JPanel jPanel, boolean bl) {
        Object object;
        Object object2;
        AttributeList attributeList = new AttributeList();
        SourceImage sourceImage = null;
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading referenced image ..."));
            object2 = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
            object = new DicomInputStream((File)object2);
            attributeList.read((DicomInputStream)object);
            ((FilterInputStream)object).close();
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            if (SOPClass.isImageStorage(string2)) {
                sourceImage = new SourceImage(attributeList);
            }
        }
        catch (Exception exception) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(exception.toString()));
            exception.printStackTrace(System.err);
        }
        finally {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
        }
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            object2 = this.getNewGeometryOfVolume(attributeList);
            object = new SingleImagePanel(sourceImage, WellKnownContext.REFERENCEPANEL, (GeometryOfVolume)object2);
            ((SingleImagePanel)object).setOrientationAnnotations(new OrientationAnnotations(attributeList, (GeometryOfVolume)object2), "SansSerif", 0, 8, Color.pink);
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
            jPanel.removeAll();
            jPanel.add((Component)object);
            if (bl) {
                this.spectroscopyLocalizerManager.setReferenceImagePanel((SingleImagePanel)object);
            } else {
                this.imageLocalizerManager.setReferenceImagePanel((SingleImagePanel)object);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceImageSelectionChangeEvent(WellKnownContext.REFERENCEPANEL, sourceImage, null, 0, attributeList, (GeometryOfVolume)object2));
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(WellKnownContext.MAINPANEL, this.currentSourceIndex));
        }
    }

    private void loadMultiPanelWithImage(JPanel jPanel, SourceImage sourceImage, AttributeList attributeList) {
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            GeometryOfVolume geometryOfVolume = this.getNewGeometryOfVolume(attributeList);
            PixelSpacing pixelSpacing = new PixelSpacing(attributeList, geometryOfVolume);
            SingleImagePanelWithLineDrawing singleImagePanelWithLineDrawing = new SingleImagePanelWithLineDrawing(sourceImage, WellKnownContext.MAINPANEL, geometryOfVolume);
            singleImagePanelWithLineDrawing.setPixelSpacingInSourceImage(pixelSpacing.getSpacing(), pixelSpacing.getDescription());
            singleImagePanelWithLineDrawing.setDemographicAndTechniqueAnnotations(new DemographicAndTechniqueAnnotations(attributeList, geometryOfVolume), "SansSerif", 0, 10, Color.pink);
            singleImagePanelWithLineDrawing.setOrientationAnnotations(new OrientationAnnotations(attributeList, geometryOfVolume), "SansSerif", 0, 20, Color.pink);
            this.sourceImageVOILUTSelectorPanel.sendEventCorrespondingToCurrentButtonState();
            this.sourceImageGraphicDisplaySelectorPanel.sendEventCorrespondingToCurrentButtonState();
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
            SpectraPanel.deconstructAllSpectraPanelsInContainer(jPanel);
            jPanel.removeAll();
            jPanel.add(singleImagePanelWithLineDrawing);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceImageSelectionChangeEvent(WellKnownContext.MAINPANEL, sourceImage, null, 0, attributeList, geometryOfVolume));
        }
    }

    private Dimension loadMultiPanelWithSpectra(JPanel jPanel, SourceSpectra sourceSpectra, AttributeList attributeList) {
        Dimension dimension = null;
        if (sourceSpectra != null) {
            float[][] fArray = sourceSpectra.getSpectra();
            GeometryOfVolume geometryOfVolume = this.getNewGeometryOfVolume(attributeList);
            SpectroscopyVolumeLocalization spectroscopyVolumeLocalization = this.getNewSpectroscopyVolumeLocalization(attributeList);
            SpectraPanel spectraPanel = new SpectraPanel(fArray, sourceSpectra.getRows(), sourceSpectra.getColumns(), sourceSpectra.getMinimum(), sourceSpectra.getMaximum(), geometryOfVolume, spectroscopyVolumeLocalization, WellKnownContext.MAINPANEL, WellKnownContext.SPECTROSCOPYBACKGROUNDIMAGE);
            SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
            SpectraPanel.deconstructAllSpectraPanelsInContainer(jPanel);
            jPanel.removeAll();
            jPanel.add(spectraPanel);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new SourceSpectrumSelectionChangeEvent(WellKnownContext.MAINPANEL, fArray, fArray.length, null, 0, attributeList, geometryOfVolume, spectroscopyVolumeLocalization));
        }
        return dimension;
    }

    private void setCurrentRemoteQueryInformationModel(String string, JTabbedPane jTabbedPane, int n) {
        this.currentRemoteQueryInformationModel = null;
        String string2 = "";
        if (string != null && string.length() > 0 && this.networkApplicationProperties != null && this.networkApplicationInformation != null) {
            try {
                String string3 = this.networkApplicationProperties.getCallingAETitle();
                String string4 = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string4);
                if (presentationAddress == null) {
                    throw new Exception("For remote query AE <" + string + ">, presentationAddress cannot be determined");
                }
                String string5 = presentationAddress.getHostname();
                int n2 = presentationAddress.getPort();
                String string6 = this.networkApplicationInformation.getApplicationEntityMap().getQueryModel(string4);
                int n3 = this.networkApplicationProperties.getQueryDebugLevel();
                if (!NetworkApplicationProperties.isStudyRootQueryModel(string6) && string6 != null) {
                    throw new Exception("For remote query AE <" + string + ">, query model " + string6 + " not supported");
                }
                this.currentRemoteQueryInformationModel = new StudyRootQueryInformationModel(string5, n2, string4, string3, n3);
                string2 = ":" + string;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if (jTabbedPane != null) {
            jTabbedPane.setTitleAt(n, "Remote" + string2);
        }
    }

    private QueryInformationModel getCurrentRemoteQueryInformationModel() {
        return this.currentRemoteQueryInformationModel;
    }

    private void setCurrentRemoteQueryFilter(AttributeList attributeList) {
        this.currentRemoteQueryFilter = attributeList;
    }

    private AttributeList getCurrentRemoteQueryFilter() {
        return this.currentRemoteQueryFilter;
    }

    private void initializeCurrentRemoteQueryFilter() {
        AttributeList attributeList = new AttributeList();
        this.setCurrentRemoteQueryFilter(attributeList);
        AttributeTag attributeTag = TagFromName.PatientName;
        Attribute attribute = new PersonNameAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientID;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientBirthDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientSex;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientBirthTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientComments;
        attribute = new LongTextAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyID;
        attribute = new ShortStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyDescription;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.OtherStudyNumbers;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformedProcedureStepID;
        attribute = new ShortStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformedProcedureStepStartDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformedProcedureStepStartTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SOPClassesInStudy;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ModalitiesInStudy;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ReferringPhysicianName;
        attribute = new PersonNameAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AccessionNumber;
        attribute = new ShortStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PhysiciansOfRecord;
        attribute = new PersonNameAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NameOfPhysiciansReadingStudy;
        attribute = new PersonNameAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AdmittingDiagnosesDescription;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientAge;
        attribute = new AgeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientSize;
        attribute = new DecimalStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PatientWeight;
        attribute = new DecimalStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Occupation;
        attribute = new ShortStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AdditionalPatientHistory;
        attribute = new LongTextAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesDescription;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesNumber;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Modality;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.PerformingPhysicianName;
        attribute = new PersonNameAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ProtocolName;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.OperatorsName;
        attribute = new PersonNameAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Laterality;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.BodyPartExamined;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Manufacturer;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ManufacturerModelName;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StationName;
        attribute = new ShortStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.InstitutionName;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.InstitutionalDepartmentName;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.InstanceNumber;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ImageComments;
        attribute = new LongTextAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ContentDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ContentTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ImageType;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionNumber;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionDate;
        attribute = new DateAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionTime;
        attribute = new TimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.AcquisitionDateTime;
        attribute = new DateTimeAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.DerivationDescription;
        attribute = new ShortTextAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.QualityControlImage;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.BurnedInAnnotation;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.LossyImageCompression;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.LossyImageCompressionRatio;
        attribute = new DecimalStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.LossyImageCompressionMethod;
        attribute = new CodeStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.ContrastBolusAgent;
        attribute = new LongStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfFrames;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Rows;
        attribute = new UnsignedShortAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.Columns;
        attribute = new UnsignedShortAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.StudyInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SeriesInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SOPInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.SOPClassUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfStudyRelatedInstances;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfStudyRelatedSeries;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.NumberOfSeriesRelatedInstances;
        attribute = new IntegerStringAttribute(attributeTag);
        attributeList.put(attributeTag, attribute);
    }

    private void setCurrentRemoteQuerySelection(AttributeList attributeList, Attribute attribute, AttributeList attributeList2) {
        Object object;
        this.currentRemoteQuerySelectionUniqueKeys = attributeList;
        this.currentRemoteQuerySelectionUniqueKey = attribute;
        this.currentRemoteQuerySelectionRetrieveAE = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.RetrieveAETitle)) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionRetrieveAE == null && (object = this.getCurrentRemoteQueryInformationModel()) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((QueryInformationModel)object).getCalledAETitle();
        }
        this.currentRemoteQuerySelectionLevel = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.QueryRetrieveLevel)) != null) {
            this.currentRemoteQuerySelectionLevel = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionLevel == null) {
            if (attribute != null && (object = attribute.getTag()) != null) {
                if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                    this.currentRemoteQuerySelectionLevel = "PATIENT";
                } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "STUDY";
                } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "SERIES";
                } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "IMAGE";
                }
            }
            System.err.println("DicomImageViewer.setCurrentRemoteQuerySelection(): Guessed missing currentRemoteQuerySelectionLevel to be " + this.currentRemoteQuerySelectionLevel);
        }
    }

    private QueryTreeRecord getCurrentRemoteQuerySelectionQueryTreeRecord() {
        return this.currentRemoteQuerySelectionQueryTreeRecord;
    }

    private void setCurrentRemoteQuerySelectionQueryTreeRecord(QueryTreeRecord queryTreeRecord) {
        this.currentRemoteQuerySelectionQueryTreeRecord = queryTreeRecord;
    }

    private AttributeList getCurrentRemoteQuerySelectionUniqueKeys() {
        return this.currentRemoteQuerySelectionUniqueKeys;
    }

    private Attribute getCurrentRemoteQuerySelectionUniqueKey() {
        return this.currentRemoteQuerySelectionUniqueKey;
    }

    private String getCurrentRemoteQuerySelectionRetrieveAE() {
        return this.currentRemoteQuerySelectionRetrieveAE;
    }

    private String getCurrentRemoteQuerySelectionLevel() {
        return this.currentRemoteQuerySelectionLevel;
    }

    private void setCurrentFilePathSelection(Vector vector) {
        this.currentFilePathSelections = vector;
    }

    private String getCurrentFilePathSelection() {
        return this.currentFilePathSelections != null && this.currentFilePathSelections.size() > 0 ? (String)this.currentFilePathSelections.get(0) : null;
    }

    private Vector getCurrentFilePathSelections() {
        return this.currentFilePathSelections;
    }

    private void setCurrentDatabaseTreeRecordSelection(DatabaseTreeRecord databaseTreeRecord) {
        this.currentDatabaseTreeRecordSelection = databaseTreeRecord;
    }

    private DatabaseTreeRecord getCurrentDatabaseTreeRecordSelection() {
        return this.currentDatabaseTreeRecordSelection;
    }

    private void setCurrentlyDisplayedInstanceFilePath(String string) {
        this.currentlyDisplayedInstanceFilePath = string;
    }

    private String getCurrentlyDisplayedInstanceFilePath() {
        return this.currentlyDisplayedInstanceFilePath;
    }

    private void setAttributeListForDatabaseImport(AttributeList attributeList) {
        this.currentAttributeListForDatabaseImport = attributeList;
    }

    private AttributeList getAttributeListForDatabaseImport() {
        return this.currentAttributeListForDatabaseImport;
    }

    private void loadDicomFileOrDirectory(String string) {
        this.loadDicomFileOrDirectory(string, this.multiPanel, this.referenceImagePanelForImages, this.referenceImagePanelForSpectra);
    }

    private void loadDicomFileOrDirectory(String string, JPanel jPanel, JPanel jPanel2, JPanel jPanel3) {
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel);
        SpectraPanel.deconstructAllSpectraPanelsInContainer(jPanel);
        jPanel.removeAll();
        jPanel.repaint();
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel2);
        jPanel2.removeAll();
        jPanel2.repaint();
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(jPanel3);
        jPanel3.removeAll();
        jPanel3.repaint();
        this.imageLocalizerManager.reset();
        this.spectroscopyLocalizerManager.reset();
        this.scrollPaneOfCurrentAttributes.setViewportView(null);
        this.scrollPaneOfCurrentAttributes.repaint();
        this.attributeTreeScrollPane.setViewportView(null);
        this.attributeTreeScrollPane.repaint();
        this.attributeFrameTableScrollPane.setViewportView(null);
        this.attributeFrameTableScrollPane.repaint();
        this.structuredReportTreeScrollPane.setViewportView(null);
        this.structuredReportTreeScrollPane.repaint();
        this.setAttributeListForDatabaseImport(null);
        this.setCurrentlyDisplayedInstanceFilePath(null);
        if (string != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String string2;
                System.err.println("Open: " + string);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Reading and parsing DICOM file ..."));
                File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
                string = file.getAbsolutePath();
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                new AttributeTreeBrowser(attributeList, this.attributeTreeScrollPane);
                Attribute attribute = attributeList.get(TagFromName.MediaStorageSOPClassUID);
                String string3 = string2 = attribute != null && attribute.getVM() == 1 ? attribute.getStringValues()[0] : null;
                if (string2 == null) {
                    attribute = attributeList.get(TagFromName.SOPClassUID);
                    String string4 = string2 = attribute != null && attribute.getVM() == 1 ? attribute.getStringValues()[0] : null;
                }
                if (SOPClass.isDirectory(string2)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building tree from DICOMDIR ..."));
                    OurDicomDirectoryBrowser ourDicomDirectoryBrowser = new OurDicomDirectoryBrowser(attributeList);
                    this.currentDicomDirectory = ourDicomDirectoryBrowser.getDicomDirectory();
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 2));
                } else if (SOPClass.isImageStorage(string2)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building images ..."));
                    SourceImage sourceImage = new SourceImage(attributeList);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading images and attributes ..."));
                    this.currentSourceIndex = 0;
                    this.currentSourceSortOrder = null;
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().initializeModelFromAttributeList(attributeList);
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(this.currentSourceIndex);
                    this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
                    this.scrollPaneOfCurrentAttributes.setViewportView(this.getTableOfCurrentAttributesForCurrentFrameBrowser());
                    this.getModelOfCurrentAttributesForAllFramesBrowser().initializeModelFromAttributeList(attributeList);
                    this.getTableOfCurrentAttributesForAllFramesBrowser().setColumnWidths();
                    this.attributeFrameTableScrollPane.setViewportView(this.getTableOfCurrentAttributesForAllFramesBrowser());
                    this.loadMultiPanelWithImage(jPanel, sourceImage, attributeList);
                    this.referenceImageListMappedToFilenames = this.getImageListMappedToFilenamesForReferenceOrBackground(attributeList, false);
                    this.displayListOfPossibleReferenceImagesForImages.setListData(this.referenceImageListMappedToFilenames.keySet().toArray());
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 1));
                    this.setAttributeListForDatabaseImport(attributeList);
                    this.setCurrentlyDisplayedInstanceFilePath(string);
                    Vector<String> vector = new Vector<String>();
                    vector.add(string);
                    this.setCurrentFilePathSelection(vector);
                } else if (SOPClass.isSpectroscopy(string2)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building spectra ..."));
                    SourceSpectra sourceSpectra = new SourceSpectra(attributeList);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading spectra and attributes ..."));
                    this.currentSourceIndex = 0;
                    this.currentSourceSortOrder = null;
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().initializeModelFromAttributeList(attributeList);
                    this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(this.currentSourceIndex);
                    this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
                    this.scrollPaneOfCurrentAttributes.setViewportView(this.getTableOfCurrentAttributesForCurrentFrameBrowser());
                    this.getModelOfCurrentAttributesForAllFramesBrowser().initializeModelFromAttributeList(attributeList);
                    this.getTableOfCurrentAttributesForAllFramesBrowser().setColumnWidths();
                    this.attributeFrameTableScrollPane.setViewportView(this.getTableOfCurrentAttributesForAllFramesBrowser());
                    this.loadMultiPanelWithSpectra(jPanel, sourceSpectra, attributeList);
                    this.referenceImageListMappedToFilenames = this.getImageListMappedToFilenamesForReferenceOrBackground(attributeList, false);
                    this.displayListOfPossibleReferenceImagesForSpectra.setListData(this.referenceImageListMappedToFilenames.keySet().toArray());
                    this.backgroundImageListMappedToFilenames = this.getImageListMappedToFilenamesForReferenceOrBackground(attributeList, true);
                    this.displayListOfPossibleBackgroundImagesForSpectra.setListData(this.backgroundImageListMappedToFilenames.keySet().toArray());
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 4));
                    this.setAttributeListForDatabaseImport(attributeList);
                    this.setCurrentlyDisplayedInstanceFilePath(string);
                    Vector<String> vector = new Vector<String>();
                    vector.add(string);
                    this.setCurrentFilePathSelection(vector);
                } else if (SOPClass.isStructuredReport(string2) || attributeList.isSRDocument()) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Building SR ..."));
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Loading SR and attributes ..."));
                    new StructuredReportTreeBrowser(attributeList, this.structuredReportTreeScrollPane);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new BrowserPaneChangeEvent(WellKnownContext.MAINPANEL, 5));
                    this.setAttributeListForDatabaseImport(attributeList);
                    this.setCurrentlyDisplayedInstanceFilePath(string);
                    Vector<String> vector = new Vector<String>();
                    vector.add(string);
                    this.setCurrentFilePathSelection(vector);
                } else {
                    if (SOPClass.isNonImageStorage(string2)) {
                        throw new DicomException("unsupported storage SOP Class " + string2);
                    }
                    throw new DicomException("unsupported SOP Class " + string2);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(exception.toString()));
                exception.printStackTrace(System.err);
            }
            this.setCursor(cursor);
        }
    }

    private void callFileChooserThenLoadDicomFileOrDirectory(JPanel jPanel, JPanel jPanel2, JPanel jPanel3) {
        String string = null;
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectoryPath);
        if (jFileChooser.showOpenDialog(null) == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.lastDirectoryPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
        }
        this.loadDicomFileOrDirectory(string, jPanel, jPanel2, jPanel3);
    }

    private void sendDicomFileOverDicomNetwork(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7) {
        if (string != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Sending image " + string + " to " + string2 + " ..."));
                int n2 = this.networkApplicationProperties.getStorageSCUDebugLevel();
                int n3 = this.networkApplicationProperties.getStorageSCUCompressionLevel();
                new StorageSOPClassSCU(string3, n, string4, string5, string, string6, string7, n3, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            this.setCursor(cursor);
        }
    }

    private final TreeMap getImageListMappedToFilenamesForReferenceOrBackground(AttributeList attributeList, boolean bl) {
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.FrameOfReferenceUID);
        double[] dArray = GeometryOfVolumeFromAttributeList.getImageOrientationPatientFromAttributeList(attributeList);
        if (string != null) {
            String string2;
            Object object;
            String string3;
            Object object2;
            AttributeList attributeList2;
            int n;
            AbstractList abstractList;
            if (this.databaseInformationModel != null) {
                try {
                    abstractList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithMatchingParent(InformationEntity.INSTANCE, InformationEntity.SERIES, "FrameOfReferenceUID", string);
                    if (abstractList != null && ((ArrayList)abstractList).size() > 0) {
                        for (n = 0; n < ((ArrayList)abstractList).size(); ++n) {
                            attributeList2 = null;
                            object2 = (Map)((ArrayList)abstractList).get(n);
                            if (object2 == null) continue;
                            string3 = DescriptionFactory.makeImageDescription((Map)object2);
                            object = (String)object2.get("SOPINSTANCEUID");
                            string2 = (String)object2.get("SOPCLASSUID");
                            double[] dArray2 = null;
                            String string4 = (String)object2.get("IMAGEORIENTATIONPATIENT");
                            if (string4 != null) {
                                dArray2 = FloatFormatter.fromString(string4, 6, '\\');
                            }
                            if (bl && (dArray == null || dArray.length != 6 || dArray2 == null || dArray2.length != 6 || !ArrayCopyUtilities.arraysAreEqual(dArray, dArray2)) || (string4 = (String)object2.get(this.databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE).toUpperCase())) == null || string2 == null || !SOPClass.isImageStorage(string2) || treeMap.containsKey(string3)) continue;
                            treeMap.put(string3, string4);
                        }
                    }
                }
                catch (DicomException dicomException) {
                    dicomException.printStackTrace(System.err);
                }
            }
            if (this.currentDicomDirectory != null && (abstractList = this.currentDicomDirectory.findAllImagesForFrameOfReference(string)) != null) {
                for (n = 0; n < ((Vector)abstractList).size(); ++n) {
                    attributeList2 = (AttributeList)((Vector)abstractList).get(n);
                    if (attributeList2 == null) continue;
                    object2 = DescriptionFactory.makeImageDescription(attributeList2);
                    string3 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferencedSOPInstanceUIDInFile);
                    object = Attribute.getDoubleValues(attributeList2, TagFromName.ImageOrientationPatient);
                    if (string3 == null) continue;
                    string2 = null;
                    try {
                        string2 = this.currentDicomDirectory.getReferencedFileNameForSOPInstanceUID(string3);
                    }
                    catch (DicomException dicomException) {
                        // empty catch block
                    }
                    if (bl && (dArray == null || dArray.length != 6 || object == null || ((double[])object).length != 6 || !ArrayCopyUtilities.arraysAreEqual(dArray, object)) || string2 == null || treeMap.containsKey(object2)) continue;
                    treeMap.put(object2, string2);
                }
            }
        }
        return treeMap;
    }

    private String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.networkApplicationProperties != null && (set = this.networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(null, string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    private void performRetrieve(AttributeList attributeList, String string, String string2) {
        try {
            AttributeList attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
                Object object = TagFromName.QueryRetrieveLevel;
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute((AttributeTag)object);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList2.put((AttributeTag)object, codeStringAttribute);
                object = this.getCurrentRemoteQueryInformationModel();
                ((QueryInformationModel)object).performHierarchicalMoveFrom(attributeList2, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord databaseTreeRecord) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || !informationEntity.equals(InformationEntity.INSTANCE)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.purgeFilesAndDatabaseInformation(databaseTreeRecord2);
                    }
                }
                if (informationEntity != null) {
                    databaseTreeRecord.removeFromParent();
                }
            } else {
                String string = databaseTreeRecord.getLocalFileNameValue();
                String string2 = databaseTreeRecord.getLocalFileReferenceTypeValue();
                if (string2 != null && string2.equals("C")) {
                    try {
                        if (!new File(string).delete()) {
                            System.err.println("Failed to delete local copy of file " + string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
                databaseTreeRecord.removeFromParent();
            }
        }
    }

    private void copyFileAndImportToDatabase(AttributeList attributeList, String string) throws DicomException, IOException {
        String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
        if (string2 == null) {
            throw new DicomException("Cannot get SOP Instance UID to make file name for local copy when inserting into database");
        }
        String string3 = this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(this.savedImagesFolder, string2).getPath();
        if (string.equals(string3)) {
            System.err.println("DicomImageViewer.copyFileAndImportToDatabase(): input and output filenames identical - presumably copying from our own database back into our own database, so doing nothing");
        } else {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Copying object ..."));
            CopyStream.copy(new BufferedInputStream(new FileInputStream(string)), new BufferedOutputStream(new FileOutputStream(string3)));
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Inserting into database ..."));
            this.databaseInformationModel.insertObject(attributeList, string3, "C");
        }
    }

    public void osxFileHandler(String string) {
        this.lastDirectoryPath = new File(string).getParent();
        this.loadDicomFileOrDirectory(string);
    }

    public void registerForMacOSXEvents() {
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", null));
                OSXAdapter.setFileHandler(this, this.getClass().getDeclaredMethod("osxFileHandler", String.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
    }

    private void doCommonConstructorStuff(String string, String string2) {
        int n;
        Object object;
        this.registerForMacOSXEvents();
        this.mainPanelFrameSortOrderChangeListener = new OurFrameSortOrderChangeListener(WellKnownContext.MAINPANEL);
        this.mainPanelFrameSelectionChangeListener = new OurFrameSelectionChangeListener(WellKnownContext.MAINPANEL);
        this.ourBrowserPaneChangeListener = new OurBrowserPaneChangeListener(WellKnownContext.MAINPANEL);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.spectroscopyLocalizerManager = new SpectroscopyLocalizerManager();
        this.spectroscopyLocalizerManager.setReferenceSourceImageSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.spectroscopyLocalizerManager.setReferenceImageFrameSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.spectroscopyLocalizerManager.setReferenceImageFrameSortOrderContext(WellKnownContext.REFERENCEPANEL);
        this.spectroscopyLocalizerManager.setSourceSpectrumSelectionContext(WellKnownContext.MAINPANEL);
        this.spectroscopyLocalizerManager.setSpectrumFrameSelectionContext(WellKnownContext.MAINPANEL);
        this.spectroscopyLocalizerManager.setSpectrumFrameSortOrderContext(WellKnownContext.MAINPANEL);
        this.imageLocalizerManager = new ImageLocalizerManager();
        this.imageLocalizerManager.setReferenceSourceImageSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.imageLocalizerManager.setReferenceImageFrameSelectionContext(WellKnownContext.REFERENCEPANEL);
        this.imageLocalizerManager.setReferenceImageFrameSortOrderContext(WellKnownContext.REFERENCEPANEL);
        this.imageLocalizerManager.setMainSourceImageSelectionContext(WellKnownContext.MAINPANEL);
        this.imageLocalizerManager.setMainImageFrameSelectionContext(WellKnownContext.MAINPANEL);
        this.imageLocalizerManager.setMainImageFrameSortOrderContext(WellKnownContext.MAINPANEL);
        Properties properties = this.getProperties();
        this.databaseApplicationProperties = new DatabaseApplicationProperties(properties);
        this.savedImagesFolder = null;
        if (this.databaseApplicationProperties != null) {
            try {
                this.savedImagesFolder = this.databaseApplicationProperties.getSavedImagesFolderCreatingItIfNecessary();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            this.databaseInformationModel = null;
            try {
                this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(DicomImageViewer.makePathToFileInUsersHomeDirectory(this.databaseApplicationProperties.getDatabaseFileName()), this.databaseApplicationProperties.getDatabaseServerName());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        try {
            this.networkApplicationProperties = new NetworkApplicationProperties(properties);
        }
        catch (Exception exception) {
            this.networkApplicationProperties = null;
        }
        NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
        networkApplicationInformationFederated.startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.networkApplicationInformation = networkApplicationInformationFederated;
        if (this.networkApplicationProperties != null) {
            try {
                int n2 = this.networkApplicationProperties.getListeningPort();
                object = this.networkApplicationProperties.getCalledAETitle();
                int n22 = this.networkApplicationProperties.getStorageSCPDebugLevel();
                int n3 = this.networkApplicationProperties.getQueryDebugLevel();
                new Thread(new StorageSOPClassSCPDispatcher(n2, (String)object, this.savedImagesFolder, this.storedFilePathStrategy, new OurReceivedObjectHandler(), this.databaseInformationModel == null ? null : this.databaseInformationModel.getQueryResponseGeneratorFactory(n3), this.databaseInformationModel == null ? null : this.databaseInformationModel.getRetrieveResponseGeneratorFactory(n3), this.networkApplicationInformation, false, n22)).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        this.setCurrentFilePathSelection(null);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (DicomImageViewer.this.databaseInformationModel != null) {
                    DicomImageViewer.this.databaseInformationModel.close();
                }
                if (DicomImageViewer.this.networkApplicationInformation != null && DicomImageViewer.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DicomImageViewer.this.networkApplicationInformation).removeAllSources();
                }
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.applicationWidth = (int)dimension.getWidth() - 20;
        this.applicationHeight = (int)dimension.getHeight() - 70;
        this.imagesPerRow = 1;
        this.imagesPerCol = 1;
        object = this.getContentPane();
        EmptyBorder emptyBorder = (EmptyBorder)BorderFactory.createEmptyBorder();
        this.multiPanel = new JPanel();
        this.multiPanel.setLayout(new GridLayout(this.imagesPerCol, this.imagesPerRow));
        this.multiPanel.setBackground(Color.black);
        this.multiPanel.setOpaque(true);
        this.referenceImagePanelForImages = new JPanel();
        this.referenceImagePanelForImages.setLayout(new GridLayout(1, 1));
        this.referenceImagePanelForImages.setBackground(Color.black);
        this.referenceImagePanelForImages.setPreferredSize(new Dimension(128, 128));
        this.referenceImagePanelForSpectra = new JPanel();
        this.referenceImagePanelForSpectra.setLayout(new GridLayout(1, 1));
        this.referenceImagePanelForSpectra.setBackground(Color.black);
        this.referenceImagePanelForSpectra.setPreferredSize(new Dimension(128, 128));
        this.scrollPaneOfCurrentAttributes = new JScrollPane();
        this.createTableOfCurrentAttributesForCurrentFrameBrowser();
        this.scrollPaneOfCurrentAttributes.setViewportView(this.getTableOfCurrentAttributesForCurrentFrameBrowser());
        this.attributeFrameTableScrollPane = new JScrollPane();
        this.createTableOfCurrentAttributesForAllFramesBrowser();
        this.attributeFrameTableScrollPane.setViewportView(this.getTableOfCurrentAttributesForAllFramesBrowser());
        this.displayControlsPanel = new JPanel();
        this.displayControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.displayControlsPanel.add((Component)jPanel, "North");
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton("File...");
        jButton.setToolTipText("Choose a DICOM image or spectroscopy file to display or DICOMDIR file to browse");
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Import");
        jButton2.setToolTipText("Import a copy of displayed image into the local database");
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Send...");
        jButton3.setToolTipText("Send displayed image via DICOM network");
        jPanel.add(jButton3);
        JButton jButton4 = new JButton("XML...");
        jButton4.setToolTipText("Save displayed image attributes to XML file");
        jPanel.add(jButton4);
        JButton jButton5 = new JButton("Validate...");
        jButton5.setToolTipText("Validate displayed image against standard IOD");
        jPanel.add(jButton5);
        JPanel jPanel2 = new JPanel();
        this.displayControlsPanel.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new BorderLayout());
        JComponent jComponent = new SourceImageSortOrderPanel(WellKnownContext.MAINPANEL);
        jPanel2.add((Component)jComponent, "North");
        JComponent jComponent2 = new JPanel();
        jComponent2.setLayout(new GridLayout(2, 1));
        jPanel2.add((Component)jComponent2, "South");
        this.sourceImageVOILUTSelectorPanel = new SourceImageVOILUTSelectorPanel(null);
        jComponent2.add(this.sourceImageVOILUTSelectorPanel);
        this.sourceImageGraphicDisplaySelectorPanel = new SourceImageGraphicDisplaySelectorPanel(null);
        jComponent2.add(this.sourceImageGraphicDisplaySelectorPanel);
        jPanel2 = new JPanel(new BorderLayout());
        this.displayControlsPanel.add((Component)jPanel2, "South");
        jComponent = new JPanel(new FlowLayout(1));
        jPanel2.add((Component)jComponent, "Center");
        jComponent.add(this.referenceImagePanelForImages);
        this.displayListOfPossibleReferenceImagesForImages = new JList();
        this.displayListOfPossibleReferenceImagesForImages.setVisibleRowCount(4);
        jComponent2 = new JScrollPane(this.displayListOfPossibleReferenceImagesForImages);
        jPanel2.add((Component)jComponent2, "North");
        this.displayListOfPossibleReferenceImagesForImages.setSelectionMode(0);
        this.displayListOfPossibleReferenceImagesForImages.addListSelectionListener(new OurReferenceListSelectionListener(this.referenceImagePanelForImages, false));
        this.spectroscopyControlsPanel = new JPanel();
        this.spectroscopyControlsPanel.setLayout(new BorderLayout());
        jPanel2 = new JPanel();
        this.spectroscopyControlsPanel.add((Component)jPanel2, "North");
        jPanel2.setLayout(new FlowLayout(1));
        jComponent = new JButton("File...");
        jComponent.setToolTipText("Choose a DICOM image or spectroscopy file to display or DICOMDIR file to browse");
        jPanel2.add(jComponent);
        jComponent2 = new JButton("Import");
        jComponent2.setToolTipText("Import a copy of displayed specra into the local database");
        jPanel2.add(jComponent2);
        JButton jButton6 = new JButton("Send...");
        jButton6.setToolTipText("Send display spectra via DICOM network");
        jPanel2.add(jButton6);
        JButton jButton7 = new JButton("XML...");
        jButton7.setToolTipText("Save displayed spectra attributes to XML file");
        jPanel2.add(jButton7);
        JButton jButton8 = new JButton("Validate...");
        jButton8.setToolTipText("Validate displayed spectra against standard IOD");
        jPanel2.add(jButton8);
        SourceSpectrumSortOrderPanel sourceSpectrumSortOrderPanel = new SourceSpectrumSortOrderPanel(WellKnownContext.MAINPANEL);
        this.spectroscopyControlsPanel.add((Component)sourceSpectrumSortOrderPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.spectroscopyControlsPanel.add((Component)jPanel3, "South");
        JComponent jComponent3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jComponent3, "North");
        this.displayListOfPossibleBackgroundImagesForSpectra = new JList();
        this.displayListOfPossibleBackgroundImagesForSpectra.setVisibleRowCount(4);
        JComponent jComponent4 = new JScrollPane(this.displayListOfPossibleBackgroundImagesForSpectra);
        jComponent3.add((Component)jComponent4, "North");
        this.displayListOfPossibleBackgroundImagesForSpectra.setSelectionMode(0);
        this.displayListOfPossibleBackgroundImagesForSpectra.addListSelectionListener(new OurBackgroundListSelectionListener());
        jComponent3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jComponent3, "South");
        jComponent4 = new JPanel(new FlowLayout(1));
        jComponent3.add((Component)jComponent4, "Center");
        jComponent4.add(this.referenceImagePanelForSpectra);
        this.displayListOfPossibleReferenceImagesForSpectra = new JList();
        this.displayListOfPossibleReferenceImagesForSpectra.setVisibleRowCount(4);
        JComponent jComponent5 = new JScrollPane(this.displayListOfPossibleReferenceImagesForSpectra);
        jComponent3.add((Component)jComponent5, "North");
        this.displayListOfPossibleReferenceImagesForSpectra.setSelectionMode(0);
        this.displayListOfPossibleReferenceImagesForSpectra.addListSelectionListener(new OurReferenceListSelectionListener(this.referenceImagePanelForSpectra, true));
        this.dicomdirControlsPanel = new JPanel();
        this.dicomdirControlsPanel.setLayout(new BorderLayout());
        jPanel3 = new JPanel();
        this.dicomdirControlsPanel.add((Component)jPanel3, "North");
        jPanel3.setLayout(new FlowLayout(1));
        jComponent3 = new JButton("File...");
        jComponent3.setToolTipText("Choose a DICOM image file to display or DICOMDIR file to browse");
        jPanel3.add(jComponent3);
        jComponent4 = new JButton("Import");
        jComponent4.setToolTipText("Import all the images selected into the local database");
        jPanel3.add(jComponent4);
        jComponent5 = new JButton("View");
        jComponent5.setToolTipText("Display the image selected (or first image of the selection)");
        jPanel3.add(jComponent5);
        JButton jButton9 = new JButton("Send...");
        jButton9.setToolTipText("Send all the images selected via DICOM network");
        jPanel3.add(jButton9);
        this.dicomdirTreeScrollPane = new JScrollPane();
        this.dicomdirControlsPanel.add((Component)this.dicomdirTreeScrollPane, "Center");
        this.databaseControlsPanel = new JPanel();
        this.databaseControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this.databaseControlsPanel.add((Component)jPanel4, "North");
        JButton jButton10 = new JButton("Refresh");
        jButton10.setToolTipText("Query the database to update the browser");
        jPanel4.add(jButton10);
        JButton jButton11 = new JButton("File...");
        jButton11.setToolTipText("Import DICOM files from a DICOMDIR or recursive directory search");
        jPanel4.add(jButton11);
        JButton jButton12 = new JButton("View");
        jButton12.setToolTipText("Display the image selected");
        jPanel4.add(jButton12);
        JButton jButton13 = new JButton("Send...");
        jButton13.setToolTipText("Send all the images selected via DICOM network");
        jPanel4.add(jButton13);
        JButton jButton14 = new JButton("Purge");
        jButton14.setToolTipText("Remove selected entry from local database and delete local copies of files");
        jPanel4.add(jButton14);
        this.databaseTreeScrollPane = new JScrollPane();
        this.databaseControlsPanel.add((Component)this.databaseTreeScrollPane, "Center");
        this.queryControlsPanel = new JPanel();
        this.queryControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this.queryControlsPanel.add((Component)jPanel5, "North");
        JButton jButton15 = new JButton("Select");
        jButton15.setToolTipText("Select the remote system to use for subsequent queries");
        jPanel5.add(jButton15);
        JButton jButton16 = new JButton("Filter");
        jButton16.setToolTipText("Configure the filter to use for subsequent queries");
        jPanel5.add(jButton16);
        JButton jButton17 = new JButton("Query");
        jButton17.setToolTipText("Query the currently selected remote system to update the browser");
        jPanel5.add(jButton17);
        JButton jButton18 = new JButton("Retrieve");
        jButton18.setToolTipText("Retrieve the selection to the local database");
        jPanel5.add(jButton18);
        this.queryTreeScrollPane = new JScrollPane();
        this.queryControlsPanel.add((Component)this.queryTreeScrollPane, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        JPanel jPanel7 = new JPanel();
        jPanel6.add((Component)jPanel7, "North");
        jPanel7.setLayout(new FlowLayout(1));
        this.attributeTreeScrollPane = new JScrollPane();
        jPanel7.add(new JLabel("Sort attributes:"));
        this.attributeTreeSortOrderButtons = new ButtonGroup();
        SortAttributesActionListener sortAttributesActionListener = new SortAttributesActionListener();
        JRadioButton jRadioButton = new JRadioButton("by name", true);
        jRadioButton.setActionCommand("NAME");
        jRadioButton.setToolTipText("Sort attributes in tree alphabetically by name");
        jRadioButton.addActionListener(sortAttributesActionListener);
        this.attributeTreeSortOrderButtons.add(jRadioButton);
        jPanel7.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("by number", false);
        jRadioButton2.setActionCommand("NUMBER");
        jRadioButton2.setToolTipText("Sort attributes in tree numerically by group and element number");
        jRadioButton2.addActionListener(sortAttributesActionListener);
        this.attributeTreeSortOrderButtons.add(jRadioButton2);
        jPanel7.add(jRadioButton2);
        jPanel6.add((Component)this.attributeTreeScrollPane, "Center");
        this.structuredReportTreeControlsPanel = new JPanel();
        this.structuredReportTreeControlsPanel.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        this.structuredReportTreeControlsPanel.add((Component)jPanel8, "North");
        jPanel8.setLayout(new FlowLayout(1));
        JButton jButton19 = new JButton("File...");
        jButton19.setToolTipText("Choose a DICOM SR or image or spectroscopy file to display or DICOMDIR file to browse");
        jPanel8.add(jButton19);
        JButton jButton20 = new JButton("Import");
        jButton20.setToolTipText("Import a copy of displayed SR into the local database");
        jPanel8.add(jButton20);
        JButton jButton21 = new JButton("Send...");
        jButton21.setToolTipText("Send displayed SR via DICOM network");
        jPanel8.add(jButton21);
        JButton jButton22 = new JButton("XML...");
        jButton22.setToolTipText("Save displayed SR to XML file");
        jPanel8.add(jButton22);
        JButton jButton23 = new JButton("Validate...");
        jButton23.setToolTipText("Validate displayed SR against standard IOD and templates");
        jPanel8.add(jButton23);
        this.structuredReportTreeScrollPane = new JScrollPane();
        this.structuredReportTreeControlsPanel.add((Component)this.structuredReportTreeScrollPane, "Center");
        this.browserPane = new JTabbedPane();
        this.browserPane.setTabLayoutPolicy(0);
        this.browserPane.addTab("Local", this.databaseControlsPanel);
        this.browserPane.addTab("Remote", this.queryControlsPanel);
        this.browserPane.addTab("DICOMDIR", this.dicomdirControlsPanel);
        this.browserPane.addTab("Image", this.displayControlsPanel);
        this.browserPane.addTab("Report", this.structuredReportTreeControlsPanel);
        this.browserPane.addTab("Spectra", this.spectroscopyControlsPanel);
        this.browserPane.addTab("Attributes", jPanel6);
        this.browserPane.addTab("Frames", this.attributeFrameTableScrollPane);
        int n3 = this.browserPane.indexOfComponent(this.queryControlsPanel);
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.databaseControlsPanel), "Browse the contents of the local database");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.queryControlsPanel), "Browse the contents of the local database");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.dicomdirControlsPanel), "Browse the contents of the currently loaded DICOMDIR");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.displayControlsPanel), "Controls for the currently displayed image");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.spectroscopyControlsPanel), "Controls for the currently displayed spectra");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(jPanel6), "Tree of attributes and values for currently displayed image");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.attributeFrameTableScrollPane), "Table of all per-frame varying attributes for this object");
        this.browserPane.setToolTipTextAt(this.browserPane.indexOfComponent(this.structuredReportTreeControlsPanel), "Tree of current structured report content");
        this.browserPane.setEnabledAt(this.browserPane.indexOfComponent(this.displayControlsPanel), false);
        this.browserPane.setEnabledAt(this.browserPane.indexOfComponent(this.spectroscopyControlsPanel), false);
        this.browserPane.setEnabledAt(this.browserPane.indexOfComponent(this.structuredReportTreeControlsPanel), false);
        this.browserPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n == DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.databaseControlsPanel)) {
                    try {
                        new OurDatabaseTreeBrowser();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        });
        this.setCurrentRemoteQueryInformationModel(properties.getProperty(propertyName_DicomCurrentlySelectedQueryTargetAE), this.browserPane, n3);
        this.initializeCurrentRemoteQueryFilter();
        JLabel jLabel = this.getStatusBar();
        if (string2 == null) {
            this.lastDirectoryPath = null;
        } else {
            this.lastDirectoryPath = new File(string2).getParent();
            this.loadDicomFileOrDirectory(string2, this.multiPanel, this.referenceImagePanelForImages, this.referenceImagePanelForSpectra);
        }
        if (this.lastDirectoryPath == null) {
            this.browserPane.setSelectedIndex(-1);
            this.browserPane.setSelectedIndex(this.browserPane.indexOfComponent(this.databaseControlsPanel));
        }
        DicomFileOrDirectoryLoadActionListener dicomFileOrDirectoryLoadActionListener = new DicomFileOrDirectoryLoadActionListener(this.multiPanel, this.referenceImagePanelForImages, this.referenceImagePanelForSpectra);
        ((AbstractButton)jComponent3).addActionListener(dicomFileOrDirectoryLoadActionListener);
        jButton.addActionListener(dicomFileOrDirectoryLoadActionListener);
        ((AbstractButton)jComponent).addActionListener(dicomFileOrDirectoryLoadActionListener);
        jButton19.addActionListener(dicomFileOrDirectoryLoadActionListener);
        ImportCurrentlyDisplayedInstanceToDatabaseActionListener importCurrentlyDisplayedInstanceToDatabaseActionListener = new ImportCurrentlyDisplayedInstanceToDatabaseActionListener();
        jButton2.addActionListener(importCurrentlyDisplayedInstanceToDatabaseActionListener);
        ((AbstractButton)jComponent2).addActionListener(importCurrentlyDisplayedInstanceToDatabaseActionListener);
        jButton20.addActionListener(importCurrentlyDisplayedInstanceToDatabaseActionListener);
        ((AbstractButton)jComponent4).addActionListener(new ImportFromSelectionToDatabaseActionListener());
        ((AbstractButton)jComponent5).addActionListener(new DicomFileLoadFromSelectionActionListener());
        jButton12.addActionListener(new DicomFileLoadFromSelectionActionListener());
        jButton10.addActionListener(new DatabaseRefreshActionListener());
        jButton11.addActionListener(new DatabaseImportFromFilesActionListener());
        jButton14.addActionListener(new DatabasePurgeActionListener());
        jButton15.addActionListener(new QuerySelectActionListener(this.browserPane, n3));
        jButton16.addActionListener(new QueryFilterActionListener(this.browserPane, n3));
        jButton17.addActionListener(new QueryRefreshActionListener());
        jButton18.addActionListener(new QueryRetrieveActionListener());
        NetworkSendCurrentSelectionActionListener networkSendCurrentSelectionActionListener = new NetworkSendCurrentSelectionActionListener();
        jButton9.addActionListener(networkSendCurrentSelectionActionListener);
        jButton3.addActionListener(networkSendCurrentSelectionActionListener);
        jButton6.addActionListener(networkSendCurrentSelectionActionListener);
        jButton21.addActionListener(networkSendCurrentSelectionActionListener);
        jButton13.addActionListener(networkSendCurrentSelectionActionListener);
        SaveCurrentlyDisplayedImageToXMLActionListener saveCurrentlyDisplayedImageToXMLActionListener = new SaveCurrentlyDisplayedImageToXMLActionListener();
        jButton4.addActionListener(saveCurrentlyDisplayedImageToXMLActionListener);
        jButton7.addActionListener(saveCurrentlyDisplayedImageToXMLActionListener);
        SaveCurrentlyDisplayedStructuredReportToXMLActionListener saveCurrentlyDisplayedStructuredReportToXMLActionListener = new SaveCurrentlyDisplayedStructuredReportToXMLActionListener();
        jButton22.addActionListener(saveCurrentlyDisplayedStructuredReportToXMLActionListener);
        ValidateCurrentlyDisplayedImageActionListener validateCurrentlyDisplayedImageActionListener = new ValidateCurrentlyDisplayedImageActionListener();
        jButton5.addActionListener(validateCurrentlyDisplayedImageActionListener);
        jButton8.addActionListener(validateCurrentlyDisplayedImageActionListener);
        ValidateCurrentlyDisplayedStructuredReportActionListener validateCurrentlyDisplayedStructuredReportActionListener = new ValidateCurrentlyDisplayedStructuredReportActionListener();
        jButton23.addActionListener(validateCurrentlyDisplayedStructuredReportActionListener);
        JSplitPane jSplitPane = new JSplitPane(1, this.browserPane, this.multiPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setBorder(emptyBorder);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.scrollPaneOfCurrentAttributes);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setResizeWeight(0.9);
        Box box = new Box(1);
        box.add(jSplitPane2);
        box.add(jLabel);
        ((Container)object).add(box);
        Dimension dimension2 = defaultMultiPanelDimension;
        this.multiPanel.setSize(dimension2);
        this.multiPanel.setPreferredSize(dimension2);
        this.browserPane.setPreferredSize(new Dimension(400, (int)this.multiPanel.getPreferredSize().getHeight()));
        Dimension dimension3 = this.getTableOfCurrentAttributesForCurrentFrameBrowser().getPreferredSize();
        int n4 = (int)dimension3.getWidth();
        int bl = (int)dimension3.getHeight();
        int n5 = 400 + (int)this.multiPanel.getPreferredSize().getWidth();
        if (n4 > n5) {
            n4 = n5;
        }
        if (bl < 76) {
            n = 76;
        }
        this.scrollPaneOfCurrentAttributes.setPreferredSize(new Dimension(n4, n));
        boolean bl2 = false;
        GraphicsDevice[] graphicsDeviceArray = properties.getProperty(propertyName_FullScreen);
        if (graphicsDeviceArray != null && graphicsDeviceArray.equals("true")) {
            bl2 = true;
        }
        graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        boolean bl3 = bl2 && graphicsDeviceArray.length == 1 && graphicsDeviceArray[0].isFullScreenSupported();
        this.setUndecorated(bl3);
        this.setResizable(!bl3);
        if (bl3) {
            graphicsDeviceArray[0].setFullScreenWindow(this);
            this.validate();
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    private DicomImageViewer(String string, int n, int n2) {
    }

    private DicomImageViewer(String string) {
    }

    private DicomImageViewer(String string, String string2) {
    }

    private DicomImageViewer(String string, String string2, String string3) {
        super(string, string2);
        this.doCommonConstructorStuff(string, string3);
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.awt.fakefullscreen", "true");
        }
        DicomImageViewer dicomImageViewer = new DicomImageViewer("Dicom Image Viewer", propertiesFileName, string);
    }

    static /* synthetic */ int[] access$102(DicomImageViewer dicomImageViewer, int[] nArray) {
        dicomImageViewer.currentSourceSortOrder = nArray;
        return nArray;
    }

    private class SortAttributesActionListener
    implements ActionListener {
        static final String ByName = "NAME";
        static final String ByNumber = "NUMBER";

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DicomImageViewer.this.attributeTreeSortOrderButtons.getSelection().getActionCommand();
            AttributeTreeBrowser.setSortByName(DicomImageViewer.this.attributeTreeScrollPane, string != null && string.equals(ByName));
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                System.err.println("Received: " + string + " from " + string3 + " in " + string2);
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    DicomImageViewer.this.databaseInformationModel.insertObject(attributeList, string, "C");
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    private class ValidateCurrentlyDisplayedStructuredReportActionListener
    implements ActionListener {
        DicomSRValidator validator = null;

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                AttributeList attributeList = DicomImageViewer.this.getAttributeListForDatabaseImport();
                if (this.validator == null) {
                    this.validator = new DicomSRValidator();
                }
                String string = this.validator == null ? "Could not instantiate a validator\n" : this.validator.validate(attributeList);
                JTextArea jTextArea = new JTextArea(string);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                JDialog jDialog = new JDialog();
                jDialog.setSize(512, 384);
                jDialog.setTitle("Validation of " + DicomImageViewer.this.getCurrentFilePathSelection());
                jDialog.getContentPane().add(jScrollPane);
                jDialog.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class ValidateCurrentlyDisplayedImageActionListener
    implements ActionListener {
        DicomInstanceValidator validator = null;

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                AttributeList attributeList = DicomImageViewer.this.getAttributeListForDatabaseImport();
                if (this.validator == null) {
                    this.validator = new DicomInstanceValidator();
                }
                String string = this.validator == null ? "Could not instantiate a validator\n" : this.validator.validate(attributeList);
                JTextArea jTextArea = new JTextArea(string);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                JDialog jDialog = new JDialog();
                jDialog.setSize(512, 384);
                jDialog.setTitle("Validation of " + DicomImageViewer.this.getCurrentFilePathSelection());
                jDialog.getContentPane().add(jScrollPane);
                jDialog.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class SaveCurrentlyDisplayedStructuredReportToXMLActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                JFileChooser jFileChooser = new JFileChooser(DicomImageViewer.this.lastDirectoryPath);
                if (jFileChooser.showSaveDialog(null) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    DicomImageViewer.this.lastDirectoryPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                    AttributeList attributeList = DicomImageViewer.this.getAttributeListForDatabaseImport();
                    new XMLRepresentationOfStructuredReportObjectFactory();
                    XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(attributeList, (OutputStream)new BufferedOutputStream(new FileOutputStream(string)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class SaveCurrentlyDisplayedImageToXMLActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                JFileChooser jFileChooser = new JFileChooser(DicomImageViewer.this.lastDirectoryPath);
                if (jFileChooser.showSaveDialog(null) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    DicomImageViewer.this.lastDirectoryPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                    AttributeList attributeList = DicomImageViewer.this.getAttributeListForDatabaseImport();
                    new XMLRepresentationOfDicomObjectFactory();
                    XMLRepresentationOfDicomObjectFactory.createDocumentAndWriteIt(attributeList, new BufferedOutputStream(new FileOutputStream(string)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class NetworkSendCurrentSelectionActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = DicomImageViewer.this.getCurrentFilePathSelections();
            if (vector != null && vector.size() > 0) {
                Properties properties = DicomImageViewer.this.getProperties();
                String string = properties.getProperty(DicomImageViewer.propertyName_DicomCurrentlySelectedStorageTargetAE);
                if ((string = DicomImageViewer.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select destination", "Send ...", string)) != null && DicomImageViewer.this.networkApplicationProperties != null) {
                    try {
                        String string2 = DicomImageViewer.this.networkApplicationProperties.getCallingAETitle();
                        String string3 = DicomImageViewer.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                        PresentationAddress presentationAddress = DicomImageViewer.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string3);
                        String string4 = presentationAddress.getHostname();
                        int n = presentationAddress.getPort();
                        String string5 = null;
                        String string6 = null;
                        for (int i = 0; i < vector.size(); ++i) {
                            String string7 = (String)vector.get(i);
                            if (string7 == null) continue;
                            try {
                                System.err.println("Send: " + string7);
                                File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string7);
                                DicomImageViewer.this.sendDicomFileOverDicomNetwork(file.getAbsolutePath(), string, string4, n, string3, string2, string5, string6);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace(System.err);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    public class ImportFromSelectionToDatabaseActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            Vector vector = DicomImageViewer.this.getCurrentFilePathSelections();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string = (String)vector.get(i);
                    if (string == null) continue;
                    try {
                        File file = FileUtilities.getFileFromNameInsensitiveToCaseIfNecessary(string);
                        DicomInputStream dicomInputStream = new DicomInputStream(file);
                        AttributeList attributeList = new AttributeList();
                        attributeList.read(dicomInputStream);
                        dicomInputStream.close();
                        DicomImageViewer.this.copyFileAndImportToDatabase(attributeList, file.getAbsolutePath());
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class ImportCurrentlyDisplayedInstanceToDatabaseActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DicomImageViewer.this.copyFileAndImportToDatabase(DicomImageViewer.this.getAttributeListForDatabaseImport(), DicomImageViewer.this.getCurrentlyDisplayedInstanceFilePath());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class DatabaseImportFromFilesActionListener
    implements ActionListener {
        private DatabaseMediaImporter importer;

        public DatabaseImportFromFilesActionListener() {
            this.importer = new DatabaseMediaImporter(null, DicomImageViewer.this.savedImagesFolder, DicomImageViewer.this.storedFilePathStrategy, DicomImageViewer.this.databaseInformationModel, new OurMessageLogger());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.importer.choosePathAndImportDicomFiles();
                new OurDatabaseTreeBrowser();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done.                                                   "));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class DatabaseRefreshActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                new OurDatabaseTreeBrowser();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private class DatabasePurgeActionListener
    implements ActionListener {
        private DatabasePurgeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                new Thread(new DatabasePurgeWorker(DicomImageViewer.this.getCurrentDatabaseTreeRecordSelection())).start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class DatabasePurgeWorker
    implements Runnable {
        DatabaseTreeRecord databaseSelection;

        DatabasePurgeWorker(DatabaseTreeRecord databaseTreeRecord) {
            this.databaseSelection = databaseTreeRecord;
        }

        public void run() {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging started"));
            try {
                DicomImageViewer.this.purgeFilesAndDatabaseInformation(this.databaseSelection);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                exception.printStackTrace(System.err);
            }
            try {
                new OurDatabaseTreeBrowser();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done purging"));
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class QueryRefreshActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DicomImageViewer.this.queryTreeScrollPane.setViewportView(null);
                DicomImageViewer.this.scrollPaneOfCurrentAttributes.setViewportView(null);
                QueryInformationModel queryInformationModel = DicomImageViewer.this.getCurrentRemoteQueryInformationModel();
                if (queryInformationModel != null) {
                    AttributeList attributeList = DicomImageViewer.this.getCurrentRemoteQueryFilter();
                    attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                    QueryTreeModel queryTreeModel = queryInformationModel.performHierarchicalQuery(attributeList);
                    new OurQueryTreeBrowser(queryInformationModel, queryTreeModel, DicomImageViewer.this.queryTreeScrollPane, DicomImageViewer.this.scrollPaneOfCurrentAttributes);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class QueryRetrieveActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomImageViewer.this.getCursor();
            DicomImageViewer.this.setCursor(Cursor.getPredefinedCursor(3));
            if (DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel() == null) {
                QueryTreeRecord queryTreeRecord = DicomImageViewer.this.getCurrentRemoteQuerySelectionQueryTreeRecord();
                if (queryTreeRecord != null) {
                    System.err.println("Retrieve: everything from " + DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                    Enumeration enumeration = queryTreeRecord.children();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)enumeration.nextElement();
                            if (queryTreeRecord2 == null) continue;
                            DicomImageViewer.this.setCurrentRemoteQuerySelection(queryTreeRecord2.getUniqueKeys(), queryTreeRecord2.getUniqueKey(), queryTreeRecord2.getAllAttributesReturnedInIdentifier());
                            System.err.println("Retrieve: " + DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel() + " " + DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKey().getSingleStringValueOrEmptyString() + " from " + DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                            DicomImageViewer.this.performRetrieve(DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKeys(), DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel(), DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                        }
                    }
                    System.err.println("Retrieve done");
                    DicomImageViewer.this.setCurrentRemoteQuerySelection(null, null, null);
                }
            } else {
                System.err.println("Retrieve: " + DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel() + " " + DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKey().getSingleStringValueOrEmptyString() + " from " + DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                DicomImageViewer.this.performRetrieve(DicomImageViewer.this.getCurrentRemoteQuerySelectionUniqueKeys(), DicomImageViewer.this.getCurrentRemoteQuerySelectionLevel(), DicomImageViewer.this.getCurrentRemoteQuerySelectionRetrieveAE());
                System.err.println("Retrieve done");
            }
            DicomImageViewer.this.setCursor(cursor);
        }
    }

    private class QueryFilterActionListener
    implements ActionListener {
        JTabbedPane browserPane;
        int tabNumberOfRemoteInBrowserPane;

        public QueryFilterActionListener(JTabbedPane jTabbedPane, int n) {
            this.browserPane = jTabbedPane;
            this.tabNumberOfRemoteInBrowserPane = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageViewer.this.queryTreeScrollPane.setViewportView(new FilterPanel(DicomImageViewer.this.getCurrentRemoteQueryFilter()));
        }
    }

    private class QuerySelectActionListener
    implements ActionListener {
        JTabbedPane browserPane;
        int tabNumberOfRemoteInBrowserPane;

        public QuerySelectActionListener(JTabbedPane jTabbedPane, int n) {
            this.browserPane = jTabbedPane;
            this.tabNumberOfRemoteInBrowserPane = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = DicomImageViewer.this.getProperties();
            String string = properties.getProperty(DicomImageViewer.propertyName_DicomCurrentlySelectedQueryTargetAE);
            string = DicomImageViewer.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select remote system", "Query ...", string);
            DicomImageViewer.this.queryTreeScrollPane.setViewportView(null);
            DicomImageViewer.this.scrollPaneOfCurrentAttributes.setViewportView(null);
            if (string != null) {
                DicomImageViewer.this.setCurrentRemoteQueryInformationModel(string, this.browserPane, this.tabNumberOfRemoteInBrowserPane);
            }
        }
    }

    private final class OurBackgroundListSelectionListener
    implements ListSelectionListener {
        private String lastSelectedDicomFileName = null;

        OurBackgroundListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            if (jList.isSelectionEmpty()) {
                this.lastSelectedDicomFileName = null;
            } else {
                String string;
                String string2 = (String)jList.getSelectedValue();
                if (!(string2 == null || (string = (String)DicomImageViewer.this.backgroundImageListMappedToFilenames.get(string2)) == null || this.lastSelectedDicomFileName != null && string.equals(this.lastSelectedDicomFileName))) {
                    this.lastSelectedDicomFileName = string;
                    DicomImageViewer.this.loadBackgroundImageForSpectra(string);
                }
            }
        }
    }

    private final class OurReferenceListSelectionListener
    implements ListSelectionListener {
        private String lastSelectedDicomFileName = null;
        private JPanel referenceImagePanel;
        private boolean spectroscopy;

        OurReferenceListSelectionListener(JPanel jPanel, boolean bl) {
            this.referenceImagePanel = jPanel;
            this.spectroscopy = bl;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            if (jList.isSelectionEmpty()) {
                this.lastSelectedDicomFileName = null;
            } else {
                String string;
                String string2 = (String)jList.getSelectedValue();
                if (!(string2 == null || (string = (String)DicomImageViewer.this.referenceImageListMappedToFilenames.get(string2)) == null || this.lastSelectedDicomFileName != null && string.equals(this.lastSelectedDicomFileName))) {
                    this.lastSelectedDicomFileName = string;
                    DicomImageViewer.this.loadReferenceImagePanel(string, this.referenceImagePanel, this.spectroscopy);
                }
            }
        }
    }

    private class DicomFileLoadFromSelectionActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = DicomImageViewer.this.getCurrentFilePathSelection();
            if (string != null) {
                DicomImageViewer.this.loadDicomFileOrDirectory(string, DicomImageViewer.this.multiPanel, DicomImageViewer.this.referenceImagePanelForImages, DicomImageViewer.this.referenceImagePanelForSpectra);
            }
        }
    }

    private class DicomFileOrDirectoryLoadActionListener
    implements ActionListener {
        JPanel imagePanel;
        JPanel referenceImagePanelForImages;
        JPanel referenceImagePanelForSpectra;

        public DicomFileOrDirectoryLoadActionListener(JPanel jPanel, JPanel jPanel2, JPanel jPanel3) {
            this.imagePanel = jPanel;
            this.referenceImagePanelForImages = jPanel2;
            this.referenceImagePanelForSpectra = jPanel3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DicomImageViewer.this.callFileChooserThenLoadDicomFileOrDirectory(this.imagePanel, this.referenceImagePanelForImages, this.referenceImagePanelForSpectra);
        }
    }

    private class OurQueryTreeBrowser
    extends QueryTreeBrowser {
        OurQueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
            super(queryInformationModel, queryTreeModel, jScrollPane, jScrollPane2);
        }

        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
            return new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                        DicomImageViewer.this.setCurrentRemoteQuerySelection(queryTreeRecord.getUniqueKeys(), queryTreeRecord.getUniqueKey(), queryTreeRecord.getAllAttributesReturnedInIdentifier());
                        DicomImageViewer.this.setCurrentRemoteQuerySelectionQueryTreeRecord(queryTreeRecord);
                    }
                }
            };
        }
    }

    private class OurDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurDatabaseTreeBrowser() throws DicomException {
            super(DicomImageViewer.this.databaseInformationModel, DicomImageViewer.this.databaseTreeScrollPane, DicomImageViewer.this.scrollPaneOfCurrentAttributes);
        }

        protected boolean doSomethingWithSelection(DatabaseTreeRecord databaseTreeRecord) {
            DicomImageViewer.this.setCurrentDatabaseTreeRecordSelection(databaseTreeRecord);
            return false;
        }

        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomImageViewer.this.setCurrentFilePathSelection(vector);
        }

        protected void doSomethingMoreWithWhateverWasSelected() {
            String string = DicomImageViewer.this.getCurrentFilePathSelection();
            if (string != null) {
                DicomImageViewer.this.loadDicomFileOrDirectory(string, DicomImageViewer.this.multiPanel, DicomImageViewer.this.referenceImagePanelForImages, DicomImageViewer.this.referenceImagePanelForSpectra);
            }
        }
    }

    private class OurDicomDirectoryBrowser
    extends DicomDirectoryBrowser {
        public OurDicomDirectoryBrowser(AttributeList attributeList) throws DicomException {
            super(attributeList, DicomImageViewer.this.lastDirectoryPath, DicomImageViewer.this.dicomdirTreeScrollPane, DicomImageViewer.this.scrollPaneOfCurrentAttributes);
        }

        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomImageViewer.this.setCurrentFilePathSelection(vector);
        }

        protected void doSomethingMoreWithWhateverWasSelected() {
            String string = DicomImageViewer.this.getCurrentFilePathSelection();
            if (string != null) {
                DicomImageViewer.this.loadDicomFileOrDirectory(string, DicomImageViewer.this.multiPanel, DicomImageViewer.this.referenceImagePanelForImages, DicomImageViewer.this.referenceImagePanelForSpectra);
            }
        }
    }

    class OurBrowserPaneChangeListener
    extends SelfRegisteringListener {
        public OurBrowserPaneChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.BrowserPaneChangeEvent", eventContext);
        }

        public void changed(Event event) {
            BrowserPaneChangeEvent browserPaneChangeEvent = (BrowserPaneChangeEvent)event;
            if (browserPaneChangeEvent.getType() == 1) {
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.displayControlsPanel), true);
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.displayControlsPanel);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.spectroscopyControlsPanel), false);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.structuredReportTreeControlsPanel), false);
            } else if (browserPaneChangeEvent.getType() == 2) {
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.dicomdirControlsPanel);
            } else if (browserPaneChangeEvent.getType() == 3) {
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.databaseControlsPanel);
            } else if (browserPaneChangeEvent.getType() == 4) {
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.spectroscopyControlsPanel), true);
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.spectroscopyControlsPanel);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.displayControlsPanel), false);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.structuredReportTreeControlsPanel), false);
            } else if (browserPaneChangeEvent.getType() == 5) {
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.structuredReportTreeControlsPanel), true);
                DicomImageViewer.this.browserPane.setSelectedComponent(DicomImageViewer.this.structuredReportTreeControlsPanel);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.displayControlsPanel), false);
                DicomImageViewer.this.browserPane.setEnabledAt(DicomImageViewer.this.browserPane.indexOfComponent(DicomImageViewer.this.spectroscopyControlsPanel), false);
            }
        }
    }

    class OurFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            DicomImageViewer.this.currentSourceIndex = frameSortOrderChangeEvent.getIndex();
            DicomImageViewer.access$102(DicomImageViewer.this, frameSortOrderChangeEvent.getSortOrder());
            DicomImageViewer.this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(DicomImageViewer.this.currentSourceIndex);
            DicomImageViewer.this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            DicomImageViewer.this.currentSourceIndex = frameSelectionChangeEvent.getIndex();
            if (DicomImageViewer.this.currentSourceSortOrder != null) {
                DicomImageViewer.this.currentSourceIndex = DicomImageViewer.this.currentSourceSortOrder[DicomImageViewer.this.currentSourceIndex];
            }
            DicomImageViewer.this.getModelOfCurrentAttributesForCurrentFrameBrowser().selectValuesForDifferentFrame(DicomImageViewer.this.currentSourceIndex);
            DicomImageViewer.this.getTableOfCurrentAttributesForCurrentFrameBrowser().setColumnWidths();
        }
    }

    private class OurMessageLogger
    implements MessageLogger {
        private OurMessageLogger() {
        }

        public void send(String string) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string));
        }

        public void sendLn(String string) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string));
        }
    }
}

