/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.ConsumerFormatImageMaker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class IconListBrowser {
    public static final int DEFAULT_ICON_SIZE = 128;
    protected static final String ICON_FILE_PREFIX = "icon";
    protected static final String ICON_FORMAT = "jpeg";
    protected static final int ICON_QUALITY = 100;
    protected static final String ICON_FILE_SUFFIX = ".jpg";
    protected int iconSize;
    protected JScrollPane parentScrollPane;
    protected JList list;
    protected DefaultListModel model;
    private Border selectedBorder = new LineBorder(Color.green, 2);
    private Border unselectedBorder = new LineBorder(Color.black, 2);

    protected void setParentScrollPane(JScrollPane jScrollPane) {
        this.parentScrollPane = jScrollPane;
        jScrollPane.setViewportView(this.list);
    }

    public void addDicomFiles(String[] stringArray) throws DicomException, FileNotFoundException, IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.add(string);
        }
    }

    public IconListBrowser(int n) throws DicomException {
        this.iconSize = n;
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setCellRenderer(new OurCellRenderer());
        this.list.setBackground(Color.BLACK);
        this.list.setSelectionMode(2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = IconListBrowser.this.list.locationToIndex(mouseEvent.getPoint());
                    System.err.println("Double clicked on Item " + n);
                    int[] nArray = IconListBrowser.this.list.getSelectedIndices();
                    System.err.println("At which time selected Items were " + Arrays.toString(nArray));
                }
            }
        };
        this.list.addMouseListener(mouseAdapter);
        this.parentScrollPane = null;
    }

    public IconListBrowser(JScrollPane jScrollPane, int n) throws DicomException {
        this(n);
        this.setParentScrollPane(jScrollPane);
    }

    public IconListBrowser(JScrollPane jScrollPane) throws DicomException {
        this(jScrollPane, 128);
    }

    public IconListBrowser(JScrollPane jScrollPane, String[] stringArray) throws DicomException, FileNotFoundException, IOException {
        this(jScrollPane);
        this.addDicomFiles(stringArray);
    }

    public IconListBrowser(Container container, String[] stringArray) throws DicomException, FileNotFoundException, IOException {
        this(128);
        JScrollPane jScrollPane = new JScrollPane();
        container.add(jScrollPane);
        this.setParentScrollPane(jScrollPane);
        this.addDicomFiles(stringArray);
    }

    public IconListBrowser(JFrame jFrame, String[] stringArray) throws DicomException, FileNotFoundException, IOException {
        this(jFrame.getContentPane(), stringArray);
    }

    public void add(String string) throws DicomException, FileNotFoundException, IOException {
        File file = File.createTempFile(ICON_FILE_PREFIX, ICON_FILE_SUFFIX);
        file.deleteOnExit();
        String string2 = file.getAbsolutePath();
        ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, ICON_FORMAT, 0.0, 0.0, 128, 0, 100, ICON_FILE_PREFIX, 0);
        ImageIcon imageIcon = new ImageIcon(string2);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setToolTipText(string);
        this.model.addElement(jLabel);
    }

    public static void main(String[] stringArray) {
        try {
            ApplicationFrame applicationFrame = new ApplicationFrame("IconListBrowser");
            new IconListBrowser(applicationFrame, stringArray);
            applicationFrame.pack();
            applicationFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    protected class OurCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected OurCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                this.setText(jLabel.getText());
                this.setIcon(jLabel.getIcon());
                this.setToolTipText(jLabel.getToolTipText());
                if (bl) {
                    this.setBorder(IconListBrowser.this.selectedBorder);
                } else {
                    this.setBorder(IconListBrowser.this.unselectedBorder);
                }
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

