/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.PixelSpacing;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SpatialCoordinateAndImageReference;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.DisplayedAreaSelection;
import com.pixelmed.display.DrawingUtilities;
import com.pixelmed.display.MammoDemographicAndTechniqueAnnotations;
import com.pixelmed.display.OrientationAnnotations;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SingleImagePanelWithLineDrawing;
import com.pixelmed.display.SourceImage;
import com.pixelmed.event.EventContext;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MammoImageViewer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/MammoImageViewer.java,v 1.75 2009/12/22 13:35:58 dclunie Exp $";
    protected JFrame frame;
    protected JPanel multiPanel;
    protected int frameWidth;
    protected int frameHeight;
    protected boolean doNotFlipOrRotate = false;
    protected boolean forceFitEntireMatrixToWindow = false;
    protected boolean doNotJustify = false;
    private static final int crossSize = 50;
    private static final int crossGap = 15;

    public void setDoNotFlipOrRotate(boolean bl) {
        this.doNotFlipOrRotate = bl;
    }

    public void setForceFitEntireMatrixToWindow(boolean bl) {
        this.forceFitEntireMatrixToWindow = bl;
    }

    public void setDoNotJustify(boolean bl) {
        this.doNotJustify = bl;
    }

    private static String[] getPatientOrientation(AttributeList attributeList) {
        String[] stringArray = null;
        Attribute attribute = attributeList.get(TagFromName.PatientOrientation);
        if (attribute != null && attribute.getVM() == 2) {
            try {
                stringArray = attribute.getStringValues();
                if (stringArray != null && stringArray.length != 2) {
                    stringArray = null;
                }
            }
            catch (DicomException dicomException) {
                stringArray = null;
            }
        }
        if (stringArray == null) {
            stringArray = new String[2];
        }
        return stringArray;
    }

    private static String getView(AttributeList attributeList) {
        String string = null;
        CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ViewCodeSequence);
        if (codedSequenceItem != null) {
            string = MammoDemographicAndTechniqueAnnotations.getViewAbbreviationFromViewCodeSequenceAttributes(codedSequenceItem.getAttributeList());
        }
        return string;
    }

    private static String getImageLateralityViewModifierAndViewModifier(AttributeList attributeList) {
        return MammoDemographicAndTechniqueAnnotations.getAbbreviationFromImageLateralityViewModifierAndViewModifierCodeSequenceAttributes(attributeList);
    }

    private static String getLaterality(AttributeList attributeList) {
        return Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ImageLaterality);
    }

    private static String getDate(AttributeList attributeList) {
        return Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate);
    }

    private static String getDateOfCurrentStudy(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        String string = null;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            int n3 = 0;
            try {
                n3 = Integer.parseInt(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
            if (n3 <= n2) continue;
            n2 = n3;
            string = stringArray[i];
        }
        return string;
    }

    private static int[] determineOrderForDisplay(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = null;
        if (n == 2) {
            n6 = stringArray4[0] != null && stringArray4[1] != null && stringArray4[0].equals(stringArray4[1]) ? 1 : 0;
            n5 = stringArray[0] != null && stringArray[1] != null && stringArray[0].equals(stringArray[1]) ? 1 : 0;
            int n7 = n4 = stringArray2[0] != null && stringArray2[1] != null && stringArray2[0].equals(stringArray2[1]) ? 1 : 0;
            if (n5 != 0) {
                if (n6 != 0) {
                    if (n4 == 0 && stringArray2[0] != null) {
                        nArray = new int[n];
                        System.err.println("Hanging two of same view and same study with right side on left of display");
                        if (stringArray2[0].equals("R")) {
                            nArray[0] = 0;
                            nArray[1] = 1;
                        } else {
                            nArray[0] = 1;
                            nArray[1] = 0;
                        }
                    }
                } else if (n4 != 0 && stringArray4[0] != null && stringArray4[1] != null) {
                    nArray = new int[n];
                    System.err.println("Hanging two of same view and same side different study with earlier study on left of display");
                    if (Integer.parseInt(stringArray4[0]) < Integer.parseInt(stringArray4[1])) {
                        nArray[0] = 0;
                        nArray[1] = 1;
                    } else {
                        nArray[0] = 1;
                        nArray[1] = 0;
                    }
                }
            }
        }
        if (nArray == null && n == 4) {
            System.err.println("Hanging four views");
            nArray = new int[n];
            for (n6 = 0; n6 < n; ++n6) {
                nArray[n6] = -1;
            }
            n6 = 0;
            while (n6 < n) {
                n5 = stringArray2[n6] != null && stringArray2[n6].equals("L") ? 1 : 0;
                n3 = n5 + (n4 = stringArray[n6] != null && stringArray[n6].equals("CC") ? 2 : 0);
                if (nArray[n3] != -1) {
                    System.err.println("spot " + n3 + " wanted by " + n6 + " but already used by " + nArray[n3]);
                    nArray = null;
                    break;
                }
                nArray[n3] = n6++;
            }
        }
        if (nArray == null && n == 8) {
            System.err.println("Hanging eight views - looking for prior and current four views");
            nArray = new int[n];
            for (n6 = 0; n6 < n; ++n6) {
                nArray[n6] = -1;
            }
            String string = MammoImageViewer.getDateOfCurrentStudy(stringArray4);
            n5 = 0;
            while (n5 < n) {
                n4 = string != null && stringArray4[n5] != null && string.equals(stringArray4[n5]) ? 4 : 0;
                int n8 = n4 + (n3 = stringArray2[n5] != null && stringArray2[n5].equals("L") ? 1 : 0) + (n2 = stringArray[n5] != null && stringArray[n5].equals("CC") ? 2 : 0);
                if (nArray[n8] != -1) {
                    System.err.println("spot " + n8 + " wanted by " + n5 + " but already used by " + nArray[n8]);
                    nArray = null;
                    break;
                }
                nArray[n8] = n5++;
            }
        }
        if (nArray == null && n == 8) {
            int n9;
            System.err.println("Hanging eight views - looking for views with and without modifiers");
            nArray = new int[n];
            for (n9 = 0; n9 < n; ++n9) {
                nArray[n9] = -1;
            }
            n9 = 0;
            while (n9 < n) {
                n4 = stringArray2[n9] != null && stringArray2[n9].equals("L") ? 1 : 0;
                n2 = n4 + (n3 = stringArray[n9] != null && stringArray[n9].equals("CC") ? 2 : 0) + (n5 = stringArray3[n9] != null && stringArray2[n9] != null && stringArray[n9] != null && stringArray3[n9].equals(stringArray2[n9] + stringArray[n9]) ? 0 : 4);
                if (nArray[n2] != -1) {
                    System.err.println("spot " + n2 + " wanted by " + n9 + " but already used by " + nArray[n2]);
                    nArray = null;
                    break;
                }
                nArray[n2] = n9++;
            }
        }
        return nArray;
    }

    private static char invertOrientation(char c) {
        switch (c) {
            case 'A': {
                return 'P';
            }
            case 'P': {
                return 'A';
            }
            case 'R': {
                return 'L';
            }
            case 'L': {
                return 'R';
            }
            case 'H': {
                return 'F';
            }
            case 'F': {
                return 'H';
            }
        }
        return c;
    }

    private static String invertOrientation(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer.append(MammoImageViewer.invertOrientation(cArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    private static String getSingleSourceImageSequenceReferencedSOPInstanceUIDOrNull(AttributeList attributeList) {
        Attribute attribute;
        String string = null;
        Attribute attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SourceImageSequence, TagFromName.SpatialLocationsPreserved);
        if ((attribute2 == null || attribute2.getSingleStringValueOrEmptyString().equals("YES")) && (attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, TagFromName.SourceImageSequence, TagFromName.ReferencedSOPInstanceUID)) != null && (string = attribute.getSingleStringValueOrNull()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private static void addCADMarkToPreDefinedShapes(SpatialCoordinateAndImageReference spatialCoordinateAndImageReference, Vector vector) {
        String string = spatialCoordinateAndImageReference.getGraphicType();
        float[] fArray = spatialCoordinateAndImageReference.getGraphicData();
        if (string != null && fArray != null && (spatialCoordinateAndImageReference.getRenderingIntent() == 0 || spatialCoordinateAndImageReference.getRenderingIntent() == 1)) {
            if (string.equals("POINT") && fArray.length == 2) {
                int n = (int)fArray[0];
                int n2 = (int)fArray[1];
                if (spatialCoordinateAndImageReference.getCoordinateCategory() == 3) {
                    DrawingUtilities.addVerticalCross(vector, n, n2, 50, 15);
                } else {
                    DrawingUtilities.addDiagonalCross(vector, n, n2, 50, 15);
                }
            } else if (string.equals("POLYLINE") && fArray.length >= 4) {
                int n = (int)fArray[0];
                int n3 = (int)fArray[1];
                int n4 = 2;
                while (n4 + 1 < fArray.length) {
                    int n5 = (int)fArray[n4];
                    int n6 = (int)fArray[n4 + 1];
                    vector.add(new Line2D.Float(new Point(n, n3), new Point(n5, n6)));
                    n = n5;
                    n3 = n6;
                    n4 += 2;
                }
            } else if (string.equals("ELLIPSE") && fArray.length == 8) {
                int n = (int)fArray[0];
                int n7 = (int)fArray[1];
                int n8 = (int)fArray[2];
                int n9 = (int)fArray[3];
                int n10 = (int)fArray[4];
                int n11 = (int)fArray[5];
                int n12 = (int)fArray[6];
                int n13 = (int)fArray[7];
                if (n7 == n9 && n10 == n12) {
                    vector.add(new Ellipse2D.Float(n, n11, n8 - n, n13 - n11));
                } else if (n == n8 && n11 == n13) {
                    vector.add(new Ellipse2D.Float(n10, n7, n12 - n10, n9 - n7));
                } else {
                    System.err.println("addCADMarkToPreDefinedShapes(): NOT adding ELLIPSE that is not parallel to row");
                }
            } else {
                System.err.println("addCADMarkToPreDefinedShapes(): NOT adding " + string);
            }
        }
    }

    protected SingleImagePanel makeNewImagePanel(SourceImage sourceImage, EventContext eventContext) {
        return new OurSingleImagePanel(sourceImage, eventContext);
    }

    public void loadMultiPanelFromSpecifiedFiles(String[] stringArray) throws Exception {
        int n;
        double d;
        double d2;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3 = stringArray.length;
        SingleImagePanel[] singleImagePanelArray = new SingleImagePanel[n3];
        String[][] stringArrayArray = new String[n3][];
        String[] stringArray2 = new String[n3];
        String[] stringArray3 = new String[n3];
        String[] stringArray4 = new String[n3];
        String[] stringArray5 = new String[n3];
        PixelSpacing[] pixelSpacingArray = new PixelSpacing[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        String[] stringArray6 = new String[n3];
        String[] stringArray7 = new String[n3];
        AffineTransform[] affineTransformArray = new AffineTransform[n3];
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        String[] stringArray8 = new String[n3];
        String[] stringArray9 = new String[n3];
        String[] stringArray10 = new String[n3];
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        double d3 = 0.0;
        double d4 = 0.0;
        StructuredReport[] structuredReportArray = new StructuredReport[n3];
        int n4 = 0;
        int n5 = 0;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                int n6;
                String string = stringArray[n2];
                DicomInputStream dicomInputStream = null;
                InputStream inputStream = classLoader.getResourceAsStream(string);
                dicomInputStream = inputStream != null ? new DicomInputStream(inputStream) : new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                if (attributeList.isImage()) {
                    n6 = n4++;
                    System.err.println("IMAGE [" + n6 + "] is file " + n2 + " (" + stringArray[n2] + ")");
                    stringArray8[n6] = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
                    stringArray9[n6] = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
                    stringArray10[n6] = MammoImageViewer.getSingleSourceImageSequenceReferencedSOPInstanceUIDOrNull(attributeList);
                    stringArrayArray[n6] = MammoImageViewer.getPatientOrientation(attributeList);
                    stringArray2[n6] = MammoImageViewer.getView(attributeList);
                    stringArray3[n6] = MammoImageViewer.getImageLateralityViewModifierAndViewModifier(attributeList);
                    stringArray4[n6] = MammoImageViewer.getLaterality(attributeList);
                    stringArray5[n6] = MammoImageViewer.getDate(attributeList);
                    pixelSpacingArray[n6] = new PixelSpacing(attributeList, null, false, true);
                    SourceImage sourceImage = new SourceImage(attributeList);
                    BufferedImage bufferedImage = sourceImage.getBufferedImage();
                    nArray[n6] = sourceImage.getWidth();
                    nArray2[n6] = sourceImage.getHeight();
                    FlipAsNecessary flipAsNecessary = new FlipAsNecessary(bufferedImage, stringArrayArray[n6], stringArray2[n6], stringArray4[n6], this.doNotFlipOrRotate);
                    bufferedImage = flipAsNecessary.getImage();
                    stringArray6[n6] = flipAsNecessary.getRowOrientation();
                    stringArray7[n6] = flipAsNecessary.getColumnOrientation();
                    affineTransformArray[n6] = flipAsNecessary.getTransform();
                    if (this.doNotJustify) {
                        nArray8[n6] = 0;
                        nArray8[n6] = 0;
                    } else {
                        int n7 = stringArray6[n6] == null ? 0 : (nArray7[n6] = stringArray6[n6].indexOf("P") == -1 ? -1 : 1);
                        nArray8[n6] = stringArray7[n6] == null ? 0 : (stringArray7[n6].indexOf("F") == -1 ? 0 : -1);
                    }
                    object3 = new BreastExtentFinder(bufferedImage, stringArray6[n6], sourceImage.getMinimum(), sourceImage.getMaximum(), sourceImage.isInverted(), pixelSpacingArray[n6].getSpacing());
                    dArray[n6] = ((BreastExtentFinder)object3).getHorizontalExtentInMm();
                    dArray2[n6] = ((BreastExtentFinder)object3).getVerticalExtentInMm();
                    if (dArray[n6] > d3) {
                        d3 = dArray[n6];
                    }
                    if (dArray2[n6] > d4) {
                        d4 = dArray2[n6];
                    }
                    nArray3[n6] = ((BreastExtentFinder)object3).getUpperBound();
                    nArray4[n6] = ((BreastExtentFinder)object3).getLowerBound();
                    nArray5[n6] = ((BreastExtentFinder)object3).getLeftBound();
                    nArray6[n6] = ((BreastExtentFinder)object3).getRightBound();
                    boolean bl = false;
                    object2 = null;
                    if (bl && (object2 = (EventContext)hashMap.get(stringArray5[n6])) == null) {
                        object2 = new EventContext(stringArray5[n6]);
                        hashMap.put(stringArray5[n6], object2);
                    }
                    if (object2 == null) {
                        object2 = new EventContext(Integer.toString(n6));
                    }
                    object = this.makeNewImagePanel(sourceImage, (EventContext)object2);
                    boolean bl2 = nArray7[n6] >= 0;
                    ((SingleImagePanel)object).setDemographicAndTechniqueAnnotations(new MammoDemographicAndTechniqueAnnotations(attributeList, !bl2), "SansSerif", 0, 10, Color.pink);
                    ((SingleImagePanel)object).setOrientationAnnotations(new OrientationAnnotations(bl2 ? MammoImageViewer.invertOrientation(stringArray6[n6]) : stringArray6[n6], stringArray7[n6]), "SansSerif", 0, 20, Color.pink, bl2);
                    ((SingleImagePanel)object).setSideAndViewAnnotationString(MammoDemographicAndTechniqueAnnotations.getAbbreviationFromImageLateralityViewModifierAndViewModifierCodeSequenceAttributes(attributeList), 60, "SansSerif", 0, 20, Color.pink, bl2);
                    ((SingleImagePanel)object).setShowZoomFactor(true, bl2, pixelSpacingArray[n6].getSpacing(), pixelSpacingArray[n6].getDescription());
                    if (Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.VOILUTFunction).equals("SIGMOID")) {
                        ((SingleImagePanel)object).setVOIFunctionToLogistic();
                    }
                    singleImagePanelArray[n6] = object;
                    continue;
                }
                if (attributeList.isSRDocument()) {
                    n6 = n5++;
                    System.err.println("CAD [" + n6 + "] is file " + n2 + " (" + stringArray[n2] + ")");
                    structuredReportArray[n6] = new StructuredReport(attributeList);
                    continue;
                }
                throw new DicomException("Unsupported SOP Class in file " + stringArray[n2]);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        n2 = n4 >= 4 ? 4 : n4;
        int n8 = (n4 - 1) / n2 + 1;
        int n9 = this.frameWidth / n2;
        int n10 = this.frameHeight / n8;
        if (n4 == 1 && n9 > n10) {
            n9 /= 2;
        }
        double d5 = (d2 = d3 / (double)n9) < (d = d4 / (double)n10) ? d : d2;
        int[] nArray9 = MammoImageViewer.determineOrderForDisplay(n4, stringArray2, stringArray4, stringArray3, stringArray5);
        for (int i = 0; i < n4; ++i) {
            DisplayedAreaSelection displayedAreaSelection = null;
            displayedAreaSelection = this.forceFitEntireMatrixToWindow ? new DisplayedAreaSelection(nArray[i], nArray2[i], 0, 0, nArray[i], nArray2[i], true, 0.0, 0.0, 0.0, nArray7[i], nArray8[i], false) : new DisplayedAreaSelection(nArray[i], nArray2[i], nArray5[i], nArray3[i], nArray6[i], nArray4[i], d5 <= 0.0, d5, pixelSpacingArray[i].getSpacing(), pixelSpacingArray[i].getSpacing(), nArray7[i], nArray8[i], false);
            singleImagePanelArray[i].setDisplayedAreaSelection(displayedAreaSelection);
            singleImagePanelArray[i].setPreTransformImageRelativeCoordinates(affineTransformArray[i]);
        }
        Vector[] vectorArray = new Vector[n4];
        for (n = 0; n < n5; ++n) {
            object3 = (ContentItem)structuredReportArray[n].getRoot();
            ContentItem contentItem = ((ContentItem)object3).getNamedChild("DCM", "111017");
            if (contentItem == null || (object2 = StructuredReport.findAllContainedSOPInstances((ContentItem)object3, contentItem)) == null || ((Vector)object2).size() == 0) continue;
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                String string;
                SpatialCoordinateAndImageReference spatialCoordinateAndImageReference = (SpatialCoordinateAndImageReference)object.next();
                if (spatialCoordinateAndImageReference == null || spatialCoordinateAndImageReference.getRenderingIntent() == 2 || (string = spatialCoordinateAndImageReference.getSOPInstanceUID()) == null || string.length() <= 0) continue;
                int n11 = -1;
                for (int i = 0; i < n4; ++i) {
                    if ((stringArray9[i] == null || !stringArray9[i].equals(string)) && (stringArray10[i] == null || !stringArray10[i].equals(string))) continue;
                    n11 = i;
                    break;
                }
                if (n11 != -1) {
                    Vector vector = vectorArray[n11];
                    if (vector == null) {
                        vectorArray[n11] = vector = new Vector();
                    }
                    MammoImageViewer.addCADMarkToPreDefinedShapes(spatialCoordinateAndImageReference, vector);
                    continue;
                }
                System.err.println("CAD [" + n + "] could not find match for referencedUID=" + string);
            }
        }
        for (n = 0; n < n4; ++n) {
            if (vectorArray[n] == null) continue;
            singleImagePanelArray[n].setPreDefinedShapes(vectorArray[n]);
        }
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
        this.multiPanel.removeAll();
        this.multiPanel.setLayout(new GridLayout(n8, n2));
        this.multiPanel.setBackground(Color.black);
        for (n = 0; n < n8; ++n) {
            for (int i = 0; i < n2; ++i) {
                int n12 = n * n2 + i;
                if (n12 >= n4) continue;
                singleImagePanelArray[n12].setPreferredSize(new Dimension(n9, n10));
                this.multiPanel.add(singleImagePanelArray[nArray9 == null ? n12 : nArray9[n12]]);
            }
        }
        this.frame.getContentPane().validate();
        this.frame.getContentPane().repaint();
    }

    public MammoImageViewer(JFrame jFrame) throws Exception {
        this.frame = jFrame;
        this.doCommonConstructorStuff();
    }

    public MammoImageViewer(JFrame jFrame, String[] stringArray) throws Exception {
        this.frame = jFrame;
        this.doCommonConstructorStuff();
        this.loadMultiPanelFromSpecifiedFiles(stringArray);
    }

    public MammoImageViewer(String[] stringArray) throws Exception {
        this.frame = new ApplicationFrame();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        boolean bl = graphicsDeviceArray.length == 1 && graphicsDeviceArray[0].isFullScreenSupported();
        this.frame.setUndecorated(bl);
        this.frame.setResizable(!bl);
        if (bl) {
            graphicsDeviceArray[0].setFullScreenWindow(this.frame);
            this.frame.validate();
        } else {
            this.frame.pack();
            this.frame.setVisible(true);
        }
        this.doCommonConstructorStuff();
        this.loadMultiPanelFromSpecifiedFiles(stringArray);
    }

    protected void doCommonConstructorStuff() throws Exception {
        Container container = this.frame.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        this.multiPanel = new JPanel();
        this.frameWidth = this.frame.getWidth();
        this.frameHeight = this.frame.getHeight();
        Dimension dimension = new Dimension(this.frameWidth, this.frameHeight);
        this.multiPanel.setPreferredSize(dimension);
        this.multiPanel.setBackground(Color.black);
        container.add(this.multiPanel);
        container.validate();
    }

    public void clear() {
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
        this.multiPanel.removeAll();
        this.frame.getContentPane().validate();
        this.frame.getContentPane().repaint();
    }

    public static void main(String[] stringArray) {
        try {
            new MammoImageViewer(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    class OurSingleImagePanel
    extends SingleImagePanelWithLineDrawing {
        public OurSingleImagePanel(SourceImage sourceImage, EventContext eventContext) {
            super(sourceImage, eventContext);
        }

        protected Shape makeNewDrawingShape(int n, int n2, int n3, int n4) {
            return new Ellipse2D.Double(n, n2, n3, n4);
        }
    }

    private class BreastExtentFinder {
        double samplingFactorFractionOfDimension = 0.05;
        double indentFromChestWallFactorFractionOfDimension = 0.1;
        double thresholdFractionOfPixelRangeAboveBlackToBeBreast = 0.01;
        int upperBound;
        int lowerBound;
        int leftBound;
        int rightBound;
        double horizontalExtentInMm;
        double verticalExtentInMm;

        public int getUpperBound() {
            return this.upperBound;
        }

        public int getLowerBound() {
            return this.lowerBound;
        }

        public int getLeftBound() {
            return this.leftBound;
        }

        public int getRightBound() {
            return this.rightBound;
        }

        public double getHorizontalExtentInMm() {
            return this.horizontalExtentInMm;
        }

        public double getVerticalExtentInMm() {
            return this.verticalExtentInMm;
        }

        public int getVerticalCenter() {
            return (this.lowerBound - this.upperBound) / 2;
        }

        BreastExtentFinder(BufferedImage bufferedImage, double d) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            this.upperBound = 0;
            this.lowerBound = n2 - 1;
            this.leftBound = 0;
            this.rightBound = n - 1;
            this.horizontalExtentInMm = (double)(this.rightBound - this.leftBound) * d;
            this.verticalExtentInMm = (double)(this.lowerBound - this.upperBound) * d;
        }

        BreastExtentFinder(BufferedImage bufferedImage, String string, int n, int n2, boolean bl, double d) {
            int n3;
            int n4;
            int[] nArray;
            int n5;
            boolean bl2 = string != null && string.indexOf("P") != -1;
            int n6 = bufferedImage.getWidth();
            int n7 = bufferedImage.getHeight();
            int n8 = (int)((double)(n2 - n) * this.thresholdFractionOfPixelRangeAboveBlackToBeBreast + (double)n);
            if (bl) {
                n8 = n2 - n8;
            }
            int n9 = (int)((double)n7 * this.samplingFactorFractionOfDimension);
            int n10 = n9 / 2;
            int n11 = (int)((double)n6 * this.indentFromChestWallFactorFractionOfDimension);
            int n12 = bl2 ? n6 - n11 - 1 : n11;
            this.upperBound = 0;
            for (n5 = n10; n5 < n7; n5 += n9) {
                nArray = bufferedImage.getRaster().getPixel(n12, n5, (int[])null);
                n4 = nArray[0];
                if (bl && n4 < n8 || !bl && n4 > n8) break;
                this.upperBound = n5;
            }
            this.lowerBound = n7 - 1;
            for (n5 = n7 - n10 - 1; n5 > 0; n5 -= n9) {
                nArray = bufferedImage.getRaster().getPixel(n12, n5, (int[])null);
                n4 = nArray[0];
                if (bl && n4 < n8 || !bl && n4 > n8) break;
                this.lowerBound = n5;
            }
            if (this.upperBound > this.lowerBound) {
                this.upperBound = 0;
                this.lowerBound = n7 - 1;
            }
            int n13 = (int)((double)n6 * this.samplingFactorFractionOfDimension);
            this.leftBound = 0;
            this.rightBound = n6 - 1;
            n4 = this.upperBound > n10 ? this.upperBound : n10;
            int n14 = n3 = this.lowerBound < n7 - n10 - 1 ? this.lowerBound : n7 - n10 - 1;
            if (n4 < n3) {
                int n15 = bl2 ? n6 - n11 - 1 : n11;
                for (int i = n11; i < n6; i += n13) {
                    boolean bl3 = false;
                    int n16 = bl2 ? n6 - i - 1 : i;
                    for (n5 = n4; n5 <= n3 && !bl3; n5 += n9) {
                        int[] nArray2 = bufferedImage.getRaster().getPixel(n16, n5, (int[])null);
                        int n17 = nArray2[0];
                        if ((!bl || n17 >= n8) && (bl || n17 <= n8)) continue;
                        bl3 = true;
                    }
                    if (!bl3) {
                        if (bl2) {
                            this.leftBound = n15;
                            break;
                        }
                        this.rightBound = n15;
                        break;
                    }
                    n15 = n16;
                }
            }
            if (this.upperBound > n9) {
                this.upperBound -= n9;
            }
            if (this.lowerBound < n7 - n9 - 1) {
                this.lowerBound += n9;
            }
            if (bl2) {
                if (this.leftBound > n13) {
                    this.leftBound -= n13;
                }
            } else if (this.rightBound < n7 - n9 - 1) {
                this.rightBound += n9;
            }
            this.horizontalExtentInMm = (double)(this.rightBound - this.leftBound) * d;
            this.verticalExtentInMm = (double)(this.lowerBound - this.upperBound) * d;
        }
    }

    private class FlipAsNecessary {
        private BufferedImage img;
        private String rowOrientation;
        private String columnOrientation;
        private AffineTransform transform;

        FlipAsNecessary(BufferedImage bufferedImage, String[] stringArray, String string, String string2, boolean bl) {
            this.img = bufferedImage;
            this.rowOrientation = stringArray != null ? stringArray[0] : null;
            this.columnOrientation = stringArray != null ? stringArray[1] : null;
            this.transform = new AffineTransform();
            if (bl) {
                return;
            }
            if (this.rowOrientation != null && this.rowOrientation.indexOf("P") == -1 && this.rowOrientation.indexOf("A") == -1) {
                String string3 = this.rowOrientation;
                this.rowOrientation = this.columnOrientation;
                this.columnOrientation = string3;
                System.err.println("FlipAsNecessary(): swapping rows and columns");
                this.img = BufferedImageUtilities.rotateAndFlipSwappingRowsAndColumns(bufferedImage);
                this.transform.concatenate(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
            }
            if (this.rowOrientation != null && string2 != null && (string2.equals("R") && this.rowOrientation.indexOf("P") == -1 || string2.equals("L") && this.rowOrientation.indexOf("A") == -1)) {
                System.err.println("FlipAsNecessary(): flipping horizontally");
                BufferedImageUtilities.flipHorizontally(bufferedImage);
                this.rowOrientation = MammoImageViewer.invertOrientation(this.rowOrientation);
                this.transform.concatenate(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, bufferedImage.getWidth() - 1, 0.0f));
            }
            if (this.columnOrientation != null && string2 != null && string != null) {
                boolean bl2 = false;
                if (string.equals("MLO") || string.equals("ML") || string.equals("LM") || string.equals("LMO") || string.equals("SIO")) {
                    if (this.columnOrientation.indexOf("F") == -1) {
                        System.err.println("FlipAsNecessary(): flipping vertically for lateral or oblique to put feet at bottom");
                        bl2 = true;
                    }
                } else if (this.columnOrientation.indexOf(string2) != -1) {
                    System.err.println("FlipAsNecessary(): flipping vertically to put laterality in axilla");
                    bl2 = true;
                }
                if (bl2) {
                    BufferedImageUtilities.flipVertically(bufferedImage);
                    this.columnOrientation = MammoImageViewer.invertOrientation(this.columnOrientation);
                    System.err.println("FlipAsNecessary(): WARNING: flipping vertically but supressing coordinate transform because does not work - check CAD locations, which may be wrong");
                }
            }
        }

        public BufferedImage getImage() {
            return this.img;
        }

        public String getRowOrientation() {
            return this.rowOrientation;
        }

        public String getColumnOrientation() {
            return this.columnOrientation;
        }

        public AffineTransform getTransform() {
            return this.transform;
        }
    }
}

