/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.event.GraphicDisplayChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SourceImageGraphicDisplaySelectorPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImageGraphicDisplaySelectorPanel.java,v 1.1 2008/09/03 01:16:54 dclunie Exp $";
    private EventContext eventContext;
    private ButtonGroup graphicDisplayButtons;
    private JRadioButton offButton;
    private JRadioButton onButton;
    private static final String onCommand = "ON";
    private static final String offCommand = "OFF";

    public void sendEventCorrespondingToCurrentButtonState() {
        String string = this.graphicDisplayButtons.getSelection().getActionCommand();
        boolean bl = string != null && string.equals(onCommand);
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new GraphicDisplayChangeEvent(this.eventContext, bl));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public SourceImageGraphicDisplaySelectorPanel(EventContext eventContext) {
        this.eventContext = eventContext;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel("Show overlays:"));
        this.graphicDisplayButtons = new ButtonGroup();
        GraphicDisplayActionListener graphicDisplayActionListener = new GraphicDisplayActionListener();
        this.offButton = new JRadioButton("off", false);
        this.offButton.setActionCommand(offCommand);
        this.offButton.setToolTipText("Do not display overlays");
        this.offButton.addActionListener(graphicDisplayActionListener);
        this.graphicDisplayButtons.add(this.offButton);
        jPanel.add(this.offButton);
        this.onButton = new JRadioButton("on", true);
        this.onButton.setActionCommand(onCommand);
        this.onButton.setToolTipText("Display overlays");
        this.onButton.addActionListener(graphicDisplayActionListener);
        this.graphicDisplayButtons.add(this.onButton);
        jPanel.add(this.onButton);
    }

    private class GraphicDisplayActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SourceImageGraphicDisplaySelectorPanel.this.sendEventCorrespondingToCurrentButtonState();
        }
    }
}

