/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.CompositeInstanceContext;
import com.pixelmed.dose.DeviceParticipant;
import com.pixelmed.dose.PersonParticipant;
import com.pixelmed.dose.RadiationDoseStructuredReport;
import com.pixelmed.dose.RadiationDoseStructuredReportFactory;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CTDose
implements RadiationDoseStructuredReport,
RadiationDoseStructuredReportFactory {
    protected String dlpTotal;
    protected int totalNumberOfIrradiationEvents;
    protected ScopeOfDoseAccummulation scopeOfDoseAccummulation;
    protected String scopeUID;
    protected ArrayList<CTDoseAcquisition> acquisitions;
    protected CommonDoseObserverContext observerContext;
    protected CompositeInstanceContext compositeInstanceContext;
    protected String startDateTime;
    protected String endDateTime;
    protected String description;
    protected String sourceSOPInstanceUID;
    protected StructuredReport sr;
    protected AttributeList list;

    public RadiationDoseStructuredReport makeRadiationDoseStructuredReportInstance(StructuredReport structuredReport) throws DicomException {
        return new CTDose(structuredReport);
    }

    public RadiationDoseStructuredReport makeRadiationDoseStructuredReportInstance(StructuredReport structuredReport, AttributeList attributeList) throws DicomException {
        return new CTDose(structuredReport, attributeList);
    }

    public RadiationDoseStructuredReport makeRadiationDoseStructuredReportInstance(AttributeList attributeList) throws DicomException {
        return new CTDose(attributeList);
    }

    public CTDose(StructuredReport structuredReport) throws DicomException {
        this.sr = structuredReport;
        this.list = null;
        this.acquisitions = new ArrayList();
        this.parseSRContent();
    }

    public CTDose(StructuredReport structuredReport, AttributeList attributeList) throws DicomException {
        this.sr = structuredReport;
        this.list = attributeList;
        this.acquisitions = new ArrayList();
        this.parseSRContent();
    }

    public CTDose(AttributeList attributeList) throws DicomException {
        this.list = attributeList;
        this.sr = new StructuredReport(attributeList);
        this.acquisitions = new ArrayList();
        this.parseSRContent();
    }

    public CTDose(String string, int n, ScopeOfDoseAccummulation scopeOfDoseAccummulation, String string2, String string3, String string4, String string5) {
        this.observerContext = null;
        this.compositeInstanceContext = null;
        this.dlpTotal = string;
        this.totalNumberOfIrradiationEvents = n;
        this.scopeOfDoseAccummulation = scopeOfDoseAccummulation;
        this.scopeUID = string2;
        this.acquisitions = new ArrayList();
        this.startDateTime = string3;
        this.endDateTime = string4;
        this.description = string5;
    }

    public CTDose(ScopeOfDoseAccummulation scopeOfDoseAccummulation, String string, String string2, String string3, String string4) {
        this.observerContext = null;
        this.compositeInstanceContext = null;
        this.dlpTotal = null;
        this.totalNumberOfIrradiationEvents = 0;
        this.scopeOfDoseAccummulation = scopeOfDoseAccummulation;
        this.scopeUID = string;
        this.acquisitions = new ArrayList();
        this.startDateTime = string2;
        this.endDateTime = string3;
        this.description = string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseSRContent() throws DicomException {
        CodedSequenceItem codedSequenceItem;
        if (this.sr == null) throw new DicomException("No SR content");
        ContentItem contentItem = (ContentItem)this.sr.getRoot();
        if (contentItem == null) throw new DicomException("No SR root node");
        if (!(contentItem instanceof ContentItemFactory.ContainerContentItem) || !contentItem.getConceptNameCodingSchemeDesignator().equals("DCM") || !contentItem.getConceptNameCodeValue().equals("113701")) throw new DicomException("SR document title is not X-Ray Radiation Dose Report");
        ContentItem contentItem2 = contentItem.getNamedChild("DCM", "121058");
        if (contentItem2 == null || !(contentItem2 instanceof ContentItemFactory.CodeContentItem)) throw new DicomException("SR procedure reported is missing or not correctly encoded");
        CodedSequenceItem codedSequenceItem2 = ((ContentItemFactory.CodeContentItem)contentItem2).getConceptCode();
        if (codedSequenceItem2 == null || !codedSequenceItem2.getCodingSchemeDesignator().equals("SRT") || !codedSequenceItem2.getCodeValue().equals("P5-08000")) throw new DicomException("SR procedure reported is not CT");
        this.startDateTime = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "113809");
        this.endDateTime = ContentItem.getSingleStringValueOrNullOfNamedChild(contentItem, "DCM", "113810");
        ContentItem contentItem3 = contentItem.getNamedChild("DCM", "113811");
        if (contentItem3 == null || !(contentItem3 instanceof ContentItemFactory.ContainerContentItem)) throw new DicomException("SR does not contain CT Accumulated Dose Data");
        ContentItem contentItem4 = contentItem3.getNamedChild("DCM", "113813");
        if (contentItem4 != null && contentItem4 instanceof ContentItemFactory.NumericContentItem) {
            codedSequenceItem = ((ContentItemFactory.NumericContentItem)contentItem4).getUnits();
            if (CTDoseAcquisition.checkUnitIs_mGycm(codedSequenceItem)) {
                this.dlpTotal = ((ContentItemFactory.NumericContentItem)contentItem4).getNumericValue();
            } else {
                System.err.println("CT Accumulated Dose Data DLP units are not mGy.cm - ignoring value");
            }
        } else {
            System.err.println("CT Accumulated Dose Data DLP not found");
        }
        contentItem4 = contentItem.getNamedChild("DCM", "113705");
        if (contentItem4 != null && contentItem4 instanceof ContentItemFactory.CodeContentItem) {
            ContentItem contentItem5;
            this.scopeOfDoseAccummulation = ScopeOfDoseAccummulation.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem4).getConceptCode());
            if (this.scopeOfDoseAccummulation != null && (contentItem5 = contentItem4.getNamedChild(codedSequenceItem = this.scopeOfDoseAccummulation.getCodedSequenceItemForUIDConcept())) != null && contentItem5 instanceof ContentItemFactory.UIDContentItem) {
                this.scopeUID = ((ContentItemFactory.UIDContentItem)contentItem5).getConceptValue();
            }
        }
        int n = contentItem.getChildCount();
        for (int i = 0; i < n; ++i) {
            ContentItem contentItem6 = (ContentItem)contentItem.getChildAt(i);
            if (contentItem6 == null || !contentItem6.getConceptNameCodingSchemeDesignator().equals("DCM") || !contentItem6.getConceptNameCodeValue().equals("113819")) continue;
            this.addAcquisition(new CTDoseAcquisition(this.scopeUID, contentItem6));
        }
        if (this.list == null) {
            this.getAttributeList();
        }
        if (this.list == null) return;
        this.description = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.StudyDescription);
        this.sourceSOPInstanceUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPInstanceUID);
    }

    public void addAcquisition(CTDoseAcquisition cTDoseAcquisition) {
        this.acquisitions.add(cTDoseAcquisition);
    }

    public CommonDoseObserverContext getObserverContext() {
        return this.observerContext;
    }

    public void setObserverContext(CommonDoseObserverContext commonDoseObserverContext) {
        this.observerContext = commonDoseObserverContext;
    }

    public CompositeInstanceContext getCompositeInstanceContext() {
        return this.compositeInstanceContext;
    }

    public void setCompositeInstanceContext(CompositeInstanceContext compositeInstanceContext) {
        this.compositeInstanceContext = compositeInstanceContext;
    }

    public String getDLPTotal() {
        return this.dlpTotal;
    }

    public void setDLPTotal(String string) {
        this.dlpTotal = string;
    }

    public int getTotalNumberOfIrradiationEvents() {
        return this.totalNumberOfIrradiationEvents == 0 ? this.acquisitions.size() : this.totalNumberOfIrradiationEvents;
    }

    public ScopeOfDoseAccummulation getScopeOfDoseAccummulation() {
        return this.scopeOfDoseAccummulation;
    }

    public String getScopeUID() {
        return this.scopeUID;
    }

    public int getNumberOfAcquisitions() {
        return this.acquisitions.size();
    }

    public CTDoseAcquisition getAcquisition(int n) {
        return this.acquisitions.get(n);
    }

    public String getDLPTotalFromAcquisitions() throws NumberFormatException {
        double d = 0.0;
        for (CTDoseAcquisition object2 : this.acquisitions) {
            String string;
            if (object2 == null || (string = object2.getDLP()) == null || string.length() <= 0) continue;
            try {
                d += Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(d);
        return string;
    }

    public boolean specifiedDLPTotalMatchesDLPTotalFromAcquisitions() {
        return this.dlpTotal != null && this.dlpTotal.equals(this.getDLPTotalFromAcquisitions()) || this.dlpTotal == null && this.getNumberOfAcquisitions() == 0;
    }

    public String getStartDateTime() {
        return this.startDateTime;
    }

    public String getEndDateTime() {
        return this.endDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceSOPInstanceUID() {
        return this.sourceSOPInstanceUID;
    }

    public void setSourceSOPInstanceUID(String string) {
        this.sourceSOPInstanceUID = string;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dose");
        Object object = "";
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.compositeInstanceContext != null) {
            AttributeList attributeList = this.compositeInstanceContext.getAttributeList();
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID);
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName);
            string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex);
            string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate);
            string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientAge);
            string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientWeight);
            string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSize);
            string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber);
        }
        stringBuffer.append("\t");
        stringBuffer.append("Patient ID=");
        stringBuffer.append((String)object);
        stringBuffer.append("\tName=");
        stringBuffer.append(string);
        stringBuffer.append("\tSex=");
        stringBuffer.append(string2);
        stringBuffer.append("\tDOB=");
        stringBuffer.append(string3);
        stringBuffer.append("\tAge=");
        stringBuffer.append(string4);
        stringBuffer.append("\tWeight=");
        stringBuffer.append(string5);
        stringBuffer.append(" kg");
        stringBuffer.append("\tHeight=");
        stringBuffer.append(string6);
        stringBuffer.append(" m");
        stringBuffer.append("\tAccession=");
        stringBuffer.append(string7);
        if (bl || this.startDateTime != null) {
            stringBuffer.append("\t");
            if (!bl2) {
                stringBuffer.append("Start=");
            }
            if (bl2 && this.startDateTime != null && this.startDateTime.length() > 0) {
                try {
                    object = new SimpleDateFormat("yyyyMMddHHmmss").parse(this.startDateTime);
                    string = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format((Date)object);
                    stringBuffer.append(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace(System.err);
                }
            } else {
                stringBuffer.append(this.startDateTime);
            }
        }
        if (bl && !bl2) {
            stringBuffer.append("\tEnd=");
            stringBuffer.append(this.endDateTime);
        }
        stringBuffer.append("\t");
        if (!bl2) {
            stringBuffer.append("Modality=");
        }
        stringBuffer.append("CT");
        stringBuffer.append("\t");
        if (!bl2) {
            stringBuffer.append("Description=");
        }
        stringBuffer.append(this.description);
        if (bl && !bl2) {
            stringBuffer.append("\tScope=");
            stringBuffer.append(this.scopeOfDoseAccummulation);
        }
        if (bl && !bl2) {
            stringBuffer.append("\tUID=");
            stringBuffer.append(this.scopeUID);
        }
        if (bl && !bl2) {
            stringBuffer.append("\tEvents=");
            stringBuffer.append(Integer.toString(this.getTotalNumberOfIrradiationEvents()));
        }
        stringBuffer.append("\tDLP Total=");
        stringBuffer.append(this.dlpTotal == null ? this.getDLPTotalFromAcquisitions() : this.dlpTotal);
        stringBuffer.append(" mGy.cm");
        stringBuffer.append("\n");
        if (bl) {
            for (int i = 0; i < this.acquisitions.size(); ++i) {
                stringBuffer.append(this.acquisitions.get(i).toString(bl2));
            }
        }
        return stringBuffer.toString();
    }

    public static String getHTMLTableHeaderRow() {
        return "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th></tr>\n";
    }

    public String getHTMLTableRow(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(CTDose.getHTMLTableHeaderRow());
        }
        stringBuffer.append("<tr>");
        String string = "";
        Object object = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (this.compositeInstanceContext != null) {
            AttributeList attributeList = this.compositeInstanceContext.getAttributeList();
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID);
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName);
            string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex);
            string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate);
            string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientAge);
            string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientWeight);
            string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSize);
            string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber);
        }
        stringBuffer.append("<td>");
        stringBuffer.append(string);
        stringBuffer.append("</td><td>");
        stringBuffer.append((String)object);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string2);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string3);
        stringBuffer.append("</td><td align=right>");
        stringBuffer.append(string4);
        stringBuffer.append("</td><td align=right>");
        stringBuffer.append(string5);
        stringBuffer.append("</td><td align=right>");
        stringBuffer.append(string6);
        stringBuffer.append("</td><td>");
        stringBuffer.append(string7);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        string = "";
        if (this.startDateTime != null && this.startDateTime.length() > 0) {
            try {
                object = new SimpleDateFormat("yyyyMMddHHmmss").parse(this.startDateTime);
                string = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format((Date)object);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace(System.err);
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("</td>");
        stringBuffer.append("<td>CT</td>");
        stringBuffer.append("<td>");
        stringBuffer.append(this.description);
        stringBuffer.append("</td>");
        stringBuffer.append("<td align=right>");
        stringBuffer.append(this.dlpTotal == null ? this.getDLPTotalFromAcquisitions() : this.dlpTotal);
        stringBuffer.append("</td>");
        stringBuffer.append("</tr>\n");
        if (bl && this.acquisitions != null) {
            int n;
            stringBuffer.append("<tr><td colspan=2></td><td colspan=10><table>");
            string = null;
            for (n = 0; n < this.acquisitions.size(); ++n) {
                if (string == null) {
                    string = this.acquisitions.get(n).getHTMLTableHeaderRow();
                    continue;
                }
                if (this.acquisitions.get(n).getAcquisitionParameters() == null) continue;
                string = this.acquisitions.get(n).getHTMLTableHeaderRow();
                break;
            }
            stringBuffer.append(string);
            for (n = 0; n < this.acquisitions.size(); ++n) {
                stringBuffer.append(this.acquisitions.get(n).getHTMLTableRow());
            }
            stringBuffer.append("</table></td></tr>\n");
        }
        return stringBuffer.toString();
    }

    public StructuredReport getStructuredReport() throws DicomException {
        if (this.sr == null) {
            PersonParticipant personParticipant;
            Object object2;
            Object object3;
            ContentItemFactory contentItemFactory;
            ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
            contentItemFactory2.getClass();
            ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory2.new ContentItemFactory.ContainerContentItem(null, null, new CodedSequenceItem("113701", "DCM", "X-Ray Radiation Dose Report"), true, "DCMR", "10011");
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory3.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("121058", "DCM", "Procedure reported"), new CodedSequenceItem("P5-08000", "SRT", "Computed Tomography X-Ray"));
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            contentItemFactory4.new ContentItemFactory.CodeContentItem(codeContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("G-C0E8", "SRT", "Has Intent"), new CodedSequenceItem("R-408C3", "SRT", "Diagnostic Intent"));
            if (this.observerContext != null) {
                object3 = this.observerContext.getRecordingDeviceObserverContext().getStructuredReportFragment();
                object2 = object3.keySet().iterator();
                while (object2.hasNext()) {
                    containerContentItem.addChild(object3.get((Object)object2.next()));
                }
            }
            if (this.startDateTime != null && this.startDateTime.trim().length() > 0) {
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                contentItemFactory5.new ContentItemFactory.DateTimeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("113809", "DCM", "Start of X-Ray Irradiation"), this.startDateTime);
            }
            if (this.endDateTime != null && this.endDateTime.trim().length() > 0) {
                ContentItemFactory contentItemFactory6 = contentItemFactory;
                contentItemFactory6.getClass();
                contentItemFactory6.new ContentItemFactory.DateTimeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("113810", "DCM", "End of X-Ray Irradiation"), this.endDateTime);
            }
            ContentItemFactory contentItemFactory7 = contentItemFactory;
            contentItemFactory7.getClass();
            object3 = contentItemFactory7.new ContentItemFactory.ContainerContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("113811", "DCM", "CT Accumulated Dose Data"), true, "DCMR", "10012");
            ContentItemFactory contentItemFactory8 = contentItemFactory;
            contentItemFactory8.getClass();
            contentItemFactory8.new ContentItemFactory.NumericContentItem((ContentItem)object3, "CONTAINS", new CodedSequenceItem("113812", "DCM", "Total Number of Irradiation Events"), Integer.toString(this.acquisitions.size()), new CodedSequenceItem("{events}", "UCUM", "1.8", "events"));
            ContentItemFactory contentItemFactory9 = contentItemFactory;
            contentItemFactory9.getClass();
            contentItemFactory9.new ContentItemFactory.NumericContentItem((ContentItem)object3, "CONTAINS", new CodedSequenceItem("113813", "DCM", "CT Dose Length Product Total"), this.dlpTotal == null ? this.getDLPTotalFromAcquisitions() : this.dlpTotal, new CodedSequenceItem("mGy.cm", "UCUM", "1.8", "mGy.cm"));
            for (CTDoseAcquisition object4 : this.acquisitions) {
                PersonParticipant personParticipant2;
                ContentItem contentItem;
                if (object4 == null || (contentItem = object4.getStructuredReportFragment(containerContentItem)) == null || this.observerContext == null) continue;
                DeviceParticipant deviceParticipant = this.observerContext.getDeviceParticipant();
                if (deviceParticipant != null) {
                    contentItem.addChild(deviceParticipant.getStructuredReportFragment());
                }
                if ((personParticipant2 = this.observerContext.getPersonParticipantAdministering()) == null) continue;
                contentItem.addChild(personParticipant2.getStructuredReportFragment());
            }
            ContentItemFactory contentItemFactory10 = contentItemFactory;
            contentItemFactory10.getClass();
            object2 = contentItemFactory10.new ContentItemFactory.CodeContentItem(containerContentItem, "HAS OBS CONTEXT", new CodedSequenceItem("113705", "DCM", "Scope of Accumulation"), this.scopeOfDoseAccummulation.getCodedSequenceItemForScopeConcept());
            ContentItemFactory contentItemFactory11 = contentItemFactory;
            contentItemFactory11.getClass();
            contentItemFactory11.new ContentItemFactory.UIDContentItem((ContentItem)object2, "HAS PROPERTIES", this.scopeOfDoseAccummulation.getCodedSequenceItemForUIDConcept(), this.scopeUID);
            ContentItemFactory contentItemFactory12 = contentItemFactory;
            contentItemFactory12.getClass();
            contentItemFactory12.new ContentItemFactory.CodeContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("113854", "DCM", "Source of Dose Information"), new CodedSequenceItem("113856", "DCM", "Automated Data Collection"));
            if (this.observerContext != null && (personParticipant = this.observerContext.getPersonParticipantAuthorizing()) != null) {
                containerContentItem.addChild(personParticipant.getStructuredReportFragment());
            }
            this.sr = new StructuredReport(containerContentItem);
            this.list = null;
        }
        return this.sr;
    }

    public AttributeList getAttributeList() throws DicomException {
        if (this.list == null) {
            StringAttribute stringAttribute;
            this.getStructuredReport();
            this.list = this.sr.getAttributeList();
            if (this.compositeInstanceContext != null) {
                this.list.putAll(this.compositeInstanceContext.getAttributeList());
            }
            if (this.description != null && this.list.get(TagFromName.StudyDescription) == null) {
                stringAttribute = new LongStringAttribute(TagFromName.StudyDescription);
                ((Attribute)stringAttribute).addValue(this.description);
                this.list.put(stringAttribute);
            }
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.88.67");
            this.list.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.Modality);
            ((Attribute)stringAttribute).addValue("SR");
            this.list.put(stringAttribute);
        }
        return this.list;
    }

    public void write(String string, String string2) throws DicomException, IOException {
        this.getAttributeList();
        Date date = new Date();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)stringAttribute).addValue(new SimpleDateFormat("yyyyMMdd").format(date));
        this.list.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)stringAttribute).addValue(new SimpleDateFormat("HHmmss.SSS").format(date));
        this.list.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)stringAttribute).addValue("1.3.6.1.4.1.5962.99.3");
        this.list.put(stringAttribute);
        this.list.insertSuitableSpecificCharacterSetForAllStringValues();
        this.list.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(this.list, "1.2.840.10008.1.2.1", string2);
        this.list.write(string);
    }

    public void write(String string) throws DicomException, IOException {
        this.write(string, "OURAETITLE");
    }
}

