/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;

public class CTPhantomType {
    private String description;
    public static final CTPhantomType HEAD16 = new CTPhantomType("HEAD16");
    public static final CTPhantomType BODY32 = new CTPhantomType("BODY32");

    private CTPhantomType() {
    }

    private CTPhantomType(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public static CTPhantomType selectFromDescription(String string) {
        CTPhantomType cTPhantomType = null;
        if (string != null) {
            if ((string = string.trim().toUpperCase()).equals(HEAD16.toString())) {
                cTPhantomType = HEAD16;
            } else if (string.equals(BODY32.toString())) {
                cTPhantomType = BODY32;
            }
        }
        return cTPhantomType;
    }

    public static CTPhantomType selectFromCode(CodedSequenceItem codedSequenceItem) {
        CTPhantomType cTPhantomType = null;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string2.equals("DCM") && string.equals("113690")) {
                cTPhantomType = HEAD16;
            } else if (string2.equals("DCM") && string.equals("113691")) {
                cTPhantomType = BODY32;
            }
        }
        return cTPhantomType;
    }

    public static CodedSequenceItem getCodedSequenceItem(CTPhantomType cTPhantomType) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (cTPhantomType != null) {
            if (cTPhantomType.equals(HEAD16)) {
                codedSequenceItem = new CodedSequenceItem("113690", "DCM", "IEC Head Dosimetry Phantom");
            } else if (cTPhantomType.equals(BODY32)) {
                codedSequenceItem = new CodedSequenceItem("113691", "DCM", "IEC Body Dosimetry Phantom");
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItem() throws DicomException {
        return CTPhantomType.getCodedSequenceItem(this);
    }
}

