/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.HexDump;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DeviceParticipant {
    protected String manufacturer;
    protected String modelName;
    protected String serialNumber;

    public DeviceParticipant(String string, String string2, String string3) {
        this.manufacturer = string;
        this.modelName = string2;
        this.serialNumber = string3;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public ContentItem getStructuredReportFragment() throws DicomException {
        ContentItemFactory contentItemFactory;
        ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
        contentItemFactory2.getClass();
        ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory2.new ContentItemFactory.CodeContentItem(null, "CONTAINS", new CodedSequenceItem("113876", "DCM", "Device Role in Procedure"), new CodedSequenceItem("113859", "DCM", "Irradiating Device"));
        if (this.manufacturer != null && this.manufacturer.trim().length() > 0) {
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            contentItemFactory3.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("113878", "DCM", "Device Manufacturer"), this.manufacturer);
        }
        if (this.modelName != null && this.modelName.trim().length() > 0) {
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            contentItemFactory4.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("113879", "DCM", "Device Model Name"), this.modelName);
        }
        if (this.serialNumber != null && this.serialNumber.trim().length() > 0) {
            ContentItemFactory contentItemFactory5 = contentItemFactory;
            contentItemFactory5.getClass();
            contentItemFactory5.new ContentItemFactory.TextContentItem(codeContentItem, "HAS PROPERTIES", new CodedSequenceItem("113880", "DCM", "Device Serial Number"), this.serialNumber);
        }
        return codeContentItem;
    }

    public static String getDeviceSerialNumberOrSuitableAlternative(AttributeList attributeList, boolean bl) {
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.DeviceSerialNumber);
        if (string == null || string.trim().length() == 0) {
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstitutionName);
            String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StationName);
            if (string2.length() > 0 || string3.length() > 0) {
                try {
                    byte[] byArray = (string2 + "|" + string3).getBytes("UTF8");
                    string = HexDump.byteArrayToHexString(MessageDigest.getInstance("SHA").digest(byArray));
                    if (bl) {
                        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.DeviceSerialNumber);
                        ((Attribute)longStringAttribute).addValue(string);
                        attributeList.put(longStringAttribute);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace(System.err);
                    string = null;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    noSuchAlgorithmException.printStackTrace(System.err);
                    string = null;
                }
                catch (DicomException dicomException) {
                    dicomException.printStackTrace(System.err);
                }
            }
        }
        return string;
    }
}

