/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;

public class ScopeOfDoseAccummulation {
    private String description;
    public static final ScopeOfDoseAccummulation STUDY = new ScopeOfDoseAccummulation("Study");
    public static final ScopeOfDoseAccummulation SERIES = new ScopeOfDoseAccummulation("Series");
    public static final ScopeOfDoseAccummulation PPS = new ScopeOfDoseAccummulation("Performed Procedure Step");
    public static final ScopeOfDoseAccummulation IRRADIATION_EVENT = new ScopeOfDoseAccummulation("Irradiation Event");

    private ScopeOfDoseAccummulation() {
    }

    private ScopeOfDoseAccummulation(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public static ScopeOfDoseAccummulation selectFromCode(CodedSequenceItem codedSequenceItem) {
        ScopeOfDoseAccummulation scopeOfDoseAccummulation = null;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string2.equals("DCM") && string.equals("113014")) {
                scopeOfDoseAccummulation = STUDY;
            } else if (string2.equals("DCM") && string.equals("113015")) {
                scopeOfDoseAccummulation = SERIES;
            } else if (string2.equals("DCM") && string.equals("113016")) {
                scopeOfDoseAccummulation = PPS;
            } else if (string2.equals("DCM") && string.equals("113852")) {
                scopeOfDoseAccummulation = IRRADIATION_EVENT;
            }
        }
        return scopeOfDoseAccummulation;
    }

    public static CodedSequenceItem getCodedSequenceItemForScopeConcept(ScopeOfDoseAccummulation scopeOfDoseAccummulation) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (scopeOfDoseAccummulation != null) {
            if (scopeOfDoseAccummulation.equals(STUDY)) {
                codedSequenceItem = new CodedSequenceItem("113014", "DCM", "Study");
            } else if (scopeOfDoseAccummulation.equals(SERIES)) {
                codedSequenceItem = new CodedSequenceItem("113015", "DCM", "Series");
            } else if (scopeOfDoseAccummulation.equals(PPS)) {
                codedSequenceItem = new CodedSequenceItem("113016", "DCM", "Performed Procedure Step");
            } else if (scopeOfDoseAccummulation.equals(IRRADIATION_EVENT)) {
                codedSequenceItem = new CodedSequenceItem("113852", "DCM", "Irradiation Event");
            }
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem getCodedSequenceItemForUIDConcept(ScopeOfDoseAccummulation scopeOfDoseAccummulation) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (scopeOfDoseAccummulation != null) {
            if (scopeOfDoseAccummulation.equals(STUDY)) {
                codedSequenceItem = new CodedSequenceItem("110180", "DCM", "Study Instance UID");
            } else if (scopeOfDoseAccummulation.equals(SERIES)) {
                codedSequenceItem = new CodedSequenceItem("112002", "DCM", "Series Instance UID");
            } else if (scopeOfDoseAccummulation.equals(PPS)) {
                codedSequenceItem = new CodedSequenceItem("121126", "DCM", "Performed Procedure Step SOP Instance UID");
            } else if (scopeOfDoseAccummulation.equals(IRRADIATION_EVENT)) {
                codedSequenceItem = new CodedSequenceItem("113853", "DCM", "Irradiation Event UID");
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItemForScopeConcept() throws DicomException {
        return ScopeOfDoseAccummulation.getCodedSequenceItemForScopeConcept(this);
    }

    public CodedSequenceItem getCodedSequenceItemForUIDConcept() throws DicomException {
        return ScopeOfDoseAccummulation.getCodedSequenceItemForUIDConcept(this);
    }
}

