/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.ftp;

import com.pixelmed.ftp.FTPApplicationProperties;
import com.pixelmed.ftp.FTPException;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPRemoteHostConfigurationDialog;
import com.pixelmed.ftp.FTPRemoteHostInformation;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

public class FTPClientApplicationConfigurationDialog {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/ftp/FTPClientApplicationConfigurationDialog.java,v 1.1 2010/11/15 20:30:23 dclunie Exp $";
    protected FTPRemoteHostInformation ftpRemoteHostInformation;
    protected FTPApplicationProperties ftpApplicationProperties;
    protected JTextField calledAETitleField;
    protected JTextField callingAETitleField;
    protected JTextField listeningPortField;
    Component componentToCenterDialogOver;
    JDialog dialog;

    protected String showInputDialogToSelectNetworkTargetByLocalName(Component component, FTPRemoteHostInformation fTPRemoteHostInformation, String string, String string2) {
        Set set;
        String string3 = null;
        if (fTPRemoteHostInformation != null && (set = fTPRemoteHostInformation.getListOfLocalNames()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string3 = (String)JOptionPane.showInputDialog(component, string, string2, 3, null, objectArray, null);
        }
        return string3;
    }

    public FTPClientApplicationConfigurationDialog(Component component, FTPRemoteHostInformation fTPRemoteHostInformation, FTPApplicationProperties fTPApplicationProperties) throws FTPException {
        this.ftpRemoteHostInformation = fTPRemoteHostInformation;
        this.ftpApplicationProperties = fTPApplicationProperties;
        this.componentToCenterDialogOver = component;
        this.dialog = new JDialog();
        this.dialog.setModal(true);
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.componentToCenterDialogOver);
        this.dialog.setDefaultCloseOperation(0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 20, 5, 20));
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(compoundBorder);
        JComponent jComponent = new JLabel("Our FTP properties:");
        jPanel.add(jComponent);
        jPanel.add(new JLabel(""));
        jComponent = new JPanel();
        jComponent.setBorder(compoundBorder);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(new JLabel("Remote FTP host network properties:"));
        JComponent jComponent2 = new JPanel();
        jComponent2.setLayout(new FlowLayout(1));
        Serializable serializable = new JButton("Add");
        ((JComponent)serializable).setToolTipText("Add a host to the list of remote FTP hosts");
        jComponent2.add((Component)serializable);
        ((AbstractButton)serializable).addActionListener(new AddRemoteHostActionListener());
        Serializable serializable2 = new JButton("Edit");
        serializable2.setToolTipText("Edit a host in the list of remote FTP hosts");
        jComponent2.add((Component)serializable2);
        serializable2.addActionListener(new EditRemoteHostActionListener());
        JButton jButton = new JButton("Remove");
        jButton.setToolTipText("Remove a host from the list of remote FTP hosts");
        jComponent2.add(jButton);
        jButton.addActionListener(new RemoveRemoteHostActionListener());
        serializable = new GridBagLayout();
        jComponent.setLayout((LayoutManager)((Object)serializable));
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 0;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 1.0;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagLayout)serializable).setConstraints(jPanel2, (GridBagConstraints)serializable2);
        jComponent.add(jPanel2);
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 1;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagLayout)serializable).setConstraints(jComponent2, (GridBagConstraints)serializable2);
        jComponent.add(jComponent2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.setBorder(compoundBorder);
        jComponent2 = new JButton("Done");
        jComponent2.setToolTipText("Finished edits, so reset application to use new configuration");
        jPanel2.add(jComponent2);
        ((AbstractButton)jComponent2).addActionListener(new DoneActionListener());
        jComponent2 = new JPanel();
        serializable = new GridBagLayout();
        jComponent2.setLayout((LayoutManager)((Object)serializable));
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 0;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 1.0;
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagLayout)serializable).setConstraints(jPanel, (GridBagConstraints)serializable2);
        jComponent2.add(jPanel);
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 1;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagLayout)serializable).setConstraints(jComponent, (GridBagConstraints)serializable2);
        jComponent2.add(jComponent);
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 2;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagLayout)serializable).setConstraints(jPanel2, (GridBagConstraints)serializable2);
        jComponent2.add(jPanel2);
        serializable = this.dialog.getContentPane();
        ((Container)serializable).add(jComponent2);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            System.err.println("properties=" + properties);
            FTPApplicationProperties fTPApplicationProperties = new FTPApplicationProperties(properties);
            FTPRemoteHostInformation fTPRemoteHostInformation = fTPApplicationProperties.getFTPRemoteHostInformation();
            new FTPClientApplicationConfigurationDialog(null, fTPRemoteHostInformation, fTPApplicationProperties);
            properties = fTPApplicationProperties.getProperties(properties);
            System.err.println("properties after=" + properties);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, "Edited and saved from user interface");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected class DoneActionListener
    implements ActionListener {
        protected DoneActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.err.println("ftpRemoteHostInformation after = \n" + FTPClientApplicationConfigurationDialog.this.ftpRemoteHostInformation);
            System.err.println("ftpApplicationProperties after = \n" + FTPClientApplicationConfigurationDialog.this.ftpApplicationProperties);
            FTPClientApplicationConfigurationDialog.this.dialog.dispose();
        }
    }

    protected class RemoveRemoteHostActionListener
    implements ActionListener {
        protected RemoveRemoteHostActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FTPRemoteHostInformation fTPRemoteHostInformation = FTPClientApplicationConfigurationDialog.this.ftpApplicationProperties.getFTPRemoteHostInformation();
                String string = FTPClientApplicationConfigurationDialog.this.showInputDialogToSelectNetworkTargetByLocalName(FTPClientApplicationConfigurationDialog.this.componentToCenterDialogOver, fTPRemoteHostInformation, "Select remote host to remove", "Remove");
                if (string != null && string.length() > 0) {
                    fTPRemoteHostInformation.remove(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class EditRemoteHostActionListener
    implements ActionListener {
        protected EditRemoteHostActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FTPRemoteHost fTPRemoteHost;
                FTPRemoteHostInformation fTPRemoteHostInformation = FTPClientApplicationConfigurationDialog.this.ftpApplicationProperties.getFTPRemoteHostInformation();
                String string = FTPClientApplicationConfigurationDialog.this.showInputDialogToSelectNetworkTargetByLocalName(FTPClientApplicationConfigurationDialog.this.componentToCenterDialogOver, fTPRemoteHostInformation, "Select remote host to edit", "Edit");
                if (string != null && string.length() > 0 && fTPRemoteHostInformation != null && (fTPRemoteHost = fTPRemoteHostInformation.getRemoteHost(string)) != null) {
                    fTPRemoteHostInformation.remove(string);
                    FTPRemoteHostConfigurationDialog fTPRemoteHostConfigurationDialog = new FTPRemoteHostConfigurationDialog(FTPClientApplicationConfigurationDialog.this.componentToCenterDialogOver, string, fTPRemoteHost);
                    string = fTPRemoteHostConfigurationDialog.getLocalName();
                    fTPRemoteHostInformation.add(string, fTPRemoteHostConfigurationDialog);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class AddRemoteHostActionListener
    implements ActionListener {
        protected AddRemoteHostActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FTPRemoteHostInformation fTPRemoteHostInformation = FTPClientApplicationConfigurationDialog.this.ftpApplicationProperties.getFTPRemoteHostInformation();
                FTPRemoteHostConfigurationDialog fTPRemoteHostConfigurationDialog = new FTPRemoteHostConfigurationDialog(FTPClientApplicationConfigurationDialog.this.componentToCenterDialogOver);
                String string = fTPRemoteHostConfigurationDialog.getLocalName();
                fTPRemoteHostInformation.remove(string);
                fTPRemoteHostInformation.add(string, fTPRemoteHostConfigurationDialog);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

