/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.ftp;

import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.ftp.FTPException;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPSecurityType;
import com.pixelmed.utils.MessageLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.swing.JProgressBar;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPFileSender {
    public FTPFileSender(FTPRemoteHost fTPRemoteHost, String[] stringArray, boolean bl, int n, MessageLogger messageLogger, JProgressBar jProgressBar) throws NoSuchAlgorithmException, IOException, Exception {
        this(fTPRemoteHost.getHost(), fTPRemoteHost.getUser(), fTPRemoteHost.getPassword(), fTPRemoteHost.getDirectory(), stringArray, fTPRemoteHost.getSecurity().equals(FTPSecurityType.TLS), bl, n, messageLogger, jProgressBar);
    }

    public FTPFileSender(String string, String string2, String string3, String string4, String[] stringArray, boolean bl, boolean bl2, int n) throws NoSuchAlgorithmException, IOException, FTPException {
        this(string, string2, string3, string4, stringArray, bl, bl2, n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPFileSender(String string, String string2, String string3, String string4, String[] stringArray, boolean bl, boolean bl2, int n, MessageLogger messageLogger, JProgressBar jProgressBar) throws NoSuchAlgorithmException, IOException, FTPException {
        FTPSClient fTPSClient;
        Object object = fTPSClient = bl ? new FTPSClient("TLS", false) : new FTPClient();
        if (n > 0) {
            fTPSClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.err)));
        }
        try {
            int n2;
            if (bl) {
                try {
                    if (n > 0) {
                        System.err.println("Trying to connect in explicit mode to " + string);
                    }
                    fTPSClient.connect(string);
                }
                catch (Exception exception) {
                    if (n > 0) {
                        exception.printStackTrace(System.err);
                    }
                    if (n > 0) {
                        System.err.println("Failed to connect in explicit mode to " + string + " so trying again in implicit mode on port 990");
                    }
                    fTPSClient = new FTPSClient("TLS", true);
                    fTPSClient.setDefaultPort(990);
                    if (n > 0) {
                        fTPSClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.err)));
                    }
                    fTPSClient.connect(string);
                }
            } else {
                fTPSClient.connect(string);
            }
            if (n > 0) {
                System.err.println("Connected to " + string);
            }
            if (n > 0) {
                System.err.print(fTPSClient.getReplyString());
            }
            if (!FTPReply.isPositiveCompletion((int)(n2 = fTPSClient.getReplyCode()))) {
                fTPSClient.disconnect();
                throw new FTPException("FTP server " + string + " refused connection");
            }
            if (bl) {
                fTPSClient.execPBSZ(0L);
                fTPSClient.execPROT("P");
            }
            if (!fTPSClient.login(string2, string3)) {
                fTPSClient.disconnect();
                throw new FTPException("FTP server " + string + " login failed");
            }
            fTPSClient.enterLocalPassiveMode();
            if (string4 != null && string4.length() > 0) {
                if (!fTPSClient.changeWorkingDirectory(string4)) {
                    fTPSClient.disconnect();
                    throw new FTPException("FTP server " + string + " cwd to " + string4 + " failed");
                }
                if (n > 0) {
                    System.err.println("Working directory is now " + fTPSClient.printWorkingDirectory());
                }
            }
            if (!fTPSClient.setFileType(2)) {
                fTPSClient.disconnect();
                throw new FTPException("FTP server " + string + " set file type to Binary failed");
            }
            ApplicationEventDispatcher applicationEventDispatcher = ApplicationEventDispatcher.getApplicationEventDispatcher();
            int n3 = stringArray.length;
            if (jProgressBar != null) {
                jProgressBar.setValue(0);
                jProgressBar.setMaximum(n3);
                jProgressBar.setStringPainted(true);
                jProgressBar.repaint();
            }
            int n4 = 0;
            for (String string5 : stringArray) {
                String string6;
                if (jProgressBar != null) {
                    jProgressBar.setValue(n4);
                    jProgressBar.setStringPainted(true);
                    jProgressBar.repaint();
                }
                File file = new File(string5);
                FileInputStream fileInputStream = new FileInputStream(file);
                String string7 = string6 = bl2 ? UUID.randomUUID().toString() : file.getName();
                if (n > 0) {
                    System.err.println("Attempting to store local " + string5 + " to remote " + string6);
                }
                if (!fTPSClient.storeFile(string6, (InputStream)fileInputStream)) {
                    fTPSClient.disconnect();
                    throw new FTPException("FTP server " + string + " file store of local " + string5 + " to remote " + string6 + " failed");
                }
                ((InputStream)fileInputStream).close();
                if (n > 0) {
                    System.err.println("Successfully stored local " + string5 + " to remote " + string6);
                }
                if (messageLogger != null) {
                    messageLogger.sendLn("Successfully stored local " + string5 + " to remote " + string6);
                }
                if (jProgressBar != null) {
                    jProgressBar.setValue(n3);
                    jProgressBar.setStringPainted(true);
                    jProgressBar.repaint();
                }
                if (applicationEventDispatcher != null) {
                    applicationEventDispatcher.processEvent(new StatusChangeEvent("Sent " + string5 + " to Registry"));
                }
                ++n4;
            }
            fTPSClient.logout();
        }
        finally {
            if (fTPSClient.isConnected()) {
                if (n > 0) {
                    System.err.println("FTPFileSender(): finally so disconnect");
                }
                fTPSClient.disconnect();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            if (string4.equals("-") || string4.equals(".")) {
                string4 = null;
            }
            boolean bl = stringArray[4].toUpperCase().trim().equals("SECURE");
            boolean bl2 = stringArray[5].toUpperCase().trim().equals("RANDOM");
            int n = new Integer(stringArray[6]);
            int n2 = stringArray.length - 7;
            String[] stringArray2 = new String[n2];
            System.arraycopy(stringArray, 7, stringArray2, 0, n2);
            new FTPFileSender(string, string2, string3, string4, stringArray2, bl, bl2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

