/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.ftp;

import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPSecurityType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class FTPRemoteHostConfigurationDialog
extends FTPRemoteHost {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/ftp/FTPRemoteHostConfigurationDialog.java,v 1.1 2010/11/15 20:30:23 dclunie Exp $";
    protected static final String badFieldString = "\\\\\\BAD\\\\\\";
    protected String localName;
    protected JTextField localNameField;
    protected JTextField hostField;
    protected JTextField userField;
    protected JTextField passwordField;
    protected JTextField directoryField;
    protected JMenu securityMenu;

    public String getLocalName() {
        return this.localName;
    }

    public FTPRemoteHostConfigurationDialog(Component component, String string, FTPRemoteHost fTPRemoteHost) {
        super(fTPRemoteHost);
        this.localName = string;
        this.doCommonConstructorStuff(component);
    }

    public FTPRemoteHostConfigurationDialog(String string, FTPRemoteHost fTPRemoteHost) {
        super(fTPRemoteHost);
        this.localName = string;
        this.doCommonConstructorStuff(null);
    }

    public FTPRemoteHostConfigurationDialog(Component component, String string) {
        this.localName = string;
        this.doCommonConstructorStuff(component);
    }

    public FTPRemoteHostConfigurationDialog(Component component) {
        this(component, null);
    }

    public FTPRemoteHostConfigurationDialog() {
        this.localName = null;
        this.doCommonConstructorStuff(null);
    }

    protected void doCommonConstructorStuff(Component component) {
        final JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo(component);
        this.localNameField = new JTextField();
        this.hostField = new JTextField();
        this.userField = new JTextField();
        this.passwordField = new JTextField();
        this.directoryField = new JTextField();
        this.securityMenu = new JMenu("select ...");
        Serializable serializable = new ButtonGroup();
        Object object = FTPSecurityType.getListOfTypesAsString();
        Object object2 = this.security == null ? object[0] : this.security.toString();
        this.securityMenu.setText((String)object2);
        if (object != null) {
            for (String string : object) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                this.securityMenu.add(jRadioButtonMenuItem);
                serializable.add(jRadioButtonMenuItem);
                if (string.equals(object2)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = ((JRadioButtonMenuItem)actionEvent.getSource()).getText();
                        FTPRemoteHostConfigurationDialog.this.security = FTPSecurityType.selectFromDescription(string);
                        FTPRemoteHostConfigurationDialog.this.securityMenu.setText(string);
                    }
                });
            }
        }
        this.localNameField.setText(this.localName);
        this.hostField.setText(this.host);
        this.userField.setText(this.user);
        this.passwordField.setText(this.password);
        this.directoryField.setText(this.directory);
        this.localNameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.hostField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.userField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.passwordField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.directoryField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        serializable = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 20, 5, 20));
        object = new JPanel(new GridLayout(0, 2));
        ((JComponent)object).setBorder((Border)((Object)serializable));
        object2 = new JLabel("Local name: ", 4);
        ((JComponent)object2).setToolTipText("The name by which we refer to this remote ftp host(which can be different from its network host name)");
        ((Container)object).add((Component)object2);
        ((Container)object).add(this.localNameField);
        object2 = new JLabel("Hostname or IP address: ", 4);
        ((JComponent)object2).setToolTipText("The remote host name within the current domain, or fully qualified hostname or the IPV4 address of the remote host");
        ((Container)object).add((Component)object2);
        ((Container)object).add(this.hostField);
        object2 = new JLabel("User: ", 4);
        ((JComponent)object2).setToolTipText("The user name to log in with");
        ((Container)object).add((Component)object2);
        ((Container)object).add(this.userField);
        object2 = new JLabel("Password: ", 4);
        ((JComponent)object2).setToolTipText("The password to log in with");
        ((Container)object).add((Component)object2);
        ((Container)object).add(this.passwordField);
        object2 = new JLabel("Directory: ", 4);
        ((JComponent)object2).setToolTipText("The directory to switch to");
        ((Container)object).add((Component)object2);
        ((Container)object).add(this.directoryField);
        object2 = new JLabel("Security: ", 4);
        ((JComponent)object2).setToolTipText("The security to use");
        ((Container)object).add((Component)object2);
        Object object3 = new JMenuBar();
        ((JMenuBar)object3).add(this.securityMenu);
        ((Container)object).add((Component)object3);
        object2 = new JPanel(new FlowLayout(1));
        object3 = new JButton("OK");
        ((JComponent)object3).setToolTipText("Accept remote host configuration");
        ((Container)object2).add((Component)object3);
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                FTPRemoteHostConfigurationDialog.this.localName = FTPRemoteHostConfigurationDialog.this.localNameField.getText().trim();
                if (FTPRemoteHostConfigurationDialog.this.localName.length() == 0 || FTPRemoteHostConfigurationDialog.this.localName.equals(FTPRemoteHostConfigurationDialog.badFieldString)) {
                    bl = false;
                    FTPRemoteHostConfigurationDialog.this.localNameField.setText(FTPRemoteHostConfigurationDialog.badFieldString);
                }
                FTPRemoteHostConfigurationDialog.this.host = FTPRemoteHostConfigurationDialog.this.hostField.getText().trim();
                if (FTPRemoteHostConfigurationDialog.this.host.length() == 0 || FTPRemoteHostConfigurationDialog.this.host.equals(FTPRemoteHostConfigurationDialog.badFieldString)) {
                    bl = false;
                    FTPRemoteHostConfigurationDialog.this.hostField.setText(FTPRemoteHostConfigurationDialog.badFieldString);
                }
                FTPRemoteHostConfigurationDialog.this.user = FTPRemoteHostConfigurationDialog.this.userField.getText().trim();
                if (FTPRemoteHostConfigurationDialog.this.user.length() == 0 || FTPRemoteHostConfigurationDialog.this.user.equals(FTPRemoteHostConfigurationDialog.badFieldString)) {
                    bl = false;
                    FTPRemoteHostConfigurationDialog.this.userField.setText(FTPRemoteHostConfigurationDialog.badFieldString);
                }
                FTPRemoteHostConfigurationDialog.this.password = FTPRemoteHostConfigurationDialog.this.passwordField.getText().trim();
                if (FTPRemoteHostConfigurationDialog.this.password.length() == 0 || FTPRemoteHostConfigurationDialog.this.password.equals(FTPRemoteHostConfigurationDialog.badFieldString)) {
                    bl = false;
                    FTPRemoteHostConfigurationDialog.this.passwordField.setText(FTPRemoteHostConfigurationDialog.badFieldString);
                }
                FTPRemoteHostConfigurationDialog.this.directory = FTPRemoteHostConfigurationDialog.this.directoryField.getText().trim();
                if (bl) {
                    jDialog.dispose();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "North");
        jPanel.add((Component)object2, "South");
        jDialog.getContentPane().add(jPanel);
        jDialog.getRootPane().setDefaultButton((JButton)object3);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 0) {
                throw new Exception("Argument list must be empty");
            }
            FTPRemoteHostConfigurationDialog fTPRemoteHostConfigurationDialog = new FTPRemoteHostConfigurationDialog();
            System.err.println("FTPRemoteHostConfigurationDialog.main(): result of dialog " + fTPRemoteHostConfigurationDialog);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

