/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.NetworkDefaultValues;
import com.pixelmed.network.PresentationAddress;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;

public class ApplicationEntityConfigurationDialog
extends ApplicationEntity {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/ApplicationEntityConfigurationDialog.java,v 1.4 2009/12/10 18:39:04 dclunie Exp $";
    protected String localName;
    protected JTextField localNameField;
    protected JTextField dicomAETitleField;
    protected JTextField hostnameField;
    protected JTextField portField;

    public String getLocalName() {
        return this.localName;
    }

    public static boolean isValidAETitle(String string) {
        boolean bl = true;
        if (string == null) {
            bl = false;
        } else if (string.length() == 0) {
            bl = false;
        } else if (string.length() > 16) {
            bl = false;
        } else if (string.trim().length() == 0) {
            bl = false;
        } else if (string.contains("\\")) {
            bl = false;
        } else {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2 = string.codePointAt(i);
                try {
                    Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n2);
                    if (unicodeBlock != Character.UnicodeBlock.BASIC_LATIN) {
                        bl = false;
                        continue;
                    }
                    if (!Character.isISOControl(n2)) continue;
                    bl = false;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public ApplicationEntityConfigurationDialog(Component component, String string, ApplicationEntity applicationEntity) {
        super(applicationEntity);
        this.localName = string;
        this.doCommonConstructorStuff(component);
    }

    public ApplicationEntityConfigurationDialog(String string, ApplicationEntity applicationEntity) {
        super(applicationEntity);
        this.localName = string;
        this.doCommonConstructorStuff(null);
    }

    public ApplicationEntityConfigurationDialog(Component component, String string) {
        super(NetworkDefaultValues.getDefaultApplicationEntityTitle(11112));
        this.presentationAddress = new PresentationAddress(NetworkDefaultValues.getUnqualifiedLocalHostName(), 11112);
        this.primaryDeviceType = NetworkDefaultValues.getDefaultPrimaryDeviceType();
        this.localName = string == null ? NetworkDefaultValues.getUnqualifiedLocalHostName() : string;
        this.doCommonConstructorStuff(component);
    }

    public ApplicationEntityConfigurationDialog(Component component) {
        this(component, null);
    }

    public ApplicationEntityConfigurationDialog() {
        super(NetworkDefaultValues.getDefaultApplicationEntityTitle(11112));
        this.presentationAddress = new PresentationAddress(NetworkDefaultValues.getUnqualifiedLocalHostName(), 11112);
        this.primaryDeviceType = NetworkDefaultValues.getDefaultPrimaryDeviceType();
        this.localName = NetworkDefaultValues.getUnqualifiedLocalHostName();
        this.doCommonConstructorStuff(null);
    }

    protected void doCommonConstructorStuff(Component component) {
        final JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        jDialog.setResizable(false);
        jDialog.setLocationRelativeTo(component);
        this.localNameField = new JTextField();
        this.dicomAETitleField = new JTextField();
        this.hostnameField = new JTextField();
        this.portField = new JTextField();
        this.localNameField.setText(this.localName);
        this.dicomAETitleField.setText(this.dicomAETitle);
        this.hostnameField.setText(this.presentationAddress.getHostname());
        this.portField.setText(Integer.toString(this.presentationAddress.getPort()));
        this.localNameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.dicomAETitleField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.hostnameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        this.portField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 20, 5, 20));
        JPanel jPanel = new JPanel(new GridLayout(4, 2));
        jPanel.setBorder(compoundBorder);
        JComponent jComponent = new JLabel("Local name: ", 4);
        jComponent.setToolTipText("The name by which we refer to this remote AE (which can be different from its AE Title)");
        jPanel.add(jComponent);
        jPanel.add(this.localNameField);
        jComponent = new JLabel("AE Title: ", 4);
        jComponent.setToolTipText("The Called AE Title of the remote AE (the AE Title that it expects to be called as)");
        jPanel.add(jComponent);
        jPanel.add(this.dicomAETitleField);
        jComponent = new JLabel("Hostname or IP address: ", 4);
        jComponent.setToolTipText("The remote host name within the current domain, or fully qualified hostname or the IPV4 address of the remote AE");
        jPanel.add(jComponent);
        jPanel.add(this.hostnameField);
        jComponent = new JLabel("Port: ", 4);
        jComponent.setToolTipText("The port on the remote host to connect to (the port that the remote AE listens for inbound connections from another AE)");
        jPanel.add(jComponent);
        jPanel.add(this.portField);
        jComponent = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton("OK");
        jButton.setToolTipText("Accept AE configuration");
        jComponent.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                ApplicationEntityConfigurationDialog.this.localName = ApplicationEntityConfigurationDialog.this.localNameField.getText();
                ApplicationEntityConfigurationDialog.this.dicomAETitle = ApplicationEntityConfigurationDialog.this.dicomAETitleField.getText();
                if (!ApplicationEntityConfigurationDialog.isValidAETitle(ApplicationEntityConfigurationDialog.this.dicomAETitle)) {
                    bl = false;
                    ApplicationEntityConfigurationDialog.this.dicomAETitleField.setText("\\\\\\BAD\\\\\\");
                }
                String string = ApplicationEntityConfigurationDialog.this.hostnameField.getText();
                int n = 0;
                try {
                    n = Integer.parseInt(ApplicationEntityConfigurationDialog.this.portField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    ApplicationEntityConfigurationDialog.this.portField.setText("\\\\\\BAD\\\\\\");
                }
                ApplicationEntityConfigurationDialog.this.presentationAddress = new PresentationAddress(string, n);
                if (bl) {
                    jDialog.dispose();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jComponent, "South");
        jDialog.getContentPane().add(jPanel2);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 0) {
                throw new Exception("Argument list must be empty");
            }
            ApplicationEntityConfigurationDialog applicationEntityConfigurationDialog = new ApplicationEntityConfigurationDialog();
            System.err.println("ApplicationEntityConfigurationDialog.main(): result of dialog " + applicationEntityConfigurationDialog);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

