/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.ApplicationEntityConfigurationDialog;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;

public class NetworkApplicationConfigurationDialog {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationConfigurationDialog.java,v 1.2 2010/04/30 21:25:25 dclunie Exp $";
    protected NetworkApplicationInformation networkApplicationInformation;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected JTextField calledAETitleField;
    protected JTextField callingAETitleField;
    protected JTextField listeningPortField;
    Component componentToCenterDialogOver;
    JDialog dialog;

    protected String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(Component component, NetworkApplicationInformation networkApplicationInformation, String string, String string2) {
        Set set;
        String string3 = null;
        if (networkApplicationInformation != null && (set = networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string3 = (String)JOptionPane.showInputDialog(component, string, string2, 3, null, objectArray, null);
        }
        return string3;
    }

    public NetworkApplicationConfigurationDialog(Component component, NetworkApplicationInformation networkApplicationInformation, NetworkApplicationProperties networkApplicationProperties) throws DicomNetworkException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        this.networkApplicationInformation = networkApplicationInformation;
        this.networkApplicationProperties = networkApplicationProperties;
        this.componentToCenterDialogOver = component;
        this.dialog = new JDialog();
        this.dialog.setModal(true);
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.componentToCenterDialogOver);
        this.dialog.setDefaultCloseOperation(0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 20, 5, 20));
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(compoundBorder);
        Object object5 = new JLabel("Our DICOM network properties:");
        jPanel.add((Component)object5);
        jPanel.add(new JLabel(""));
        try {
            object5 = NetworkInterface.getNetworkInterfaces();
            while (object5.hasMoreElements()) {
                object4 = (NetworkInterface)object5.nextElement();
                object3 = ((NetworkInterface)object4).getInetAddresses();
                while (object3.hasMoreElements()) {
                    serializable = object3.nextElement();
                    if (((InetAddress)serializable).isLoopbackAddress()) continue;
                    object2 = ((InetAddress)serializable).getCanonicalHostName();
                    jPanel.add(new JLabel((String)object2 + ": ", 4));
                    object = ((InetAddress)serializable).getHostAddress();
                    jPanel.add(new JLabel((String)object));
                }
            }
        }
        catch (SocketException socketException) {
            System.err.println(socketException);
        }
        object5 = new JLabel("Calling AE Title: ", 4);
        ((JComponent)object5).setToolTipText("The AE Title we use for ourselves when calling (initiating an association to) another AE");
        jPanel.add((Component)object5);
        this.callingAETitleField = new JTextField();
        this.callingAETitleField.setText(networkApplicationProperties.getCallingAETitle());
        jPanel.add(this.callingAETitleField);
        this.callingAETitleField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel("Called AE Title: ", 4);
        ((JComponent)object5).setToolTipText("The AE Title we expect to be called by (when accepting an association from) another AE; usually the same as the Calling AE Title");
        jPanel.add((Component)object5);
        this.calledAETitleField = new JTextField();
        this.calledAETitleField.setText(networkApplicationProperties.getCalledAETitle());
        jPanel.add(this.calledAETitleField);
        this.calledAETitleField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel("Listening port: ", 4);
        ((JComponent)object5).setToolTipText("The port on which we listen for inbound connections from another AE");
        jPanel.add((Component)object5);
        this.listeningPortField = new JTextField();
        this.listeningPortField.setText(Integer.toString(networkApplicationProperties.getListeningPort()));
        jPanel.add(this.listeningPortField);
        this.listeningPortField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JPanel();
        ((JComponent)object5).setBorder(compoundBorder);
        object4 = new JPanel(new GridLayout(1, 1));
        ((Container)object4).add(new JLabel("Remote AE DICOM network properties:"));
        object3 = new JPanel();
        ((Container)object3).setLayout(new FlowLayout(1));
        serializable = new JButton("Add");
        ((JComponent)serializable).setToolTipText("Add an AE to the list of remote Application Entities");
        ((Container)object3).add((Component)serializable);
        ((AbstractButton)serializable).addActionListener(new AddRemoteAEActionListener());
        object2 = new JButton("Edit");
        ((JComponent)object2).setToolTipText("Edit an AE in the list of remote Application Entities");
        ((Container)object3).add((Component)object2);
        ((AbstractButton)object2).addActionListener(new EditRemoteAEActionListener());
        object = new JButton("Remove");
        ((JComponent)object).setToolTipText("Remove an AE from the list of remote Application Entities");
        ((Container)object3).add((Component)object);
        ((AbstractButton)object).addActionListener(new RemoveRemoteAEActionListener());
        serializable = new GridBagLayout();
        ((Container)object5).setLayout((LayoutManager)((Object)serializable));
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object4, (GridBagConstraints)object2);
        ((Container)object5).add((Component)object4);
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object3, (GridBagConstraints)object2);
        ((Container)object5).add((Component)object3);
        object4 = new JPanel();
        ((Container)object4).setLayout(new FlowLayout(1));
        ((JComponent)object4).setBorder(compoundBorder);
        object3 = new JButton("Done");
        ((JComponent)object3).setToolTipText("Finished edits, so reset application to use new configuration");
        ((Container)object4).add((Component)object3);
        ((AbstractButton)object3).addActionListener(new DoneActionListener());
        object3 = new JPanel();
        serializable = new GridBagLayout();
        ((Container)object3).setLayout((LayoutManager)((Object)serializable));
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagLayout)serializable).setConstraints(jPanel, (GridBagConstraints)object2);
        ((Container)object3).add(jPanel);
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object5, (GridBagConstraints)object2);
        ((Container)object3).add((Component)object5);
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 2;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object4, (GridBagConstraints)object2);
        ((Container)object3).add((Component)object4);
        serializable = this.dialog.getContentPane();
        ((Container)serializable).add((Component)object3);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            System.err.println("properties=" + properties);
            NetworkApplicationProperties networkApplicationProperties = new NetworkApplicationProperties(properties);
            NetworkApplicationInformation networkApplicationInformation = networkApplicationProperties.getNetworkApplicationInformation();
            new NetworkApplicationConfigurationDialog(null, networkApplicationInformation, networkApplicationProperties);
            properties = networkApplicationProperties.getProperties(properties);
            System.err.println("properties after=" + properties);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected class DoneActionListener
    implements ActionListener {
        protected DoneActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            String string = NetworkApplicationConfigurationDialog.this.calledAETitleField.getText();
            if (!ApplicationEntityConfigurationDialog.isValidAETitle(string)) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.calledAETitleField.setText("\\\\\\BAD\\\\\\");
            }
            if (!ApplicationEntityConfigurationDialog.isValidAETitle(string = NetworkApplicationConfigurationDialog.this.callingAETitleField.getText())) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.callingAETitleField.setText("\\\\\\BAD\\\\\\");
            }
            int n = 0;
            try {
                n = Integer.parseInt(NetworkApplicationConfigurationDialog.this.listeningPortField.getText());
                if (n < 1024) {
                    bl = false;
                    NetworkApplicationConfigurationDialog.this.listeningPortField.setText("want >= 1024");
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.listeningPortField.setText("\\\\\\BAD\\\\\\");
            }
            if (bl) {
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setListeningPort(Integer.parseInt(NetworkApplicationConfigurationDialog.this.listeningPortField.getText()));
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setCalledAETitle(NetworkApplicationConfigurationDialog.this.calledAETitleField.getText());
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setCallingAETitle(NetworkApplicationConfigurationDialog.this.callingAETitleField.getText());
                Cursor cursor = NetworkApplicationConfigurationDialog.this.dialog.getCursor();
                NetworkApplicationConfigurationDialog.this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (NetworkApplicationConfigurationDialog.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                        ((NetworkApplicationInformationFederated)NetworkApplicationConfigurationDialog.this.networkApplicationInformation).removeAllSources();
                        ((NetworkApplicationInformationFederated)NetworkApplicationConfigurationDialog.this.networkApplicationInformation).startupAllKnownSourcesAndRegister(NetworkApplicationConfigurationDialog.this.networkApplicationProperties);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                NetworkApplicationConfigurationDialog.this.dialog.setCursor(cursor);
                NetworkApplicationConfigurationDialog.this.dialog.dispose();
            }
        }
    }

    protected class RemoveRemoteAEActionListener
    implements ActionListener {
        protected RemoveRemoteAEActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkApplicationInformation networkApplicationInformation = NetworkApplicationConfigurationDialog.this.networkApplicationProperties.getNetworkApplicationInformation();
                String string = NetworkApplicationConfigurationDialog.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver, networkApplicationInformation, "Select AE to remove", "Remove");
                if (string != null && string.length() > 0) {
                    networkApplicationInformation.remove(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class EditRemoteAEActionListener
    implements ActionListener {
        protected EditRemoteAEActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkApplicationInformation networkApplicationInformation = NetworkApplicationConfigurationDialog.this.networkApplicationProperties.getNetworkApplicationInformation();
                String string = NetworkApplicationConfigurationDialog.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver, networkApplicationInformation, "Select AE to edit", "Edit");
                if (string != null && string.length() > 0) {
                    ApplicationEntity applicationEntity;
                    Set set = networkApplicationInformation.getListOfLocalNamesOfApplicationEntities();
                    ApplicationEntityMap applicationEntityMap = networkApplicationInformation.getApplicationEntityMap();
                    String string2 = networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                    if (applicationEntityMap != null && string2 != null && string2.length() > 0 && (applicationEntity = (ApplicationEntity)applicationEntityMap.get(string2)) != null) {
                        networkApplicationInformation.remove(string);
                        ApplicationEntityConfigurationDialog applicationEntityConfigurationDialog = new ApplicationEntityConfigurationDialog(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver, string, applicationEntity);
                        string = applicationEntityConfigurationDialog.getLocalName();
                        networkApplicationInformation.add(string, applicationEntityConfigurationDialog);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class AddRemoteAEActionListener
    implements ActionListener {
        protected AddRemoteAEActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkApplicationInformation networkApplicationInformation = NetworkApplicationConfigurationDialog.this.networkApplicationProperties.getNetworkApplicationInformation();
                ApplicationEntityConfigurationDialog applicationEntityConfigurationDialog = new ApplicationEntityConfigurationDialog(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver);
                String string = applicationEntityConfigurationDialog.getLocalName();
                networkApplicationInformation.remove(string);
                networkApplicationInformation.add(string, applicationEntityConfigurationDialog);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

