/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.network.PresentationAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimerTask;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class NetworkConfigurationFromLDAP
extends NetworkConfigurationSource {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkConfigurationFromLDAP.java,v 1.4 2008/09/24 18:54:53 dclunie Exp $";
    private static final String defaultInitialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String defaultProviderURL = "ldap://";
    private static final String defaultdevicesDN = "cn=Devices,cn=DICOM Configuration,o=pixelmed,c=us";
    private static final String devicesRDN = "cn=Devices";
    protected GetNetworkApplicationInformation getter;

    private String getDicomDevicesRootDistinguishedName(DirContext dirContext) {
        Object object;
        String string = null;
        try {
            if (this.debugLevel > 2) {
                System.err.println("getDicomDevicesRootDistinguishedName: name of context = " + dirContext.getNameInNamespace());
            }
            object = new SearchControls();
            ((SearchControls)object).setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search("", "(cn=DICOM Configuration)", (SearchControls)object);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                string = searchResult.getName();
                if (this.debugLevel <= 1) continue;
                System.err.println("getDicomDevicesRootDistinguishedName: found " + string);
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace(System.err);
        }
        object = null;
        if (string == null) {
            object = defaultdevicesDN;
            if (this.debugLevel > 1) {
                System.err.println("getDicomDevicesRootDistinguishedName: not found  - using default name = " + (String)object);
            }
        } else {
            object = "cn=Devices," + string;
        }
        return object;
    }

    public void activateDiscovery(int n) {
        if (n == 0) {
            this.getNetworkConfiguration();
        } else {
            if (this.getter == null) {
                this.getter = new GetNetworkApplicationInformation(n);
            }
            this.getter.start();
        }
    }

    public void deActivateDiscovery() {
        if (this.getter != null) {
            this.getter.cancel();
        }
    }

    protected void getNetworkConfiguration() {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", defaultInitialContextFactory);
            hashtable.put("java.naming.provider.url", defaultProviderURL);
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string = this.getDicomDevicesRootDistinguishedName(initialDirContext);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string, null);
            while (namingEnumeration.hasMore()) {
                String string2;
                String string3;
                Attributes attributes = namingEnumeration.next().getAttributes();
                BasicAttribute basicAttribute = (BasicAttribute)attributes.get("dicomDeviceName");
                String string4 = string3 = basicAttribute == null ? "" : basicAttribute.get(0).toString();
                if (this.debugLevel > 1) {
                    System.err.println("dicomDeviceName: " + string3);
                }
                if (basicAttribute == null) continue;
                HashMap<String, PresentationAddress> hashMap = new HashMap<String, PresentationAddress>();
                ArrayList<ApplicationEntityWithDicomNetworkConnectionName> arrayList = new ArrayList<ApplicationEntityWithDicomNetworkConnectionName>();
                NamingEnumeration<SearchResult> namingEnumeration2 = initialDirContext.search("dicomDeviceName=" + string3 + "," + string, null);
                while (namingEnumeration2.hasMore()) {
                    String string5;
                    Object object;
                    BasicAttribute basicAttribute2;
                    String string6;
                    String string7;
                    BasicAttribute basicAttribute3;
                    Attributes attributes2 = namingEnumeration2.next().getAttributes();
                    BasicAttribute basicAttribute4 = (BasicAttribute)attributes2.get("objectClass");
                    String string8 = string2 = basicAttribute4 == null ? "" : basicAttribute4.get(0).toString();
                    if (this.debugLevel > 1) {
                        System.err.println("\tvObjectClass: " + string2);
                    }
                    if (string2 == null) continue;
                    if (string2.equals("dicomNetworkAE")) {
                        basicAttribute3 = (BasicAttribute)attributes2.get("dicomAETitle");
                        String string9 = string7 = basicAttribute3 == null ? "" : basicAttribute3.get(0).toString();
                        if (this.debugLevel > 1) {
                            System.err.println("\t\tdicomAETitle: " + string7);
                        }
                        String string10 = string6 = (basicAttribute2 = (BasicAttribute)attributes2.get("dicomNetworkConnectionReference")) == null ? "" : basicAttribute2.get(0).toString();
                        if (this.debugLevel > 1) {
                            System.err.println("\t\tdicomNetworkConnectionReference: " + string6);
                        }
                        object = null;
                        if (string6 != null) {
                            int n = string6.indexOf(",");
                            if (n >= 0) {
                                string6 = string6.substring(0, n);
                                if (this.debugLevel > 1) {
                                    System.err.println("\t\tdicomNetworkConnectionReference first part: " + string6);
                                }
                            }
                            object = string6.replaceFirst("[cC][nN]=", "");
                            if (this.debugLevel > 1) {
                                System.err.println("\t\tdicomNetworkConnectionCommonNameValue: " + (String)object);
                            }
                        }
                        if (string7 == null || string7.length() <= 0 || object == null || ((String)object).length() <= 0) continue;
                        arrayList.add(new ApplicationEntityWithDicomNetworkConnectionName(string7, (String)object));
                        continue;
                    }
                    if (!string2.equals("dicomNetworkConnection")) continue;
                    basicAttribute3 = (BasicAttribute)attributes2.get("cn");
                    String string11 = string7 = basicAttribute3 == null ? "" : basicAttribute3.get(0).toString();
                    if (this.debugLevel > 1) {
                        System.err.println("\t\tcn: " + string7);
                    }
                    String string12 = string6 = (basicAttribute2 = (BasicAttribute)attributes2.get("dicomHostname")) == null ? "" : basicAttribute2.get(0).toString();
                    if (this.debugLevel > 1) {
                        System.err.println("\t\tdicomHostname: " + string6);
                    }
                    String string13 = string5 = (object = (BasicAttribute)attributes2.get("dicomPort")) == null ? "" : ((BasicAttribute)object).get(0).toString();
                    if (this.debugLevel > 1) {
                        System.err.println("\t\tdicomPort: " + string5);
                    }
                    if (string7 == null || string7.length() <= 0 || string6 == null || string6.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    hashMap.put(string7, new PresentationAddress(string6, Integer.parseInt(string5)));
                }
                for (ApplicationEntityWithDicomNetworkConnectionName applicationEntityWithDicomNetworkConnectionName : arrayList) {
                    string2 = applicationEntityWithDicomNetworkConnectionName.getDicomNetworkConnectionName();
                    applicationEntityWithDicomNetworkConnectionName.setPresentationAddress((PresentationAddress)hashMap.get(string2));
                    this.getNetworkApplicationInformation().add(string2, applicationEntityWithDicomNetworkConnectionName);
                }
                for (ApplicationEntity applicationEntity : arrayList) {
                    if (this.debugLevel <= 1) continue;
                    System.err.println("\tApplicationEntity: " + applicationEntity);
                }
            }
        }
        catch (CommunicationException communicationException) {
            if (this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromLDAP.getNetworkConfiguration(): LDAP service not available (Could not contact server)");
            }
            if (this.debugLevel > 2) {
                communicationException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public NetworkConfigurationFromLDAP(int n) {
        super(n);
    }

    public static void main(String[] stringArray) {
        NetworkConfigurationFromLDAP networkConfigurationFromLDAP = new NetworkConfigurationFromLDAP(99);
        networkConfigurationFromLDAP.activateDiscovery(5000);
        networkConfigurationFromLDAP.activateDumper(1000);
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            networkConfigurationFromLDAP.close();
            return;
        }
    }

    protected class GetNetworkApplicationInformation
    extends TimerTask {
        private int interval;

        GetNetworkApplicationInformation(int n) {
            this.interval = n;
        }

        public void run() {
            NetworkConfigurationFromLDAP.this.getNetworkApplicationInformation().removeAll();
            NetworkConfigurationFromLDAP.this.getNetworkConfiguration();
        }

        void start() {
            NetworkConfigurationFromLDAP.this.timer.schedule((TimerTask)this, 0L, (long)this.interval);
        }
    }

    private class ApplicationEntityWithDicomNetworkConnectionName
    extends ApplicationEntity {
        private String dicomNetworkConnectionName;

        ApplicationEntityWithDicomNetworkConnectionName(String string, String string2) {
            super(string);
            this.dicomNetworkConnectionName = string2;
        }

        public final String getDicomNetworkConnectionName() {
            return this.dicomNetworkConnectionName;
        }
    }
}

