/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeListTableBrowser;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class QueryTreeBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/QueryTreeBrowser.java,v 1.14 2010/11/27 20:53:40 dclunie Exp $";
    private JTree tree;
    private QueryTreeModel treeModel;
    private QueryInformationModel queryInformationModel;

    public QueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
        this.queryInformationModel = queryInformationModel;
        this.treeModel = queryTreeModel;
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        jScrollPane.setViewportView(this.tree);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedLevel());
    }

    public QueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, Container container) throws DicomException {
        this.queryInformationModel = queryInformationModel;
        this.treeModel = queryTreeModel;
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JScrollPane jScrollPane2 = new JScrollPane();
        final JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.7);
        jSplitPane.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                jSplitPane.setDividerLocation(1.0);
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        container.add(jSplitPane);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedLevel());
    }

    public QueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, JFrame jFrame) throws DicomException {
        this(queryInformationModel, queryTreeModel, jFrame.getContentPane());
    }

    public QueryTreeRecord[] getSelectionPaths() {
        Object[] objectArray;
        ArrayList<QueryTreeRecord> arrayList = new ArrayList<QueryTreeRecord>();
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (treeSelectionModel != null && (objectArray = treeSelectionModel.getSelectionPaths()) != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                Object object2;
                if (object == null || !((object2 = ((TreePath)object).getLastPathComponent()) instanceof QueryTreeRecord)) continue;
                QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object2;
                arrayList.add(queryTreeRecord);
            }
        }
        objectArray = new QueryTreeRecord[arrayList.size()];
        return (QueryTreeRecord[])arrayList.toArray(objectArray);
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                    QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                }
            }
        };
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(final JScrollPane jScrollPane) {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                QueryTreeRecord queryTreeRecord;
                AttributeList attributeList;
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord && (attributeList = (queryTreeRecord = (QueryTreeRecord)object).getAllAttributesReturnedInIdentifier()) != null) {
                    HashSet hashSet = null;
                    HashSet hashSet2 = null;
                    AttributeListTableBrowser attributeListTableBrowser = new AttributeListTableBrowser(attributeList, hashSet, hashSet2);
                    attributeListTableBrowser.setAutoResizeMode(0);
                    attributeListTableBrowser.setColumnWidths();
                    jScrollPane.setViewportView(attributeListTableBrowser);
                }
            }
        };
    }
}

