/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.LongTextAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.query.QueryInformationModel;
import java.util.HashSet;

public class StudyRootQueryInformationModel
extends QueryInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/StudyRootQueryInformationModel.java,v 1.21 2010/01/31 11:59:07 dclunie Exp $";
    private static HashSet useForStudy;
    private static HashSet useForSeries;
    private static HashSet useForInstance;

    public StudyRootQueryInformationModel(String string, int n, String string2, String string3, int n2) {
        super(string, n, string2, string3, n2);
        if (useForStudy == null) {
            useForStudy = new HashSet();
            useForStudy.add(InformationEntity.PATIENT);
            useForStudy.add(InformationEntity.STUDY);
        }
        if (useForSeries == null) {
            useForSeries = new HashSet();
            useForSeries.add(InformationEntity.SERIES);
            useForSeries.add(InformationEntity.PROCEDURESTEP);
        }
        if (useForInstance == null) {
            useForInstance = new HashSet();
            useForInstance.add(InformationEntity.INSTANCE);
            useForInstance.add(InformationEntity.CONCATENATION);
        }
    }

    protected InformationEntity getRoot() {
        return InformationEntity.STUDY;
    }

    protected InformationEntity getChildTypeForParent(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.STUDY) {
            return InformationEntity.SERIES;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return InformationEntity.INSTANCE;
        }
        return null;
    }

    protected HashSet getAllInformationEntitiesToIncludeAtThisQueryLevel(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.STUDY) {
            return useForStudy;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return useForSeries;
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return useForInstance;
        }
        return null;
    }

    protected String getFindSOPClassUID() {
        return "1.2.840.10008.5.1.4.1.2.2.1";
    }

    protected String getMoveSOPClassUID() {
        return "1.2.840.10008.5.1.4.1.2.2.2";
    }

    protected String getStringValueForTreeFromResponseIdentifier(InformationEntity informationEntity, AttributeList attributeList) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = informationEntity.toString();
        if (informationEntity == InformationEntity.INSTANCE && (string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID)) != null) {
            if (SOPClass.isImageStorage(string)) {
                string2 = "Image";
            } else if (SOPClass.isStructuredReport(string)) {
                string2 = "SR Document";
            } else if (SOPClass.isWaveform(string)) {
                string2 = "Waveform";
            } else if (SOPClass.isSpectroscopy(string)) {
                string2 = "Spectra";
            } else if (SOPClass.isRawData(string)) {
                string2 = "Raw Data";
            }
        }
        if (informationEntity == InformationEntity.STUDY) {
            stringBuffer.append(InformationEntity.PATIENT.toString());
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName));
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID));
            stringBuffer.append(" ");
            stringBuffer.append(InformationEntity.STUDY.toString());
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate));
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID));
            stringBuffer.append(" ");
            stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription));
        } else if (informationEntity == InformationEntity.SERIES) {
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(DescriptionFactory.makeSeriesDescription(attributeList));
        } else if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(DescriptionFactory.makeImageDescription(attributeList));
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"ISO_IR 100"};
            SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(stringArray2);
            AttributeList attributeList = new AttributeList();
            Object object = TagFromName.PatientName;
            Object object2 = new PersonNameAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientID;
            object2 = new ShortStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientBirthDate;
            object2 = new DateAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientSex;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientBirthTime;
            object2 = new TimeAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientComments;
            object2 = new LongTextAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.StudyID;
            object2 = new ShortStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.StudyDescription;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ModalitiesInStudy;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.StudyDate;
            object2 = new DateAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.StudyTime;
            object2 = new TimeAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ReferringPhysicianName;
            object2 = new PersonNameAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AccessionNumber;
            object2 = new ShortStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PhysiciansOfRecord;
            object2 = new PersonNameAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.NameOfPhysiciansReadingStudy;
            object2 = new PersonNameAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AdmittingDiagnosesDescription;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientAge;
            object2 = new AgeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientSize;
            object2 = new DecimalStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PatientWeight;
            object2 = new DecimalStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.Occupation;
            object2 = new ShortStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AdditionalPatientHistory;
            object2 = new LongTextAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SeriesDescription;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SeriesNumber;
            object2 = new IntegerStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.Modality;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SeriesDate;
            object2 = new DateAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SeriesTime;
            object2 = new TimeAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.PerformingPhysicianName;
            object2 = new PersonNameAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ProtocolName;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.OperatorsName;
            object2 = new PersonNameAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.Laterality;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.BodyPartExamined;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.Manufacturer;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ManufacturerModelName;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.StationName;
            object2 = new ShortStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.InstitutionName;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.InstitutionalDepartmentName;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.InstanceNumber;
            object2 = new IntegerStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ImageComments;
            object2 = new LongTextAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ContentDate;
            object2 = new DateAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ContentTime;
            object2 = new TimeAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ImageType;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AcquisitionNumber;
            object2 = new IntegerStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AcquisitionDate;
            object2 = new DateAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AcquisitionTime;
            object2 = new TimeAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.AcquisitionDateTime;
            object2 = new DateTimeAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.DerivationDescription;
            object2 = new ShortTextAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.QualityControlImage;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.BurnedInAnnotation;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.LossyImageCompression;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.LossyImageCompressionRatio;
            object2 = new DecimalStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.LossyImageCompressionMethod;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.ContrastBolusAgent;
            object2 = new LongStringAttribute((AttributeTag)object, specificCharacterSet);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.NumberOfFrames;
            object2 = new IntegerStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.StudyInstanceUID;
            object2 = new UniqueIdentifierAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SeriesInstanceUID;
            object2 = new UniqueIdentifierAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SOPInstanceUID;
            object2 = new UniqueIdentifierAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SOPClassUID;
            object2 = new UniqueIdentifierAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            object = TagFromName.SpecificCharacterSet;
            object2 = new CodeStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, (Attribute)object2);
            ((Attribute)object2).addValue(stringArray2[0]);
            object = new StudyRootQueryInformationModel(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], 1);
            object2 = ((QueryInformationModel)object).performHierarchicalQuery(attributeList);
            System.err.println("Tree=" + object2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

