/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTScanType;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTAcquisitionParameters
extends TestCase {
    public TestCTAcquisitionParameters(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTAcquisitionParameters");
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_WithAllParameters"));
        testSuite.addTest((Test)new TestCTAcquisitionParameters("TestCTAcquisitionParametersConstructor_Equality"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCTAcquisitionParametersConstructor_WithAllParameters() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1";
        String string3 = "750";
        String string4 = "0.625";
        String string5 = "40";
        String string6 = "0.984";
        String string7 = "120";
        String string8 = "397";
        String string9 = "433";
        String string10 = "0.6";
        String string11 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string11);
        CTScanType cTScanType = CTScanType.HELICAL;
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string2, string3, string4, string5, string6, string7, string8, string9, string10);
        String string12 = "\tIrradiationEventUID=" + string + "\tHelical\tAnatomy=" + codedSequenceItem + "\tScanningLength=" + string3 + " mm" + "\tCollimation single/total=" + string4 + "/" + string5 + " mm" + "\tPitchFactor=" + string6 + ":1" + "\tKVP=" + string7 + " kVP" + "\tTubeCurrent/Max=" + string8 + "/" + string9 + " mA" + "\tExposure time/per rotation=" + string2 + "/" + string10 + " s\n";
        String string13 = "\tHelical\t" + string11 + "\t" + string3 + " mm" + "\t" + string4 + "/" + string5 + " mm" + "\t" + string6 + ":1" + "\t" + string7 + " kVP" + "\t" + string8 + "/" + string9 + " mA" + "\t" + string2 + "/" + string10 + " s\n";
        String string14 = "<th>Type</th><th>Anatomy</th><th>Scanning Length mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th>";
        String string15 = "<td>Helical</td><td>Chest, Abdomen and Pelvis</td><td>750</td><td>0.625/40</td><td>0.984:1</td><td>120</td><td>397/433</td><td>1/0.6</td>";
        TestCTAcquisitionParameters.assertEquals((String)"Checking IrradiationEventUID equality", (String)string, (String)cTAcquisitionParameters.getIrradiationEventUID());
        TestCTAcquisitionParameters.assertEquals((String)"Checking Anatomy equality", (Object)codedSequenceItem, (Object)cTAcquisitionParameters.getAnatomy());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimeInSeconds equality", (String)string2, (String)cTAcquisitionParameters.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ScanningLengthInMM equality", (String)string3, (String)cTAcquisitionParameters.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalSingleCollimationWidthInMM equality", (String)string4, (String)cTAcquisitionParameters.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking NominalTotalCollimationWidthInMM equality", (String)string5, (String)cTAcquisitionParameters.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking PitchFactor equality", (String)string6, (String)cTAcquisitionParameters.getPitchFactor());
        TestCTAcquisitionParameters.assertEquals((String)"Checking KVP equality", (String)string7, (String)cTAcquisitionParameters.getKVP());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrent equality", (String)string8, (String)cTAcquisitionParameters.getTubeCurrent());
        TestCTAcquisitionParameters.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string9, (String)cTAcquisitionParameters.getTubeCurrentMaximum());
        TestCTAcquisitionParameters.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string10, (String)cTAcquisitionParameters.getExposureTimePerRotation());
        TestCTAcquisitionParameters.assertEquals((String)"Checking toString", (String)string12, (String)cTAcquisitionParameters.toString());
        TestCTAcquisitionParameters.assertEquals((String)"Checking toString pretty", (String)string13, (String)cTAcquisitionParameters.toString(true));
        TestCTAcquisitionParameters.assertEquals((String)"Checking getHTML header", (String)string14, (String)cTAcquisitionParameters.getHTMLTableHeaderRowFragment());
        TestCTAcquisitionParameters.assertEquals((String)"Checking getHTML", (String)string15, (String)cTAcquisitionParameters.getHTMLTableRowFragment());
        ContentItem contentItem = cTAcquisitionParameters.getStructuredReportFragment(null);
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(contentItem);
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip ExposureTimeInSeconds equality", (String)string2, (String)cTAcquisitionParameters2.getExposureTimeInSeconds());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip ScanningLengthInMM equality", (String)string3, (String)cTAcquisitionParameters2.getScanningLengthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip NominalSingleCollimationWidthInMM equality", (String)string4, (String)cTAcquisitionParameters2.getNominalSingleCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip NominalTotalCollimationWidthInMM equality", (String)string5, (String)cTAcquisitionParameters2.getNominalTotalCollimationWidthInMM());
        TestCTAcquisitionParameters.assertEquals((String)"Checking round trip PitchFactor equality", (String)string6, (String)cTAcquisitionParameters2.getPitchFactor());
    }

    public void TestCTAcquisitionParametersConstructor_Equality() throws Exception {
        String string = "1.2.3.4";
        String string2 = "1.2.3.5";
        String string3 = "1";
        String string4 = "750";
        String string5 = "0.625";
        String string6 = "40";
        String string7 = "0.984";
        String string8 = "120";
        String string9 = "397";
        String string10 = "433";
        String string11 = "0.6";
        String string12 = "Chest, Abdomen and Pelvis";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", string12);
        CTScanType cTScanType = CTScanType.HELICAL;
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        CTAcquisitionParameters cTAcquisitionParameters2 = new CTAcquisitionParameters(string, cTScanType, codedSequenceItem, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        CTAcquisitionParameters cTAcquisitionParameters3 = new CTAcquisitionParameters(string2, cTScanType, codedSequenceItem, string3, string4, string5, string6, string7, string8, string9, string10, string11);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality", (boolean)cTAcquisitionParameters.equals(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality apart from event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters2));
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters inequality with different event UID", (!cTAcquisitionParameters.equals(cTAcquisitionParameters3) ? 1 : 0) != 0);
        TestCTAcquisitionParameters.assertTrue((String)"Checking CTAcquisitionParameters equality apart from different event UID", (boolean)cTAcquisitionParameters.equalsApartFromIrradiationEventUID(cTAcquisitionParameters3));
    }
}

