/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.utils.FloatFormatter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTDoseAcquisition
extends TestCase {
    public TestCTDoseAcquisition(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTDoseAcquisition");
        testSuite.addTest((Test)new TestCTDoseAcquisition("TestCTDoseAcquisitionConstructor_WithAllParameters_Helical"));
        testSuite.addTest((Test)new TestCTDoseAcquisition("TestCTDoseAcquisitionConstructor_WithAllParameters_Axial"));
        testSuite.addTest((Test)new TestCTDoseAcquisition("TestCTDoseAcquisitionConstructor_WithAllParameters_AxialOnePosition"));
        testSuite.addTest((Test)new TestCTDoseAcquisition("TestCTDoseAcquisitionConstructor_WithAllParameters_WithAcquisitionParameterChildren"));
        testSuite.addTest((Test)new TestCTDoseAcquisition("TestCTDoseAcquisitionConstructor_WithAllParameters_StationaryBasedOnZeroPitchInAcquisitionParameterChildren"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCTDoseAcquisitionConstructor_WithAllParameters_Helical() throws Exception {
        String string = "1.2.3.4.5";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string, true, "1", CTScanType.HELICAL, new ScanRange("I", "12.750", "I", "602.750"), "15.51", "948.89", CTPhantomType.selectFromDescription("BODY32"));
        String string2 = "\tSeries=1\tHelical\tRange=I12.750-I602.750 mm\tCTDIvol=15.51 mGy\tDLP=948.89 mGy.cm\tPhantom=BODY32\n";
        String string3 = "\tSeries=1\tHelical\tI12.750-I602.750 mm\t15.51 mGy\t948.89 mGy.cm\tBODY32\n";
        String string4 = "<tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th></tr>\n";
        String string5 = "<tr><td>Series=1</td><td>Helical</td><td>I12.750-I602.750</td><td>15.51</td><td>948.89</td><td>BODY32</td></tr>\n";
        TestCTDoseAcquisition.assertEquals((String)"Checking SeriesNumber equality", (String)"1", (String)cTDoseAcquisition.getSeriesOrAcquisitionNumber());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType equality", (Object)CTScanType.HELICAL, (Object)cTDoseAcquisition.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType string equality", (String)"Helical", (String)cTDoseAcquisition.getScanType().toString());
        TestCTDoseAcquisition.assertTrue((String)"Checking ScanRange equality", (boolean)new ScanRange("I", "12.750", "I", "602.750").equals(cTDoseAcquisition.getScanRange()));
        TestCTDoseAcquisition.assertEquals((String)"Checking CTDIvol equality", (String)"15.51", (String)cTDoseAcquisition.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking DLP equality", (String)"948.89", (String)cTDoseAcquisition.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking CTPhantomType equality", (boolean)CTPhantomType.BODY32.equals(cTDoseAcquisition.getPhantomType()));
        TestCTDoseAcquisition.assertFalse((String)"Checking specified DLP does not equal DLP computed from range and CTDIvol due to overscan", (boolean)cTDoseAcquisition.specifiedDLPMatchesDLPFromRangeAndCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking toString", (String)string2, (String)cTDoseAcquisition.toString());
        TestCTDoseAcquisition.assertEquals((String)"Checking toString pretty", (String)string3, (String)cTDoseAcquisition.toString(true));
        TestCTDoseAcquisition.assertEquals((String)"Checking getHTML header", (String)string4, (String)cTDoseAcquisition.getHTMLTableHeaderRow());
        TestCTDoseAcquisition.assertEquals((String)"Checking getHTML", (String)string5, (String)cTDoseAcquisition.getHTMLTableRow());
        ContentItem contentItem = cTDoseAcquisition.getStructuredReportFragment(null);
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string, contentItem);
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTScanType equality", (Object)CTScanType.HELICAL, (Object)cTDoseAcquisition2.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTDIvol equality", (String)"15.51", (String)cTDoseAcquisition2.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip DLP equality", (String)"948.89", (String)cTDoseAcquisition2.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking round trip CTPhantomType equality", (boolean)CTPhantomType.BODY32.equals(cTDoseAcquisition2.getPhantomType()));
    }

    public void TestCTDoseAcquisitionConstructor_WithAllParameters_Axial() throws Exception {
        String string = "1.2.3.4.5";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string, true, "2", CTScanType.AXIAL, new ScanRange("I", "24.500", "S", "33.000"), "234.67", "1408.00", CTPhantomType.selectFromDescription("HEAD16"));
        String string2 = "\tSeries=2\tAxial\tRange=I24.500-S33.000 mm\tCTDIvol=234.67 mGy\tDLP=1408.00 mGy.cm\tPhantom=HEAD16\n";
        String string3 = "\tSeries=2\tAxial\tI24.500-S33.000 mm\t234.67 mGy\t1408.00 mGy.cm\tHEAD16\n";
        TestCTDoseAcquisition.assertEquals((String)"Checking SeriesNumber equality", (String)"2", (String)cTDoseAcquisition.getSeriesOrAcquisitionNumber());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType equality", (Object)CTScanType.AXIAL, (Object)cTDoseAcquisition.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType string equality", (String)"Axial", (String)cTDoseAcquisition.getScanType().toString());
        TestCTDoseAcquisition.assertTrue((String)"Checking ScanRange equality", (boolean)new ScanRange("I", "24.500", "S", "33.000").equals(cTDoseAcquisition.getScanRange()));
        TestCTDoseAcquisition.assertEquals((String)"Checking CTDIvol equality", (String)"234.67", (String)cTDoseAcquisition.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking DLP equality", (String)"1408.00", (String)cTDoseAcquisition.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking CTPhantomType equality", (boolean)CTPhantomType.HEAD16.equals(cTDoseAcquisition.getPhantomType()));
        TestCTDoseAcquisition.assertFalse((String)"Checking specified DLP does not equal DLP computed from range and CTDIvol due to slice thickness or spacing", (boolean)cTDoseAcquisition.specifiedDLPMatchesDLPFromRangeAndCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking toString", (String)string2, (String)cTDoseAcquisition.toString());
        TestCTDoseAcquisition.assertEquals((String)"Checking toString pretty", (String)string3, (String)cTDoseAcquisition.toString(true));
        ContentItem contentItem = cTDoseAcquisition.getStructuredReportFragment(null);
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string, contentItem);
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTScanType equality", (Object)CTScanType.AXIAL, (Object)cTDoseAcquisition2.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTDIvol equality", (String)"234.67", (String)cTDoseAcquisition2.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip DLP equality", (String)"1408.00", (String)cTDoseAcquisition2.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking round trip CTPhantomType equality", (boolean)CTPhantomType.HEAD16.equals(cTDoseAcquisition2.getPhantomType()));
    }

    public void TestCTDoseAcquisitionConstructor_WithAllParameters_AxialOnePosition() throws Exception {
        String string = "1.2.3.4.5";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string, true, "200", CTScanType.AXIAL, new ScanRange("I", "254.500", "I", "254.500"), "46.29", "23.10", CTPhantomType.selectFromDescription("BODY32"));
        String string2 = "\tSeries=200\tAxial\tRange=I254.500-I254.500 mm\tCTDIvol=46.29 mGy\tDLP=23.10 mGy.cm\tPhantom=BODY32\n";
        String string3 = "\tSeries=200\tAxial\tI254.500-I254.500 mm\t46.29 mGy\t23.10 mGy.cm\tBODY32\n";
        TestCTDoseAcquisition.assertEquals((String)"Checking SeriesNumber equality", (String)"200", (String)cTDoseAcquisition.getSeriesOrAcquisitionNumber());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType equality", (Object)CTScanType.AXIAL, (Object)cTDoseAcquisition.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType string equality", (String)"Axial", (String)cTDoseAcquisition.getScanType().toString());
        TestCTDoseAcquisition.assertTrue((String)"Checking ScanRange equality", (boolean)new ScanRange("I", "254.500", "I", "254.500").equals(cTDoseAcquisition.getScanRange()));
        TestCTDoseAcquisition.assertEquals((String)"Checking CTDIvol equality", (String)"46.29", (String)cTDoseAcquisition.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking DLP equality", (String)"23.10", (String)cTDoseAcquisition.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking CTPhantomType equality", (boolean)CTPhantomType.BODY32.equals(cTDoseAcquisition.getPhantomType()));
        TestCTDoseAcquisition.assertFalse((String)"Checking specified DLP does not equal DLP computed from range and CTDIvol due to slice thickness", (boolean)cTDoseAcquisition.specifiedDLPMatchesDLPFromRangeAndCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking toString", (String)string2, (String)cTDoseAcquisition.toString());
        TestCTDoseAcquisition.assertEquals((String)"Checking toString pretty", (String)string3, (String)cTDoseAcquisition.toString(true));
        ContentItem contentItem = cTDoseAcquisition.getStructuredReportFragment(null);
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string, contentItem);
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTScanType equality", (Object)CTScanType.AXIAL, (Object)cTDoseAcquisition2.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTDIvol equality", (String)"46.29", (String)cTDoseAcquisition2.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip DLP equality", (String)"23.10", (String)cTDoseAcquisition2.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking round trip CTPhantomType equality", (boolean)CTPhantomType.BODY32.equals(cTDoseAcquisition2.getPhantomType()));
    }

    public void TestCTDoseAcquisitionConstructor_WithAllParameters_WithAcquisitionParameterChildren() throws Exception {
        String string = "2";
        CTScanType cTScanType = CTScanType.HELICAL;
        ScanRange scanRange = new ScanRange("S", "14.250", "I", "635.750");
        String string2 = "20.23";
        String string3 = "1362.24";
        CTPhantomType cTPhantomType = CTPhantomType.selectFromDescription("BODY32");
        String string4 = "1.2.3.4.5";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string4, true, string, cTScanType, scanRange, string2, string3, cTPhantomType);
        String string5 = "1.2.3.4";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", "Chest, Abdomen and Pelvis");
        String string6 = "1";
        String string7 = "120";
        String string8 = "397";
        String string9 = "433";
        String string10 = "0.6";
        String string11 = "0.625";
        String string12 = "40";
        String string13 = "0.984";
        String string14 = FloatFormatter.toString(673.3761739990114);
        String string15 = "<tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th><th>Type</th><th>Anatomy</th><th>Scanning Length mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th></tr>\n";
        String string16 = "<tr><td>Series=2</td><td>Helical</td><td>S14.250-I635.750</td><td>20.23</td><td>1362.24</td><td>BODY32</td><td>Helical</td><td>Chest, Abdomen and Pelvis</td><td>673.4</td><td>0.625/40</td><td>0.984:1</td><td>120</td><td>397/433</td><td>1/0.6</td></tr>\n";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string5, cTScanType, codedSequenceItem, string6, null, string11, string12, string13, string7, string8, string9, string10);
        cTAcquisitionParameters.deriveScanningLengthFromDLPAndCTDIVol(string3, string2);
        cTDoseAcquisition.setAcquisitionParameters(cTAcquisitionParameters);
        TestCTDoseAcquisition.assertEquals((String)"Checking getHTML header", (String)string15, (String)cTDoseAcquisition.getHTMLTableHeaderRow());
        TestCTDoseAcquisition.assertEquals((String)"Checking getHTML", (String)string16, (String)cTDoseAcquisition.getHTMLTableRow());
        TestCTDoseAcquisition.assertEquals((String)"Checking SeriesNumber equality", (String)string, (String)cTDoseAcquisition.getSeriesOrAcquisitionNumber());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType equality", (Object)cTScanType, (Object)cTDoseAcquisition.getScanType());
        TestCTDoseAcquisition.assertTrue((String)"Checking ScanRange equality", (boolean)scanRange.equals(cTDoseAcquisition.getScanRange()));
        TestCTDoseAcquisition.assertEquals((String)"Checking CTDIvol equality", (String)string2, (String)cTDoseAcquisition.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking DLP equality", (String)string3, (String)cTDoseAcquisition.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking CTPhantomType equality", (boolean)cTPhantomType.equals(cTDoseAcquisition.getPhantomType()));
        TestCTDoseAcquisition.assertFalse((String)"Checking specified DLP does not equal DLP computed from range and CTDIvol due to slice thickness", (boolean)cTDoseAcquisition.specifiedDLPMatchesDLPFromRangeAndCTDIvol());
        ContentItem contentItem = cTDoseAcquisition.getStructuredReportFragment(null);
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string4, contentItem);
        CTAcquisitionParameters cTAcquisitionParameters2 = cTDoseAcquisition2.getAcquisitionParameters();
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTScanType equality", (Object)cTScanType, (Object)cTDoseAcquisition2.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTDIvol equality", (String)string2, (String)cTDoseAcquisition2.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip DLP equality", (String)string3, (String)cTDoseAcquisition2.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking round trip CTPhantomType equality", (boolean)cTPhantomType.equals(cTDoseAcquisition2.getPhantomType()));
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip IrradiationEventUID equality", (String)string5, (String)cTAcquisitionParameters2.getIrradiationEventUID());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip Anatomy equality", (Object)codedSequenceItem, (Object)cTAcquisitionParameters2.getAnatomy());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip ExposureTimeInSeconds equality", (String)string6, (String)cTAcquisitionParameters2.getExposureTimeInSeconds());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip ScanningLengthInMM equality", (String)string14, (String)cTAcquisitionParameters2.getScanningLengthInMM());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip NominalSingleCollimationWidthInMM equality", (String)string11, (String)cTAcquisitionParameters2.getNominalSingleCollimationWidthInMM());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip NominalTotalCollimationWidthInMM equality", (String)string12, (String)cTAcquisitionParameters2.getNominalTotalCollimationWidthInMM());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip PitchFactor equality", (String)string13, (String)cTAcquisitionParameters2.getPitchFactor());
        TestCTDoseAcquisition.assertEquals((String)"Checking KVP equality", (String)string7, (String)cTAcquisitionParameters2.getKVP());
        TestCTDoseAcquisition.assertEquals((String)"Checking TubeCurrent equality", (String)string8, (String)cTAcquisitionParameters2.getTubeCurrent());
        TestCTDoseAcquisition.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string9, (String)cTAcquisitionParameters2.getTubeCurrentMaximum());
        TestCTDoseAcquisition.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string10, (String)cTAcquisitionParameters2.getExposureTimePerRotation());
    }

    public void TestCTDoseAcquisitionConstructor_WithAllParameters_StationaryBasedOnZeroPitchInAcquisitionParameterChildren() throws Exception {
        String string = "2";
        CTScanType cTScanType = CTScanType.STATIONARY;
        String string2 = "20.23";
        String string3 = "1362.24";
        CTPhantomType cTPhantomType = CTPhantomType.selectFromDescription("BODY32");
        String string4 = "1.2.3.4.5";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string4, true, string, CTScanType.UNKNOWN, null, string2, string3, cTPhantomType);
        String string5 = "1.2.3.4";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", "Chest, Abdomen and Pelvis");
        String string6 = "1";
        String string7 = "120";
        String string8 = "397";
        String string9 = "433";
        String string10 = "0.6";
        String string11 = "0.625";
        String string12 = "40";
        String string13 = "0";
        String string14 = FloatFormatter.toString(673.3761739990114);
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string5, cTScanType, codedSequenceItem, string6, null, string11, string12, string13, string7, string8, string9, string10);
        cTAcquisitionParameters.deriveScanningLengthFromDLPAndCTDIVol(string3, string2);
        cTDoseAcquisition.setAcquisitionParameters(cTAcquisitionParameters);
        TestCTDoseAcquisition.assertEquals((String)"Checking SeriesNumber equality", (String)string, (String)cTDoseAcquisition.getSeriesOrAcquisitionNumber());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTScanType equality", (Object)cTScanType, (Object)cTDoseAcquisition.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking CTDIvol equality", (String)string2, (String)cTDoseAcquisition.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking DLP equality", (String)string3, (String)cTDoseAcquisition.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking CTPhantomType equality", (boolean)cTPhantomType.equals(cTDoseAcquisition.getPhantomType()));
        TestCTDoseAcquisition.assertFalse((String)"Checking specified DLP does not equal DLP computed from range and CTDIvol due to slice thickness", (boolean)cTDoseAcquisition.specifiedDLPMatchesDLPFromRangeAndCTDIvol());
        ContentItem contentItem = cTDoseAcquisition.getStructuredReportFragment(null);
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string4, contentItem);
        CTAcquisitionParameters cTAcquisitionParameters2 = cTDoseAcquisition2.getAcquisitionParameters();
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTScanType equality", (Object)cTScanType, (Object)cTDoseAcquisition2.getScanType());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip CTDIvol equality", (String)string2, (String)cTDoseAcquisition2.getCTDIvol());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip DLP equality", (String)string3, (String)cTDoseAcquisition2.getDLP());
        TestCTDoseAcquisition.assertTrue((String)"Checking round trip CTPhantomType equality", (boolean)cTPhantomType.equals(cTDoseAcquisition2.getPhantomType()));
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip IrradiationEventUID equality", (String)string5, (String)cTAcquisitionParameters2.getIrradiationEventUID());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip Anatomy equality", (Object)codedSequenceItem, (Object)cTAcquisitionParameters2.getAnatomy());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip ExposureTimeInSeconds equality", (String)string6, (String)cTAcquisitionParameters2.getExposureTimeInSeconds());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip ScanningLengthInMM equality", (String)string14, (String)cTAcquisitionParameters2.getScanningLengthInMM());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip NominalSingleCollimationWidthInMM equality", (String)string11, (String)cTAcquisitionParameters2.getNominalSingleCollimationWidthInMM());
        TestCTDoseAcquisition.assertEquals((String)"Checking round trip NominalTotalCollimationWidthInMM equality", (String)string12, (String)cTAcquisitionParameters2.getNominalTotalCollimationWidthInMM());
        TestCTDoseAcquisition.assertTrue((String)"Checking round trip PitchFactor is absent", (cTAcquisitionParameters2.getPitchFactor() == null ? 1 : 0) != 0);
        TestCTDoseAcquisition.assertEquals((String)"Checking KVP equality", (String)string7, (String)cTAcquisitionParameters2.getKVP());
        TestCTDoseAcquisition.assertEquals((String)"Checking TubeCurrent equality", (String)string8, (String)cTAcquisitionParameters2.getTubeCurrent());
        TestCTDoseAcquisition.assertEquals((String)"Checking TubeCurrentMaximum equality", (String)string9, (String)cTAcquisitionParameters2.getTubeCurrentMaximum());
        TestCTDoseAcquisition.assertEquals((String)"Checking ExposureTimePerRotation equality", (String)string10, (String)cTAcquisitionParameters2.getExposureTimePerRotation());
    }
}

