/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCodeContentItemValueMatching
extends TestCase {
    ContentItemFactory cf;

    public TestCodeContentItemValueMatching(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCodeContentItemValueMatching");
        testSuite.addTest((Test)new TestCodeContentItemValueMatching("TestCodeContentItemValueMatching_ClassMethod"));
        testSuite.addTest((Test)new TestCodeContentItemValueMatching("TestCodeContentItemValueMatching_Static"));
        return testSuite;
    }

    protected void setUp() {
        this.cf = new ContentItemFactory();
    }

    protected void tearDown() {
    }

    public void TestCodeContentItemValueMatching_ClassMethod() throws Exception {
        String string = "R-00339";
        String string2 = "SRT";
        String string3 = "No";
        String string4 = "122140";
        String string5 = "DCM";
        String string6 = "Comparison with Prior Exam Done";
        ContentItemFactory.CodeContentItem codeContentItem = this.cf.makeCodeContentItem(null, null, new CodedSequenceItem(string4, string5, string6), new CodedSequenceItem(string, string2, string3));
        TestCodeContentItemValueMatching.assertTrue((String)"Checking concept name correct CSD and CV match", (boolean)codeContentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(string4, string5));
        TestCodeContentItemValueMatching.assertTrue((String)"Checking concept name incorrect CSD does not match", (!codeContentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(string4, "bad") ? 1 : 0) != 0);
        TestCodeContentItemValueMatching.assertTrue((String)"Checking concept name incorrect CV does not match", (!codeContentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator("bad", string5) ? 1 : 0) != 0);
        TestCodeContentItemValueMatching.assertTrue((String)"Checking value correct CSD and CV match", (boolean)codeContentItem.contentItemValueMatchesCodeValueAndCodingSchemeDesignator(string, string2));
        TestCodeContentItemValueMatching.assertTrue((String)"Checking value incorrect CSD does not match", (!codeContentItem.contentItemValueMatchesCodeValueAndCodingSchemeDesignator(string, "bad") ? 1 : 0) != 0);
        TestCodeContentItemValueMatching.assertTrue((String)"Checking value incorrect CV does not match", (!codeContentItem.contentItemValueMatchesCodeValueAndCodingSchemeDesignator("bad", string2) ? 1 : 0) != 0);
    }

    public void TestCodeContentItemValueMatching_Static() throws Exception {
        String string = "R-00339";
        String string2 = "SRT";
        String string3 = "No";
        String string4 = "122140";
        String string5 = "DCM";
        String string6 = "Comparison with Prior Exam Done";
        ContentItemFactory.CodeContentItem codeContentItem = this.cf.makeCodeContentItem(null, null, new CodedSequenceItem(string4, string5, string6), new CodedSequenceItem(string, string2, string3));
        TestCodeContentItemValueMatching.assertTrue((String)"Checking concept name correct CSD and CV match", (boolean)ContentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(codeContentItem, string4, string5));
        TestCodeContentItemValueMatching.assertTrue((String)"Checking concept name incorrect CSD does not match", (!ContentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(codeContentItem, string4, "bad") ? 1 : 0) != 0);
        TestCodeContentItemValueMatching.assertTrue((String)"Checking concept name incorrect CV does not match", (!ContentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(codeContentItem, "bad", string5) ? 1 : 0) != 0);
        TestCodeContentItemValueMatching.assertTrue((String)"Checking value correct CSD and CV match", (boolean)ContentItemFactory.codeContentItemValueMatchesCodeValueAndCodingSchemeDesignator(codeContentItem, string, string2));
        TestCodeContentItemValueMatching.assertTrue((String)"Checking value incorrect CSD does not match", (!ContentItemFactory.codeContentItemValueMatchesCodeValueAndCodingSchemeDesignator(codeContentItem, string, "bad") ? 1 : 0) != 0);
        TestCodeContentItemValueMatching.assertTrue((String)"Checking value incorrect CV does not match", (!ContentItemFactory.codeContentItemValueMatchesCodeValueAndCodingSchemeDesignator(codeContentItem, "bad", string2) ? 1 : 0) != 0);
    }
}

