/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dose.DeviceParticipant;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDeviceParticipant
extends TestCase {
    public TestDeviceParticipant(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestDeviceParticipant");
        testSuite.addTest((Test)new TestDeviceParticipant("TestDeviceParticipant_WithAllParameters"));
        testSuite.addTest((Test)new TestDeviceParticipant("TestDeviceParticipant_SerialNumberWithSerialNumberPresent"));
        testSuite.addTest((Test)new TestDeviceParticipant("TestDeviceParticipant_SerialNumberWithNoSerialNumberPresentButStationName"));
        testSuite.addTest((Test)new TestDeviceParticipant("TestDeviceParticipant_SerialNumberWithNoSerialNumberPresentButInstitutionName"));
        testSuite.addTest((Test)new TestDeviceParticipant("TestDeviceParticipant_SerialNumberWithNoSerialNumberPresentButStationAndInstitutionName"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestDeviceParticipant_WithAllParameters() throws Exception {
        String string = "Acme";
        String string2 = "Scanner";
        String string3 = "72349236741";
        DeviceParticipant deviceParticipant = new DeviceParticipant(string, string2, string3);
        TestDeviceParticipant.assertEquals((String)"Checking manufacturer", (String)string, (String)deviceParticipant.getManufacturer());
        TestDeviceParticipant.assertEquals((String)"Checking modelName", (String)string2, (String)deviceParticipant.getModelName());
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber", (String)string3, (String)deviceParticipant.getSerialNumber());
        ContentItem contentItem = deviceParticipant.getStructuredReportFragment();
        TestDeviceParticipant.assertEquals((String)"Checking SR fragment", (String)"CONTAINS: CODE: Device Role in Procedure = Irradiating Device", (String)contentItem.toString());
        TestDeviceParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Device Manufacturer = " + string), (String)contentItem.getNamedChild("DCM", "113878").toString());
        TestDeviceParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Device Model Name = " + string2), (String)contentItem.getNamedChild("DCM", "113879").toString());
        TestDeviceParticipant.assertEquals((String)"Checking SR fragment", (String)("HAS PROPERTIES: TEXT: Device Serial Number = " + string3), (String)contentItem.getNamedChild("DCM", "113880").toString());
    }

    public void TestDeviceParticipant_SerialNumberWithSerialNumberPresent() throws Exception {
        String string = "72349236741";
        AttributeList attributeList = new AttributeList();
        Object object = new LongStringAttribute(TagFromName.DeviceSerialNumber);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        object = DeviceParticipant.getDeviceSerialNumberOrSuitableAlternative(attributeList, false);
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber", (String)string, (String)object);
    }

    public void TestDeviceParticipant_SerialNumberWithNoSerialNumberPresentButStationName() throws Exception {
        String string = "BLASTAT1";
        String string2 = "420ea865fb1878adc17ddc02f83c97301862f183";
        AttributeList attributeList = new AttributeList();
        ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.StationName);
        ((Attribute)shortStringAttribute).addValue(string);
        attributeList.put(shortStringAttribute);
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber returned", (String)string2, (String)DeviceParticipant.getDeviceSerialNumberOrSuitableAlternative(attributeList, true));
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber in list", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DeviceSerialNumber));
    }

    public void TestDeviceParticipant_SerialNumberWithNoSerialNumberPresentButInstitutionName() throws Exception {
        String string = "St. Elsewhere";
        String string2 = "f79b1268bfca6bfddcc9c8ef43c5312a63b5f4fd";
        AttributeList attributeList = new AttributeList();
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.InstitutionName);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(longStringAttribute);
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber returned", (String)string2, (String)DeviceParticipant.getDeviceSerialNumberOrSuitableAlternative(attributeList, true));
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber in list", (String)string2, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DeviceSerialNumber));
    }

    public void TestDeviceParticipant_SerialNumberWithNoSerialNumberPresentButStationAndInstitutionName() throws Exception {
        String string = "St. Elsewhere";
        String string2 = "BLASTAT1";
        String string3 = "72df0a054f1dd39cfa93d8ade3671371429fa4b6";
        AttributeList attributeList = new AttributeList();
        StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.InstitutionName);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string);
        attributeList.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.StationName);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string2);
        attributeList.put(stringAttributeAffectedBySpecificCharacterSet);
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber returned", (String)string3, (String)DeviceParticipant.getDeviceSerialNumberOrSuitableAlternative(attributeList, true));
        TestDeviceParticipant.assertEquals((String)"Checking serialNumber in list", (String)string3, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DeviceSerialNumber));
    }
}

