/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.UnknownAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPrivateCreatorValueRepresentation
extends TestCase {
    public TestPrivateCreatorValueRepresentation(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestPrivateCreatorValueRepresentation");
        testSuite.addTest((Test)new TestPrivateCreatorValueRepresentation("TestPrivateCreatorValueRepresentation_FromImplicitVR"));
        testSuite.addTest((Test)new TestPrivateCreatorValueRepresentation("TestPrivateCreatorValueRepresentation_FromExplicitVR"));
        testSuite.addTest((Test)new TestPrivateCreatorValueRepresentation("TestPrivateCreatorValueRepresentation_FromExplicitUNVR"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestPrivateCreatorValueRepresentation_FromImplicitVR() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestPrivateCreatorValueRepresentation_FromImplicitVR", ".dcm");
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(17, 16));
        attribute.addValue(string);
        attributeList.put(attribute);
        attributeList.write(file, "1.2.840.10008.1.2", false, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(new AttributeTag(17, 16));
        TestPrivateCreatorValueRepresentation.assertTrue((String)"Checking creator was read", (attribute != null ? 1 : 0) != 0);
        TestPrivateCreatorValueRepresentation.assertTrue((String)"Checking creator is LO", (boolean)(attribute instanceof LongStringAttribute));
        TestPrivateCreatorValueRepresentation.assertEquals((String)"Checking creator value", (String)string, (String)attribute.getSingleStringValueOrNull());
    }

    public void TestPrivateCreatorValueRepresentation_FromExplicitVR() throws Exception {
        String string = "Test Creator";
        File file = File.createTempFile("TestPrivateCreatorValueRepresentation_FromExplicitVR", ".dcm");
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(17, 16));
        attribute.addValue(string);
        attributeList.put(attribute);
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(new AttributeTag(17, 16));
        TestPrivateCreatorValueRepresentation.assertTrue((String)"Checking creator was read", (attribute != null ? 1 : 0) != 0);
        TestPrivateCreatorValueRepresentation.assertTrue((String)"Checking creator is LO", (boolean)(attribute instanceof LongStringAttribute));
        TestPrivateCreatorValueRepresentation.assertEquals((String)"Checking creator value", (String)string, (String)attribute.getSingleStringValueOrNull());
    }

    public void TestPrivateCreatorValueRepresentation_FromExplicitUNVR() throws Exception {
        String string = "Test Creator";
        File file = new File("/tmp/holdforme");
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new OurUnknownAttribute(new AttributeTag(17, 16), string);
        attributeList.put(attribute);
        attributeList.write(file, "1.2.840.10008.1.2.1", false, true);
        attributeList = new AttributeList();
        attributeList.read(file);
        attribute = attributeList.get(new AttributeTag(17, 16));
        TestPrivateCreatorValueRepresentation.assertTrue((String)"Checking creator was read", (attribute != null ? 1 : 0) != 0);
        TestPrivateCreatorValueRepresentation.assertTrue((String)"Checking creator is LO", (boolean)(attribute instanceof LongStringAttribute));
        TestPrivateCreatorValueRepresentation.assertEquals((String)"Checking creator value", (String)string, (String)attribute.getSingleStringValueOrNull());
    }

    protected class OurUnknownAttribute
    extends UnknownAttribute {
        OurUnknownAttribute(AttributeTag attributeTag, String string) {
            super(attributeTag);
            this.originalLittleEndianByteValues = string.getBytes();
            this.valueLength = this.originalLittleEndianByteValues.length;
            assert (this.valueLength % 2L == 0L);
            this.valueMultiplicity = 1;
        }
    }
}

