/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import com.pixelmed.utils.HexDump;
import java.text.Collator;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/StringUtilities.java,v 1.12 2009/04/21 08:38:50 dclunie Exp $";
    private static Collator ourCollator = Collator.getInstance();

    private StringUtilities() {
    }

    public static final String replaceAllInWith(String string, String string2, String string3) {
        String string4 = string;
        if (string != null && string2 != null && string2.length() > 0) {
            int n = string3 == null ? 0 : string3.length();
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (i < n) {
                    char c2 = string3.charAt(i);
                    string4.replace(c, c2);
                    continue;
                }
                string4.replace(Character.toString(c), "");
            }
        }
        return string4;
    }

    public static final boolean contains(String string, String[] stringArray) {
        if (string != null && stringArray != null) {
            for (String string2 : stringArray) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean containsRegardlessOfCase(String string, String[] stringArray) {
        if (string != null && stringArray != null) {
            string = string.toLowerCase();
            for (String string2 : stringArray) {
                if (!string.contains(string2.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static final Vector getDelimitedValues(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                if (bl) {
                    vector.add("");
                }
                bl = true;
                continue;
            }
            vector.add(string3);
            bl = false;
        }
        if (bl) {
            vector.add("");
        }
        return vector;
    }

    public static final String removeTrailingCharacter(String string, char c) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        for (n2 = n = cArray.length; n2 > 0 && cArray[n2 - 1] == c; --n2) {
        }
        return n2 == n ? string : (n2 > 0 ? new String(cArray, 0, n2) : "");
    }

    public static final String removeTrailingWhitespaceOrISOControl(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        for (n2 = n = cArray.length; n2 > 0 && (Character.isWhitespace(cArray[n2 - 1]) || Character.isISOControl(cArray[n2 - 1])); --n2) {
        }
        return n2 == n ? string : (n2 > 0 ? new String(cArray, 0, n2) : "");
    }

    public static final String removeLeadingCharacter(String string, char c) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (n = 0; n < n2 && cArray[n] == c; ++n) {
        }
        return n == 0 ? string : (n < n2 ? new String(cArray, n, n2 - n) : "");
    }

    public static final String removeLeadingWhitespaceOrISOControl(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (n = 0; n < n2 && (Character.isWhitespace(cArray[n]) || Character.isISOControl(cArray[n])); ++n) {
        }
        return n == 0 ? string : (n < n2 ? new String(cArray, n, n2 - n) : "");
    }

    public static final String removeTrailingSpaces(String string) {
        return StringUtilities.removeTrailingCharacter(string, ' ');
    }

    public static final String removeLeadingSpaces(String string) {
        return StringUtilities.removeLeadingCharacter(string, ' ');
    }

    public static final String removeLeadingOrTrailingWhitespaceOrISOControl(String string) {
        return StringUtilities.removeTrailingWhitespaceOrISOControl(StringUtilities.removeLeadingWhitespaceOrISOControl(string));
    }

    public static final int compareStringsThatMayBeIntegers(String string, String string2) {
        try {
            return Integer.parseInt(string) - Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return ourCollator.compare(string, string2);
        }
    }

    public static final int compareStringsWithEmbeddedNonZeroPaddedIntegers(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
        int n = 0;
        while (stringTokenizer.hasMoreElements() && stringTokenizer2.hasMoreElements()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            n = StringUtilities.compareStringsThatMayBeIntegers(string4, string3 = stringTokenizer2.nextToken());
            if (n == 0) continue;
            return n;
        }
        n = stringTokenizer.hasMoreElements() ? 1 : (stringTokenizer.hasMoreElements() ? -1 : 0);
        return n;
    }

    public static String dump(String string) {
        return StringUtilities.dump(string.toCharArray());
    }

    public static String dump(char[] cArray) {
        int n = 0;
        int n2 = cArray == null ? 0 : cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray != null && n2 > 0) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n3 < n2) {
                int n6 = n3 + n;
                if (n3 % 16 == 0) {
                    if (n3 != 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(HexDump.intToPaddedDecimalString(n6));
                    stringBuffer.append(" (");
                    stringBuffer.append(HexDump.intToPaddedHexStringWith0x(n6));
                    stringBuffer.append("):");
                    n4 = n6;
                    n5 = 0;
                }
                stringBuffer.append(" ");
                stringBuffer.append(HexDump.shortToPaddedHexString((short)cArray[n6]));
                ++n5;
                if (++n3 % 16 != 0 && n3 != n2) continue;
                stringBuffer.append(" ");
                stringBuffer.append(new String(cArray, n4, n5));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length == 0) {
            return "";
        }
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append("[");
            stringBuffer.append(i);
            stringBuffer.append("]=");
            stringBuffer.append(dArray[i]);
            string = " ";
        }
        return stringBuffer.toString();
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append("[");
            stringBuffer.append(i);
            stringBuffer.append("]=");
            stringBuffer.append(stringArray[i]);
            string = " ";
        }
        return stringBuffer.toString();
    }

    public static String toString(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append("[");
            stringBuffer.append(i);
            stringBuffer.append("]={");
            stringBuffer.append(StringUtilities.toString(stringArray[i]));
            stringBuffer.append("}");
            string = " ";
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "1234";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "1234  ";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "12  34  ";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "  1234";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "  1234  ";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "1";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = " ";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "    ";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        string = "";
        System.err.println("src <" + string + "> dst <" + StringUtilities.removeTrailingSpaces(string) + ">");
        String string2 = "this is 2 way";
        String string3 = "this is 2 way";
        System.err.println("s1 <" + string2 + "> s2 <" + string3 + "> : compare =" + StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(string2, string3));
        string2 = "this is 2 way";
        string3 = "this is 10 way";
        System.err.println("s1 <" + string2 + "> s2 <" + string3 + "> : compare =" + StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(string2, string3));
        string2 = "this is 10 way";
        string3 = "this is 2 way";
        System.err.println("s1 <" + string2 + "> s2 <" + string3 + "> : compare =" + StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(string2, string3));
        string2 = "this is 2 way";
        string3 = "this is 2 way plus";
        System.err.println("s1 <" + string2 + "> s2 <" + string3 + "> : compare =" + StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(string2, string3));
        string2 = "this is 2 way";
        string3 = "this is 10 way plus";
        System.err.println("s1 <" + string2 + "> s2 <" + string3 + "> : compare =" + StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(string2, string3));
        string2 = "this is 10 way";
        string3 = "this is 2 way plus";
        System.err.println("s1 <" + string2 + "> s2 <" + string3 + "> : compare =" + StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(string2, string3));
    }

    static {
        ourCollator.setStrength(3);
        ourCollator.setDecomposition(2);
    }
}

