/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.display.ConsumerFormatImageMaker;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WadoRequest;
import com.pixelmed.web.WebRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class WadoRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WadoRequestHandler.java,v 1.8 2010/11/27 13:54:14 dclunie Exp $";
    private static Map cacheOfConvertedFiles = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCacheOfConvertedFiles(Object object, String string) {
        Map map = cacheOfConvertedFiles;
        synchronized (map) {
            cacheOfConvertedFiles.put(object, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromCacheOfConvertedFiles(Object object) {
        String string = null;
        Map map = cacheOfConvertedFiles;
        synchronized (map) {
            if (object != null) {
                string = (String)cacheOfConvertedFiles.get(object);
            }
        }
        return string;
    }

    private static final Object makeCacheKey(String string, double d, double d2, int n, int n2, int n3) {
        return string + "#" + Double.toString(d) + "#" + Double.toString(d2) + "#" + Integer.toString(n) + "#" + Integer.toString(n2) + "#" + Integer.toString(n3);
    }

    protected WadoRequestHandler(String string, int n) {
        super(string, n);
    }

    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        block23: {
            try {
                WadoRequest wadoRequest = new WadoRequest(webRequest);
                String string4 = wadoRequest.getObjectUID();
                ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string4);
                if (arrayList != null && arrayList.size() == 1) {
                    File file;
                    Map map = (Map)arrayList.get(0);
                    String string5 = (String)map.get(databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE).toUpperCase());
                    if (this.webServerDebugLevel > 1) {
                        System.err.println("WadoRequestHandler.generateResponseToGetRequest(): Found in database " + string5);
                    }
                    if ((file = new File(string5)).exists() && file.isFile()) {
                        if (this.webServerDebugLevel > 1) {
                            System.err.println("WadoRequestHandler.generateResponseToGetRequest(): File exists");
                        }
                        if (wadoRequest.isContentTypeDicom()) {
                            if (this.webServerDebugLevel > 1) {
                                System.err.println("WadoRequestHandler.generateResponseToGetRequest(): is DICOM request");
                            }
                            this.sendHeaderAndBodyOfFile(outputStream, file, string4 + ".dcm", "application/dicom");
                            break block23;
                        }
                        if (this.webServerDebugLevel > 1) {
                            System.err.println("WadoRequestHandler.generateResponseToGetRequest(): is non-DICOM request");
                        }
                        String string6 = (String)map.get("SOPCLASSUID");
                        if (this.webServerDebugLevel > 1) {
                            System.err.println("WadoRequestHandler.generateResponseToGetRequest(): SOP Class UID from database = " + string6);
                        }
                        if (string6 != null) {
                            if (SOPClass.isImageStorage(string6)) {
                                double d = wadoRequest.getWindowWidth();
                                double d2 = wadoRequest.getWindowCenter();
                                int n = wadoRequest.getColumns();
                                int n2 = wadoRequest.getRows();
                                int n3 = wadoRequest.getImageQuality();
                                String string7 = "jpeg";
                                File file2 = null;
                                Object object = WadoRequestHandler.makeCacheKey(string4, d2, d, n, n2, n3);
                                String string8 = this.getFromCacheOfConvertedFiles(object);
                                try {
                                    if (string8 == null) {
                                        if (this.webServerDebugLevel > 1) {
                                            System.err.println("WadoRequestHandler.generateResponseToGetRequest(): not in cache");
                                        }
                                        file2 = File.createTempFile("RequestTypeServer", ".jpg");
                                        file2.deleteOnExit();
                                        string8 = file2.getAbsolutePath();
                                        ConsumerFormatImageMaker.convertFileToEightBitImage(string5, string8, string7, d2, d, n, n2, n3, "all", this.webServerDebugLevel);
                                        this.addToCacheOfConvertedFiles(object, string8);
                                    } else {
                                        if (this.webServerDebugLevel > 1) {
                                            System.err.println("WadoRequestHandler.generateResponseToGetRequest(): in cache");
                                        }
                                        file2 = new File(string8);
                                    }
                                    String string9 = ".jpg";
                                    String string10 = "image/jpeg";
                                    this.sendHeaderAndBodyOfFile(outputStream, file2, string4 + string9, string10);
                                    break block23;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(System.err);
                                    throw new Exception("Cannot convert image to " + string7);
                                }
                                finally {
                                    if (this.webServerDebugLevel > 1) {
                                        System.err.println("WadoRequestHandler.generateResponseToGetRequest(): convertedFileName = " + string8);
                                    }
                                }
                            }
                            throw new Exception("Only images supported");
                        }
                        throw new Exception("Cannot determine SOP Class of instance");
                    }
                    throw new Exception("SOP Instance " + string4 + " in database but file \"" + string5 + "\" referenced by database missing");
                }
                throw new Exception("Could not find SOP Instance " + string4);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                if (this.webServerDebugLevel > 0) {
                    System.err.println("WadoRequestHandler.generateResponseToGetRequest(): Sending 404 Not Found");
                }
                WadoRequestHandler.send404NotFound(outputStream, exception.getMessage());
            }
        }
    }
}

