/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.Token;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TokenDAO
implements clinical.server.dao.TokenDAO {
    @Override
    public void insert(Connection con, Token bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_TOKEN ");
            buf.append(" (TOKEN,GROUPID,TIMECREATED,SERVED,EXPIRED) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 5) {
                buf.append('?');
                if (i < 4) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getToken(), 1);
            ps.setObject(2, bean.getGroupid(), 2);
            ps.setTimestamp(3, bean.getTimecreated() == null ? null : new Timestamp(bean.getTimecreated().getTime()));
            ps.setObject(4, this.boolean2Number(bean.getServed()), 2);
            ps.setObject(5, this.boolean2Number(bean.getExpired()), 2);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Token bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("TOKEN");
        buf.append(',');
        buf.append("GROUPID");
        buf.append(',');
        buf.append("TIMECREATED");
        buf.append(',');
        buf.append("SERVED");
        buf.append(',');
        buf.append("EXPIRED");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Token bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getToken() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TOKEN=?");
            qi.values.add(bean.getToken());
            valueSet = true;
        }
        if (bean.getGroupid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("GROUPID=?");
            qi.values.add(bean.getGroupid());
            valueSet = true;
        }
        if (bean.getTimecreated() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TIMECREATED=?");
            qi.values.add(new Timestamp(bean.getTimecreated().getTime()));
            valueSet = true;
        }
        if (bean.getServed() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SERVED=?");
            qi.values.add(this.boolean2Number(bean.getServed()));
            valueSet = true;
        }
        if (bean.getExpired() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("EXPIRED=?");
            qi.values.add(this.boolean2Number(bean.getExpired()));
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Token bean, Token criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_TOKEN SET ");
        if (bean.getToken() != null || bean.isNull("token")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TOKEN=? ");
            uqi.setValues.add(bean.getToken());
            uqi.sqlTypes.add(new Integer(1));
            this.prepareNullSetListValue(bean.isNull("token"), uqi);
            valueSet = true;
        }
        if (bean.getGroupid() != null || bean.isNull("groupid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("GROUPID=? ");
            uqi.setValues.add(bean.getGroupid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("groupid"), uqi);
            valueSet = true;
        }
        if (bean.getTimecreated() != null || bean.isNull("timecreated")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TIMECREATED=? ");
            uqi.setValues.add(new Timestamp(bean.getTimecreated().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("timecreated"), uqi);
            valueSet = true;
        }
        if (bean.getServed() != null || bean.isNull("served")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SERVED=? ");
            uqi.setValues.add(this.boolean2Number(bean.getServed()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("served"), uqi);
            valueSet = true;
        }
        if (bean.getExpired() != null || bean.isNull("expired")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("EXPIRED=? ");
            uqi.setValues.add(this.boolean2Number(bean.getExpired()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("expired"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Token createObject(ResultSet rs) throws SQLException {
        Token obj = new Token();
        obj.setToken((String)rs.getObject(1));
        obj.setGroupid((BigDecimal)rs.getObject(2));
        if (rs.getTimestamp(3) != null) {
            obj.setTimecreated(new Date(rs.getTimestamp(3).getTime()));
        }
        obj.setServed(this.convert2Boolean(rs.getObject(4)));
        obj.setExpired(this.convert2Boolean(rs.getObject(5)));
        return obj;
    }

    @Override
    public List<Token> find(Connection con, Token criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Token> results = new LinkedList<Token>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_TOKEN ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Token item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Token bean, Token criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Token criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_TOKEN ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

