/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.sql.CLOB;
import oracle.sql.DATE;

public class OracleUtils {
    protected OracleUtils() {
    }

    public static String readCLOB(CLOB clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(128);
        Reader r = clob.characterStreamValue();
        try {
            int c;
            while ((c = r.read()) != -1) {
                buf.append((char)c);
            }
        }
        catch (IOException iox) {
            throw new SQLException(iox.getMessage());
        }
        return buf.toString();
    }

    public static CLOB getCLOB(Connection con, String data) throws SQLException {
        CLOB tempClob = null;
        Writer w = null;
        try {
            try {
                tempClob = CLOB.createTemporary((Connection)con, (boolean)true, (int)10);
                tempClob.open(1);
                w = tempClob.getCharacterOutputStream();
                w.write(data);
                w.flush();
            }
            catch (Exception x) {
                if (tempClob != null) {
                    tempClob.freeTemporary();
                }
                x.printStackTrace();
                throw new SQLException(x.getMessage());
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
        }
        return tempClob;
    }

    public static String escapeQuotes(String str) {
        if (str == null) {
            return str;
        }
        if (str.indexOf(39) != -1) {
            str = str.replaceAll("'", "''");
        }
        return str;
    }

    public static Timestamp getTimestamp(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        return ((DATE)value).timestampValue();
    }
}

