/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.security;

import clinical.web.common.security.Privilege;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class User {
    protected String name;
    protected String pwd;
    protected boolean useGSI = false;
    protected User dbUser;
    protected Map<String, Privilege> fullPrivilegesMap = new LinkedHashMap<String, Privilege>(7);
    protected Map<String, String> availableTables = new HashMap<String, String>();
    protected Map<String, Privilege> privilegeMap = Collections.synchronizedMap(new LinkedHashMap(7));
    protected List<PrivilegeExperiments> privExperiments;

    public User(String name, String pwd) {
        this.name = name;
        this.pwd = pwd;
    }

    public User(String name, String pwd, boolean useGSI) {
        this(name, pwd);
        this.useGSI = useGSI;
    }

    public String getName() {
        return this.name;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public User getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(User dbUser) {
        this.dbUser = dbUser;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof User)) {
            return false;
        }
        return this.name.equals(((User)other).name);
    }

    public void addAvailableTable(String tableName) {
        this.availableTables.put(tableName, tableName);
    }

    public Map<String, String> getAvailableTables() {
        return this.availableTables;
    }

    public synchronized void addPrivilege(Privilege privilege) {
        this.privilegeMap.put(privilege.getName(), privilege);
    }

    public synchronized void removePrivilege(String privName) {
        this.privilegeMap.remove(privName);
    }

    public List<Privilege> listPrivileges() {
        return new ArrayList<Privilege>(this.privilegeMap.values());
    }

    public List<Privilege> getPrivileges() {
        return new ArrayList<Privilege>(this.privilegeMap.values());
    }

    public boolean hasPrivilege(String privName) {
        return this.privilegeMap.get(privName) != null;
    }

    public int getNumOfPrivileges() {
        return this.privilegeMap.size();
    }

    public Map<String, Privilege> getFullPrivilegesMap() {
        return this.fullPrivilegesMap;
    }

    public void setFullPrivilegesMap(Map<String, Privilege> fullPrivilegesMap) {
        this.fullPrivilegesMap = fullPrivilegesMap;
    }

    public List<Privilege> getMissingPrivileges() {
        if (this.privilegeMap.size() == this.fullPrivilegesMap.size()) {
            return new ArrayList<Privilege>(0);
        }
        ArrayList<Privilege> list = new ArrayList<Privilege>(this.fullPrivilegesMap.size());
        for (String privName : this.fullPrivilegesMap.keySet()) {
            if (this.privilegeMap.containsKey(privName)) continue;
            list.add(this.fullPrivilegesMap.get(privName));
        }
        return list;
    }

    public boolean isSame(User other) {
        if (other == null) {
            return false;
        }
        boolean ok = true;
        boolean bl = ok = this.name.equals(other.name) && this.pwd.equals(other.pwd);
        if (!ok) {
            return false;
        }
        if (this.dbUser != null) {
            return this.dbUser.isSame(other.dbUser);
        }
        return ok;
    }

    public boolean isUseGSI() {
        return this.useGSI;
    }

    public void setUseGSI(boolean useGSI) {
        this.useGSI = useGSI;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(104);
        buf.append("User::[");
        buf.append("name=").append(this.name);
        buf.append(", dbUser=").append(this.dbUser);
        buf.append(']');
        return buf.toString();
    }

    public List<PrivilegeExperiments> getPrivExperiments() {
        return this.privExperiments;
    }

    public void setPrivExperiments(List<PrivilegeExperiments> privExperiments) {
        this.privExperiments = privExperiments;
    }

    public static class PrivilegeExperiments {
        String privilege;
        List<ProjectPrivilegeStatus> ppStatusList;

        public PrivilegeExperiments(String privilege, List<ProjectPrivilegeStatus> ppStatusList) {
            this.privilege = privilege;
            this.ppStatusList = ppStatusList;
        }

        public String getPrivilege() {
            return this.privilege;
        }

        public List<ProjectPrivilegeStatus> getPpStatusList() {
            return this.ppStatusList;
        }

        public boolean hasGranted() {
            for (ProjectPrivilegeStatus pps : this.ppStatusList) {
                if (!pps.isGranted()) continue;
                return true;
            }
            return false;
        }
    }

    public static class ProjectPrivilegeStatus {
        int expId;
        String expName;
        boolean granted;

        public ProjectPrivilegeStatus(int expId, boolean granted, String expName) {
            this.expId = expId;
            this.granted = granted;
            this.expName = expName;
        }

        public int getExpId() {
            return this.expId;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public void setGranted(boolean granted) {
            this.granted = granted;
        }

        public String getExpName() {
            return this.expName;
        }
    }
}

