/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int m_rmid = -1;
    private String m_xaOpenString = null;
    private static boolean s_libraryLoaded = false;
    private static final String s_dbSuffix = "HeteroXA";
    private static final String s_dllName = "heteroxa9";
    private static final char at_sign_char = '@';
    private static int s_rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.m_user, this.m_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        try {
            String string3 = this.getURL();
            if (this.m_nativeXA && (string3.startsWith("jdbc:oracle:oci8") || string3.startsWith("jdbc:oracle:oci"))) {
                Object object;
                long[] lArray = new long[]{0L, 0L};
                Properties properties = new Properties();
                String string4 = null;
                string4 = this.m_tnsentry != null ? this.m_tnsentry : this.getTNSEntryFromUrl(string3);
                if (string4.startsWith("(DESCRIPTION") && this.m_tnsentry == null) {
                    DBError.throwSqlException(207);
                }
                if (!s_libraryLoaded) {
                    object = this.getClass();
                    synchronized (object) {
                        if (!s_libraryLoaded) {
                            try {
                                System.loadLibrary(s_dllName);
                                s_libraryLoaded = true;
                            }
                            catch (Error error) {
                                s_libraryLoaded = false;
                                throw error;
                            }
                        }
                    }
                }
                object = this.m_databaseName + s_dbSuffix + s_rmidSeed;
                this.m_rmid = s_rmidSeed;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    s_rmidSeed = (s_rmidSeed + 1) % 65536;
                }
                int n = 0;
                this.m_xaOpenString = this.generateXAOpenString((String)object, string4, this.m_user, this.m_password, 60, 2000, true, false, ".", n, false);
                String string5 = this.generateXACloseString((String)object, false);
                int n2 = this.do_xa_open(this.m_xaOpenString, this.m_rmid, 0, 0);
                if (n2 != 0) {
                    DBError.throwSqlException(-1 * n2);
                }
                if ((n2 = this.convert_oci_handles((String)object, lArray)) != 0) {
                    DBError.throwSqlException(-1 * n2);
                }
                properties.put("user", this.m_user);
                properties.put("password", this.m_password);
                properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                Connection connection = this.m_od.connect(this.getURL(), properties);
                OracleXAHeteroConnection oracleXAHeteroConnection = new OracleXAHeteroConnection(connection);
                oracleXAHeteroConnection.setRmid(this.m_rmid);
                oracleXAHeteroConnection.setXaCloseString(string5);
                oracleXAHeteroConnection.registerCloseCallback(new OracleXAHeteroCloseCallback(), oracleXAHeteroConnection);
                return oracleXAHeteroConnection;
            }
            return new OracleXAConnection(super.getPhysicalConnection(string, string2));
        }
        catch (XAException xAException) {
            return null;
        }
    }

    private native int do_xa_open(String var1, int var2, int var3, int var4);

    private native int convert_oci_handles(String var1, long[] var2);

    synchronized void setRmid(int n) {
        this.m_rmid = n;
    }

    synchronized int getRmid() {
        return this.m_rmid;
    }

    synchronized void setXaOpenString(String string) {
        this.m_xaOpenString = string;
    }

    synchronized String getXaOpenString() {
        return this.m_xaOpenString;
    }

    private String generateXAOpenString(String string, String string2, String string3, String string4, int n, int n2, boolean bl, boolean bl2, String string5, int n3, boolean bl3) {
        return new String("ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n2 + "+SESWT=" + n + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n3 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String generateXACloseString(String string, boolean bl) {
        return new String("ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String getTNSEntryFromUrl(String string) {
        int n = string.indexOf(64);
        return string.substring(n + 1);
    }
}

