/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFaultConverter
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(ClientFaultConverter.class);

    public ClientFaultConverter() {
        super("unmarshal");
    }

    public ClientFaultConverter(String phase) {
        super(phase);
    }

    @Override
    public void handleMessage(Message msg) {
        Fault fault = (Fault)msg.getContent(Exception.class);
        if (fault.getDetail() != null) {
            this.processFaultDetail(fault, msg);
            this.setStackTrace(fault, msg);
        }
    }

    protected void processFaultDetail(Fault fault, Message msg) {
        DataReader<Object> reader;
        Element exDetail = (Element)DOMUtils.getChild((Node)fault.getDetail(), 1);
        if (exDetail == null) {
            return;
        }
        QName qname = new QName(exDetail.getNamespaceURI(), exDetail.getLocalName());
        FaultInfo faultWanted = null;
        MessagePartInfo part = null;
        BindingOperationInfo boi = msg.getExchange().get(BindingOperationInfo.class);
        if (boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        for (FaultInfo faultInfo : boi.getOperationInfo().getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                if (!qname.equals(mpi.getConcreteName())) continue;
                faultWanted = faultInfo;
                part = mpi;
                break;
            }
            if (faultWanted == null) continue;
            break;
        }
        if (faultWanted == null) {
            for (FaultInfo faultInfo : boi.getOperationInfo().getFaults()) {
                for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                    if (!qname.getLocalPart().equals(mpi.getConcreteName().getLocalPart())) continue;
                    faultWanted = faultInfo;
                    part = mpi;
                    break;
                }
                if (faultWanted == null) continue;
                break;
            }
        }
        if (faultWanted == null) {
            return;
        }
        Service s = msg.getExchange().get(Service.class);
        DataBinding dataBinding = s.getDataBinding();
        Object e = null;
        if (this.isDOMSupported(dataBinding)) {
            reader = dataBinding.createReader(Node.class);
            reader.setProperty(DataReader.FAULT, fault);
            e = reader.read(part, exDetail);
        } else {
            reader = dataBinding.createReader(XMLStreamReader.class);
            W3CDOMStreamReader xsr = new W3CDOMStreamReader(exDetail);
            try {
                xsr.nextTag();
            }
            catch (XMLStreamException e1) {
                throw new Fault(e1);
            }
            reader.setProperty(DataReader.FAULT, fault);
            e = reader.read(part, xsr);
        }
        if (!(e instanceof Exception)) {
            try {
                Class exClass = faultWanted.getProperty(Class.class.getName(), Class.class);
                if (e == null) {
                    Constructor constructor = exClass.getConstructor(String.class);
                    e = constructor.newInstance(fault.getMessage());
                } else {
                    Class<?> beanClass = e.getClass();
                    Constructor constructor = exClass.getConstructor(String.class, beanClass);
                    e = constructor.newInstance(fault.getMessage(), e);
                }
                msg.setContent(Exception.class, e);
            }
            catch (Exception e1) {
                LogUtils.log(LOG, Level.INFO, "EXCEPTION_WHILE_CREATING_EXCEPTION", (Throwable)e1, (Object)e1.getMessage());
            }
        } else if (e != null) {
            if (fault.getMessage() != null) {
                try {
                    Field f = Throwable.class.getDeclaredField("detailMessage");
                    f.setAccessible(true);
                    f.set(e, fault.getMessage());
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            msg.setContent(Exception.class, e);
        }
    }

    private boolean isDOMSupported(DataBinding db) {
        boolean supportsDOM = false;
        for (Class<?> c : db.getSupportedReaderFormats()) {
            if (!c.equals(Node.class)) continue;
            supportsDOM = true;
        }
        return supportsDOM;
    }

    private void setStackTrace(Fault fault, Message msg) {
        HashMap<String, String> ns = new HashMap<String, String>();
        XPathUtils xu = new XPathUtils(ns);
        String ss = (String)xu.getValue("//stackTrace/text()", fault.getDetail(), XPathConstants.STRING);
        ArrayList<StackTraceElement> stackTraceList = new ArrayList<StackTraceElement>();
        if (StringUtils.isEmpty(ss)) {
            StringTokenizer st = new StringTokenizer(ss, "\n");
            while (st.hasMoreTokens()) {
                String oneLine = st.nextToken();
                StringTokenizer stInner = new StringTokenizer(oneLine, "!");
                StackTraceElement ste = new StackTraceElement(stInner.nextToken(), stInner.nextToken(), stInner.nextToken(), Integer.parseInt(stInner.nextToken()));
                stackTraceList.add(ste);
            }
            if (stackTraceList.size() > 0) {
                StackTraceElement[] stackTraceElement = new StackTraceElement[stackTraceList.size()];
                Exception e = msg.getContent(Exception.class);
                e.setStackTrace(stackTraceList.toArray(stackTraceElement));
            }
        }
    }
}

