/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Cookie {
    public static final String DISCARD_ATTRIBUTE = "discard";
    public static final String MAX_AGE_ATTRIBUTE = "max-age";
    public static final String PATH_ATTRIBUTE = "path";
    private String name;
    private String value;
    private String path;
    private int maxAge = -1;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int hashCode() {
        return 17 * this.name.hashCode() + (this.path != null ? 11 * this.path.hashCode() : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie c = (Cookie)o;
        boolean result = this.name.equals(c.name) && (this.path == null && c.path == null || this.path != null && this.path.equals(c.path));
        return result;
    }

    public static String requestCookieHeader(List<Cookie> cookies) {
        if (cookies == null || cookies.size() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("$Version=\"1\"");
        for (Cookie cookie : cookies) {
            b.append("; ").append(cookie.getName()).append("=").append(cookie.getValue());
            if (cookie.getPath() == null || cookie.getPath().length() <= 0) continue;
            b.append("; $Path=").append(cookie.getPath());
        }
        return b.toString();
    }

    public static List<Cookie> handleSetCookie(List<Cookie> current, String header) {
        String[] cookies;
        if (header == null || header.length() == 0) {
            return current;
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        if (current != null) {
            result.addAll(current);
        }
        for (String cookie : cookies = header.split(",")) {
            String[] parts = cookie.split(";");
            String[] kv = parts[0].split("=", 2);
            if (kv.length != 2) continue;
            String name = kv[0].trim();
            String value = kv[1].trim();
            Cookie newCookie = new Cookie(name, value);
            for (int i = 1; i < parts.length; ++i) {
                kv = parts[i].split("=", 2);
                name = kv[0].trim();
                String string = value = kv.length > 1 ? kv[1].trim() : null;
                if (name.equalsIgnoreCase(DISCARD_ATTRIBUTE)) {
                    newCookie.setMaxAge(0);
                    continue;
                }
                if (name.equalsIgnoreCase(MAX_AGE_ATTRIBUTE) && value != null) {
                    try {
                        newCookie.setMaxAge(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!name.equalsIgnoreCase(PATH_ATTRIBUTE) || value == null) continue;
                newCookie.setPath(value);
            }
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                Cookie oldCookie = (Cookie)iter.next();
                if (!newCookie.equals(oldCookie)) continue;
                iter.remove();
                break;
            }
            if (newCookie.getMaxAge() == 0) continue;
            result.add(newCookie);
        }
        return result;
    }
}

